package com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：UiBot组件模型构建策略工厂类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotCompDataBuildStrategyFactory
 * @Author: Zaregoto
 * @Date: 2021/10/20 16:28
 */
@Component("uiBotCompDataBuildStrategyFactory")
public class UiBotCompDataBuildStrategyFactory implements InitializingBean, ApplicationContextAware {

    private static final Map<String, UiBotCompDataBuildStrategy> STRATEGY_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public UiBotCompDataBuildStrategy get(String key) {
        return STRATEGY_MAP.get(key);
    }

    @Override public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 UiBotComponentDataBuildStrategy 注册到 STRATEGY_MAP
        this.appContext.getBeansOfType(UiBotCompDataBuildStrategy.class).values()
            .forEach(strategy ->
                STRATEGY_MAP.put(strategy.getTypeByRequestId(), strategy)
            );
    }

    @Override public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.appContext = applicationContext;
    }
}
