package com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;

/**
 * <p>功能描述：移动端组件提交参数解析器。不同的组件需要实现这个接口类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>*
 *
 * @FileName: ComponentParamAnalyzer
 * @Author: Zaregoto
 * @Date: 2021/5/25 19:24
 *
 * @param <ComptT> 组件Class类型
 * @param <SubmitT> 组件提交时参数的Class类型
 */
public interface ComponentParamAnalyzer<ComptT, SubmitT> {

    /**
     * 获取针对的移动端组件类型
     * @return
     */
    String getComponentType();

    Class<ComptT> getSubmitParamType();

    /**
     * 分析提交的参数。
     * 参数的内容根据不同的组件，解析不同的字段
     * @param submitParam
     * @return
     */
    SubmitT analyzeSubmitParam(Object submitParam);

    /**
     * 处理需要展示的参数
     * @param apiRequest
     * @param pageDataKey
     * @param pageData
     * @param args
     */
    void handleDisplayParam(ApiRequest apiRequest, String pageDataKey, UiBotPageData pageData,
        Object... args);
}
