package com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: ComponentSubmitHandlerFactory
 * @Author: Zaregoto
 * @Date: 2021/5/25 20:33
 */
@Component("componentParamAnalyzerFactory")
public class ComponentParamAnalyzerFactory implements InitializingBean, ApplicationContextAware {

    private static final Logger logger = LoggerFactory.getLogger(
        ComponentParamAnalyzerFactory.class);

    private static final Map<String, ComponentParamAnalyzer> PARAM_ANALYZER_MAP = new HashMap<>();

    private ApplicationContext appContext;

    public ComponentParamAnalyzer get(String key) {
        return PARAM_ANALYZER_MAP.get(key);
    }

    @Override public void afterPropertiesSet() throws Exception {
        // 将 Spring 容器中所有的 ComponentSubmitParamAnalyzer 注册到 SUBMIT_PARAM_ANALYZER_MAP
        this.appContext.getBeansOfType(ComponentParamAnalyzer.class).values().forEach(
            strategy -> PARAM_ANALYZER_MAP.put(strategy.getComponentType(), strategy));
    }

    @Override public void setApplicationContext(ApplicationContext applicationContext)
        throws BeansException {
        this.appContext = applicationContext;
    }
}
