package com.digiwin.mobile.mobileuibot.core.strategy.itemdetail;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.Container;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContent;
import com.digiwin.mobile.mobileuibot.core.component.layout.container.ContainerContentGroupLayoutTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainer;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerBody;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerBuilder;
import com.digiwin.mobile.mobileuibot.core.component.layout.headbodycontainer.HeadBodyContainerHead;
import com.digiwin.mobile.mobileuibot.core.component.search.SmartPreciseSearchItemList;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.PcUiBotPageDataUtil;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumnDefinition;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：搜索结果项的详情页构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelSearchItemDetailStrategy
 * @Author: Zaregoto
 * @Date: 2022/2/25 21:15
 */
@Component("uiBotModelSearchItemDetailStrategy")
public class UiBotModelSearchItemDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelSearchItemDetailStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private RuleService ruleService;

    @Autowired
    private ColumnTagService columnTagService;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private HeadBodyContainerBuilder headBodyContainerBuilder;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildSearchItemDetail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
//        uiBotModel = this.doMockData(pageSetting, apiRequest);
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {

        UiBotModel uiBotModel = null;
        String tmActivityId = Optional.ofNullable(apiRequest.getRawData())
                .map(apiRawData -> apiRawData.getString("tmActivityId")).orElse("");
        if (apiRequest.getRawData().get("params") instanceof List) {
            List<Map<String, Object>> paramsList = Optional.ofNullable(apiRequest.getRawData())
                    .map(apiRawData -> apiRawData.getObject("params", List.class)).orElse(Collections.emptyList());
            Map<String, Object> data = new HashMap<>();
            if (paramsList != null && paramsList.size() > 0) {
                String dataKey = (String) apiRequest.getRawData().get("dataKey");
                for (Map<String, Object> params : paramsList) {
                    if (dataKey.equals(params.get("graph_no"))) {
                        data = params;
                        break;
                    }
                }
            }
            List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPathAndPageId("cad_info", apiRequest.getPageId());
            stopWatch.start("Build Common Page Model");
            uiBotModel = this.buildUibotModel(pageSetting, apiRequest, columnTagList, data);
        } else {
            Map<String, Object> params = Optional.ofNullable(apiRequest.getRawData())
                    .map(apiRawData -> apiRawData.getObject("params", Map.class)).orElse(Collections.emptyMap());
            Map<String, Object> map = new HashMap<>(1);
            map.put("params", params);
            UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.simpleShow(tmActivityId, map,
                    apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());

            // 找到实际明细数据的layout
            UiBotLayout pcDataLayout = pcUiBotModel.searchPcTargetLayout().getTargetUiBotLayout();

            ItemDetail itemDetail = null;
            if (pcDataLayout.isTypeOfTable()) {
                itemDetail = this.processWithPcTable(pageSetting, apiRequest, pcUiBotModel, pcDataLayout);
            }

            stopWatch.start("Build Common Page Model");
            uiBotModel =
                    this.uiBotModelBuildService.buildModel(pageSetting, itemDetail, true);
        }

        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel buildUibotModel(PageSetting pageSetting, ApiRequest apiRequest, List<ColumnTag> columnTagList, Map<String, Object> data) {
        ItemDetail itemDetail = new ItemDetail(this.localeService);
        String locale = apiRequest.getLocale();
        List<UiBotLayout> layouts = pageSetting.getPageModel().getLayout();
        UiBotPageData pageData = pageSetting.getPageModel().getPageData();
        HeadBodyContainer headBodyContainer = new HeadBodyContainer();
        HeadBodyContainerHead headBodyContainerHead = new HeadBodyContainerHead();
        for (UiBotLayout uiBotLayout : layouts) {
            Map<String, Object> map = (Map<String, Object>) pageData.get(uiBotLayout.getSchema());
            if (map.get("head") != null) {
                Map<String, Object> headMap = (Map<String, Object>) map.get("head");
                if (headMap != null && headMap.size() > 0) {
                    List<Map<String, Object>> headLayOut = (List<Map<String, Object>>) headMap.get("layout");
                    String schema = "";
                    if (headLayOut != null && headLayOut.size() > 0) {
                        //目前就一个组件
                        for (Map<String, Object> lay1 : headLayOut) {
                            if (Container.COMPONENT_TYPE.equals(lay1.get("type"))) {
                                schema = (String) lay1.get("schema");
                                break;
                            }
                        }
                        if (schema != null && !schema.trim().equals("")) {
                            Map<String, Object> pageDataOut = (Map<String, Object>) headMap.get("pageData");
                            Container container = null;
                            if (pageDataOut != null && pageDataOut.size() > 0) {
                                container = JsonUtil.objectToJavaObject(pageDataOut.get(schema), Container.class);
                                container.setShowLessText(LocaleUtil.getMobileTextByDatabaseKey(locale, container.getShowLessText()) + Container.LESS_TEXT_SUFFIX_SYMBOL);
                                container.setShowMoreText(LocaleUtil.getMobileTextByDatabaseKey(locale, container.getShowMoreText()) + Container.MORE_TEXT_SUFFIX_SYMBOL);
                                container.setContentList(buildContentList(data, columnTagList, locale));
                                pageDataOut.put(schema, JsonUtil.objectToJavaObject(container, Map.class));
                            }
                            headBodyContainerHead.setPageData(JsonUtil.objectToJavaObject(pageDataOut, UiBotPageData.class));
                            UiBotLayout uiBotLayout1 = JsonUtil.objectToJavaObject(headLayOut.get(0), UiBotLayout.class);
                            List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
                            uiBotLayouts.add(uiBotLayout1);
                            headBodyContainerHead.setLayout(uiBotLayouts);
                            headBodyContainer.setHead(headBodyContainerHead);
                        }

                    }
                }
            }
            if (map.get("body") != null) {
                List<Map<String, Object>> bodyMaps = (List<Map<String, Object>>) map.get("body");
                if (bodyMaps != null && bodyMaps.size() > 0) {
                    List<HeadBodyContainerBody> headBodyContainerBodies = new ArrayList<>(bodyMaps.size());
                    for (Map<String, Object> bodyMap : bodyMaps) {
                        List<Map<String, Object>> bodyLayOuts = (List<Map<String, Object>>) bodyMap.get("layout");
                        if (bodyLayOuts == null || bodyLayOuts.size() == 0) {
                            continue;
                        }
                        Map<String, Object> bodyLayout = bodyLayOuts.get(0);
                        Map<String, Object> bodyPageData = (Map<String, Object>) bodyMap.get("pageData");
                        String schema = (String) bodyLayout.get("schema");
                        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
                        uiBotLayouts.add(JsonUtil.objectToJavaObject(bodyLayout, UiBotLayout.class));

                        if (Webview.COMPONENT_TYPE.equals(bodyLayout.get("type"))) {
                            HeadBodyContainerBody headBodyContainerBody = new HeadBodyContainerBody();
                            headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByKey(locale, (String) bodyMap.get("title")));

                            Webview webview = Optional.ofNullable(JsonUtil.objectToJavaObject(bodyPageData.get(schema), Webview.class)).orElse(new Webview());
                            String resultUrl = "";
                            String prefixUrl = AppContext.getApiUrlSetting().getMuiUrl() + "/graph-viewer?online_drawing_format=2&cad_url=";
                            if ("url2D".equals(schema)) {
                                resultUrl = (String) data.get("cad_url_2d");
                            } else if ("url3D".equals(schema)) {
                                resultUrl = (String) data.get("cad_url_3d");
                            }
                            if (StringUtils.hasLength(resultUrl) && !resultUrl.toLowerCase().contains("null")) {
                                webview.initSetting(locale);
                                webview.setUrl(prefixUrl + resultUrl);
                                headBodyContainerBody.setLayout(uiBotLayouts);
                                bodyPageData.put(schema, JsonUtil.objectToJavaObject(webview, Map.class));
                                headBodyContainerBody.setPageData(JsonUtil.objectToJavaObject(bodyPageData, UiBotPageData.class));
                            } else {
                                headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "暂无数据");
                            }
                            headBodyContainerBodies.add(headBodyContainerBody);
                        } else if (SmartPreciseSearchItemList.COMPONENT_TYPE.equals(bodyLayout.get("type"))) {
                            //这个图纸是没有历史数据的
                            HeadBodyContainerBody headBodyContainerBody = new HeadBodyContainerBody();
                            headBodyContainerBody.setTitle(LocaleUtil.getMobileTextByDatabaseKey(locale, (String) bodyMap.get("title")));
                            headBodyContainerBody.createEmptyContentModel(apiRequest.getLocale(), "暂无数据");
                            headBodyContainerBodies.add(headBodyContainerBody);
                        }
                    }
                    headBodyContainer.setBody(headBodyContainerBodies);
                }
            }
            itemDetail.put(uiBotLayout.getSchema(), headBodyContainer);
        }
        return this.uiBotModelBuildService.buildModel(pageSetting, itemDetail, true);
    }

    private List<ContainerContent> buildContentList(Map<String, Object> data, List<ColumnTag> columnTagList, String locale) {
        List<ContainerContent> containerContents = new ArrayList<>();
        Map<Integer, List<ColumnTag>> groupNos = new HashMap<>();
        // 分组字段tag
        List<ColumnTag> groupTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase("cad_info") && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_GROUP.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getGroupNo))
                .collect(Collectors.toList());
        for (ColumnTag columnTag : columnTagList) {
            List<ColumnTag> columnTags = groupNos.get(columnTag.getGroupNo());
            if (columnTags != null && columnTags.size() > 0) {
                columnTags.add(columnTag);
            } else {
                columnTags = new ArrayList<>();
                columnTags.add(columnTag);
                groupNos.put(columnTag.getGroupNo(), columnTags);
            }
        }
        for (Integer groupNo : groupNos.keySet()) {
            ContainerContent containerContent = new ContainerContent();
            List<ColumnTag> sameGroupNoColumnTags = groupNos.get(groupNo);
            if (sameGroupNoColumnTags.size() == 1) {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.EXCLUSIVE_ONE_LINE.getValue());
            } else {
                containerContent.setGroupLayoutType(ContainerContentGroupLayoutTypeEnum.SHARE_ONE_LINE_AND_OVERFLOW_WITH_NEW_LINE.getValue());
            }
            List<UiBotModel> uiBotModels = buildGroupList(data, sameGroupNoColumnTags, locale);
            if (uiBotModels == null || uiBotModels.size() < 1) {
                continue;
            }
            containerContent.setGroupList(uiBotModels);
            containerContents.add(containerContent);
        }
        return containerContents;
    }

    private List<UiBotModel> buildGroupList(Map<String, Object> data, List<ColumnTag> sameGroupNoColumnTags, String locale) {
        List<UiBotModel> uiBotModels = new ArrayList<>(sameGroupNoColumnTags.size());
        for (ColumnTag columnTag : sameGroupNoColumnTags) {
            List<UiBotLayout> layoutList = new ArrayList<>();
            UiBotLayout layout = new UiBotLayout();
            UiBotModel uiBotModel = new UiBotModel(layoutList);
            String param = (String) data.get(columnTag.getSchema());
            if (param == null) {
                continue;
            }
            Field field = Field.create(columnTag.getmLabelText().get(locale), "1", param, columnTag.getSchema(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_CENTER.getValue());
            uiBotModel.addPageData(columnTag.getSchema(), field);
            layout.setSchema(columnTag.getSchema());
            layout.setType(Field.COMPONENT_TYPE);
            layoutList.add(layout);
            uiBotModels.add(uiBotModel);
        }
        return uiBotModels;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;
        data = FileUtil.readText("static/appstore-use/smartsearch-itemdetail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }

    private ItemDetail processWithPcTable(PageSetting pageSetting, ApiRequest apiRequest, UiBotModel pcUiBotModel,
                                          UiBotLayout pcDataLayout) {
        String mobileRequestRawDataDataKey = Optional.ofNullable(apiRequest.getRawData())
                .map(apiRawData -> apiRawData.getString("dataKey")).orElse("");
        String schema = pcDataLayout.getSchema();
        // 因为是TABLE类型的layout，所以数据一定是数组
        List<Map<String, Object>> bizDataList = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(schema);
        Assert.notNull(bizDataList, "pagedata." + schema + " cannot be null");

        List<UiBotTableColumnDefinition> tableColumnDefinitionList = pcDataLayout.getColumnDefs();
        // 分解出明细数据一行的字段列表
        List<UiBotTableColumn> tableColumns = UiBotTableColumnDefinition
                .decomposeTableColumnDefinitions(tableColumnDefinitionList);

        // FIXME 获取移动端的规则库。后续需要和PC端UIBot负责人商量更合适的做法
        List<Rule> mobileRuleList = this.ruleService.findByRulePath(schema);

        List<ColumnTag> columnTagList = this.columnTagService.listColumnTagsByPath(schema);

        ItemDetail itemDetail = new ItemDetail(this.localeService);

        for (UiBotLayout pageSettingLayout : pageSetting.getPageModel().getLayout()) {
            if (HeadBodyContainer.COMPONENT_TYPE.equals(pageSettingLayout.getType())
                    && pageSetting.getPageModel().getPageData().get(pageSettingLayout.getSchema()) != null) {
                HeadBodyContainer headBodyContainer = new HeadBodyContainer();
                for (Map<String, Object> dataKeyMatchedBizData : bizDataList) {
                    String dataKey = PcUiBotPageDataUtil.getBizDataKey(pcUiBotModel, schema, dataKeyMatchedBizData);
                    // 根据请求ApiRequest的rawData中放入的dataKey，只筛选出对应的业务数据进行组件的生成
                    if (dataKey.equals(mobileRequestRawDataDataKey)) {
                        // FIXME 写死了组件
                        headBodyContainer = this.headBodyContainerBuilder
                                .build(apiRequest, pageSetting, pcUiBotModel, HeadBodyContainer.class,
                                        dataKeyMatchedBizData, columnTagList, pageSettingLayout);
                        break;
                    }
                }
                itemDetail.put(pageSettingLayout.getSchema(), headBodyContainer);
            }
        }
        return itemDetail;
    }


}
