package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 功能: 底部弹窗展示数据 场景类型
 *
 * @author: wjw
 * @date: created at 2023/2/6
 */
public enum BottomWindowInfoTypeEnum {

    /**
     * 工时回报 人员上下线 ，已上线未下线资料
     */
    CHECK_IN_NOT_CHECK_OUT_DATA,
    /**
     * 工时回报 人员上下线 ，工时重叠资料
     */
    WORK_HOURS_OVERLAP_DATA,
    /**
     * 工时回报 人员上下线 ，除外工时重叠资料
     */
    EXCEPT_WORK_HOURS_OVERLAP_DATA,
    /**
     * 除外回报，工时重叠资料
     */
    EXCEPT_RETURN_WORK_HOURS_OVERLAP_DATA,
    /**
     * 除外回报，有在线工时
     */
    EXCEPT_RETURN_CHECK_IN_DATA,
    ;

    public static BottomWindowInfoTypeEnum exist(String name) {
        if (StringUtils.isEmpty(name)) {
            return null;
        }
        for (BottomWindowInfoTypeEnum bottomWindowInfoTypeEnum : BottomWindowInfoTypeEnum.values()) {
            if (Objects.equals(bottomWindowInfoTypeEnum.name(), name)) {
                return bottomWindowInfoTypeEnum;
            }
        }
        return null;
    }
}
