package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Optional;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildActionBizApprovalAgreeStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/26 16:26
 */
@Component("uiBotModelBuildActionPageStrategy")
public class UiBotModelBuildActionPageStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildActionPageStrategy.class);

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private ComponentParamAnalyzerFactory componentSubmitParamAnalyzerFactory;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        UiBotModel pageSettingModel = pageSetting.getPageModel();
        UiBotPageData pageData = pageSettingModel.getPageData();
        for (String pageDataKey : pageData.keySet()) {
            Optional<UiBotLayout> optType = pageSettingModel.getLayout().stream()
                    .filter(layout -> layout.getSchema().equalsIgnoreCase(pageDataKey))
                    .findFirst();
            String type = optType.orElse(new UiBotLayout()).getType();
            if (CustomGroup.COMPONENT_TYPE.equals(type)) {
                CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(pageDataKey), CustomGroup.class);
                customGroup.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), customGroup.getName()));
                CustomGroupContent customGroupContent = customGroup.getContent();
                for (UiBotLayout layout : customGroupContent.getLayout()) {
                    this.componentSubmitParamAnalyzerFactory.get(layout.getType()).handleDisplayParam(apiRequest, layout.getSchema(), customGroupContent.getPageData(), apiRequest.getRawData());
                }
                customGroup.setContent(customGroupContent);
                pageData.put(pageDataKey, customGroup);
            } else {
                this.componentSubmitParamAnalyzerFactory.get(type).handleDisplayParam(apiRequest, pageDataKey, pageData, apiRequest.getRawData());
            }
        }

        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, pageData);
        //转派提交刷新需要刷新TODO_LIST
        ModuleUtils.addRefreshPageId(uiBotModel, apiRequest.getRefreshPageId());
        return uiBotModel;
    }
}
