package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildApprovalTaskProgressStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/24 15:26
 */
@Component("uiBotModelBuildApprovalTaskProgressStrategy")
public class UiBotModelBuildApprovalTaskProgressStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildApprovalTaskProgressStrategy.class);

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private TaskService taskService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        List<TaskProgress> taskProgressList;
        if (!useMockData && !modelTypeShow) {
            taskProgressList = this.doActually(apiRequest);
        } else {
            taskProgressList = this.doMockData();
        }
        UiBotPageData pageData = new UiBotPageData();
        List<BottomButtonDigiwinAthena> bottomButtonList = new ArrayList<>();
        bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(apiRequest.getLocale()));

        // FIXME 这里用数据库中的配置好的页面模板中的task关键来判断，感觉不太好。后面要再想想
        pageSetting.getPageModel().getLayout().forEach(uiBotLayout -> {
            String schema = uiBotLayout.getSchema();
            if (schema.trim().toLowerCase().contains("task")) {
                pageData.put(schema, taskProgressList);
            } else {
                pageData.put(schema, bottomButtonList);
            }
        });


        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, pageData);
        if (StringUtils.hasLength(apiRequest.getDataId())) {
            uiBotModel.setDataId(apiRequest.getDataId());
        }
        return uiBotModel;
    }

    private List<TaskProgress> doActually(ApiRequest apiRequest) {
        return this.taskService.getTaskProgressList(
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getRawData(),
                null);
    }

    private List<TaskProgress> doMockData() {
        String data = FileUtil.readText("static/task-progress.json");

        return JSONArray.parseArray(data, TaskProgress.class);
    }
}
