package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.multi.MultiFunctionList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;


/**
 * 底部弹窗展示页（目前用于工时回报错误页面）
 *
 * @author 吴阳
 * @date 20230103
 */
@Component("uiBotModelBuildBottomWindowInfoStrategy")
public class UiBotModelBuildBottomWindowInfoStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildBottomWindowInfoStrategy.class);

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        ApiRawData rawData = apiRequest.getRawData();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        for (UiBotLayout uiBotLayout : layoutList) {
            String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case MessageBar.COMPONENT_TYPE:
                    pageData.put(schema, MessageBar.create((String) rawData.get("message")));
                    break;
                case MultiFunctionList.COMPONENT_TYPE:
                    MultiFunctionList multiFunctionList = JsonUtil.objectToJavaObject(pageData.get(schema), MultiFunctionList.class);
                    multiFunctionList.setRawData(rawData);
                    pageData.put(schema, multiFunctionList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) pageData.get(uiBotLayout.getSchema()), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                    }
                    if (Optional.ofNullable(rawData.getBoolean("submit_button")).orElse(false)) {
                        BottomButtonDigiwinAthena buttonDigiwinAthena = new BottomButtonDigiwinAthena();
                        buttonDigiwinAthena.setType(BottomButtonStyleEnum.STRESS.getValue());
                        buttonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, "提交"));
                        Action<Map<String, Object>> action = new Action<>();
                        action.setType(ActionTypeEnum.CALL_API_RAWDATA_OPEN_SUCCESS_PAGE.getValue());
                        action.setSuccessMsg(LocaleUtil.getMobileTextByKey(locale, "项目创建成功"));
                        action.setRawData(rawData);
                        buttonDigiwinAthena.setAction(action);
                        buttons.add(buttonDigiwinAthena);
                    }
                    pageData.put(uiBotLayout.getSchema(), buttons);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }


}
