package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.CardListToTableRawData;
import com.digiwin.mobile.mobileuibot.core.component.table.Table;
import com.digiwin.mobile.mobileuibot.core.component.table.TableHiddenConfig;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.IOException;

/**
 * <p>功能描述：Athena V2版-- cardList 转 table 页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildCardlistConvertTablePageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/4/17 17:31
 */
@Component
public class UiBotModelBuildCardlistConvertTablePageStrategy implements UiBotModelBuildStrategy {

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        // 构建table组件
        BaseMobileComponentWrapper<BaseMobileComponent> tableWrapper = this.buildTableWrapper(apiRequest);
        if (tableWrapper == null) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
            return uiBotModel;
        }
        uiBotModel.getRenderData().addWrapperedComponentToBody(tableWrapper);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> buildTableWrapper(ApiRequest apiRequest) {
        CardListToTableRawData tableRawData = JsonUtil.objectToJavaObject(apiRequest.getRawData(), CardListToTableRawData.class);
        if (tableRawData == null) {
            return null;
        }
        Card.DesignerRawCard.TableConfig tableConfig = tableRawData.getTableConfig();
        if (tableConfig == null || CollectionUtils.isEmpty(tableConfig.getContent())) {
            return null;
        }
        Table table = new Table();
        table.setName(tableConfig.getName());
        table.setColumnFreeze(tableConfig.getColumnFreeze());
        table.setTableHeader(Table.buildTableHeader(tableConfig.getContent(), tableConfig.getTableFixed()));
        table.setRows(Table.buildTableRows(tableConfig.getContent(), tableRawData.getDataList()));
        table.setDefaultLandscape(tableConfig.getDefaultLandscape());
        table.setIsLandscape(tableConfig.getIsLandscape());
        table.setHiddenConfig(this.buildTableHiddenConfig(apiRequest.getLocale()));

        return new BaseMobileComponentWrapper<>(table, "DW_" + Table.COMPONENT_TYPE);
    }

    private TableHiddenConfig buildTableHiddenConfig(String locale) {
        TableHiddenConfig tableHiddenConfig = new TableHiddenConfig();
        tableHiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(locale, "查看更多"));
        tableHiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(locale, "收起"));
        return tableHiddenConfig;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
