package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.common.PortalConstans;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.AllWorkComponent;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.AllWorkContent;
import com.digiwin.mobile.mobileuibot.core.component.business.portal.SampleApp;
import com.digiwin.mobile.mobileuibot.core.component.kingkong.BallRouter;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.AppModuleItem;
import com.digiwin.mobile.mobileuibot.core.component.layout.app.module.AppModuleCodeEnum;
import com.digiwin.mobile.mobileuibot.core.component.qrcode.QrCodeContentMsg;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.dashboard.UiBotModelBuildDashboardV2Strategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.portal.model.ApiRequsetPortal;
import com.digiwin.mobile.mobileuibot.project.common.ProjectConstant;
import com.digiwin.mobile.mobileuibot.project.model.LaunchableProject;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created by changcong 21064
 * Date 2025/9/4 18:52
 * Description  全部作业数据模型构建策略
 */
@Component("uiBotModelBuildFoundPageStrategy")
public class UiBotModelBuildFoundPageStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinSemcProxyService semcProxyService;

    @Autowired
    private UiBotModelBuildDashboardV2Strategy uiBotModelBuildDashboardV2Strategy;

    @Autowired
    private DigiwinAudcProxyService audcProxyService;

    @Autowired
    private BallRouter ballRouter;

    @Autowired
    private ProjectService projectService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setRenderVersion(2);
        UiBotRenderData renderData = UiBotRenderData.createEmptyRenderData();
        AllWorkComponent allWorkComponent = new AllWorkComponent();
        List<AllWorkContent> content = new ArrayList<>();
        allWorkComponent.setContent(content);
        //组装组件
        //移动自定义
        ApiRequsetPortal apiRequsetPortal = new ApiRequsetPortal();
        apiRequsetPortal.setIsAll(true);
        apiRequsetPortal.setLocale(apiRequest.getLocale());
        apiRequsetPortal.setIamUserToken(apiRequest.getIamUserToken());
        List<MobileClassificatonResp> classificatonRespList = semcProxyService.getClassificationList(apiRequsetPortal);
        for (MobileClassificatonResp mobileClassificatonResp : classificatonRespList){
            if (CollectionUtils.isEmpty(mobileClassificatonResp.getMobileCustomAppList())){
                continue;
            }
            AllWorkContent allWorkContent = new AllWorkContent();
            allWorkContent.setTitle(mobileClassificatonResp.getClassificationName());
            List<SampleApp> children = new ArrayList<>();
            allWorkContent.setChildren(children);
            for (MobileDatasourceInfoResp mobileDatasourceInfoResp : mobileClassificatonResp.getMobileCustomAppList()){
                SampleApp sampleApp = new SampleApp();
                sampleApp.setName(mobileDatasourceInfoResp.getName());
                sampleApp.setIcon(mobileDatasourceInfoResp.getIcon());
                MobileBallResp mobileBallResp = new MobileBallResp();
                mobileBallResp.setCustomApplicationId(mobileDatasourceInfoResp.getId());
                mobileBallResp.setCallBackUrl("");
                mobileBallResp.setBallName("");
                Action action = ballRouter.getCompoentAction(PortalConstans.CUSTOM_APPLICATION, apiRequest, mobileBallResp);
                sampleApp.setAction(action);
                children.add(sampleApp);
            }
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(allWorkContent.getChildren())) {
                content.add(allWorkContent);
            }
        }
        //报表
        boolean hasReportModule = false;
        List<DigiwinAtmcTmData> tmDataList = audcProxyService.getTmDataList(apiRequest.getClientId(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (!CollectionUtils.isEmpty(tmDataList)) {
            for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
                AllWorkContent allWorkContent = new AllWorkContent();
                allWorkContent.setTitle(digiwinAtmcTmData.getAppName());
                List<SampleApp> children = new ArrayList<>();
                allWorkContent.setChildren(children);
                if (CollectionUtils.isEmpty(digiwinAtmcTmData.getBaseItemDtoList())) {
                    continue;
                }
                for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                    if (dataReport.isAllow()) {
                        if (ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())){
                            SampleApp sampleApp = new SampleApp();
                            sampleApp.setName(dataReport.getName());
                            sampleApp.setIcon(dataReport.getIcon());
                            Action action = new Action();
                            action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                            action.setRequestUrl(buildTbbH5Url(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), Optional.ofNullable(dataReport.getResCode()).filter(StrUtil::isNotEmpty).orElse(dataReport.getCode()), dataReport.getName()));
                            children.add(sampleApp);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(children)){
                    hasReportModule = true;
                }
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(allWorkContent.getChildren())) {
                    content.add(allWorkContent);
                }
            }
        }
        //  手动发起项目
        List<LaunchableProject> accessibleLaunchableProjectList =
                this.projectService.getLaunchableProjectList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (!CollectionUtils.isEmpty(accessibleLaunchableProjectList)){
            AllWorkContent allWorkContent = new AllWorkContent();
            allWorkContent.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.START_PROJECT.getName()));
            List<SampleApp> children = new ArrayList<>();
            allWorkContent.setChildren(children);
            for (LaunchableProject launchableProject : accessibleLaunchableProjectList){
                SampleApp sampleApp = new SampleApp();
                if (ProjectConstant.INTELLIGENT_MATERIAL_INSPECTION_PROJECT_CODE.equals(launchableProject.getCode())) {
                    sampleApp.setName(launchableProject.getName().substring(0, 4));
                } else {
                    sampleApp.setName(launchableProject.getName());
                }
                Action<Map<String, Object>> action = new Action<>();
                sampleApp.setAction(action);
                // 发起项目设计器跳转需要的信息
                if (BooleanUtils.isTrue(launchableProject.getIsDesigner())) {
                    action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                    action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_PROJECT_CREATE_V2_PAGE.toString());
                    action.setJumpPageTitle(launchableProject.getName());
                    Map<String, Object> rawData = new HashMap<>(2);
                    rawData.put("project_introduce", launchableProject.getDesc());
                    rawData.put("project_name", launchableProject.getName());
                    rawData.put("dataId", launchableProject.getCreateSuffix());
                    action.setRawData(rawData);
                } else {
                    if ("scan_freightage_start".equalsIgnoreCase(launchableProject.getCode())) {
                        Action rawDataAction = new Action();
                        rawDataAction.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                        rawDataAction.setJumpPageTitle(launchableProject.getName());
                        rawDataAction.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        rawDataAction.setDataId(launchableProject.getCreateSuffix());
                        Map<String, Object> rawData = new HashMap<>(2);
                        rawData.put("bizType", QrCodeContentMsg.BIZ_TYPE_ASN_CODE);
                        rawData.put("action", rawDataAction);
                        action.setType(ActionTypeEnum.OPEN_NATIVE_SCAN.getValue());
                        action.setRawData(rawData);
                    } else {
                        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_PROJECT_CREATE.name());
                        action.setJumpPageTitle(launchableProject.getName());
                        action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                        action.setDataId(launchableProject.getCreateSuffix());
                    }
                }
                children.add(sampleApp);
            }
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(allWorkContent.getChildren())) {
                content.add(allWorkContent);
            }
        }
        //数据录入
        List<DigiwinAtmcTmData> basicDataList =
                audcProxyService.getBasicDataList(apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        if (CollectionUtils.isEmpty(basicDataList)) {
        }else {
            String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
            // 获取type为数据录入的数据
            List<String> tmActivityIdList = activityFilterService
                    .findByTypeOfMobileDesignerConfig(MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue(), apiRequest.getTenantId(), tenantVersion)
                    .stream().map(MobileDesignerConfig::getTmActivityId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(tmActivityIdList)) {
            }else {
                if (!CollectionUtils.isEmpty(basicDataList)) {
                    for (DigiwinAtmcTmData digiwinAtmcTmData : basicDataList) {
                        if (CollectionUtils.isEmpty(digiwinAtmcTmData.getBaseItemDtoList())) {
                            continue;
                        }
                        AllWorkContent allWorkContent = new AllWorkContent();
                        allWorkContent.setTitle(digiwinAtmcTmData.getAppName());
                        List<SampleApp> children = new ArrayList<>();
                        allWorkContent.setChildren(children);
                        for (DigiwinAtmcTmDataReport digiwinAtmcTmDataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                            SampleApp sampleApp = new SampleApp();
                            if (digiwinAtmcTmDataReport.isAllow() && tmActivityIdList.contains(digiwinAtmcTmDataReport.getCode())){
                                sampleApp.setName(digiwinAtmcTmDataReport.getName());
                            sampleApp.setIcon(digiwinAtmcTmDataReport.getIcon());
                            Action<?> action = new Action<>();

                            action.setType(ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                            if ("SIGN-DOCUMENT".equals(digiwinAtmcTmDataReport.getCategory())) {
                                // 单档多栏(模型驱动)
                                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BASIC_PAGE.name());
                            } else if (Lists.newArrayList("DOUBLE-DOCUMENT-FORM", "DOUBLE-DOCUMENT", "DOUBLE-DOCUMENT-MULTI").contains(digiwinAtmcTmDataReport.getCategory())) {
                                // 单档(模型驱动) / 双档(模型驱动) / 多档(模型驱动)
                                action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_BASIC_DATA_ENTRY_BROWSE_PAGE.name());
                            } else {
                                // 不存在，返回
                                continue;
                            }
                            action.setJumpPageTitle(digiwinAtmcTmDataReport.getName());
                            action.setDataId(digiwinAtmcTmDataReport.getCode());
                            sampleApp.setAction(action);
                            children.add(sampleApp);
                        }
                    }
                        allWorkContent.setChildren(children);
                        if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(allWorkContent.getChildren())) {
                            content.add(allWorkContent);
                        }
                    }
                }
            }
        }
        //智能入口
        List<AppModuleItem> intelligentEnterAppModuleItemList = uiBotModelBuildDashboardV2Strategy.getIntelligentEnterAppModuleItemList(apiRequest, hasReportModule);
        if (!CollectionUtils.isEmpty(intelligentEnterAppModuleItemList)){
            AllWorkContent allWorkContent = new AllWorkContent();
            allWorkContent.setTitle(localeService.getLanguageValue(apiRequest.getLocale(), AppModuleCodeEnum.INTELLIGENT_ENTER.getName()));
            List<SampleApp> children = new ArrayList<>();
            allWorkContent.setChildren(children);
            for (AppModuleItem appModuleItem : intelligentEnterAppModuleItemList){
                SampleApp sampleApp = new SampleApp();
                sampleApp.setName(appModuleItem.getName());
                sampleApp.setIcon(appModuleItem.getImageUrl());
                sampleApp.setAction(appModuleItem.getAction());
                children.add(sampleApp);
            }
            if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(allWorkContent.getChildren())) {
                content.add(allWorkContent);
            }
        }
        //绿色智机
        //查询用户模组作业
        List<TopicPresetResp> topicPresetRespList = semcProxyService.queryAllJob(new ArrayList<>(), apiRequest.getLocale(), apiRequest.getIamUserToken());
        if (!CollectionUtils.isEmpty(topicPresetRespList)){
            for (TopicPresetResp topicPresetResp : topicPresetRespList){
                if (CollectionUtils.isEmpty(topicPresetResp.getTopicpList())){
                    continue;
                }
                AllWorkContent allWorkContent = new AllWorkContent();
                allWorkContent.setTitle(topicPresetResp.getModuleName());
                List<SampleApp> children = new ArrayList<>();
                allWorkContent.setChildren(children);
                for (TopicPresetJobResp topicPresetJobResp : topicPresetResp.getTopicpList()){
                    SampleApp sampleApp = new SampleApp();
                    sampleApp.setName(topicPresetJobResp.getTopicPresetName());
                    sampleApp.setIcon(topicPresetJobResp.getTopicPresetIcon());
                    Action action = new Action();
                    action.setOpenWebPageTitle(topicPresetJobResp.getTopicPresetName());
                    //跳转url
                    action.setRequestUrl(topicPresetJobResp.getTopicPresetUrl());
                    //跳转类型-webview
                    action.setType(ActionTypeEnum.OPEN_WEB_PAGE.getValue());
                    //如果没有设置公司别和厂别，给出提示
                    if (!topicPresetJobResp.getIsSetCompany()) {
                        action.setType(ActionTypeEnum.SHOW_TOAST.getValue());
                        action.setToastMsg(localeService.getLanguageValue(apiRequest.getLocale(), "请先设置公司别和厂别"));
                    }
                    sampleApp.setAction(action);
                    children.add(sampleApp);
                }
                if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(allWorkContent.getChildren())) {
                    content.add(allWorkContent);
                }
            }
        }
        BaseMobileComponentWrapper<BaseMobileComponent> componentWrapper = new BaseMobileComponentWrapper<>(allWorkComponent,"DW_" + AllWorkComponent.COMPONENT_TYPE);
        List<BaseMobileComponentWrapper<BaseMobileComponent>> body = new ArrayList<>();
        body.add(componentWrapper);
        renderData.setBody(body);
        uiBotModel.setRenderData(renderData);
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    public static String buildTbbH5Url(String locale, String iamUserToken, String tenantId, String resCode, String name) {
        String encode = name;
        String hostUrl = AppContext.getApiUrlSetting().getTbbUrl();
        try {
            encode = URLEncoder.encode(name, "utf-8");
            hostUrl = URLEncoder.encode(hostUrl, "utf-8");
        } catch (Exception ignored) {

        }
        return AppContext.getApiUrlSetting().getTbbH5Url() + "?tenantId=" + tenantId
                + "&dashboardId=" + resCode
                + "#/pages/board?"
                + "locale=" + locale
                + "&mobile_user_token=" + iamUserToken
                + "&systemtype=athena"
                + "&dashboardtype=template"
                + "&name=" + encode;
    }
}
