package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardCategory;
import com.digiwin.mobile.mobileuibot.core.component.list.card.CardList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.pattern.bean.PatternDetail;
import com.digiwin.mobile.mobileuibot.project.service.ProjectService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

/**
 * 项目列表
 *
 * @author zhangjj
 * @date 2021/6/23 0023 14:05
 */
@Component("uiBotModelBuildJumpProjectOrTaskListStrategy")
public class UiBotModelBuildJumpProjectOrTaskListStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildJumpProjectOrTaskListStrategy.class);

    @Autowired
    private ProjectService projectService;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        CardList cardList;
        boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData && !modelTypeShow) {
            //跳转项目列表
            if (PatternDetail.PATTERN_TYPE_PROJECT_LIST.equals(apiRequest.getJumpType())) {
                cardList = this.projectService.getCardList(apiRequest, false);
            } else {
                cardList = new CardList();
            }

        } else {
            cardList = this.doMockData(apiRequest);
        }

        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, cardList);
        return uiBotModel;
    }

    private CardList doMockData(ApiRequest apiRequest) {
        String data = FileUtil.readText("static/appstore-use/project-list-show-20220523.json");
        CardList cardList = null;
        if (null != data && !data.isEmpty()) {
            List<CardCategory> cardCategoryList = JSONArray.parseArray(data, CardCategory.class);
            cardList = new CardList(cardCategoryList);
        }
        return cardList;
    }
}
