package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.InputGroupSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.multi.InputWindowMultiSelect;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcCalendar;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：UiBot数据模型构建策略接口--行事历任务详情页面构建</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildManualTaskDetailActionStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/18 22:28
 */
@Component("uiBotModelBuildManualTaskDetailActionStrategy")
public class UiBotModelBuildManualTaskDetailActionStrategy
        implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildManualTaskDetailActionStrategy.class);

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildManualTaskDetailAction");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
//        uiBotModel = this.doMockData(pageSetting, apiRequest);
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        //页面卡片化
        uiBotModel.setCustomGroup();
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        stopWatch.start("GetData From Athena API");
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotModel pcUibotModel = this.digiwinPcUiBotProxyService.simpleShow("uibotManualTask", Collections.emptyMap(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List<DigiwinAtmcCalendar> digiwinAtmcCalendars = digiwinAtmcProxyService.queryAllTeamMember(apiRequest.getIamUserToken(), locale);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        if (uiBotLayouts != null && uiBotLayouts.size() > 0) {
            List<Rule> mobileRuleList = this.ruleService.findByRulePath(pcUibotModel.getLayout().get(0).getSchema());
            Map<String, Object> data = (Map<String, Object>) pcUibotModel.getPageData().get(pcUibotModel.getLayout().get(0).getSchema());
            for (UiBotLayout uiBotLayout : uiBotLayouts) {
                switch (uiBotLayout.getType()) {
                    case Field.COMPONENT_TYPE:
                        Field field = Field.create(uiBotLayout.getmLabelText().get(locale), (String) data.get(uiBotLayout.getSchema()), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, false);
                        if (field != null) {
                            if ("executorUserId".equals(uiBotLayout.getSchema()) && !StringUtils.hasLength(field.getValue())) {
                                field.setValue(apiRequest.getUserId());
                                field.setHidden(true);
                            }
                            pageData.put(uiBotLayout.getSchema(), field);
                        }
                        break;
                    case InputSwitch.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), InputSwitch.create(uiBotLayout.getmLabelText().get(locale), apiRequest.getSelectDate()));
                        break;
                    case Divider.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), Divider.create(DividerTypeEnum.ELEMENT_DIVIDER));
                        break;
                    case ButtonSingleSelect.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), ButtonSingleSelect.create(uiBotLayout, data, pageSetting.getPageId(), locale, false));
                        break;
                    case InputDateTimePicker.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), InputDateTimePicker.create(uiBotLayout, data, locale, apiRequest.getSelectDate(), false));
                        break;
                    case InputMultiText.COMPONENT_TYPE:
                        InputMultiText inputMultiText = InputMultiText.create(uiBotLayout, mobileRuleList, data, locale, false, false);
                        // 计划工作说明非必填
                        if ("description".equalsIgnoreCase(uiBotLayout.getSchema())) {
                            inputMultiText.setRequired(false);
                        }
                        pageData.put(uiBotLayout.getSchema(), inputMultiText);
                        break;
                    case InputSingleText.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), InputSingleText.create(uiBotLayout, "", data, locale, false));
                        break;
                    case Attachment.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), Attachment.create(uiBotLayout, data, locale, null, false));
                        break;
                    case InputWindowMultiSelect.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), InputWindowMultiSelect.create(uiBotLayout, AppContext.getBaseUrl() + "/mobile/v1/proxy/window/getTeamMembers", locale, 1));
                        break;
                    case InputGroupSingleSelect.COMPONENT_TYPE:
                        pageData.put(uiBotLayout.getSchema(), InputGroupSingleSelect.create(uiBotLayout, digiwinAtmcCalendars, locale));
                        break;
                    case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                        List<Map<String, Object>> bottomButtons = (List<Map<String, Object>>) pageData.get("bottomButtons");
                        Map<String, Object> submit = bottomButtons.get(0);
                        BottomButtonDigiwinAthena bottomButtonDigiwinAthena = BottomButtonDigiwinAthena.create(BottomButtonStyleEnum.STRESS.getValue(), LocaleUtil.getMobileTextByKey(locale, "提交"));

                        Map<String, Object> action = (Map<String, Object>) submit.get("action");
                        Map<String, Object> rawData = (Map<String, Object>) action.get("rawData");
                        rawData.put("actions", pcUibotModel.getLayout().get(0).getActions());
                        rawData.put("data", data);
                        Action action1 = new Action();
                        action1.setJumpPageId((String) submit.get("jumpPageId"));
                        if (StringUtils.hasLength(apiRequest.getPreviousPageId())) {
                            action1.setType(ActionTypeEnum.BACK_WITH_DEFAULT_DATA.getValue());
                        } else {
                            action1.setType(ActionTypeEnum.CALL_API.getValue());
                        }

                        action1.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "提交"));
                        action1.setRawData(rawData);
                        action1.setScreenShotSwitch(false);
                        bottomButtonDigiwinAthena.setAction(action1);
                        bottomButtonDigiwinAthena.setId((String) submit.get("id"));
                        ModuleUtils.addRefreshPageId(bottomButtonDigiwinAthena, "");
                        List<BottomButtonDigiwinAthena> buttonDigiwinAthenas = new ArrayList<>(1);
                        buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                        pageData.put(uiBotLayout.getSchema(), buttonDigiwinAthenas);
                        break;
                    default:
                        break;
                }
            }
        }
        uiBotModel.setFinished(pcUibotModel.getFinished());
        uiBotModel.setFinishedTitle(pcUibotModel.getFinishedTitle());
        stopWatch.stop();

        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = null;
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL_APPROVAL_AGREE.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            data = FileUtil.readText("static/appstore-use/manual-task-create.json");
        }
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }
        // 针对mock数据中的开始时间和结束时间做处理，使得即使用模拟数据打开画面，也可以是真实的数据
        LocalDateTime now = LocalDateTime.now();
        InputDateTime inputDateTime = new InputDateTime(
                now.getYear() + "",
                DateTimeUtil.getFullMonth(now.getMonthValue()),
                DateTimeUtil.getFullDate(now.getDayOfMonth()),
                DateTimeUtil.getFullHour(now.getHour()),
                DateTimeUtil.getFullMinute(now.getMinute())
        );
        String key = "";
        InputDateTimePicker timePicker = null;
        if (uiBotModel.getPageData().containsKey("startTime")) {
            key = "startTime";
            Object rawStartTime = uiBotModel.getPageData().get(key);
            timePicker = JsonUtil.objectToJavaObject(rawStartTime, InputDateTimePicker.class);
            timePicker.setDatetimeValue(inputDateTime);
            uiBotModel.getPageData().put(key, timePicker);
        }
        if (uiBotModel.getPageData().containsKey("endTime")) {
            key = "endTime";
            Object rawEndTime = uiBotModel.getPageData().get(key);
            timePicker = JsonUtil.objectToJavaObject(rawEndTime, InputDateTimePicker.class);
            timePicker.setDatetimeValue(inputDateTime);
            uiBotModel.getPageData().put(key, timePicker);
        }
        return uiBotModel;
    }

}
