package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.*;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.ButtonSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.rule.Rule;
import com.digiwin.mobile.mobileuibot.core.rule.RuleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcBacklogDetail;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcProjectPerformer;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcReassignUser;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.service.DigiwinDmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：UiBot数据模型构建策略接口--我的行事历任务详情页面构建</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildManualTaskDetailStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/18 22:28
 */
@Component("uiBotModelBuildManualTaskDetailStrategy")
public class UiBotModelBuildManualTaskDetailStrategy
        implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildManualTaskDetailStrategy.class);

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private DigiwinDmcProxyService digiwinDmcProxyService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildManualTaskDetail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
//        uiBotModel = this.doMockData(pageSetting, apiRequest);
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);

        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        stopWatch.start("GetData From Athena API");
        UiBotModel pcUibotModel = this.digiwinPcUiBotProxyService
                .showUibotManualTask(apiRequest.getDataId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                        apiRequest.getLocale(), apiRequest.getRawData());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        DigiwinAtmcBacklogDetail digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService
                .getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId());
        boolean isTeamTask = apiRequest.getRawData().getBooleanValue("isTeamTask");
        // 行事历任务是否已完成的标志位，会影响整个页面的组件是否可编辑、是否有按钮等
        boolean isComplete = this.judgeDetailComplete(pcUibotModel);
        // 如果是我的团队内看到的行事历任务，则强制将isComplete标志位设置成true，控制展示的组件是否可编辑
        if (isTeamTask) {
            isComplete = true;
            digiwinAtmcBacklogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(
                    apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getDataId()
            );
        }
        //转派记录
        List<DigiwinReassignReport> reassignReportList = digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(),
                apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        //判断是否支持转派
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        String customerNo = null;
        String customerName = null;
        if (!CollectionUtils.isEmpty(uiBotLayouts)) {
            /**
             * 是否为团队行事历的入口
             */
            boolean teamEnter = apiRequest.getTeamEnter() == null ? false : apiRequest.getTeamEnter();
            boolean isExecutorUser = false;
            List<Rule> mobileRuleList = this.ruleService.findByRulePath(pcUibotModel.getLayout().get(0).getSchema());
            Map<String, Object> data = (Map<String, Object>) pcUibotModel.getPageData().get(pcUibotModel.getLayout().get(0).getSchema());
            Map<String, Object> calendarTaskInfo = (Map<String, Object>) data.get("calendar_task_info");
            if (calendarTaskInfo != null && calendarTaskInfo.size() > 0) {
                customerNo = (String) calendarTaskInfo.get("customer_no");
                customerName = (String) calendarTaskInfo.get("customer_name");
            }
            List<HashMap<String, String>> executorList = (List<HashMap<String, String>>) data.get("executorList");
            for (HashMap<String, String> executor : executorList) {
                if (apiRequest.getUserId().equals(executor.get("executorUserId"))) {
                    isExecutorUser = true;
                    break;
                }
            }
            if (!teamEnter) {
                isExecutorUser = true;
            }

            if (isExecutorUser) {
                for (UiBotLayout uiBotLayout : uiBotLayouts) {
                    switch (uiBotLayout.getType()) {
                        case TitleBody.COMPONENT_TYPE:
                            pageData.put(uiBotLayout.getSchema(), TitleBody.create(locale, digiwinAtmcBacklogDetail, data));
                            break;
                        case Field.COMPONENT_TYPE:
                            Field field;
                            if ("executorList".equals(uiBotLayout.getSchema())) {
                                field = Field.create(uiBotLayout.getmLabelText().get(locale), executorList.get(0).get("executorUserName"), FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, executorList.get(0), isComplete);
                            } else if (uiBotLayout.getSchema().contains(".")) {
                                if (!StringUtils.hasLength(customerNo)) {
                                    continue;
                                }
                                String schema = uiBotLayout.getSchema().split("\\.")[1];
                                field = Field.create(uiBotLayout.getmLabelText().get(locale), (String) calendarTaskInfo.get(schema), FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, isComplete);
                            } else {
                                field = Field.create(uiBotLayout.getmLabelText().get(locale), (String) data.get(uiBotLayout.getSchema()), FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, isComplete);
                            }
                            if (field != null) {
                                pageData.put(uiBotLayout.getSchema(), field);
                            }
                            break;
                        case Divider.COMPONENT_TYPE:
                            pageData.put(uiBotLayout.getSchema(), Divider.create(DividerTypeEnum.ELEMENT_DIVIDER));
                            break;
                        case ButtonSingleSelect.COMPONENT_TYPE:
                            pageData.put(uiBotLayout.getSchema(), ButtonSingleSelect.create(uiBotLayout, data, pageSetting.getPageId(), locale, isComplete));
                            break;
                        case InputDateTimePicker.COMPONENT_TYPE:
                            pageData.put(uiBotLayout.getSchema(), InputDateTimePicker.create(uiBotLayout, data, locale, "", isComplete));
                            break;
                        case InputMultiText.COMPONENT_TYPE:
                            pageData.put(uiBotLayout.getSchema(), InputMultiText.create(uiBotLayout, mobileRuleList, data, locale, false, isComplete));
                            break;
                        case InputSingleText.COMPONENT_TYPE:
                            pageData.put(uiBotLayout.getSchema(), InputSingleText.create(uiBotLayout, "0", data, locale, isComplete));
                            break;
                        case Attachment.COMPONENT_TYPE:
                            Attachment attachment = Attachment.create(uiBotLayout, data, locale, digiwinDmcProxyService, isComplete);
                            if (attachment != null) {
                                pageData.put(uiBotLayout.getSchema(), attachment);
                            }
                            break;
                        case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                            if (!isComplete) {
                                List<Map<String, Object>> bottomButtons = (List<Map<String, Object>>) pageData.get("bottomButtons");
                                Map<String, Object> submit = bottomButtons.get(0);
                                BottomButtonDigiwinAthena bottomButtonDigiwinAthena = BottomButtonDigiwinAthena.create(BottomButtonStyleEnum.STRESS.getValue(), LocaleUtil.getMobileTextByKey(locale, "提交"));

                                Map<String, Object> action = (Map<String, Object>) submit.get("action");
                                Map<String, Object> rawData = (Map<String, Object>) action.get("rawData");
                                rawData.put("actions", pcUibotModel.getLayout().get(0).getActions());
                                rawData.put("data", data);
                                Action action1 = new Action();
                                action1.setJumpPageId((String) submit.get("jumpPageId"));
                                action1.setType(ActionTypeEnum.CALL_API.getValue());
                                action1.setJumpPageTitle(LocaleUtil.getMobileTextByKey(locale, "提交"));
                                action1.setRawData(rawData);
                                action1.setScreenShotSwitch(false);
                                bottomButtonDigiwinAthena.setAction(action1);
                                bottomButtonDigiwinAthena.setId((String) submit.get("id"));
                                ModuleUtils.addRefreshPageId(bottomButtonDigiwinAthena, "");
                                List<BottomButtonDigiwinAthena> buttonDigiwinAthenas = new ArrayList<>(1);
                                buttonDigiwinAthenas.add(bottomButtonDigiwinAthena);
                                pageData.put(uiBotLayout.getSchema(), buttonDigiwinAthenas);
                            } else {
                                pageData.remove(uiBotLayout.getSchema());
                            }
                            break;
                        default:
                            break;
                    }
                }
            } else {
                UiBotPageData readOnlyPageData = new UiBotPageData();
                for (UiBotLayout uiBotLayout : uiBotLayouts) {
                    switch (uiBotLayout.getType()) {
                        case TitleBody.COMPONENT_TYPE:
                            readOnlyPageData.put(uiBotLayout.getSchema(), TitleBody.create(locale, digiwinAtmcBacklogDetail, data));
                            break;
                        case Field.COMPONENT_TYPE:
                            Field field;
                            if ("executorList".equals(uiBotLayout.getSchema())) {
                                field = Field.create(uiBotLayout.getmLabelText().get(locale), executorList.get(0).get("executorUserName"), FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, isComplete);
                            } else if (uiBotLayout.getSchema().contains(".")) {
                                if (!StringUtils.hasLength(customerNo)) {
                                    continue;
                                }
                                String schema = uiBotLayout.getSchema().split("\\.")[1];
                                field = Field.create(uiBotLayout.getmLabelText().get(locale), (String) calendarTaskInfo.get(schema), FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, isComplete);
                            } else {
                                field = Field.create(uiBotLayout.getmLabelText().get(locale), (String) data.get(uiBotLayout.getSchema()), FieldLabelStyleTypeEnum.LABEL_GREY.getValue(), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT, isComplete);
                            }
                            if (field != null) {
                                readOnlyPageData.put(uiBotLayout.getSchema(), field);
                            }
                            break;
                        default:
                            break;
                    }
                }
                uiBotModel.setPageData(readOnlyPageData);
            }
        }

        //传参数给左滑推荐资讯
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getRight() != null) {
            LeftHeader header = uiBotModel.getSlip().getSlipConfig().getRight().getHeader();
            header.getSubTitle().setContent(digiwinAtmcBacklogDetail.getName());
            if (uiBotModel.getSlip().getSlipConfig().getRight().getBody() != null) {
                Map<String, Object> params = uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().getParams();
                params.put("tenant_id", apiRequest.getTenantId());
                params.put("user_id", apiRequest.getUserId());
                params.put("transaction_id", digiwinAtmcBacklogDetail.getId());
                params.put("transaction_code", digiwinAtmcBacklogDetail.getTmActivityId());
                if (customerNo != null) {
                    params.put("customer_no", customerNo);
                }
                if (customerName != null) {
                    params.put("customer_name", customerName);
                }
                params.put("dataId", digiwinAtmcBacklogDetail.getTmActivityId());
            }
        }
        //右滑新增联系人
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getLeft() != null) {

            SlipConfigLeft left = uiBotModel.getSlip().getSlipConfig().getLeft();
            //先查EOC、IAM等账号信息（不包含邮箱、手机号等）
            List<DigiwinAtmcProjectPerformer> projectPerformers = digiwinAtmcProxyService.getPerformerListByBackLogId(digiwinAtmcBacklogDetail.getBacklogId(),
                    apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
            //在查邮箱、手机号等信息
            EocPersonResponse eocPersonResponse = digiwinEocProxyService.getSimplePersonList(
                    apiRequest.getIamUserToken(), 9999, 1, "");
            SlipConfigLeft.setPersonList(left, projectPerformers, eocPersonResponse);
        }
        //已完成的行事历任务不需要转派功能，未完成的行事历任务有转派数据则需要有转派功能
        if (!this.judgeDetailComplete(pcUibotModel) && digiwinAtmcBacklogDetail != null && digiwinAtmcBacklogDetail.backlogHasReassignData()) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(digiwinAtmcBacklogDetail.getReassign());
            buttonActionRawData.put("appCode", digiwinAtmcBacklogDetail.getAppCode());
            buttonActionRawData.put("backlogDetail", digiwinAtmcBacklogDetail);
            buttons.add(Button.createApprovalReassign(apiRequest.getDataId() + "",
                    buttonActionRawData,
                    apiRequest.getLocale(), "TASK", 59096));
        }

        List<UiBotLayout> layouts = uiBotModel.getLayout();
        if (reassignReportList != null && reassignReportList.size() > 0) {
            for (UiBotLayout layout : layouts) {
                if (TitleBody.COMPONENT_TYPE.equals(layout.getType())) {
                    TitleBody titleBody = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleBody.class);
                    List<Tag> tags = titleBody.getTags();
                    if (tags == null) {
                        tags = new ArrayList<>();
                    } else {
                        for (Tag tag : tags) {
                            if (LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派").equals(tag.getText())) {
                                tags.remove(tag);
                                break;
                            }
                        }
                    }
                    Tag tag = Tag.createOnlyTextStateTag(String.format(
                                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "由转派"),
                                    reassignReportList.get(0).getOldPerformerName()),
                            Action.createReassignReportAction(apiRequest.getLocale(),
                                    reassignReportList));
                    tags.add(tag);
                    uiBotModel.getPageData().put(layout.getSchema(), titleBody);
                    break;
                } else {
                    if (PageDesc.COMPONENT_TYPE.equals(layout.getType())) {
                        PageDesc pageDesc = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), PageDesc.class);
                        List<PageDescContent> pageDescContents = pageDesc.getContent();
                        pageDescContents.add(PageDescContent.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                        uiBotModel.getPageData().put(layout.getSchema(), pageDesc);
                    }
                    if (TitleDesc.COMPONENT_TYPE.equals(layout.getType())) {
                        TitleDesc titleDesc = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleDesc.class);
                        List<Label> labels = titleDesc.getLabelList();
                        labels.add(Label.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                        uiBotModel.getPageData().put(layout.getSchema(), titleDesc);
                    }
                }
            }
        } else {
            for (UiBotLayout layout : layouts) {
                if (TitleBody.COMPONENT_TYPE.equals(layout.getType())) {
                    TitleBody titleBody = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleBody.class);
                    List<Tag> tags = titleBody.getTags();
                    if (tags != null) {
                        for (Tag tag : tags) {
                            if (LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派").equals(tag.getText())) {
                                tags.remove(tag);
                                tags.add(Tag.createBlueBgdWriteTextStateTag(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派")));
                                break;
                            }
                        }
                    }
                    uiBotModel.getPageData().put(layout.getSchema(), titleBody);
                    break;
                }
            }
        }

        stopWatch.stop();
        //录入页面卡片化设置
        uiBotModel.setCustomGroup();
        return uiBotModel;
    }

    private Boolean judgeDetailComplete(UiBotModel pcUibotModel) {
        if (pcUibotModel == null || pcUibotModel.getPageData() == null) {
            return false;
        } else {
            if (StringUtils.hasLength((String) ((Map<Object, Object>) pcUibotModel.getPageData().get("data")).get("actualEndTime"))
                    || (StringUtils.hasLength((String) ((Map<Object, Object>) pcUibotModel.getPageData().get("data")).get("actualDescription")))
            ) {
                return true;
            } else {
                return false;
            }
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = null;
        UiBotModel uiBotModel = null;
        if (PageSettingIdPresetEnum.MOBILE_MANUAL_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            data = FileUtil.readText(
                    "static/appstore-use/manual-task-detail-v2.json");
        }
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }
        return uiBotModel;
    }

}
