package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiExtraParameter;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderDataUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service.UniversalParsingService;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.rule.JsRule;
import com.digiwin.mobile.mobileuibot.core.rule.JsRuleService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.CustomPatternTaskTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.PatternTypeEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.pattern.UiBotModelBuildCustomPatternTaskDetailStrategy;
import com.digiwin.mobile.mobileuibot.designer.DesignerService;
import com.digiwin.mobile.mobileuibot.designer.uibot.UiBotDesignerConfig;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import com.digiwin.mobile.mobileuibot.task.common.TaskDataExtractUtil;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategy;
import com.digiwin.mobile.mobileuibot.task.strategy.TaskDetailBuildStrategyFactory;
import lombok.SneakyThrows;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
 * <p>功能描述：UiBot数据模型构建策略接口--实现我的任务详情页面构建</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildMyTaskDetailStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/18 22:28
 */
@Component("uiBotModelBuildMyTaskDetailStrategy")
public class UiBotModelBuildMyTaskDetailStrategy
        implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildMyTaskDetailStrategy.class);

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private TaskDetailBuildStrategyFactory taskDetailBuildStrategyFactory;

    @Autowired
    private UniversalParsingService universalParsingService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DesignerService designerService;

    @Autowired
    private UiBotModelBuildCustomPatternTaskDetailStrategy uiBotModelBuildCustomPatternTaskDetailStrategy;

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private UiBotModelBuildMyTaskDetailV2Strategy uiBotModelBuildMyTaskDetailV2Strategy;

    @Autowired
    private JsRuleService jsRuleService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        apiRequest.getPatternTaskInfo().setPatternType(PatternTypeEnum.STANDARD);
        StopWatch stopWatch = new StopWatch("BuildMyTaskDetail");
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doBefore(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doBefore(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        if (apiRequest.getExtraParameter() == null) {
            ApiExtraParameter apiExtraParameter = new ApiExtraParameter();
            apiExtraParameter.setAppCode(apiRequest.getRawData().getString("appCode"));
            apiExtraParameter.setTmTaskId(apiRequest.getRawData().getString("tmTaskId"));
            apiExtraParameter.setTmActivityId(apiRequest.getRawData().getString("tmActivityId"));
            if (!StringUtils.hasLength(apiExtraParameter.getTmTaskId()) || !StringUtils.hasLength(apiExtraParameter.getTmActivityId())) {
                // line 场景下，H5调用任务详情接口时不会传递ExtraParameter和rawdata，故需要手动查询存入
                DigiwinAtmcBacklogDetail backlogDetail = this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), apiRequest.getDataId());
                apiExtraParameter.setAppCode(backlogDetail.getAppCode());
                apiExtraParameter.setTmTaskId(backlogDetail.getTmTaskId());
                apiExtraParameter.setTmActivityId(backlogDetail.getTmActivityId());
            }
            apiRequest.setExtraParameter(apiExtraParameter);
        }
        // 获取任务详情的UiBot设计器配置 并 组装 apiRequest中的PatternTaskInfo
        UiBotDesignerConfig uiBotDesignerConfig = designerService.initPatternTaskInfoWithUiBotDesigner(apiRequest,
                apiRequest.getExtraParameter().getTmTaskId(), apiRequest.getExtraParameter().getTmActivityId(),
                pageSetting.getSystemDefault(), apiRequest.getExtraParameter().getAppCode());

        // 移动端任务卡展示逻辑 任务卡类型
        switch (apiRequest.getPatternTaskInfo().getCustomPatternTaskType()) {
            case EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_TRUE:
                // 跳转移动端H5界面
                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_CUSTOM_PATTERN_TASK_DETAIL.name());
                pageSetting = pageSettingService.findById(apiRequest.getPageId());
                return uiBotModelBuildCustomPatternTaskDetailStrategy
                        .buildJumpH5Page(pageSetting, apiRequest, uiBotDesignerConfig.getRawTaskActivityDefinition());
            case EXIST_MOBILE_PAGE_AND_ISCUSTOMIZE_FALSE:
                // wjw TODO: 2023/7/31 是否走V2版策略处理
//                // 使用 MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL 通用界面展示
//                apiRequest.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.name());
//                pageSetting = pageSettingService.findById(apiRequest.getPageId());
//                break;
                return uiBotModelBuildMyTaskDetailV2Strategy.doActually(pageSetting, apiRequest);
            case NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE:
                // 展示任务标题，以及空组件提示。提示文案：『APP端暂不支持该定制任务，请到Web端查看』
                // 在后面逻辑中返回构建的uibot后，进行处理
                break;
            case NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_FALSE:
                // 使用pageId配套的策略类来生成
                break;
            case DEFAULT:
                // 默认类型 -- 不受设计器影响，通过移动配置的pageId打开flutter页面详情
                // 使用pageId配套的策略类来生成
                break;
            default:
                break;
        }
        return this.doActually(pageSetting, apiRequest, stopWatch);
    }

    @SneakyThrows
    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                 StopWatch stopWatch) {
        String tmTaskId = apiRequest.getExtraParameter().getTmTaskId();
        String tmActivityId = apiRequest.getExtraParameter().getTmActivityId();
        stopWatch.start("GetData From Athena API");
        DigiwinAtmcBacklogDetail backlogDetail = null;
        UiBotModel pcUiBotModel = null;
        List<DigiwinReassignReport> reassignReportList = null;
        //使用Future方式执行多任务
        List<Future<?>> futureList = new ArrayList<>();
        Future<DigiwinAtmcBacklogReadCount> futureReadCount = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(
                        apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId()));
        futureList.add(futureReadCount);

        Future<DigiwinAtmcBacklogDetail> futureBacklogDetail = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinAtmcProxyService.getDigiwinAtmcBacklogDetailByShare(apiRequest.getLocale(),
                        apiRequest.getIamUserToken(), apiRequest.getDataId()));
        futureList.add(futureBacklogDetail);

        Future<List> futureReassignReport = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinAtmcProxyService.getTaskReassignReport(apiRequest.getDataId(),
                        apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId()));
        futureList.add(futureReassignReport);

        //查询任务执行的结果
        try {
            for (Future<?> future : futureList) {
                // CPU高速轮询：每个future都并发轮循，判断完成状态然后获取结果，
                // 这一行，是本实现方案的精髓所在。即有10个future在高速轮询，完成一个future的获取结果，就关闭一个轮询
                while (true) {
                    // 获取future成功完成状态，如果想要限制每个任务的超时时间，取消本行的状态判断+future.get(1000*1, TimeUnit.MILLISECONDS)+catch超时异常使用即可。
                    if (future.isDone() && !future.isCancelled()) {
                        //获取结果
                        Object obj = future.get();
                        if (obj instanceof DigiwinAtmcBacklogDetail) {
                            backlogDetail = (DigiwinAtmcBacklogDetail) obj;
                            if (backlogDetail != null && !StringUtils.hasLength(tmActivityId) && !StringUtils.hasLength(tmTaskId)) {
                                tmActivityId = backlogDetail.getTmActivityId();
                                tmTaskId = backlogDetail.getTmTaskId();
                            }
                        }
                        if (obj instanceof List) {
                            reassignReportList = (List<DigiwinReassignReport>) obj;
                        }
                        break;//当前future获取结果完毕，跳出while
                    } else {
                        //每次轮询休息1毫秒（CPU纳秒级），避免CPU高速轮循耗空CPU---》新手别忘记这个
                        Thread.sleep(1);
                    }
                }
            }
        } catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        } finally {

        }
        stopWatch.stop();

        //由于可能存在部分tmTaskId和tmActivityId为空的情况
        pcUiBotModel = this.digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId(),
                tmTaskId, tmActivityId, apiRequest.getRawData());
        Assert.notNull(backlogDetail, "task detail must have detail!");
        Assert.notNull(backlogDetail.getId(), "task detail must have detail!");
        Assert.notNull(pcUiBotModel, "task detail must have uibotmodel data!");
        //true 则表示此条数据已经被提交成功，工作提醒点击查看更多则显示对应的图片ui
        if (ObjectUtils.isNotEmpty(pcUiBotModel.getFinished()) && pcUiBotModel.getFinished()
                && !TaskStringUtil.isBizApproval(StringUtil.valueOf(backlogDetail.getTmPattern()), StringUtil.valueOf(backlogDetail.getTmCategory()))
                && !TaskStringUtil.isBizDataEntryDriven(StringUtil.valueOf(backlogDetail.getTmPattern()), StringUtil.valueOf(backlogDetail.getTmCategory()))
                && !TaskStringUtil.isBizSmartAdjust(backlogDetail.getTmActivityId())
        ) {
            return UiBotModel.workReminderEmptyImageUibotModel(apiRequest.getLocale());
        }

        // 任务详情与UiBot设计器集成
        this.designerService.integrateTaskDetailWithUiBotDesigner(apiRequest, pcUiBotModel);

        // 增加可能有的签核进度数据，并在后续展示在界面上
        List<DigiwinAtmcTaskProgress> digiwinAtmcTaskProgressList = Collections.emptyList();
        if (StringUtils.hasLength(backlogDetail.getApprovalState())) {
            Map<String, Object> taskSignoffProgressData = TaskDataExtractUtil
                    .getSignoffProgressData(pcUiBotModel.getPageData());
            digiwinAtmcTaskProgressList =
                    this.digiwinAtmcProxyService.getApprovalTaskSignoffProgress(
                            apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), taskSignoffProgressData);
        }

        stopWatch.start("Build Task-Detail Page Data");
        // 根据pcUiBotModel的内容，组出taskDetail内的组件信息。注意这里传了一个backlogDetail对象
        TaskDetailBuildStrategy taskDetailBuildStrategy = this.taskDetailBuildStrategyFactory.get(TaskStringUtil.
                getTaskBuildTypeByDetailPatternCategory(backlogDetail));
        if (taskDetailBuildStrategy == null || (PageSettingIdPresetEnum.MOBILE_ATHENA_UNIVERSAL_PARSING_TASK_DETAIL.toString().equals(pageSetting.getPageId()) && !TaskStringUtil.isBizSmartAdjust(backlogDetail.getTmActivityId()))) {
            UiBotModel taskModel = universalParsingService.buildPatternModel(apiRequest, pageSetting,
                    pcUiBotModel, backlogDetail, digiwinAtmcTaskProgressList, reassignReportList);
            stopWatch.stop();
            if (CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE
                    == apiRequest.getPatternTaskInfo().getCustomPatternTaskType()) {
                // 展示任务标题，以及空组件提示。提示文案：『APP端暂不支持该定制任务，请到Web端查看』
//                universalParsingService.buildShowTitleAndEmpty(taskModel, apiRequest);
                taskModel.buildShowTitleAndEmpty(localeService, apiRequest.getLocale());
            }
            if (taskModel.hasAppliedDesignerConfig()) {
                int bodyContainerType;
                switch (taskModel.getLayoutGeneratorServiceResult().getLayoutTypeEnum()) {
                    case SINGLE_PATTERN_LAYOUT:
                        bodyContainerType = 1;
                        break;
                    case MULTI_PATTERN_LAYOUT:
                        bodyContainerType = 2;
                        break;
                    default:
                        bodyContainerType = 0;
                        break;
                }
                taskModel = MobileRenderDataUtil.upgradeToV2RenderData(taskModel, bodyContainerType);
            }
            ModuleUtils.addRefreshPageId(taskModel, null);

            // v1转v2 h5 web端规则处理
            List<JsRule> jsRuleList = jsRuleService.findByTmActivityId(tmActivityId);
            if (!CollectionUtils.isEmpty(jsRuleList)) {
                List<UiBotRule> uiBotRuleList = new ArrayList<>(2);
                jsRuleList.forEach(jsRule -> {
                    UiBotRule uiBotRule = new UiBotRule();
                    BeanUtils.copyProperties(jsRule, uiBotRule);
                    uiBotRuleList.add(uiBotRule);
                });
                taskModel.setRules(uiBotRuleList);
            }

            return taskModel;
        } else {
            UiBotModel uiBotModel = taskDetailBuildStrategy
                    .buildUibotModel(apiRequest, pageSetting, pcUiBotModel, backlogDetail, digiwinAtmcTaskProgressList);
            stopWatch.stop();

            if (CustomPatternTaskTypeEnum.NOT_EXIST_MOBILE_PAGE_AND_PC_ISCUSTOMIZE_TRUE
                    == apiRequest.getPatternTaskInfo().getCustomPatternTaskType()) {
                // 展示任务标题，以及空组件提示。提示文案：『APP端暂不支持该定制任务，请到Web端查看』
                uiBotModel.buildShowTitleAndEmpty(localeService, apiRequest.getLocale());
            }
            stopWatch.start("Build Common Page Model");

            // TODO 任务卡转派功能。包含定制逻辑：对账周报任务卡的转派按钮不需要展示
            if (!PageSettingIdPresetEnum.MOBILE_ATHENA_RECONCILIATION_PROGRESS_NOTICE_LIST.toString().equals(pageSetting.getPageId())) {
                if (backlogDetail.backlogHasReassignData()) {
                    List<Button> buttons = uiBotModel.getAppbarButtonList();
                    String backlogId = String.valueOf(backlogDetail.getId());
                    if (!buttons.stream().filter(button -> button.getId().equalsIgnoreCase(backlogId)).findFirst().isPresent()) {
                        Map<String, Object> buttonActionRawData = new HashMap<>(backlogDetail.getReassign());
                        buttonActionRawData.put("appCode", backlogDetail.getAppCode());
                        buttonActionRawData.put("backlogDetail", backlogDetail);
                        buttons.add(Button.createApprovalReassign(backlogDetail.getId() + "",
                                buttonActionRawData, apiRequest.getLocale(), "TASK", 59096));
                    }
                }
            }
            List<UiBotLayout> layouts = uiBotModel.getLayout();
            if (reassignReportList != null && reassignReportList.size() > 0) {
                for (UiBotLayout layout : layouts) {
                    if (TitleBody.COMPONENT_TYPE.equals(layout.getType())) {
                        TitleBody titleBody = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleBody.class);
                        List<Tag> tags = titleBody.getTags();
                        if (tags == null) {
                            tags = new ArrayList<>();
                        } else {
                            for (Tag tag : tags) {
                                if (LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派").equals(tag.getText())) {
                                    tags.remove(tag);
                                    break;
                                }
                            }
                        }
                        Tag tag = Tag.createOnlyTextStateTag(String.format(
                                        LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "由转派"),
                                        reassignReportList.get(0).getOldPerformerName()),
                                Action.createReassignReportAction(apiRequest.getLocale(),
                                        reassignReportList));
                        tags.add(tag);
                        uiBotModel.getPageData().put(layout.getSchema(), titleBody);
                        break;
                    } else {
                        if (PageDesc.COMPONENT_TYPE.equals(layout.getType())) {
                            PageDesc pageDesc = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), PageDesc.class);
                            List<PageDescContent> pageDescContents = pageDesc.getContent();
                            pageDescContents.add(PageDescContent.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                            uiBotModel.getPageData().put(layout.getSchema(), pageDesc);
                        }
                        if (TitleDesc.COMPONENT_TYPE.equals(layout.getType())) {
                            TitleDesc titleDesc = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleDesc.class);
                            List<Label> labels = titleDesc.getLabelList();
                            labels.add(Label.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                            uiBotModel.getPageData().put(layout.getSchema(), titleDesc);
                        }
                    }
                }
            } else {
                for (UiBotLayout layout : layouts) {
                    if (TitleBody.COMPONENT_TYPE.equals(layout.getType())) {
                        TitleBody titleBody = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleBody.class);
                        List<Tag> tags = titleBody.getTags();
                        if (tags != null) {
                            for (Tag tag : tags) {
                                if (LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派").equals(tag.getText())) {
                                    tags.remove(tag);
                                    tags.add(Tag.createBlueBgdWriteTextStateTag(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派")));
                                    break;
                                }
                            }
                        }
                        uiBotModel.getPageData().put(layout.getSchema(), titleBody);
                        break;
                    }
                }
            }

            if (uiBotModel.hasAppliedDesignerConfig()) {
                int bodyContainerType;
                switch (uiBotModel.getLayoutGeneratorServiceResult().getLayoutTypeEnum()) {
                    case SINGLE_PATTERN_LAYOUT:
                        bodyContainerType = 1;
                        break;
                    case MULTI_PATTERN_LAYOUT:
                        bodyContainerType = 2;
                        break;
                    default:
                        bodyContainerType = 0;
                        break;
                }
                uiBotModel = MobileRenderDataUtil.upgradeToV2RenderData(uiBotModel, bodyContainerType);
            }

            // FIXME 待观察做法是否有漏洞。
            // 此处用Athena后端数据与IM群聊扩展字段的bizId对比后发现，需要使用bpmActivityId才可以找到对应群聊
            if (null != backlogDetail.getBpmActivityId()) {
                uiBotModel.setDataId(backlogDetail.getBpmActivityId());
            }
            // 左右滑页面的标题处理
            String athenaTaskName = Optional.ofNullable(backlogDetail).map(DigiwinAtmcBacklogDetail::getName).orElse("");
            if (!StringUtils.hasLength(athenaTaskName)) {
                athenaTaskName = String.valueOf(pcUiBotModel.getPageData().getUiBotActivity().get("name"));
            }
            //右滑摇人标题
            if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getLeft() != null) {
                SlipTitle slipTitle = uiBotModel.getSlip().getSlipConfig().getLeft().getSubTitle();
                slipTitle.setContent(athenaTaskName + " " + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "当前沟通"));
                SlipConfigLeft left = uiBotModel.getSlip().getSlipConfig().getLeft();
                //先查EOC、IAM等账号信息（不包含邮箱、手机号等）
                List<DigiwinAtmcProjectPerformer> projectPerformers = digiwinAtmcProxyService.getPerformerListByBackLogId(backlogDetail.getBacklogId(),
                        apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
                //在查邮箱、手机号等信息
                EocPersonResponse eocPersonResponse = digiwinEocProxyService.getSimplePersonList(
                        apiRequest.getIamUserToken(), 9999, 1, "");
                SlipConfigLeft.setPersonList(left, projectPerformers, eocPersonResponse);
            }

            //这边需要传递点参数给左滑辅助资讯
            if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getRight() != null) {
                LeftHeader header = uiBotModel.getSlip().getSlipConfig().getRight().getHeader();
                header.getSubTitle().setContent(athenaTaskName);
                if (uiBotModel.getSlip().getSlipConfig().getRight().getBody() != null) {
                    List<Map<String, Object>> pageData = new ArrayList<>();
                    if (pcUiBotModel.getPageData().get(pcUiBotModel.searchBizDataSchema()) instanceof List) {
                        pageData = (List<Map<String, Object>>) pcUiBotModel.getPageData().get(pcUiBotModel.searchBizDataSchema());
                    } else if (pcUiBotModel.getPageData().get(pcUiBotModel.searchBizDataSchema()) instanceof Map) {
                        Map<String, Object> params = (Map<String, Object>) pcUiBotModel.getPageData().get(pcUiBotModel.searchBizDataSchema());
                        pageData = (List<Map<String, Object>>) params.get("purchase_temp_detail");
                    }
                    List<Map<String, Object>> cardInfoList = new ArrayList<>();
                    if (pageData != null) {
                        for (Map<String, Object> param : pageData) {
                            List<Map<String, Object>> graphInfoParamList = (List<Map<String, Object>>) param.get("graph_info");
                            if (graphInfoParamList != null && graphInfoParamList.size() > 0) {
                                List<Map<String, Object>> graphInfoList = new ArrayList<>(graphInfoParamList.size());
                                for (Map<String, Object> objectMap : graphInfoParamList) {
                                    Map<String, Object> graphInfo = new HashMap<>(2);
                                    graphInfo.put("graph_no", objectMap.get("graph_no"));
                                    graphInfo.put("graph_no_version", objectMap.get("graph_no_version"));
                                    graphInfoList.add(graphInfo);
                                }
                                cardInfoList.addAll(graphInfoList);
                            }
                        }
                    }
                    Map<String, Object> params = uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().getParams();
                    params.put("tenant_id", backlogDetail.getTenantId());
                    params.put("user_id", apiRequest.getUserId());
                    params.put("transaction_id", backlogDetail.getId());
                    params.put("transaction_code", backlogDetail.getTmActivityId());
                    params.put("card_info", cardInfoList);

                    //erp签核采购单--改下dataId，可mock数据时做区分
                    Object bpmDataObj = pcUiBotModel.getExecuteContext().get("bpmData");
                    if (bpmDataObj != null) {
                        Map<String, Object> bpmData = (Map<String, Object>) bpmDataObj;
                        if (bpmData.get("__mobile_transaction_id") != null) {
                            String mobileTransactionId = bpmData.get("__mobile_transaction_id").toString();
                            if ("PURCHASE_ORDER.I01".equalsIgnoreCase(mobileTransactionId)) {
                                params.put("dataId", "PURCHASE_ORDER.I01");
                                uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().setDataId("PURCHASE_ORDER.I01");
                                //传附件数据
                                List<String> topParentLayoutTypeList = new ArrayList<>();
                                topParentLayoutTypeList.add("SPLIT_LAYOUT");
                                topParentLayoutTypeList.add("FORM_LIST");
                                List<String> targetLayoutTypeList = new ArrayList<>();
                                targetLayoutTypeList.add("FORM_UPLOAD");
                                UiBotModel topUiBotModel = pcUiBotModel.searchPcTargetModel(targetLayoutTypeList, topParentLayoutTypeList, true);
                                if (!CollectionUtils.isEmpty(topUiBotModel.getLayout())) {
                                    UiBotLayout layout = topUiBotModel.getLayout().get(0);
                                    // 这边变动，需要考虑 UiBotModelLeftSlipStrategy 817行 同步处理
                                    Map<String, Object> attachmentMap = (Map<String, Object>) topUiBotModel.getPageData().get(layout.getSchema());
                                    params.put("attachment", attachmentMap.get("data"));
                                    params.put("attribute", layout.getAttribute());
                                }
                                //传历史单价数据
                                List<String> formParentLayoutTypeList = new ArrayList<>();
                                formParentLayoutTypeList.add("SPLIT_LAYOUT");
                                formParentLayoutTypeList.add("FORM_LIST");
                                formParentLayoutTypeList.add("FORMGROUP");
                                List<String> layoutTypeList = new ArrayList<>();
                                layoutTypeList.add("TABLE");
                                UiBotModel formUiBotModel = pcUiBotModel.searchPcTargetModel(layoutTypeList, formParentLayoutTypeList, false);
                                //todo 待传获取历史单价接口所需的参数（等历史单价接口）
                                if (!CollectionUtils.isEmpty(formUiBotModel.getLayout())) {
                                    List<Map<String, Object>> mapList = (List<Map<String, Object>>) formUiBotModel.getPageData().get(formUiBotModel.getLayout().get(0).getSchema());
                                    if (!CollectionUtils.isEmpty(mapList)) {
                                        List<String> itemCodeList = new ArrayList<>();
                                        for (Map<String, Object> map : mapList) {
                                            if (map.get("__PRICE") != null) {
                                                //erp签核采购单定制处理，"__PRICE"值为"1"时，schema为"PRICE"的栏位value标红，且左滑页面展示该item的历史单价
                                                String priceType = map.get("__PRICE").toString();
                                                if ("1".equals(priceType)) {
                                                    itemCodeList.add((String) map.get("ITEM_CODE"));
                                                }
                                            }
                                        }
                                        params.put("item_code_list", itemCodeList);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            stopWatch.stop();
            //FIXME 乾冶客制 MOBILE_MY_BIZ_REPORT_TASK_DETAIL_QIANYE_UC
            if (PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL.toString().equalsIgnoreCase(pageSetting.getPageId())
                    || PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL_QIANYE_UC.toString().equalsIgnoreCase(pageSetting.getPageId())) {
                //录入页面卡片化设置
                uiBotModel.setCustomGroup();
            }

            // PCC手动任务去掉更多选项，全部平铺展示
            if (Objects.equals("manual_DTD_Assignment", tmActivityId)) {
                uiBotModel.setShowMore(false);
                uiBotModel.setPageBackgroudColor("F6F7FB");
            }
            return uiBotModel;
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;
        if (PageSettingIdPresetEnum.MOBILE_MY_BIZ_APPROVAL_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            data = FileUtil.readText(
                    "static/appstore-use/approval-task-detail-v2-"
                            + apiRequest.getDataId() + ".json");
        } else if (PageSettingIdPresetEnum.MOBILE_MY_BIZ_REPORT_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            if (TaskStringUtil.isSscEmployeeInduction(apiRequest.getExtraParameter().getTmTaskId(),
                    apiRequest.getExtraParameter().getTmActivityId())) {
                data = FileUtil.readText("static/appstore-use/taskInductionFirstDay-employeeInduction-task-detail-123456789012345.json");
            } else {
                data = FileUtil.readText(
                        "static/appstore-use/report-task-detail-"
                                + apiRequest.getDataId() + ".json");
            }
        } else if (PageSettingIdPresetEnum.MOBILE_MY_BIZ_PROCESS_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            data = FileUtil.readText(
                    "static/appstore-use/process-task-detail.json");
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_SSC_EMPLOYEE_ATTEN_CONFIRM_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            data = FileUtil.readText("static/appstore-use/attendanceConfirmation-employeeAttendanceConfirmation-task-detail-"
                    + apiRequest.getDataId() + ".json");
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_BARCODEMAN_PRINT_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            // TODO 新增mock的json数据
            data = "";
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_BARCODEMAN_PASTE_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            // TODO 新增mock的json数据
            data = "";
        } else if (PageSettingIdPresetEnum.MOBILE_ATHENA_ZHILINK_BARCODEMAN_CHECKOUT_TASK_DETAIL.toString()
                .equalsIgnoreCase(pageSetting.getPageId())) {
            // TODO 新增mock的json数据
            data = "";
        } else {
            data = "";
        }
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }


}
