package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotActivityConstants;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotAuthoredUser;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.TaskPageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>功能描述：移动任务详情DSL构建流程</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildMyTaskDetailV2Strategy.java
 * @Author: wangjwc
 * @Date: created at 2023/7/11 13:36
 */
@Slf4j
@Component
public class UiBotModelBuildMyTaskDetailV2Strategy implements UiBotModelBuildStrategy {

    @Autowired
    private TaskPageService taskPageService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        Boolean isShared = Optional.ofNullable(apiRequest.getRawData().getBoolean("isShared")).orElse(Boolean.FALSE);
        Boolean isHistory = Boolean.FALSE;
        // 判断是不是超级管理员
        Boolean isSuperAdmin = Boolean.FALSE;
        if (isShared) {
            isSuperAdmin = digiwinIamProxyService.isSuperAdmin(apiRequest.getIamUserToken(), apiRequest.getUserId());
        }
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), apiRequest.getDataId());
        executeContext.setPtmBacklogId(apiRequest.getDataId());
        executeContext.appendPageInfoAndSuperAdmin(
                UiBotDesignerService.PAGECODE_TASK_DETAIL, apiRequest.getExtraParameter().getTmTaskId(),
                apiRequest.getExtraParameter().getTmActivityId(), PcUiBotActivityConstants.PERFORMER,
                isShared, isHistory, isSuperAdmin);
        executeContext.setFromAdsc(false);
        executeContext.setSourceType(apiRequest.getSourceType());
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));
        UiBotModel uiBotModel;
        if (Objects.equals(apiRequest.getExtraParameter().getTmActivityId(), "uibotManualTask")) {
            uiBotModel = taskPageService.createManuaTaskPage(executeContext, apiRequest.getDataId());
        } else {
            uiBotModel = taskPageService.createPage(executeContext, apiRequest.getDataId(), apiRequest);
        }
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);

        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}