package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.alibaba.fastjson.JSONArray;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.index.TodoList;
import com.digiwin.mobile.mobileuibot.core.component.list.card.*;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfig;
import com.digiwin.mobile.mobileuibot.core.customtaskconfig.CustomTaskConfigService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelation;
import com.digiwin.mobile.mobileuibot.core.pagetaskrelation.PageTaskRelationService;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.PersonalConfiguration;
import com.digiwin.mobile.mobileuibot.model.db1.UserTaskFilter;
import com.digiwin.mobile.mobileuibot.mysql.service.PersonalConfigurationService;
import com.digiwin.mobile.mobileuibot.mysql.service.UserTaskFilterService;
import com.digiwin.mobile.mobileuibot.openapi.service.ActivityFilterService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.model.DigiwinAtmcGroupRecord;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.sso.enums.SsoSourceTypeEnum;
import com.digiwin.mobile.mobileuibot.task.common.TaskStringUtil;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilter;
import com.digiwin.mobile.mobileuibot.task.filter.TaskFilterService;
import com.digiwin.mobile.mobileuibot.task.model.TaskSummary;
import com.digiwin.mobile.mobileuibot.task.service.TaskService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * <p>功能描述：UiBot数据模型构建策略接口--实现我的任务清单页面构建</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildMyTaskListStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/12 22:04
 */
@Component("uiBotModelBuildMyTaskListStrategy")
public class UiBotModelBuildMyTaskListStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildMyTaskListStrategy.class);

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private PageTaskRelationService pageTaskRelationService;

    @Autowired
    private TaskFilterService taskFilterService;

    @Autowired
    private CustomTaskConfigService customTaskConfigService;

    @Autowired
    private PersonalConfigurationService personalConfigurationService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private UserTaskFilterService userTaskFilterService;

    @Autowired
    private DigiwinAudcProxyService digiwinAudcProxyService;

    @Autowired
    private TaskService taskService;

    @Autowired
    private ActivityFilterService activityFilterService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        TodoList todoList = new TodoList();
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData && !AppRequestContext.requestNeedShowMockData()) {
            todoList = this.doActually(apiRequest);
        } else {
//            todoList = this.doMockData(apiRequest.getLocale());
        }

        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        if (!CollectionUtils.isEmpty(uiBotLayouts)) {
            UiBotLayout uiBotLayout = uiBotLayouts.get(0);
            UiBotPageData uiBotPageData = uiBotModel.getPageData();
            TodoList newTodoList = JsonUtil.objectToJavaObject(uiBotPageData.get(uiBotLayout.getSchema()), TodoList.class);
            newTodoList.putAll(todoList);
            try {
                Map<String, String> params = new HashMap<>(2);
                params.put("userId", apiRequest.getUserId());
                params.put("tenantId", apiRequest.getTenantId());
                PersonalConfiguration personalConfiguration = personalConfigurationService.getByMap(params);
                if (personalConfiguration == null) {
                    personalConfiguration = new PersonalConfiguration();
                    personalConfiguration.setShowCompleted(true);
                    personalConfiguration.setShowFactory(false);
                    personalConfiguration.setUserId(apiRequest.getUserId());
                }
                newTodoList.setPersonalConfiguration(personalConfiguration);
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (!CollectionUtils.isEmpty(newTodoList.getTodoList())) {
                newTodoList.getTodoList().forEach(taskSummary -> {
                    if (taskSummary.getAction() != null) {
                        taskSummary.getAction().setRefreshPageId(PageSettingIdPresetEnum.FLASH_MY_TODO.toString());
                    }
                });
            }
            Button addTask = newTodoList.getAddTask();
            if (null != addTask && null != addTask.getAction()) {
                Action action = addTask.getAction();
                action.setJumpPageTitle(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), action.getJumpPageTitle()));
            }
            newTodoList.setCalenderType(apiRequest.getCalenderType());
            uiBotPageData.put(uiBotLayout.getSchema(), newTodoList);
        }
        return uiBotModel;
    }

    /**
     * 获取任务清单页面数据
     * 1.首页任务卡加载
     * 2.我的任务
     * 3.我的行事历
     *
     * @param apiRequest
     * @return
     */
    public TodoList doActually(ApiRequest apiRequest) {
        TodoList todoList = new TodoList();
        // 是否需要请求我的行事历任务
        boolean needRequestMyCalendar = apiRequest.getCalenderType() != 1 && (apiRequest.getRequestId() == null ||
                !apiRequest.getRequestId().equals(ComponentSettingRequestIdEnum.INDEX_MY_WORKSPACE_TODO_LIST.getReuqestId()));
        // 我的任务卡列表
        List<DigiwinAtmcBacklog> myBacklogs = new ArrayList<>();
        // 所有行事历
        List<DigiwinAtmcCalendar> digiwinAtmcCalendars = Collections.emptyList();
        // 行事历下所有成员的任务
        List<DigiwinAtmcBacklog> teamMemberWorkitems = Collections.emptyList();

        // 使用多线程计数器辅助结果获取。初始化的数量为预计多线程数量
        CountDownLatch countDownLatch;
        // 使用Future方式执行多任务
        List<Future<?>> futureList = new ArrayList<>();
        if (needRequestMyCalendar) {
            countDownLatch = new CountDownLatch(2);

            digiwinAtmcCalendars = this.digiwinAtmcProxyService.queryAllTeamMember(apiRequest.getIamUserToken(), apiRequest.getLocale());
            DigiwinAtmcCalendar myDigiwinAtmcCalendar = digiwinAtmcCalendars.stream()
                    .filter(digiwinAtmcCalendar -> digiwinAtmcCalendar.getType() == 0)
                    .findFirst().orElse(new DigiwinAtmcCalendar());
            todoList.setTeamMember(myDigiwinAtmcCalendar);
            Future<Map<String, List<DigiwinAtmcBacklog>>> futureTeamMemberWorkitems = this.threadPoolTaskExecutor.submit(() -> {
                try {
                    Map<String, List<DigiwinAtmcBacklog>> resultMap = new HashMap<>(1);
                    resultMap.put("teamMemberWorkitems", this.digiwinAtmcProxyService.
                            getTeamMemberWorkItemList(apiRequest.getClientId(), apiRequest.getIamUserToken(),
                                    String.valueOf(myDigiwinAtmcCalendar.getId()), apiRequest.getLocale(),
                                    apiRequest.getStartDate(), apiRequest.getEndDate()));
                    logger.debug("CountDown for 查询我团队成员行事历任务列表");
                    return resultMap;
                } finally {
                    countDownLatch.countDown();
                }
            });
            futureList.add(futureTeamMemberWorkitems);
        } else {
            countDownLatch = new CountDownLatch(1);
        }
        Future<Map<String, List<DigiwinAtmcBacklog>>> futureDigiwinAtmcBacklogs = this.threadPoolTaskExecutor.submit(
                () -> {
                    try {
                        Map<String, List<DigiwinAtmcBacklog>> resultMap = new HashMap<>(1);
                        resultMap.put("myBacklogs", this.digiwinAtmcProxyService.listMyBacklog(apiRequest.getClientId(),
                                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId()));
                        // 每个任务执行完成后对数量进行减一操作
                        logger.debug("CountDown for 查询我的任务列表");
                        return resultMap;
                    } finally {
                        countDownLatch.countDown();
                    }
                });
        futureList.add(futureDigiwinAtmcBacklogs);

        try {
//            logger.error("CountDownLatch执行await开始...@{}", LocalDateTime.now());
            // 等待,不断检测数量是否为0，为零是执行后面的操作
            countDownLatch.await();
            // 避免后面无法获取到Future的结果
            Thread.sleep(1);
//            logger.error("CountDownLatch执行await完成...@{}", LocalDateTime.now());
            for (Future<?> future : futureList) {
                if (future.isDone() && !future.isCancelled()) {
                    //获取结果
                    Object obj = future.get();
                    if (obj instanceof Map) {
                        Map<String, List> result = (Map<String, List>) obj;
                        if (null != result && result.size() == 1) {
                            if (result.containsKey("teamMemberWorkitems")) {
                                teamMemberWorkitems = result.get("teamMemberWorkitems");
                            } else {
                                myBacklogs = result.get("myBacklogs");
                            }
                        }
                    }
                }
            }
        } catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }

        if (needRequestMyCalendar) {
            for (DigiwinAtmcBacklog digiwinAtmcBacklog : teamMemberWorkitems) {
                //将和行事历有关的任务，设置state，0代表未完成，1代表已完成
                if (digiwinAtmcBacklog.getExtendData() != null && digiwinAtmcBacklog.getExtendData().getFinished()) {
                    if (!StringUtils.hasLength(digiwinAtmcBacklog.getTmActivityName())) {
                        digiwinAtmcBacklog.setTmActivityName(this.localeService.getLanguageValue(apiRequest.getLocale(), "行事历"));
                    }
                    myBacklogs.add(digiwinAtmcBacklog);
                } else {
                    continue;
                }
            }
        }
        // 企业微信只显示签核型任务
        if (StringUtil.isNotEmpty(apiRequest.getSourceType()) && SsoSourceTypeEnum.ENTERPRISE_WECHAT.getSource().equalsIgnoreCase(apiRequest.getSourceType())) {
            myBacklogs = myBacklogs.stream().filter(digiwinAtmcBacklog -> TaskStringUtil.isBizApproval(digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory())).collect(Collectors.toList());
        }
        // PCM 移除旧卡
        myBacklogs.removeIf(digiwinAtmcBacklog ->
                "budgetProjectApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) ||
                        "projectMaterialApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) ||
                        "projectBudgetConfirmationApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) ||
                        "projectCostApproval".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) ||
                        "projectBudgetConfirmation".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId()) ||
                        "ApproveForProjectSet".equalsIgnoreCase(digiwinAtmcBacklog.getTmActivityId())
        );
        // 构建移动任务列表结构
        return this.paddingMobileTaskListForm(apiRequest, myBacklogs, todoList);
    }

    /**
     * 构建移动任务列表结构
     *
     * @param apiRequest 请求参数
     * @param myBacklogs 平台任务列表
     * @param todoList   组装返回结构
     * @return
     */
    public TodoList paddingMobileTaskListForm(ApiRequest apiRequest, List<DigiwinAtmcBacklog> myBacklogs,
                                              TodoList todoList) {
        String tenantVersion = activityFilterService.tenantVersion(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale());
        List<TaskFilter> filterList = activityFilterService.listValidInAthenaOfTaskFilter(apiRequest.getTenantId(), tenantVersion);
        myBacklogs =
                myBacklogs.stream().filter(backlog -> taskFilterService.isSupportedTaskByDigiwinAtmcBacklog(backlog, filterList))
                        .collect(Collectors.toList());

        //获取用户是否保存过筛选条件
        UserTaskFilter selectFilter = new UserTaskFilter(apiRequest.getUserId(), apiRequest.getTenantId());
        UserTaskFilter taskFilter = this.userTaskFilterService.getUserTaskFilterByParams(selectFilter);
        Set<String> taskIds = new HashSet<>();
        if (taskFilter != null && StringUtils.hasLength(taskFilter.getQueryParam())) {
            //再次查询新的筛选的关键字数据
            taskIds = this.digiwinAtmcProxyService.taskSearch(taskFilter.getQueryParam(), apiRequest.getIamUserToken(),
                    apiRequest.getTenantId(), apiRequest.getLocale(), apiRequest.getClientId());
        }
        List<String> filterIds = new ArrayList<>(16);
        if (taskFilter != null && StringUtils.hasLength(taskFilter.getFilterIds())) {
            filterIds = (List<String>) CollectionUtils.arrayToList(taskFilter.getFilterIds().split(";"));
        }
//        // 按endTime升序排序，方便App端直接渲染界面
//        myBacklogs.sort((o1, o2) -> {
//            LocalDateTime o1EndTime = DateTimeUtil.parseUseDefaultPattern(o1.getEndTime());
//            LocalDateTime o2EndTime = DateTimeUtil.parseUseDefaultPattern(o2.getEndTime());
//            if (o1EndTime.isBefore(o2EndTime)) {
//                return -1;
//            } else if (o1EndTime.isEqual(o2EndTime)) {
//                return 0;
//            } else {
//                return 1;
//            }
//        });

        List<PageTaskRelation> pageTaskRelationList =
                activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);

        // 获取CustomTaskConfig相关文档数据
        List<CustomTaskConfig> customTaskConfigList = this.customTaskConfigService.listCustomTaskConfig();

        //任务类型数组
        Map<String, String> taskTypeMap = new HashMap<>(16);
        //任务类型的数据
        Map<String, Integer> taskTypeData = new HashMap<>(16);
        //任务流程的数据
        Map<String, Integer> taskFlowData = new HashMap<>(16);
        //是否已读的数据
        Map<String, Integer> taskReadStatusData = new HashMap<>(16);
        //任务状态的数据
        Map<String, Integer> taskStatusData = new HashMap<>(16);

        //自定义筛选条件（包含dataType）
        Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter = new HashMap<>();

        //自定义筛选条件-所有select类型的选项值信息
        Map<String, Set<String>> customSelectOptionMap = new HashMap<>();

        //自定义排序条件code（从任务列表获取)-用来后续判断从接口返回的自定义排序条件是否可用
        Set<String> orderCodeSetFromBacklogs = new HashSet<>();

        // FIXME 两重循环应该有优化空间，后续再考虑看看
        List<TaskSummary> taskSummaries = new ArrayList<>(myBacklogs.size());
        for (DigiwinAtmcBacklog digiwinAtmcBacklog : myBacklogs) {
            taskTypeMap.put(digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmActivityName());
            Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                    pageTaskRelationList.stream().filter(
                                    pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                            digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId()))
                            .findFirst();
            Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                            pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                    digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory()))
                    .findFirst();
            String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                    optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                    (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");

            String url = "";
//            // 排除内部自己mongo里的task类型 并且 CUSTOM 类型任务APP打开方式(外部链接)
//            if (!StringUtils.hasLength(jumpPageId)
//                    && optPageTaskRelationPattern.map(PageTaskRelation::matchPatternIsCustom).orElse(false)) {
//                url = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
//                        optPageTaskRelationTaskIdAndActivityId.get().getUrl() :
//                        (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getUrl() : "");
//            }
            taskSummaries.add(TaskSummary.create(apiRequest.getLocale(), apiRequest.getIamUserToken(),
                    digiwinAtmcBacklog, jumpPageId, customTaskConfigList, true, apiRequest.getUserId(),
                    false, url, taskTypeData, taskFlowData, taskReadStatusData, taskStatusData,
                    customFilter, customSelectOptionMap, orderCodeSetFromBacklogs, localeService));
        }

        todoList.setTodoList(TaskSummary.sortTeamList(taskSummaries));
        todoList.setSearchUrl("/mobile/v1/task/search");
        todoList.setSearchIdList(new ArrayList<>(taskIds));
        todoList.setQueryParam(taskFilter == null ? "" : taskFilter.getQueryParam());

        todoList.setFilterIdList(filterIds);
        todoList.setFilterList(buildFilterList(taskTypeMap, apiRequest.getLocale(), taskTypeData,
                taskFlowData, taskReadStatusData, taskStatusData, filterIds));

        // 从atmc获取可显示的筛选条件，但是该筛选条件可能存在自定义筛选条件是无效的，所以需要通过customFilter过滤在其中存在的
        List<DigiwinAtmcFilterSetting> filterTaskSettingList = digiwinAtmcProxyService.getFilterTaskSetting(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());

        //设置普通筛选信息
        buildCommonFilter(apiRequest, todoList, taskFilter, taskTypeMap,
                customFilter, filterTaskSettingList, customSelectOptionMap);

        //设置高级筛选信息
        buildSeniorFilter(apiRequest, todoList, taskFilter, taskTypeMap,
                customFilter, filterTaskSettingList, customSelectOptionMap);

        //上次使用高级筛选来筛选还是普通筛选
        todoList.setIsUseSeniorFilter(Objects.isNull(taskFilter) || Objects.isNull(taskFilter.getIsUseSeniorFilter()) ?
                false : taskFilter.getIsUseSeniorFilter());

        //设置分组信息
        buildGroupFilterInfo(apiRequest, todoList, taskFilter, true);

        //设置排序信息
        buildSortFilterList(apiRequest, todoList, taskFilter, orderCodeSetFromBacklogs, true);

        //构建开关
        buildFilterSwitch(apiRequest, todoList);

        return todoList;
    }

    private void buildCommonFilter(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter,
                                   Map<String, String> taskTypeMap, Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter,
                                   List<DigiwinAtmcFilterSetting> filterTaskSettingList, Map<String, Set<String>> customSelectOptionMap) {
        String locale = apiRequest.getLocale();

        List<CardListCommonFilterDefaultOption> defaultOptionList = new ArrayList<>(5);

        // 系统级筛选条件
        Arrays.stream(SystemFilterEnum.values()).forEach(item -> {
            Map<String, String> options = DigiwinAtmcBacklog.TASK_TYPE.equalsIgnoreCase(item.getType()) ? taskTypeMap : item.getOptions(locale);
            defaultOptionList.add(this.buildCardListCommonFilterDefaultOption(item.getType(),
                    localeService.getLanguageValue(locale, item.getName()), item.getDataType(),
                    SourceTypeEnum.SYSTEM.getType(), options));
        });

        // 自定义筛选条件，接口获取到的filterTaskSettingList没有自定义参数类型，需要从cardConfig获取
        //  filterTaskSettingList必须为normal为true 才算常规筛选自定义条件
        List<String> customFilterTaskSettingCodeList = filterTaskSettingList.stream().
                filter(item -> "customer".equalsIgnoreCase(item.getSourceType())
                        && BooleanUtils.isTrue(item.getNormal())).map(item -> item.getCode()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customFilterTaskSettingCodeList)) {
            customFilter.entrySet().forEach(item -> {
                if (customFilterTaskSettingCodeList.contains(item.getKey())) {
                    DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter cardConfigFilter = item.getValue();
                    Map<String, String> valueOptionMap = Collections.emptyMap();
                    if (DataTypeEnum.SELECT.getName().equalsIgnoreCase(cardConfigFilter.getDataType())) {
                        Set<String> customSelectOptionList = MapUtil.getOrDefault(customSelectOptionMap, item.getKey(), Collections.emptySet());
                        valueOptionMap = customSelectOptionList.stream().collect(Collectors.toMap(e -> e, e -> e));
                    }
                    defaultOptionList.add(this.buildCardListCommonFilterDefaultOption(item.getKey(),
                            cardConfigFilter.getAliasName(), cardConfigFilter.getDataType(),
                            SourceTypeEnum.CUSTOM.getType(), valueOptionMap));
                }
            });
        }

        CardListCommonFilter cardListCommonFilter = new CardListCommonFilter();
        cardListCommonFilter.setDefaultOptionList(defaultOptionList);

        if (Objects.nonNull(taskFilter) && StringUtils.hasLength(taskFilter.getCommonFilter())) {
            List<CardListCommonFilterSelectedOption> cardListCommonFilterSelectedOptionList = JsonUtil.jsonStringToObject(taskFilter.getCommonFilter(),
                    new TypeReference<List<CardListCommonFilterSelectedOption>>() {
                    });
            cardListCommonFilter.setSelectedOptionList(cardListCommonFilterSelectedOptionList);
        }
        todoList.setCommonFilter(cardListCommonFilter);
    }

    private CardListCommonFilterDefaultOption buildCardListCommonFilterDefaultOption(String filterOptionId, String filterOptionName, String dataType,
                                                                                     String sourceType, Map<String, String> valueOptionMap) {
        CardListCommonFilterDefaultOption cardListCommonFilterDefaultOption = new CardListSeniorFilterDefaultOption();
        cardListCommonFilterDefaultOption.setFilterOptionId(filterOptionId);
        cardListCommonFilterDefaultOption.setFilterOptionName(filterOptionName);
        List<CardListBaseOption> valueOptionList = valueOptionMap.entrySet().stream().map(item -> {
            CardListBaseOption cardListBaseOption = new CardListBaseOption();
            cardListBaseOption.setFilterOptionId(item.getKey());
            cardListBaseOption.setFilterOptionName(item.getValue());
            return cardListBaseOption;
        }).collect(Collectors.toList());
        cardListCommonFilterDefaultOption.setValueOptionList(valueOptionList);
        cardListCommonFilterDefaultOption.setDataType(dataType);
        cardListCommonFilterDefaultOption.setSourceType(sourceType);
        return cardListCommonFilterDefaultOption;
    }

    private void buildSeniorFilter(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter,
                                   Map<String, String> taskTypeMap, Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter,
                                   List<DigiwinAtmcFilterSetting> filterTaskSettingList, Map<String, Set<String>> customSelectOptionMap) {
        String locale = apiRequest.getLocale();

        List<CardListSeniorFilterDefaultOption> defaultOptionList = new ArrayList<>(5);

        // 系统级筛选条件
        Arrays.stream(SystemFilterEnum.values()).forEach(item -> {
            Map<String, String> options = DigiwinAtmcBacklog.TASK_TYPE.equalsIgnoreCase(item.getType()) ? taskTypeMap : item.getOptions(locale);
            defaultOptionList.add(this.buildCardListSeniorFilterDefaultOption(item.getType(),
                    localeService.getLanguageValue(locale, item.getName()), item.getDataType(),
                    SourceTypeEnum.SYSTEM.getType(), options, locale));
        });

        // 自定义筛选条件，接口获取到的filterTaskSettingList没有自定义参数类型，需要从cardConfig获取
        // filterTaskSettingList必须为normal不管为true或false 都算高级筛选自定义条件
        List<String> customFilterTaskSettingCodeList = filterTaskSettingList.stream().
                filter(item -> "customer".equalsIgnoreCase(item.getSourceType())).map(item -> item.getCode()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customFilterTaskSettingCodeList)) {
            customFilter.entrySet().forEach(item -> {
                if (customFilterTaskSettingCodeList.contains(item.getKey())) {
                    DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter cardConfigFilter = item.getValue();
                    Map<String, String> valueOptionMap = Collections.emptyMap();
                    if (DataTypeEnum.SELECT.getName().equalsIgnoreCase(cardConfigFilter.getDataType())) {
                        Set<String> customSelectOptionList = MapUtil.getOrDefault(customSelectOptionMap, item.getKey(), Collections.emptySet());
                        valueOptionMap = customSelectOptionList.stream().collect(Collectors.toMap(e -> e, e -> e));
                    }
                    defaultOptionList.add(this.buildCardListSeniorFilterDefaultOption(item.getKey(),
                            cardConfigFilter.getAliasName(), cardConfigFilter.getDataType(),
                            SourceTypeEnum.CUSTOM.getType(), valueOptionMap, locale));
                }
            });
        }

        CardListSeniorFilter cardListSeniorFilter = new CardListSeniorFilter();
        cardListSeniorFilter.setDefaultOptionList(defaultOptionList);

        if (Objects.nonNull(taskFilter) && StringUtils.hasLength(taskFilter.getSeniorFilter())) {
            List<CardListSeniorFilterSelectedOption> cardListSeniorFilterSelectedOptionList = JsonUtil.jsonStringToObject(taskFilter.getSeniorFilter(),
                    new TypeReference<List<CardListSeniorFilterSelectedOption>>() {
                    });
            cardListSeniorFilter.setSelectedOptionList(cardListSeniorFilterSelectedOptionList);
        }
        todoList.setSeniorFilter(cardListSeniorFilter);
    }

    private CardListSeniorFilterDefaultOption buildCardListSeniorFilterDefaultOption(String filterOptionId, String filterOptionName, String dataType,
                                                                                     String sourceType, Map<String, String> valueOptionMap, String locale) {
        CardListSeniorFilterDefaultOption cardListSeniorFilterDefaultOption = new CardListSeniorFilterDefaultOption();
        cardListSeniorFilterDefaultOption.setFilterOptionId(filterOptionId);
        cardListSeniorFilterDefaultOption.setFilterOptionName(filterOptionName);
        List<CardListBaseOption> valueOptionList = valueOptionMap.entrySet().stream().map(item -> {
            CardListBaseOption cardListBaseOption = new CardListBaseOption();
            cardListBaseOption.setFilterOptionId(item.getKey());
            cardListBaseOption.setFilterOptionName(item.getValue());
            return cardListBaseOption;
        }).collect(Collectors.toList());
        cardListSeniorFilterDefaultOption.setValueOptionList(valueOptionList);
        cardListSeniorFilterDefaultOption.setFilterConditionList(buildFilterConditionList(dataType, locale));
        cardListSeniorFilterDefaultOption.setSpliceConditionList(buildSpliceConditionList(locale));
        cardListSeniorFilterDefaultOption.setDataType(dataType);
        cardListSeniorFilterDefaultOption.setSourceType(sourceType);
        return cardListSeniorFilterDefaultOption;
    }

    private List<CardListBaseOption> buildFilterConditionList(String dataType, String locale) {
        return Arrays.stream(FilterTypeEnum.values())
                .filter(e -> e.getSupportDataType().contains(dataType))
                .map(item -> {
                    CardListBaseOption cardListBaseOption = new CardListBaseOption();
                    cardListBaseOption.setFilterOptionId(item.getType());
                    cardListBaseOption.setFilterOptionName(localeService.getLanguageValue(locale, item.getName()));
                    return cardListBaseOption;
                }).collect(Collectors.toList());
    }

    private List<CardListBaseOption> buildSpliceConditionList(String locale) {
        return Arrays.stream(SpliceTypeEnum.values())
                .map(item -> {
                    CardListBaseOption cardListBaseOption = new CardListBaseOption();
                    cardListBaseOption.setFilterOptionId(item.getType());
                    cardListBaseOption.setFilterOptionName(localeService.getLanguageValue(locale, item.getName()));
                    return cardListBaseOption;
                }).collect(Collectors.toList());
    }

    /**
     * 构建扫码任务查询列表
     *
     * @param apiRequest 请求参数
     * @param myBacklogs 平台任务列表
     * @param todoList   组装返回结构
     * @return
     */
    public TodoList paddingMobileTaskListFormWithOutFilterList(ApiRequest apiRequest, List<DigiwinAtmcBacklog> myBacklogs,
                                                               TodoList todoList, boolean isNeedShowFilter, String tenantVersion) {
        List<PageTaskRelation> pageTaskRelationList =
                activityFilterService.listAthenaOfPageTaskRelations(apiRequest.getTenantId(), tenantVersion);

        // 获取CustomTaskConfig相关文档数据
        List<CustomTaskConfig> customTaskConfigList = this.customTaskConfigService.listCustomTaskConfig();

        //任务类型数组
        Map<String, String> taskTypeMap = new HashMap<>(16);
        //任务类型的数据
        Map<String, Integer> taskTypeData = new HashMap<>(16);
        //任务流程的数据
        Map<String, Integer> taskFlowData = new HashMap<>(16);
        //是否已读的数据
        Map<String, Integer> taskReadStatusData = new HashMap<>(16);
        //任务状态的数据
        Map<String, Integer> taskStatusData = new HashMap<>(16);

        //自定义筛选条件
        Map<String, DigiwinAtmcCardConfigItemSetInfo.DigiwinAtmcCardConfigFilter> customFilter = new HashMap<>(16);

        //自定义筛选条件-所有select类型的选项值信息
        Map<String, Set<String>> customSelectOptionMap = new HashMap<>();

        //自定义排序条件code（从任务列表获取)-用来后续判断从接口返回的自定义排序条件是否可用
        Set<String> orderCodeSetFromBacklogs = new HashSet<>();

        List<TaskSummary> taskSummaries = new ArrayList<>(myBacklogs.size());
        for (DigiwinAtmcBacklog digiwinAtmcBacklog : myBacklogs) {
            Optional<PageTaskRelation> optPageTaskRelationTaskIdAndActivityId =
                    pageTaskRelationList.stream().filter(
                                    pageTaskRelation -> pageTaskRelation.matchInTaskIdAndActivityId(
                                            digiwinAtmcBacklog.getTmTaskId(), digiwinAtmcBacklog.getTmActivityId()))
                            .findFirst();
            Optional<PageTaskRelation> optPageTaskRelationPattern = pageTaskRelationList.stream().filter(
                            pageTaskRelation -> pageTaskRelation.matchInPatternAndCategory(
                                    digiwinAtmcBacklog.getTmPattern(), digiwinAtmcBacklog.getTmCategory()))
                    .findFirst();
            String jumpPageId = optPageTaskRelationTaskIdAndActivityId.isPresent() ?
                    optPageTaskRelationTaskIdAndActivityId.get().getPageId() :
                    (optPageTaskRelationPattern.isPresent() ? optPageTaskRelationPattern.get().getPageId() : "");

            TaskSummary taskSummary;
            if (isNeedShowFilter) {
                taskTypeMap.put(digiwinAtmcBacklog.getTmActivityId(), digiwinAtmcBacklog.getTmActivityName());
                taskSummary = TaskSummary.create(apiRequest.getLocale(), apiRequest.getIamUserToken(),
                        digiwinAtmcBacklog, jumpPageId, customTaskConfigList, true, apiRequest.getUserId(),
                        false, "", taskTypeData, taskFlowData, taskReadStatusData, taskStatusData,
                        customFilter, customSelectOptionMap, orderCodeSetFromBacklogs, localeService);
            } else {
                taskSummary = TaskSummary.create(apiRequest.getLocale(), apiRequest.getIamUserToken(), digiwinAtmcBacklog,
                        jumpPageId, customTaskConfigList, true, apiRequest.getUserId(), false, localeService);
            }
            taskSummaries.add(taskSummary);
        }
        todoList.setTodoList(TaskSummary.sortTeamList(taskSummaries));

        // 是否需要展示筛选，分组和排序，开关，扫码列表不会保存各个条件选项值
        if (isNeedShowFilter) {
            todoList.setSearchUrl("/mobile/v1/task/search");
            todoList.setSearchIdList(new ArrayList<>());

            UserTaskFilter taskFilter = new UserTaskFilter();

            List<DigiwinAtmcFilterSetting> filterTaskSettingList = digiwinAtmcProxyService.getFilterTaskSetting(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());

            //设置普通筛选信息
            buildCommonFilter(apiRequest, todoList, taskFilter, taskTypeMap,
                    customFilter, filterTaskSettingList, customSelectOptionMap);

            //设置高级筛选信息
            buildSeniorFilter(apiRequest, todoList, taskFilter, taskTypeMap,
                    customFilter, filterTaskSettingList, customSelectOptionMap);

            //上次使用高级筛选来筛选还是普通筛选
            todoList.setIsUseSeniorFilter(Objects.isNull(taskFilter) || Objects.isNull(taskFilter.getIsUseSeniorFilter()) ? false : taskFilter.getIsUseSeniorFilter());

            //设置分组信息
            buildGroupFilterInfo(apiRequest, todoList, taskFilter, false);

            //设置排序信息
            buildSortFilterList(apiRequest, todoList, taskFilter, orderCodeSetFromBacklogs, false);

            //构建开关
            buildDefaultFilterSwitch(apiRequest, todoList);
        }
        return todoList;
    }

    private List<CardListFilter> buildFilterList(Map<String, String> taskTypeMap, String locale,
                                                 Map<String, Integer> taskTypeData, Map<String, Integer> taskFlowData,
                                                 Map<String, Integer> taskReadStatusData,
                                                 Map<String, Integer> taskStatusData, List<String> filterIds) {
        List<CardListFilter> filterList = new ArrayList<>(4);
        //筛选任务类型
        CardListFilter taskTypeFilter = new CardListFilter();
        taskTypeFilter.setFilterId(DigiwinAtmcBacklog.TASK_TYPE);
        taskTypeFilter.setFilterName(localeService.getLanguageValue(locale, "任务类型"));
        List<CardListOption> taskTypeFilterOptionSet = new ArrayList<>(taskTypeMap.size());
        if (!CollectionUtils.isEmpty(taskTypeMap)) {
            for (String key : taskTypeMap.keySet()) {
                if (filterIds.contains(key)) {
                    taskTypeFilterOptionSet.add(new CardListOption(key, taskTypeMap.get(key), true));
                } else {
                    taskTypeFilterOptionSet.add(new CardListOption(key, taskTypeMap.get(key), false));
                }

            }
        }
        taskTypeFilter.setFilterDataMap(taskTypeData);
        taskTypeFilter.setFilterOptionList(taskTypeFilterOptionSet);
        filterList.add(taskTypeFilter);
        //筛选任务流程节点
        filterList.add(buildFilter(DigiwinAtmcBacklog.TASK_OTHERTASKINFO, locale, "任务来源", DigiwinAtmcBacklog.TASK_FLOW_MAP, taskFlowData, filterIds));
        filterList.add(buildFilter(DigiwinAtmcBacklog.TASK_READ_STATUS, locale, "阅读状态", DigiwinAtmcBacklog.TASK_READ_STATUS_MAP, taskReadStatusData, filterIds));
        filterList.add(buildFilter(DigiwinAtmcBacklog.TASK_STATUS, locale, "任务状态", DigiwinAtmcBacklog.TASK_STATUS_MAP, taskStatusData, filterIds));

        return filterList;
    }

    private CardListFilter buildFilter(String filterId, String locale, String name,
                                       Map<String, String> options, Map<String, Integer> dataMap,
                                       List<String> filterIds) {
        CardListFilter taskFlowFilter = new CardListFilter();
        taskFlowFilter.setFilterId(filterId);
        taskFlowFilter.setFilterName(localeService.getLanguageValue(locale, name));
        List<CardListOption> taskFlowFilterOptionSet = new ArrayList<>(options.size());
        for (String key : options.keySet()) {
            if (filterIds.contains(key)) {
                taskFlowFilterOptionSet.add(new CardListOption(key,
                        localeService.getLanguageValue(locale, options.get(key)), true));
            } else {
                taskFlowFilterOptionSet.add(new CardListOption(key,
                        localeService.getLanguageValue(locale, options.get(key)), false));
            }

        }
        taskFlowFilter.setFilterDataMap(dataMap);
        taskFlowFilter.setFilterOptionList(taskFlowFilterOptionSet);
        return taskFlowFilter;
    }

    private void buildGroupFilterInfo(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter, boolean isShowSelected) {
        List<DigiwinAtmcGroupRecord> digiwinAtmcGroupRecordList = digiwinAudcProxyService.getGroupRecord(apiRequest.getLocale(),
                apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(digiwinAtmcGroupRecordList)) {
            List<CardListGroupOption> cardListGroupFilterOptionList = digiwinAtmcGroupRecordList.stream()
                    .filter(e -> BooleanUtils.isTrue(e.getEnabled())
                            && !"groupByMember".equalsIgnoreCase(e.getCode()) // 目前使用的平台老接口，接口返回了团队任务的成员和部门选项，需要过滤掉
                            && !"groupByDepartment".equalsIgnoreCase(e.getCode()))
                    .map(item -> {
                        CardListGroupOption cardListGroupFilterOption = new CardListGroupOption();
                        cardListGroupFilterOption.setFilterOptionId(item.getCode());

                        // 业务分组名+应用名
                        String filterOptionName = item.getName() + (StringUtil.isNotEmpty(item.getAppName()) ? "(" + item.getAppName() + ")" : "");
                        cardListGroupFilterOption.setFilterOptionName(filterOptionName);

                        // 是否展示选中
                        if (Objects.nonNull(taskFilter) && isShowSelected) {
                            cardListGroupFilterOption.setIsSelect(Objects.equals(item.getCode(), taskFilter.getGroupFilterIds()));
                        } else {
                            cardListGroupFilterOption.setIsSelect("noGrouping".equalsIgnoreCase(item.getCode()) ? true : false);
                        }

                        // type枚举 system：系统分组标签，businessKey：自定义分组标签
                        cardListGroupFilterOption.setType(item.getType());
                        return cardListGroupFilterOption;
                    }).collect(Collectors.toList());

            CardListGroupFilter cardListGroupFilter = new CardListGroupFilter();
            cardListGroupFilter.setFilterOptionList(cardListGroupFilterOptionList);

            List<String> selectCodeList = cardListGroupFilterOptionList.stream()
                    .filter(e -> BooleanUtils.isTrue(e.getIsSelect())).map(e -> e.getFilterOptionId()).collect(Collectors.toList());
            todoList.setGroupFilterIdList(selectCodeList);
            todoList.setGroupFilterList(Collections.singletonList(cardListGroupFilter));
        }
    }

    private void buildSortFilterList(ApiRequest apiRequest, TodoList todoList, UserTaskFilter taskFilter,
                                     Set<String> orderCodeSetFromBacklogs, boolean isShowSelected) {
        List<DigiwinAtmcOrderSetting> atmcOrderSettingList = digiwinAtmcProxyService.getOrderTaskSetting(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (CollectionUtils.isEmpty(atmcOrderSettingList)) {
            return;
        }

        // 从接口获取的自定义排序条件需要过滤出真正能通过列表数据执行排序的条件，如果列表businessMessage没有支持该排序条件，相当于该条件无效
        atmcOrderSettingList = atmcOrderSettingList.stream()
                .filter(item -> {
                    if ("customer".equalsIgnoreCase(item.getSourceType())) {
                        return orderCodeSetFromBacklogs.contains(item.getCode());
                    }
                    return true;
                }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(atmcOrderSettingList)) {
            return;
        }

        // 点击重置后应该展示的默认排序条件，enable 为true 代表交付设计器配置的默认排序条件
        List<CardListSortItem> defaultSortList = atmcOrderSettingList.stream()
                .filter(item -> BooleanUtils.isTrue(item.getEnable()))
                .map(item -> buildDefaultSort(apiRequest, item)).collect(Collectors.toList());

        // 初始化排序应该展示的排序条件
        List<CardListSortItem> sortItemList;
        if (Objects.isNull(taskFilter) || StringUtil.isEmpty(taskFilter.getSortFilter())) {
            // 如果没有选择过排序条件，默认展示所有
            sortItemList = atmcOrderSettingList.stream().map(item -> buildDefaultSort(apiRequest, item)).collect(Collectors.toList());
        } else {
            // 如果选择过排序条件，栏位位置变动过，栏位位置展示上一次的保存位置
            List<CardListSortrSelectedOption> cardListSortrSelectedOption = JsonUtil.jsonStringToObject(taskFilter.getSortFilter(), new TypeReference<List<CardListSortrSelectedOption>>() {
            });
            Map<String, DigiwinAtmcOrderSetting> digiwinAtmcOrderSettingMapByCode = atmcOrderSettingList.stream().collect(Collectors.toMap(DigiwinAtmcOrderSetting::getCode,
                    e -> e, (key1, key2) -> key2));

            sortItemList = cardListSortrSelectedOption.stream()
                    .filter(item -> digiwinAtmcOrderSettingMapByCode.containsKey(item.getCode()))
                    .map(item -> {
                        DigiwinAtmcOrderSetting digiwinAtmcOrderSetting = digiwinAtmcOrderSettingMapByCode.get(item.getCode());
                        // 设置选项值，升序和降序固定有，选项值默认根据enableDefaultSort判断是否展示
                        List<OrderOptionEnum> orderOptionEnumList = OrderOptionEnum.getCommonSort(digiwinAtmcOrderSetting.getEnableDefaultSort());
                        List<CardListOption> cardListOptionList = orderOptionEnumList.stream().map(orderOption -> {
                            CardListOption cardListOption = new CardListOption();
                            cardListOption.setFilterOptionId(orderOption.getType());
                            String orderOptionName = orderOption.getName();
                            if ("READ_STATUS".equalsIgnoreCase(digiwinAtmcOrderSetting.getCode())) {
                                orderOptionName = ReadStateOrderOptionEnum.getReadStateOrderOptionNameByType(orderOption.getType());
                            }
                            cardListOption.setFilterOptionName(localeService.getLanguageValue(apiRequest.getLocale(), orderOptionName));

                            List<String> valueOptionList = item.getValueOptionList();
                            if (!CollectionUtils.isEmpty(valueOptionList)) {
                                cardListOption.setIsSelect(isShowSelected && valueOptionList.contains(orderOption.getType()));
                            }
                            return cardListOption;
                        }).collect(Collectors.toList());

                        CardListSortItem cardListSortItem = new CardListSortItem();
                        cardListSortItem.setFilterId(digiwinAtmcOrderSetting.getCode());
                        cardListSortItem.setFilterName(digiwinAtmcOrderSetting.getName());
                        cardListSortItem.setSourceType(digiwinAtmcOrderSetting.getSourceType());
                        cardListSortItem.setFilterOptionList(cardListOptionList);
                        return cardListSortItem;
                    }).collect(Collectors.toList());
        }
        CardListSort cardListSort = new CardListSort();
        cardListSort.setDefaultSortList(defaultSortList);
        cardListSort.setSortFilterList(sortItemList);
        todoList.setSortFilter(cardListSort);
    }

    private CardListSortItem buildDefaultSort(ApiRequest apiRequest, DigiwinAtmcOrderSetting digiwinAtmcOrderSetting) {
        List<OrderOptionEnum> orderOptionEnumList = OrderOptionEnum.getCommonSort(digiwinAtmcOrderSetting.getEnableDefaultSort());
        List<CardListOption> cardListOptionList = orderOptionEnumList.stream().map(orderOption -> {
            CardListOption cardListOption = new CardListOption();
            cardListOption.setFilterOptionId(orderOption.getType());
            String orderOptionName = orderOption.getName();
            if ("READ_STATUS".equalsIgnoreCase(digiwinAtmcOrderSetting.getCode())) {
                orderOptionName = ReadStateOrderOptionEnum.getReadStateOrderOptionNameByType(orderOption.getType());
            }
            cardListOption.setFilterOptionName(localeService.getLanguageValue(apiRequest.getLocale(), orderOptionName));
            return cardListOption;
        }).collect(Collectors.toList());

        CardListSortItem cardListSortItem = new CardListSortItem();
        cardListSortItem.setFilterId(digiwinAtmcOrderSetting.getCode());
        cardListSortItem.setFilterName(digiwinAtmcOrderSetting.getName());
        cardListSortItem.setSourceType(digiwinAtmcOrderSetting.getSourceType());
        cardListSortItem.setFilterOptionList(cardListOptionList);
        return cardListSortItem;
    }

    private void buildFilterSwitch(ApiRequest apiRequest, TodoList todoList) {
        Map<String, String> params = new HashMap<>(2);
        params.put("userId", apiRequest.getUserId());
        params.put("tenantId", apiRequest.getTenantId());
        PersonalConfiguration personalConfiguration = personalConfigurationService.getByMap(params);

        // 运营单元展示开关
        CardListFilterSwitch showEocSwitch = new CardListFilterSwitch();
        showEocSwitch.setId("eocName");
        showEocSwitch.setName(localeService.getLanguageValue(apiRequest.getLocale(), "运营单元"));
        showEocSwitch.setIsSelect(Objects.isNull(personalConfiguration) ? false : personalConfiguration.getShowEoc());
        todoList.setShowEocSwitch(showEocSwitch);

        // 已处理卡展示开关
        CardListFilterSwitch showHandledCardSwitch = new CardListFilterSwitch();
        showHandledCardSwitch.setId("engineHasWaittingData");
        showHandledCardSwitch.setName(localeService.getLanguageValue(apiRequest.getLocale(), "已处理卡"));
        showHandledCardSwitch.setIsSelect(Objects.isNull(personalConfiguration) ? true : personalConfiguration.getShowHandledCard());
        todoList.setShowHandledCardSwitch(showHandledCardSwitch);
    }

    private void buildDefaultFilterSwitch(ApiRequest apiRequest, TodoList todoList) {
        // 运营单元展示开关
        CardListFilterSwitch showEocSwitch = new CardListFilterSwitch();
        showEocSwitch.setId("eocName");
        showEocSwitch.setName(localeService.getLanguageValue(apiRequest.getLocale(), "运营单元"));
        showEocSwitch.setIsSelect(false);
        todoList.setShowEocSwitch(showEocSwitch);

        // 已处理卡展示开关
        CardListFilterSwitch showHandledCardSwitch = new CardListFilterSwitch();
        showHandledCardSwitch.setId("engineHasWaittingData");
        showHandledCardSwitch.setName(localeService.getLanguageValue(apiRequest.getLocale(), "已处理卡"));
        showHandledCardSwitch.setIsSelect(true);
        todoList.setShowHandledCardSwitch(showHandledCardSwitch);
    }

    private List<Map<String, Object>> getAllList(Map<String, Object> moduleInfo) {
        if (CollectionUtils.isEmpty(moduleInfo)) {
            return buildAllList();
        }
        if (Objects.isNull(moduleInfo.get("detail"))) {
            return buildAllList();
        }
        Map<String, Object> detail = JsonUtil.jsonStringToObject(MapUtils.getString(moduleInfo, "detail"), Map.class);
        List<Map<String, Object>> allList = (List<Map<String, Object>>) MapUtil.getOrDefault(detail, "all", Collections.emptyList());
        if (CollectionUtils.isEmpty(allList)) {
            return buildAllList();
        }
        return allList;
    }

    /**
     * 查询排序内容接口如果没有保存过，接口返回为空，这个时候需要把四个排序条件都展示出来
     */
    private List<Map<String, Object>> buildAllList() {
        List<Map<String, Object>> itemList = new ArrayList<>(4);
        Map<String, Object> typeItemMap = new HashMap<>();
        typeItemMap.put("selectedOption", "setLabelFront");
        typeItemMap.put("type", "label");
        typeItemMap.put("switch", false);
        itemList.add(typeItemMap);

        Map<String, Object> readStatusItemMap = new HashMap<>();
        readStatusItemMap.put("selectedOption", "readStatusUnread");
        readStatusItemMap.put("defaultOption", "readStatusRead");
        readStatusItemMap.put("type", "readStatus");
        readStatusItemMap.put("switch", false);
        itemList.add(readStatusItemMap);

        Map<String, Object> timeItemMap = new HashMap<>();
        timeItemMap.put("selectedOption", "timeEndTimeAsc");
        timeItemMap.put("defaultOption", "timeEndTimeDesc");
        timeItemMap.put("type", "time");
        timeItemMap.put("switch", false);
        itemList.add(timeItemMap);

        Map<String, Object> taskTypeItemMap = new HashMap<>();
        taskTypeItemMap.put("selectedOption", "taskTypeFront");
        taskTypeItemMap.put("type", "taskType");
        taskTypeItemMap.put("switch", false);
        itemList.add(taskTypeItemMap);
        return itemList;
    }

    private List<TaskSummary> doMockData(String locale) {
        try {
            Thread.sleep(1000L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data = FileUtil.readText("static/appstore-use/task-list.json");
        List<TaskSummary> taskSummaries = Collections.emptyList();
        if (null != data && !data.isEmpty()) {
            taskSummaries = JSONArray.parseArray(data, TaskSummary.class);
        }
        return taskSummaries;
    }
}