package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.notification.model.NotificationDetail;
import com.digiwin.mobile.mobileuibot.notification.service.NotificationService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;

/**
 * <p>功能描述：UiBot数据模型构建策略接口--实现消息列表页面构建</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildNotificationStrategy
 * @Author: Zaregoto
 * @Date: 2021/5/12 22:04
 */
@Component("uiBotModelBuildNotificationStrategy")
public class UiBotModelBuildNotificationStrategy implements UiBotModelBuildStrategy {

    private static final Integer PAGE_SIZE = 10;

    @Autowired
    private NotificationService notificationService;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        String mobileNotificationCategoryId = pageSetting.getPageId();
        List<NotificationDetail> notificationDetails = this.notificationService
                .listNotificationDetailsByCategoryId(apiRequest.getUserId(),
                        apiRequest.getClientId(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                        mobileNotificationCategoryId, apiRequest.getDataId(), apiRequest.getPageNum(), PAGE_SIZE);
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, notificationDetails);
        if (notificationDetails != null && notificationDetails.size() == PAGE_SIZE) {
            uiBotModel.setHasMore(true);
        } else {
            uiBotModel.setHasMore(false);
        }
        return uiBotModel;
    }
}
