package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.choosetaskprogress.ChooseTaskProgress;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinReassignReport;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 转派记录页面创建策略类
 *
 * @author wuyang
 * @date 2022/11/8 0001 9:59
 */
@Component("uiBotModelBuildReassignReportStrategy")
public class UiBotModelBuildReassignReportStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildReassignReportStrategy.class);

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData();
        Object reassignReportType = rawData.get("reassignReportType");
        List<DigiwinReassignReport> reassignReportList = new ArrayList<>();
        if ("PROJECT".equals(reassignReportType)) {
            reassignReportList = digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(),
                    apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        } else if ("TASK".equals(reassignReportType)) {
            reassignReportList = digiwinAtmcProxyService.getTaskReassignReport(apiRequest.getDataId(),
                    apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        } else {
            // 历史转派记录逻辑
            List<Map<String, Object>> reassignReportMap = (List<Map<String, Object>>) rawData.get("rawData");
            reassignReportList = ModuleUtils.listMapToListObject(reassignReportMap, DigiwinReassignReport.class);
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case ChooseTaskProgress.COMPONENT_TYPE:
                    pageData.put(uiBotLayout.getSchema(), ChooseTaskProgress.createReassignReport(locale, reassignReportList));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons = ModuleUtils.listMapToListObject((List) pageData.get(uiBotLayout.getSchema()), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                    }
                    pageData.put(uiBotLayout.getSchema(), buttons);
                    break;
                default:
                    break;
            }
        }
        return pageSetting.getPageModel();
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;
        data = FileUtil.readText(
                "static/appstore-use/project-create-" + apiRequest.getDataId() + ".json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }


}
