package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import cn.hutool.core.util.StrUtil;
import com.digiwin.mobile.mobileuibot.abireport.ReportCategoryEnum;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.apposition.Apposition;
import com.digiwin.mobile.mobileuibot.core.component.apposition.AppositionData;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcTmDataReport;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;


/**
 * 报表集合页
 *
 * @author 吴阳
 * @date 20230103
 */
@Component("uiBotModelBuildReportListStrategy")
public class UiBotModelBuildReportListStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildReportListStrategy.class);

    private static final Integer REPORT_SHOW_SIZE = 2;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinAudcProxyService audcProxyService;
    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        String iamUserToken = apiRequest.getIamUserToken();
        String tenantId = apiRequest.getTenantId();
        String clientId = apiRequest.getClientId();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        //页面加上搜索按钮
        List<Button> appbarButtonList = uiBotModel.getAppbarButtonList();
        appbarButtonList.add(Button.createSearchReportName(locale, localeService));

        //拿到所有报表
        List<DigiwinAtmcTmData> tmDataList = audcProxyService.getTmDataList(clientId,
                iamUserToken, tenantId, locale);

        for (DigiwinAtmcTmData digiwinAtmcTmData : tmDataList) {
            UiBotLayout layout = new UiBotLayout();
            String schema = UUIDUtil.getUuid();
            layout.setSchema(schema);
            layout.setType(Retractable.COMPONENT_TYPE);
            uiBotLayouts.add(layout);

            Retractable retractable = new Retractable();
            retractable.setTitle(digiwinAtmcTmData.getAppName());
            Apposition apposition = new Apposition();
            apposition.setPadding(12d);
            apposition.setColumns(REPORT_SHOW_SIZE);
            List<AppositionData> data = new ArrayList<>(tmDataList.size());
            apposition.setDatas(data);

            List<BaseMobileComponentWrapper<BaseMobileComponent>> content = retractable.getContent();
            if (!CollectionUtils.isEmpty(digiwinAtmcTmData.getBaseItemDtoList())) {
                for (DigiwinAtmcTmDataReport dataReport : digiwinAtmcTmData.getBaseItemDtoList()) {
                    AppositionData appositionData = new AppositionData();
                    if (dataReport.isAllow()) {
                        appositionData.setComponentType(Button.COMPONENT_TYPE);
                        //M2需求-过滤ABI报表
                        //if (ReportCategoryEnum.ABI_STATEMENT.getValue().equals(dataReport.getCategory())) {
                        //    appositionData.setData(BottomButtonDigiwinAthena.createABIReportButton(
                        //            dataReport.getName(), dataReport, dataReport.getCode()));
                        //} else
                        if (ReportCategoryEnum.STATEMENT.getValue().equals(dataReport.getCategory())) {
                            appositionData.setData(BottomButtonDigiwinAthena.createTBBReportButton(
                                    apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                                    Optional.ofNullable(dataReport.getResCode()).filter(StrUtil::isNotEmpty).orElse(dataReport.getCode()),
                                    dataReport.getName()));
//                            continue;
                        } else {
                            continue;
                        }
                        data.add(appositionData);
                    }
                }
            }
            if (CollectionUtils.isEmpty(data)) {
                continue;
            }
            content.add(new BaseMobileComponentWrapper<>(apposition, Apposition.COMPONENT_TYPE));
            pageData.put(schema, retractable);
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }


}
