package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.TextMulti;
import com.digiwin.mobile.mobileuibot.core.component.image.BaseImageContent;
import com.digiwin.mobile.mobileuibot.core.component.image.swiper.Swiper;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.title.articletitle.ArticleTitle;
import com.digiwin.mobile.mobileuibot.core.component.title.articletitle.BaseArticleContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.kbs.serivce.DigiwinKbsService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：聚合搜索详情页面的生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildSearchItemDetailStrategy
 * @Author: Liux
 * @Date: 2022年6月7日 17点22分
 */
@Component("uiBotModelBuildSearchItemDetailStrategy")
public class UiBotModelBuildSearchItemDetailStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildSearchItemDetailStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinKbsService digiwinKbsService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        String knowledgeId = (String) apiRequest.getRawData().get("knowledge_id");
        Map<String, Object> knowledgeInfos = new HashMap<>();
        knowledgeInfos.put("knowledge_id", knowledgeId);

        Map<String, Object> detailInfo = digiwinKbsService.getDetailInfo(knowledgeInfos, userToken, locale);

        // 拼成最终数据
        stopWatch.start("Build PccTailTask Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            switch (layout.getType()) {
                case ArticleTitle.COMPONENT_TYPE:   //文章标题
                    ArticleTitle articleTitle = ArticleTitle.create(locale, userToken, detailInfo);
                    uiBotModel.getPageData().put(layout.getSchema(), articleTitle);
                    break;
                case TextMulti.COMPONENT_TYPE:   //问题描述
                    TextMulti description = TextMulti.create(locale, userToken, detailInfo);
                    if (null != description.getValue() && StringUtils.isNotEmpty(description.getValue())) {
                        uiBotModel.getPageData().put(layout.getSchema(), description);
                    }
                    break;
                case Swiper.COMPONENT_TYPE:   //问题图片。目前web端没有，配置已去掉。启用的话需要在mongo里面配置下
                    Swiper picture = Swiper.create(locale, userToken, detailInfo);
                    if (picture.getContent().size() > 0) {
                        if (picture.getContent().size() == 1) {
                            BaseImageContent content = JsonUtil.objectToJavaObject(picture.getContent().get(0), BaseImageContent.class);
                            if (null == content.getData() || !StringUtils.isNotEmpty(content.getData())) {
                                break;
                            }
                        }
                        uiBotModel.getPageData().put(layout.getSchema(), picture);
                    }


                    break;
                case Attachment.COMPONENT_TYPE:
                    if ("solution".equalsIgnoreCase(layout.getSchema())) {
                        //问题解决方案
                        Attachment solution = Attachment.createSolution(locale, userToken, detailInfo);
                        if (solution.getFileList().size() > 0) {
                            if (solution.getFileList().size() == 1) {
                                AttachmentFile attachmentFile = JsonUtil.objectToJavaObject(solution.getFileList().get(0), AttachmentFile.class);
                                if (null == attachmentFile.getShareUrl() || !StringUtils.isNotEmpty(attachmentFile.getShareUrl())) {
                                    break;
                                }
                            }
                            uiBotModel.getPageData().put(layout.getSchema(), solution);
                        }
                    } else if ("actualAttachment".equalsIgnoreCase(layout.getSchema())) {
                        //附件
                        Attachment actualAttachment = Attachment.createActualAttachment(locale, userToken, detailInfo);
                        if (actualAttachment.getFileList().size() > 0) {
                            if (actualAttachment.getFileList().size() == 1) {
                                AttachmentFile attachmentFile = JsonUtil.objectToJavaObject(actualAttachment.getFileList().get(0), AttachmentFile.class);
                                if (null == attachmentFile.getShareUrl() || !StringUtils.isNotEmpty(attachmentFile.getShareUrl())) {
                                    break;
                                }
                            }
                            uiBotModel.getPageData().put(layout.getSchema(), actualAttachment);
                        }
                    }
                    break;
                default:
                    break;
            }

        }

        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        data = FileUtil.readText("static/mobile_athena_search_item_detail.json");
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
            ArticleTitle articleTitle = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get("articleTitle"), ArticleTitle.class);
            BaseArticleContent minorContent = articleTitle.getMinorContent();
            int readNum = minorContent.getReadNum();
            readNum++;
            minorContent.setReadNum(readNum);
            articleTitle.setMinorContent(minorContent);
            uiBotModel.getPageData().put("articleTitle", articleTitle);
        }

        return uiBotModel;
    }
}
