package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildStrategyFactory
 * @Author: Zaregoto
 * @Date: 2021/5/12 22:07
 */
@Component("uiBotModelBuildStrategyFactory")
public class UiBotModelBuildStrategyFactory {

    // TODO 改成使用业务key。Spring会自动将Strategy接口的实现类注入到这个Map中，key为bean id，value值则为对应的策略实现类
    @Autowired
    private Map<String, UiBotModelBuildStrategy> strategyMap;

    public UiBotModelBuildStrategy get(String beanName) {
        return this.strategyMap.get(beanName);
    }
}
