package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.core.component.index.TripartiteTodoList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.semc.model.LabelSystemData;
import com.digiwin.mobile.mobileuibot.proxy.semc.service.DigiwinSemcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

/**
 * UiBot数据模型构建策略接口--实现三方待办清单页面构建
 *
 * @author yanfenga
 * @data 2024-03-18
 */
@Component("uiBotModelBuildTripartiteToDoListStrategy")
public class UiBotModelBuildTripartiteToDoListStrategy implements UiBotModelBuildStrategy {

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinSemcProxyService digiwinSemcProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            if (uiBotLayout.getType().equals(TripartiteTodoList.COMPONENT_TYPE)) {
                pageData.put(uiBotLayout.getSchema(),
                        TripartiteTodoList.createTripartiteToDoList(apiRequest, pageData, handleData(apiRequest), uiBotLayout.getSchema()));
            }
        }
        return uiBotModel;
    }

    private List<LabelSystemData> handleData(ApiRequest apiRequest) {
        try {
            CompletableFuture<List<LabelSystemData>> supplyAsync = CompletableFuture.supplyAsync(() -> this.digiwinSemcProxyService.getTripartiteToDoList(apiRequest.getClientId(),
                            apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId())
                    , this.threadPoolTaskExecutor);
            return supplyAsync.get();
        } catch (InterruptedException | ExecutionException e) {
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
    }

}
