package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtabcontroller.CustomTabController;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabscroll.TabScrollContainer;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.service.impl.UniversalParsingServiceImpl;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * Uibot通用解析策略类
 *
 * @author zhangjj
 * @date 2021/11/1 0001 9:59
 */
@Component("uiBotModelBuildUibotUniversalParseStrategy")
public class UiBotModelBuildUibotUniversalParseStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger = LoggerFactory.getLogger(UiBotModelBuildUibotUniversalParseStrategy.class);

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;
    @Autowired
    private DigiwinAtdmProxyService atdmProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        Map<String, Object> rawData = apiRequest.getRawData();
        Boolean isTabs = (Boolean) rawData.get("isTabs");
        List<UiBotLayout> uiBotLayouts = new ArrayList<>(1);
        UiBotModel uiBotModel = new UiBotModel(uiBotLayouts);
        UiBotPageData pageData = new UiBotPageData();
        UiBotModel pcUiBotModel = digiwinPcUiBotProxyService.getTaskTemplateShowByBacklogId(
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                (String) rawData.get("dataId"),
                (String) rawData.get("tmTaskId"),
                (String) rawData.get("tmActivityId"),
                JsonUtil.jsonStringToObject(JsonUtil.javaObjectToJsonString(rawData.get("rawData")), ApiRawData.class));

        UiBotLayout tabScrollLayout = new UiBotLayout();
        tabScrollLayout.setType(TabScrollContainer.COMPONENT_TYPE);
        tabScrollLayout.setSchema(UniversalParsingServiceImpl.TABSCROLL_SCHEMA);
        TabScrollContainer tabScrollContainer = new TabScrollContainer();
        List<CustomTabContentContainer> bodyArea = tabScrollContainer.getBodyArea();
        CustomTabContentContainer container = new CustomTabContentContainer();
        container.setContentCmptType(CustomTabController.COMPONENT_TYPE);

        if (isTabs) {
            container.setData(ModuleUtils.buildOneTab(pcUiBotModel, apiRequest));
        } else {
            container.setData(ModuleUtils.buildTabs(pcUiBotModel, apiRequest, atdmProxyService));
        }
        bodyArea.add(container);
        uiBotLayouts.add(tabScrollLayout);
        pageData.put(UniversalParsingServiceImpl.TABSCROLL_SCHEMA, tabScrollContainer);
        uiBotModel.setPageData(pageData);
        uiBotModel.setParams(apiRequest.getParams());
        Map<String, Object> commonRawData = uiBotModel.getCommonRawData();
        commonRawData.put("layout", ModuleUtils.getAthenaTable(pcUiBotModel.getLayout()));
        commonRawData.put("pageData", pcUiBotModel.getPageData());
        commonRawData.put("executeContext", pcUiBotModel.getExecuteContext());
        commonRawData.put("rules", pcUiBotModel.getRules());
        commonRawData.put("action", ModuleUtils.getDefaultAction(pcUiBotModel));
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }


    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }


}
