package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.MobileRenderMetaData;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.button.ButtonGroup;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgress;
import com.digiwin.mobile.mobileuibot.core.component.progress.TaskProgressList;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowPreSign;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowProgressHistory;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcWorkflowSignHistory;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotRenderData;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressPerson;
import com.digiwin.mobile.mobileuibot.task.model.TaskProgressStateEnum;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：流程进度固定页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: uiBotModelBuildWorkflowProgressFixationPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/1/5 10:55
 */
@Component("uiBotModelBuildWorkflowProgressFixationPageStrategy")
public class UiBotModelBuildWorkflowProgressFixationPageStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinIamProxyService digiwinIamProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        List<BaseMobileComponentWrapper<BaseMobileComponent>> body = this.buildBody(apiRequest);
        if (CollectionUtils.isEmpty(body)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            uiBotModel.getRenderData().addWrapperedComponentListToBody(body);
        }
        uiBotModel.getRenderData().addWrapperedComponentListToBottom(this.buildBottom(apiRequest));
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBody(ApiRequest apiRequest) {
        List<BaseMobileComponentWrapper<BaseMobileComponent>> body = new ArrayList<>();
        BaseMobileComponentWrapper<BaseMobileComponent> progressListWrapper = this.renderProgressListWrapper(apiRequest);
        if (progressListWrapper != null) {
            body.add(progressListWrapper);
        }
        return body;
    }

    private BaseMobileComponentWrapper<BaseMobileComponent> renderProgressListWrapper(ApiRequest apiRequest) {
        String serialNumber = apiRequest.getRawData().getString("serialNumber");
        if (!StringUtils.hasLength(serialNumber)) {
            return null;
        }
        Map<String, Object> params = new HashMap<>(2);
        params.put("serialNumber", serialNumber);
        //workItemId--2.0参数用不到，但先保留
        params.put("workItemId", StringUtil.valueOf(apiRequest.getRawData().get("workItemId")));
        DigiwinAtmcWorkflowProgressHistory progressList =
                digiwinAtmcProxyService.getApprovalWorkflowHistory(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), params);
        if (ObjectUtils.isEmpty(progressList)) {
            return null;
        }
        List<TaskProgress> taskProgressCmpt = this.buildTaskProgressCmpt(apiRequest.getLocale(), apiRequest.getIamUserToken(), null, progressList);
        if (CollectionUtils.isEmpty(taskProgressCmpt)) {
            return null;
        }
        TaskProgressList progressListCmpt = new TaskProgressList();
        progressListCmpt.setTaskProgressList(taskProgressCmpt);
        return new BaseMobileComponentWrapper<>(progressListCmpt, "DW_" + TaskProgressList.COMPONENT_TYPE);
    }

    private List<TaskProgress> buildTaskProgressCmpt(String locale, String iamUserToken, TaskProgressStateEnum taskProgressStateEnum, DigiwinAtmcWorkflowProgressHistory digiwinAtmcWorkflowProgressHistory) {
        if (ObjectUtils.isEmpty(digiwinAtmcWorkflowProgressHistory) || ObjectUtils.isEmpty(digiwinAtmcWorkflowProgressHistory.getData())) {
            return Collections.emptyList();
        }
        List<DigiwinAtmcWorkflowSignHistory> signHistory = digiwinAtmcWorkflowProgressHistory.getData().getSignHistory();
        List<DigiwinAtmcWorkflowPreSign> preSign = digiwinAtmcWorkflowProgressHistory.getData().getPreSign();
        List<TaskProgress> allProgressList = new ArrayList<>();
        //历史流程进度
        List<TaskProgress> signHistoryProgressList = signHistory.stream().map(
                        digiwinAtmcWorkflowSignHistory -> TaskProgress.create(locale, digiwinAtmcWorkflowSignHistory))
                .collect(Collectors.toList());
        //未开始流程进度
        List<TaskProgress> preSignProgressList = preSign.stream().map(
                        digiwinAtmcWorkflowPreSign -> TaskProgress.create(locale, digiwinAtmcWorkflowPreSign))
                .collect(Collectors.toList());
        allProgressList.addAll(signHistoryProgressList);
        allProgressList.addAll(preSignProgressList);
        if (null != taskProgressStateEnum) {
            allProgressList = allProgressList.stream().filter(
                    taskProgress -> taskProgress.getState().equals(taskProgressStateEnum.getValue())
            ).collect(Collectors.toList());
        }
        List<String> userIds = new ArrayList<>();
        for (TaskProgress taskProgress : allProgressList) {
            if (!CollectionUtils.isEmpty(taskProgress.getPersonList())) {
                for (TaskProgressPerson taskProgressPerson : taskProgress.getPersonList()) {
                    userIds.add(taskProgressPerson.getUserId());
                }
            }
        }
        List<DigiwinIamUserInfo> iamUserInfos = digiwinIamProxyService.userList(userIds, iamUserToken, locale);
        if (!CollectionUtils.isEmpty(iamUserInfos)) {
            for (TaskProgress taskProgress : allProgressList) {
                if (!CollectionUtils.isEmpty(taskProgress.getPersonList())) {
                    for (TaskProgressPerson taskProgressPerson : taskProgress.getPersonList()) {
                        for (DigiwinIamUserInfo digiwinIamUserInfo : iamUserInfos) {
                            if (digiwinIamUserInfo.getId().equals(taskProgressPerson.getUserId())) {
                                taskProgressPerson.setDigiwinIamUserInfo(digiwinIamUserInfo);
                                break;
                            }
                        }
                    }
                }
            }
        }
        return allProgressList;
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(ApiRequest apiRequest) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(apiRequest));
        return Lists.newArrayList(new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE));
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(ApiRequest apiRequest) {
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        // 构建取消按钮
        contentGroup.add(this.buildCancelButton(apiRequest));
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildCancelButton(ApiRequest apiRequest) {
        BottomButtonDigiwinAthena cancelButton = BottomButtonDigiwinAthena.createNormalCancelButton(apiRequest.getLocale());
        return new BaseMobileComponentWrapper<>(cancelButton, "DW_" + Button.COMPONENT_TYPE);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
