package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentPerson;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.*;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.divider.Divider;
import com.digiwin.mobile.mobileuibot.core.component.divider.DividerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgress;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgressItem;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgressType;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.*;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePickerTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.multitext.InputMultiText;
import com.digiwin.mobile.mobileuibot.core.component.input.numeric.InputNumeric;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectList;
import com.digiwin.mobile.mobileuibot.core.component.input.singleselect.SingleSelectListTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.singletext.InputSingleText;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitchStateEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.windowselect.single.InputWindowSingleSelect;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.bean.PcModuleEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotAction;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotExecuteContext;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import com.digiwin.mobile.mobileuibot.proxy.uibot.parser.ParseFieldData;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 设计变更详情页
 *
 * @author zhangjj
 * @date 2021/11/11 0011 16:33
 */
@Component("uiBotModelECNProjectDetailStrategy")
public class UiBotModelECNProjectDetailStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;
    @Autowired
    private ComponentParamAnalyzerFactory componentParamAnalyzerFactory;
    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        if (PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.equals(
                PageSettingIdPresetEnum.getEnumByName(apiRequest.getPageId()))) {
            return itemDetailModel(pageSetting, apiRequest);
        }
        ApiRawData rawData = apiRequest.getRawData();
        Boolean isShare = rawData.get("isShare") == null ? false : (Boolean) rawData.get("isShare");
        Boolean useMockData = AppContext.getUseMockData();
        String locale = apiRequest.getLocale();
        if (useMockData) {
            String data =
                    FileUtil.readText("static/appstore-use/ecn-project-detail.json");
            UiBotModel uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
            return uiBotModel;
        }

        DigiwinAtmcPanel digiwinAtmcPanel = digiwinAtmcProxyService
                .getTaskPanel(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        List<DigiwinReassignReport> reassignReportList = digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(), apiRequest.getIamUserToken(),
                apiRequest.getLocale(), apiRequest.getTenantId());
        //titleBody组件
        TitleBody titleBody = new TitleBody();
        DigiwinAtmcPanelTask task = digiwinAtmcPanel.getTask();
        String startTime = task.getStartTime();
        String endTime = task.getEndTime();
        String createTime = task.getCreateTime();
        String name = task.getName();
        if (startTime != null) {
            startTime = startTime.substring(5, 10).replace("-", ".");
        }
        if (endTime != null) {
            endTime = endTime.substring(5, 10).replace("-", ".");
        }
        if (createTime != null) {
            createTime = createTime.substring(0, 10).replace("-", ".");
        }
        TitleContent content = new TitleContent();
        content.setText(startTime + "-" + endTime + name);
        PageDesc pageDesc = new PageDesc(name);
        List<PageDesc.LabelValue> labelValueList = new ArrayList<>();
        labelValueList.add(
                new PageDesc.LabelValue(
                        LocaleUtil.getMobileTextByKey(locale, "时间"),
                        startTime + "-" + endTime));
        labelValueList.add(
                new PageDesc.LabelValue(
                        LocaleUtil.getMobileTextByKey(locale, "发起方"),
                        createTime + " " + LocaleUtil.getMobileTextByKey(locale, "由Athena发起当前项目")));
        String source;
        if (!"en_US".equalsIgnoreCase(locale)) {
            source = String.format(
                    LocaleUtil.getMobileTextByKey(locale, "标准项目来源"),
                    task.getSources().size(),
                    task.getSourceCount(),
                    task.getSourceName());
        } else {
            source = String.format(
                    LocaleUtil.getMobileTextByKey(locale, "标准项目来源"),
                    task.getSourceCount(),
                    task.getSourceName(),
                    task.getSources().size());
        }
        labelValueList.add(new PageDesc.LabelValue(LocaleUtil.getMobileTextByKey(locale, "来源"), LocaleUtil.getMobileTextByKey(locale, source)));
        pageDesc.setLabelValueList(labelValueList);
        content.setDesc(pageDesc);
        titleBody.setContent(content);
        if (reassignReportList != null && reassignReportList.size() > 0) {
            //项目新增转派标签
            List<Tag> tags = titleBody.getTags();
            if (tags == null) {
                tags = new ArrayList<>();
            } else {
                for (Tag tag : tags) {
                    if (LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派").equals(tag.getText())) {
                        tags.remove(tag);
                        break;
                    }
                }
            }
            Tag tag = Tag.createOnlyTextStateTag(String.format(
                            LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "由转派"),
                            reassignReportList.get(0).getOldPerformerName()),
                    Action.createReassignReportAction(apiRequest.getLocale(),
                            reassignReportList));
            tags.add(tag);
        }

        //水平进度组件
        HorizontalProgress horizontalProgress = new HorizontalProgress();
        if (digiwinAtmcPanel != null) {
            List<DigiwinAtmcActivity> atmcActivityList = digiwinAtmcPanel.getActivities();
            List<HorizontalProgressItem> progressList = new ArrayList<>();
            if (atmcActivityList != null) {
                boolean haveDefaultSelect = false;
                for (DigiwinAtmcActivity activity : atmcActivityList) {
                    HorizontalProgressItem item = activity2ProgressItem(activity, locale, haveDefaultSelect, apiRequest.getDataId());
                    progressList.add(item);
                    if (item.getDefaultSelected()) {
                        haveDefaultSelect = true;
                    }
                }
                if (!haveDefaultSelect && !progressList.isEmpty()) {
                    progressList.get(0).setDefaultSelected(true);
                }
            }
            horizontalProgress.setProgressList(progressList);
        }

        List<UiBotLayout> layoutList = pageSetting.getPageModel().getLayout();
        if (layoutList != null) {
            for (UiBotLayout layout : layoutList) {
                if (HorizontalProgress.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                    pageSetting.getPageModel().getPageData().put(layout.getSchema(), horizontalProgress);
                    continue;
                }
                if (TitleBody.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                    pageSetting.getPageModel().getPageData().put(layout.getSchema(), titleBody);
                }
            }
        }
        if (digiwinAtmcPanel.getReassign() != null && !isShare) {
            List<Button> buttons = pageSetting.getPageModel().getAppbarButtonList();
            // TODO 未来项目详情加载性能优化点：需要将该数据放在转派开窗时加载
            // 如果项目详情中找不到可转派的用户清单，再单独调用平台新接口获取
            if (null == digiwinAtmcPanel.getReassign().getReassignUsers()) {
                List<DigiwinAtmcReassignUser> batchReassignUsers = this.digiwinAtmcProxyService
                        .batchGetProjectReassignUsers(digiwinAtmcPanel.getTask(), apiRequest.getIamUserToken(),
                                apiRequest.getLocale(), apiRequest.getTenantId());
                digiwinAtmcPanel.getReassign().setReassignUsers(batchReassignUsers);
            }
            Map<String, Object> buttonActionRawData = new HashMap<>(JsonUtil.objectToJavaObject(digiwinAtmcPanel.getReassign(), Map.class));
            buttonActionRawData.put("appCode", digiwinAtmcPanel.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", digiwinAtmcPanel.getTask());
            buttons.add(Button.createApprovalReassign(digiwinAtmcPanel.getTask().getId() + "",
                    buttonActionRawData,
                    apiRequest.getLocale(), "PROJECT", 58926));
            buttons.add(Button.createShareWithOthers(apiRequest.getDataId(),
                    JsonUtil.objectToJavaObject(digiwinAtmcPanel.getReassign(), Map.class),
                    apiRequest.getLocale(), localeService));
        }
        return pageSetting.getPageModel();
    }

    private UiBotModel itemDetailModel(PageSetting pageSetting, ApiRequest apiRequest) {
        Map<String, Object> rawData = apiRequest.getRawData();
        List<ActionSubmitParam> params = apiRequest.getParams();
        List<ParseFieldData> fieldDataList = new ArrayList<>();
        UiBotAction uiBotAction = null;
        boolean isEditable = false;
        UiBotLayout tableLayout = new UiBotLayout();
        UiBotPageData tablePageData = new UiBotPageData();
        List<UiBotRule> rules = new ArrayList<>();
        UiBotExecuteContext executeContext = new UiBotExecuteContext();
        Map<String, UiBotTableColumn> tableColumnsMapBySchema = new HashMap<>();
        if (rawData != null) {
            if (rawData.get("data") != null) {
                List<Map<String, Object>> fieldMapList = (List<Map<String, Object>>) rawData.get("data");
                fieldDataList = fieldMapList.stream().map(map -> JsonUtil.objectToJavaObject(map, ParseFieldData.class))
                        .collect(Collectors.toList());
            }
            if (rawData.get("action") != null) {
                uiBotAction = JsonUtil.objectToJavaObject(rawData.get("action"), UiBotAction.class);
            }
            if (rawData.get("layout") != null) {
                tableLayout = JsonUtil.objectToJavaObject(rawData.get("layout"), UiBotLayout.class);
            }
            if (rawData.get("pageData") != null) {
                tablePageData = JsonUtil.objectToJavaObject(rawData.get("pageData"), UiBotPageData.class);
            }
            if (rawData.get("rules") != null) {
                rules = JsonUtil.objectToJavaObject(rawData.get("rules"), new TypeReference<List<UiBotRule>>() {
                });
            }
            if (rawData.get("executeContext") != null) {
                executeContext = JsonUtil.objectToJavaObject(rawData.get("executeContext"), UiBotExecuteContext.class);
            }
            if (rawData.get("tableColumns") != null) {
                List<UiBotTableColumn> tableColumns = JsonUtil.objectToJavaObject(rawData.get("tableColumns"), new TypeReference<List<UiBotTableColumn>>() {
                });
                if (!CollectionUtils.isEmpty(tableColumns)) {
                    tableColumnsMapBySchema = tableColumns.stream().collect(Collectors.toMap(UiBotTableColumn::getSchema, c -> c, (c1, c2) -> c1));
                }
            }
            isEditable = rawData.get("isEditable") == null ? false : (Boolean) rawData.get("isEditable");
        }
        Boolean needTitle = (Boolean) Optional.ofNullable(rawData.get("needTitle")).orElse(false);
        List<UiBotLayout> layoutList = pageSetting.getPageModel().getLayout();
        List<UiBotLayout> newLayoutList = new ArrayList<>();
        for (UiBotLayout layout : layoutList) {
            if ("${COMPONENT_TYPE}".equalsIgnoreCase(layout.getType())) {
                //找出执行人、任务进展状态、计划完成日期、签核状态
                //activity__performerName、activity__backLog__data、activity__planEndTime
                ParseFieldData performerNameFieldData = null;
                ParseFieldData backLogDataNameFieldData = null;
                ParseFieldData planEndTimeFieldData = null;
                ParseFieldData approvalStateFieldData = null;
                for (ParseFieldData fieldData : fieldDataList) {
                    if ("activity__performerName".equalsIgnoreCase(fieldData.getSchema())) {
                        performerNameFieldData = fieldData;
                    }
                    if ("activity__backLog__data".equalsIgnoreCase(fieldData.getSchema())) {
                        backLogDataNameFieldData = fieldData;
                    }
                    if ("activity__planEndTime".equalsIgnoreCase(fieldData.getSchema())) {
                        planEndTimeFieldData = fieldData;
                    }
                    if ("activity__approval__state".equalsIgnoreCase(fieldData.getSchema())) {
                        approvalStateFieldData = fieldData;
                    }
                }
                if (performerNameFieldData != null) {
                    fieldDataList.remove(performerNameFieldData);
                }
                if (backLogDataNameFieldData != null) {
                    fieldDataList.remove(backLogDataNameFieldData);
                    Field field = calculateTaskStatus(backLogDataNameFieldData, apiRequest.getLocale());
                    newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                    pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                }
                if (planEndTimeFieldData != null) {
                    fieldDataList.remove(planEndTimeFieldData);
                    Field field = convertTabItemCardContent(planEndTimeFieldData);
                    newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                    pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                }
                if (approvalStateFieldData != null) {
                    fieldDataList.remove(approvalStateFieldData);
                    Field field = approvalStateField(approvalStateFieldData, apiRequest.getLocale(), apiRequest.getDataId());
                    newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                    pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                }
                if (!newLayoutList.isEmpty()) {
                    //有任务进展状态或计划完成日期，加分割线
                    Divider divider = new Divider();
                    divider.setType(DividerTypeEnum.ELEMENT_DIVIDER.getValue());
                    String schema = divider.returnComponentType() + "_" + divider.getCmptUuid();
                    newLayoutList.add(new UiBotLayout(schema, Divider.COMPONENT_TYPE));
                    pageSetting.getPageModel().getPageData().put(schema, divider);
                }
                //标题
                if (needTitle) {
                    ParseFieldData fieldData = fieldDataList.get(0);
                    fieldDataList.remove(fieldData);
                    Field field = Field.create(fieldData, apiRequest.getLocale());
                    field.setValueStyleType(FieldValueStyleTypeEnum.VALUE_BIG_TITLE.getValue());
                    field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
                    field.setLabel("");
                    field.setLabelVisible(false);
                    newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                    pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                }
                for (ParseFieldData fieldData : fieldDataList) {
                    if (isEditable) {
                        if (PcModuleEnum.LABEL.getValue().equals(fieldData.getType())
                                || PcModuleEnum.INPUT.getValue().equals(fieldData.getType())
                        ) {
                            if (PcModuleEnum.NUMERIC.getValue().equals(fieldData.getDataType())) {
                                newLayoutList.add(new UiBotLayout(fieldData.getSchema(), InputNumeric.COMPONENT_TYPE));
                                if (params != null && params.size() > 0) {
                                    for (ActionSubmitParam param : params) {
                                        if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                            fieldData.setData(this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams()));
                                            pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputNumeric.create(apiRequest.getLocale(), fieldData, rules));
                                            break;
                                        }
                                    }
                                } else {
                                    pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputNumeric.create(apiRequest.getLocale(), fieldData, rules));
                                }
                            } else if (PcModuleEnum.BOOLEAN.getValue().equalsIgnoreCase(fieldData.getDataType())) {
                                newLayoutList.add(new UiBotLayout(fieldData.getSchema(), SingleSelectList.COMPONENT_TYPE));
                                if (params != null && params.size() > 0) {
                                    for (ActionSubmitParam param : params) {
                                        if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                            fieldData.setData(this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams()));
                                            pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), SingleSelectList.create(fieldData, rules, SingleSelectListTypeEnum.BOTTOM_OPTION.getValue()));
                                            break;
                                        }
                                    }
                                } else {
                                    pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), SingleSelectList.create(fieldData, rules, SingleSelectListTypeEnum.BOTTOM_OPTION.getValue()));
                                }
                            } else {
                                newLayoutList.add(new UiBotLayout(fieldData.getSchema(), InputSingleText.COMPONENT_TYPE));
                                if (params != null && params.size() > 0) {
                                    for (ActionSubmitParam param : params) {
                                        if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                            pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputSingleText.create(fieldData.getLabel(),
                                                    (String) this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams()),
                                                    apiRequest.getLocale(), fieldData.getSchema(), rules, fieldData.getIsEdit()));
                                            break;
                                        }
                                    }
                                } else {
                                    pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputSingleText.create(fieldData.getLabel(),
                                            fieldData.getData() != null && StringUtils.hasLength(String.valueOf(fieldData.getData())) ? String.valueOf(fieldData.getData()) : buildEmptyText(fieldData.getIsEdit()),
                                            apiRequest.getLocale(), fieldData.getSchema(), rules, fieldData.getIsEdit()));
                                }
                            }
                        } else if (PcModuleEnum.AMOUNT_INPUT.getValue().equals(fieldData.getType())
                                || PcModuleEnum.NUMERIC.getValue().equals(fieldData.getType())
                                || PcModuleEnum.MEASURE.getValue().equals(fieldData.getType())
                                || PcModuleEnum.PERCENT_INPUT.getValue().equals(fieldData.getType())
                        ) {
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), InputNumeric.COMPONENT_TYPE));
                            if (params != null && params.size() > 0) {
                                for (ActionSubmitParam param : params) {
                                    if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                        fieldData.setData(this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams()));
                                        pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputNumeric.create(apiRequest.getLocale(), fieldData, rules));
                                        break;
                                    }
                                }
                            } else {
                                pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputNumeric.create(apiRequest.getLocale(), fieldData, rules));
                            }
                        } else if (PcModuleEnum.SELECT.getValue().equalsIgnoreCase(fieldData.getType())) {
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), SingleSelectList.COMPONENT_TYPE));
                            if (params != null && params.size() > 0) {
                                for (ActionSubmitParam param : params) {
                                    if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                        fieldData.setData(this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams()));
                                        pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), SingleSelectList.create(fieldData, rules, SingleSelectListTypeEnum.BOTTOM_OPTION.getValue()));
                                        break;
                                    }
                                }
                            } else {
                                pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), SingleSelectList.create(fieldData, rules, SingleSelectListTypeEnum.BOTTOM_OPTION.getValue()));
                            }
                        } else if (PcModuleEnum.OPERATION_EDITOR.getValue().equals(fieldData.getType())) {
                            if (params != null && params.size() > 0) {
                                for (ActionSubmitParam param : params) {
                                    if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                        InputWindowSingleSelect windowSingleSelect = (InputWindowSingleSelect) param.getParams();
                                        if (StringUtils.hasLength(windowSingleSelect.getTitle())) {
                                            tablePageData.put(fieldData.getSchema(), windowSingleSelect.getTitle());
                                        }
                                        break;
                                    }
                                }
                            } else {
                                tablePageData.put(fieldData.getSchema(), fieldData.getData());
                            }
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), InputWindowSingleSelect.COMPONENT_TYPE));
                            pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputWindowSingleSelect.create(tableLayout, false,
                                    AppContext.getBaseUrl() + "/mobile/v1/proxy/window/data/list",
                                    apiRequest.getLocale(), executeContext, fieldData.getIsEdit(), tablePageData, fieldData.getSchema(), rules));
                        } else if (PcModuleEnum.TEXTAREA.getValue().equals(fieldData.getType())
                                || PcModuleEnum.TEXTAREA_TEXT.getValue().equals(fieldData.getType())) {
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), InputMultiText.COMPONENT_TYPE));
                            if (!CollectionUtils.isEmpty(params)) {
                                for (ActionSubmitParam param : params) {
                                    if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                        pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputMultiText.create(fieldData.getLabel(),
                                                (String) this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams()), fieldData.getIsEdit(), true, rules, fieldData.getSchema(), apiRequest.getLocale()));
                                        break;
                                    }
                                }
                            } else {
                                pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), InputMultiText.create(fieldData.getLabel(),
                                        fieldData.getData() == null ? "" : (String) fieldData.getData(), fieldData.getIsEdit(), true, rules, fieldData.getSchema(), apiRequest.getLocale()));
                            }
                            //产品信息图先以文本形式展示
                        } else if (PcModuleEnum.DYNAMIC_GRAPH_VIEWER.getValue().equals(fieldData.getType())) {

                        } else if (PcModuleEnum.CHECKBOX.getValue().equals(fieldData.getType())) {
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), InputSwitch.COMPONENT_TYPE));
                            if (params != null && params.size() > 0) {
                                for (ActionSubmitParam param : params) {
                                    if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                        Boolean flag;
                                        if (InputSwitchStateEnum.SWITCH_STATE_CLOSE.getState().equals(this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams()))) {
                                            flag = false;
                                        } else {
                                            flag = true;
                                        }
                                        pageSetting.getPageModel().getPageData().put(fieldData.getSchema(),
                                                InputSwitch.create(fieldData.getSchema(), flag, fieldData.getLabel(), fieldData.getIsEdit(), rules));
                                        break;
                                    }
                                }
                            } else {
                                pageSetting.getPageModel().getPageData().put(fieldData.getSchema(),
                                        InputSwitch.create(fieldData.getSchema(), fieldData.getData() == null ? false : (Boolean) fieldData.getData(), fieldData.getLabel(), fieldData.getIsEdit(), rules));
                            }
                        } else if (PcModuleEnum.DATEPICKER.getValue().equals(fieldData.getType())) {
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), InputDateTimePicker.COMPONENT_TYPE));
                            if (params != null && params.size() > 0) {
                                for (ActionSubmitParam param : params) {
                                    if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                        InputDateTime inputDateTime = (InputDateTime) this.componentParamAnalyzerFactory.get(param.getType()).analyzeSubmitParam(param.getParams());
                                        pageSetting.getPageModel().getPageData().put(fieldData.getSchema(),
                                                InputDateTimePicker.create(fieldData.getSchema(),
                                                        fieldData.getLabel(),
                                                        InputDateTime.getDateTypeDateStringByType(inputDateTime, inputDateTime.getType()),
                                                        apiRequest.getLocale(),
                                                        InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType(),
                                                        fieldData.getIsEdit(), rules));
                                        break;
                                    }
                                }
                            } else {
                                pageSetting.getPageModel().getPageData().put(fieldData.getSchema(),
                                        InputDateTimePicker.create(fieldData.getSchema(),
                                                fieldData.getLabel(),
                                                fieldData.getData() == null ? "" : (String) fieldData.getData(),
                                                apiRequest.getLocale(),
                                                InputDateTimePickerTypeEnum.YEAR_MONTH_DATE.getType(),
                                                fieldData.getIsEdit(), rules));
                            }
                        } else if (PcModuleEnum.FILE_UPLOAD.getValue().equals(fieldData.getType())
                                || PcModuleEnum.TASK_FILE_UPLOAD.getValue().equals(fieldData.getType())
                        ) {
                            if (params != null && params.size() > 0) {
                                Attachment attachment = new Attachment();
                                for (ActionSubmitParam param : params) {
                                    if (param.getSchema().equalsIgnoreCase(fieldData.getSchema())) {
                                        attachment = (Attachment) param.getParams();
                                        attachment.setTitle(fieldData.getLabel());
                                        attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
                                        attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
                                        break;
                                    }
                                }
                                pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), attachment);
                            } else {
                                Attachment attachment = new Attachment();
                                attachment.setTitle(fieldData.getLabel());
                                attachment.setType(AttachmentTypeEnum.READ_AND_WRITE.getValue());
                                attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_NORMAL.getValue());
                                if (fieldData.getData() != null) {
                                    Map dataMap = (Map) fieldData.getData();
                                    if (dataMap.get("data") != null) {
                                        List<Map<String, Object>> dataList = (ArrayList) dataMap.get("data");
                                        if (!CollectionUtils.isEmpty(dataList)) {
                                            Map<String, UiBotTableColumn> finalTableColumnsMapBySchema = tableColumnsMapBySchema;
                                            List<AttachmentFile> fileList = dataList.stream().map(data -> {
                                                AttachmentFile file = new AttachmentFile();
                                                file.setFileId((String) data.get("id"));
                                                if (data.get("size") instanceof Double) {
                                                    Double size = (Double) data.get("size");
                                                    file.setFileSize(size.longValue());
                                                } else if (data.get("size") instanceof Long) {
                                                    file.setFileSize((Long) data.get("size"));
                                                } else if (data.get("size") instanceof String) {
                                                    file.setFileSize(Long.parseLong((String) data.get("size")));
                                                }
                                                file.setUploader((String) data.get("upload_user_name"));
                                                file.setFileName((String) data.get("name"));
                                                String createDate = (String) data.get("create_date");
                                                if (StringUtils.hasLength(createDate)) {
                                                    createDate = createDate.replaceAll("/", "-");
                                                }

                                                String bucketName = DigiwinDmcConfig.ATHENA_BUCKET;
                                                UiBotTableColumn uiBotTableColumn = finalTableColumnsMapBySchema.get(fieldData.getSchema());
                                                if (ObjectUtils.isNotEmpty(uiBotTableColumn) && StringUtils.hasLength(uiBotTableColumn.getBuckets())) {
                                                    bucketName = uiBotTableColumn.getBuckets();
                                                }
                                                String shareUrl = AppContext.getApiUrlSetting().getDmcUrl() + "/api/dmc/v2/file/" + bucketName + "/preview/" + file.getFileId();
                                                file.setShareUrl(shareUrl);

                                                file.setUploadTime(createDate);
                                                file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String) data.get("name")));
                                                return file;
                                            }).collect(Collectors.toList());
                                            attachment.setFileList(fileList);
                                        }
                                    }

                                }
                                pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), attachment);
                            }
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), Attachment.COMPONENT_TYPE));
                        } else {
                            //普通文本类型
                            Field field = Field.create(fieldData, apiRequest.getLocale());
                            if (field != null) {
                                field.setLabelStyleType(2);
                                field.setValueStyleType(1);
                                field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
                                newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                                pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                            }
                        }
                    } else {
                        if ("DYNAMIC_GRAPH_VIEWER".equalsIgnoreCase(fieldData.getType())) {
                            //暂不支持产品图号信息类型展示
                            continue;
                        }
                        //签核类型数据
                        if ("SIGN_OFF_PROGRESS".equalsIgnoreCase(fieldData.getType())) {
                            Field field = approvalStateField(approvalStateFieldData, apiRequest.getLocale(), apiRequest.getDataId());
                            newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                            pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                            continue;
                        }

                        //Object类型
                        if (Objects.equals("object", fieldData.getDataType())) {
                            if (Objects.equals("task_member_info", fieldData.getSchema())) {
                                if (fieldData.getData() instanceof ArrayList) {
                                    String value = "";
                                    for (Object map : (ArrayList) fieldData.getData()) {
                                        if (map instanceof HashMap) {
                                            value = value + ((HashMap<?, ?>) map).get("executor_name") + ",";
                                        }
                                    }
                                    if (StringUtils.hasLength(value)) {
                                        value = value.substring(0, value.length() - 1);
                                    } else {
                                        value = "-";
                                    }
                                    Field field = Field.create(fieldData, apiRequest.getLocale(), value);
                                    if (field != null) {
                                        field.setLabelStyleType(2);
                                        field.setValueStyleType(1);
                                        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
                                        newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                                        pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                                    }
                                    continue;
                                }
                            }
                        }
                        //附件类型
                        if ("FILE_UPLOAD".equalsIgnoreCase(fieldData.getType())
                                || "TASK_FILE_UPLOAD".equalsIgnoreCase(fieldData.getType())
                                || "sch-manual-task-delivery".equalsIgnoreCase(fieldData.getType())
                                || "sch-manual-task-delivery-history".equalsIgnoreCase(fieldData.getType())) {
                            Attachment attachment = new Attachment();
                            attachment.setTitle(fieldData.getLabel());
                            attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                            attachment.setStyleType(AttachmentStyleTypeEnum.TITLE_WEAKENED.getValue());
                            if (fieldData.getData() != null) {
                                if (fieldData.getData() instanceof Map) {
                                    Map dataMap = (Map) fieldData.getData();
                                    if (dataMap.get("data") != null) {
                                        List<Map<String, Object>> dataList = (ArrayList) dataMap.get("data");
                                        if (!CollectionUtils.isEmpty(dataList)) {
                                            Map<String, UiBotTableColumn> finalTableColumnsMapBySchema1 = tableColumnsMapBySchema;
                                            AttachmentRawDataDigiwinAthena attachmentRawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
                                            List<AttachmentFile> fileList = dataList.stream().map(data -> {
                                                AttachmentFile file = new AttachmentFile();
                                                file.setFileId((String) data.get("id"));
                                                if (data.get("size") instanceof Double) {
                                                    Double size = (Double) data.get("size");
                                                    file.setFileSize(size.longValue());
                                                } else if (data.get("size") instanceof Long) {
                                                    file.setFileSize((Long) data.get("size"));
                                                } else if (data.get("size") instanceof String) {
                                                    file.setFileSize(Long.parseLong((String) data.get("size")));
                                                }
                                                file.setUploader((String) data.get("upload_user_name"));
                                                file.setFileName((String) data.get("name"));
                                                String createDate = data.get("create_date") == null ? "" : String.valueOf(data.get("create_date"));
                                                if (StringUtils.hasLength(createDate)) {
                                                    createDate = createDate.replaceAll("/", "-");
                                                }
                                                file.setUploadTime(createDate);
                                                file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String) data.get("name")));
                                                return file;
                                            }).collect(Collectors.toList());
                                            String bucketName = DigiwinDmcConfig.ATHENA_BUCKET;
                                            UiBotTableColumn uiBotTableColumn = finalTableColumnsMapBySchema1.get(fieldData.getSchema());
                                            if (ObjectUtils.isNotEmpty(uiBotTableColumn) && StringUtils.hasLength(uiBotTableColumn.getBuckets())) {
                                                bucketName = uiBotTableColumn.getBuckets();
                                            }
                                            if ("sch-manual-task-delivery".equalsIgnoreCase(fieldData.getType()) || "sch-manual-task-delivery-history".equalsIgnoreCase(fieldData.getType())) {
                                                // 体系云手动报工定制字段附件 bucket 修改
                                                bucketName = DigiwinDmcConfig.SCH_BUCKET;
                                            }
                                            attachmentRawDataDigiwinAthena.setBuckets(bucketName);
                                            attachment.setFileList(fileList);
                                            attachment.setRawData(attachmentRawDataDigiwinAthena);
                                        }
                                    }
                                }
                            }
                            newLayoutList.add(new UiBotLayout(fieldData.getSchema(), Attachment.COMPONENT_TYPE));
                            pageSetting.getPageModel().getPageData().put(fieldData.getSchema(), attachment);
                        } else {
                            //普通文本类型
                            Field field = Field.create(fieldData, apiRequest.getLocale());
                            if (field != null) {
                                field.setLabelStyleType(2);
                                field.setValueStyleType(1);
                                field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE.getValue());
                                newLayoutList.add(new UiBotLayout(field.getSchema(), Field.COMPONENT_TYPE));
                                pageSetting.getPageModel().getPageData().put(field.getSchema(), field);
                            }
                        }
                    }
                }
            } else if (BottomButtonDigiwinAthena.COMPONENT_TYPE.equals(layout.getType())) {
                BottomButtonList bottomButtonList = new BottomButtonList();
                if (uiBotAction != null && uiBotAction.getSubmitType() != null) {
                    String schema = UUIDUtil.getUuid();
                    UiBotLayout buttonLayout = new UiBotLayout();
                    buttonLayout.setType(BottomButtonDigiwinAthena.COMPONENT_TYPE);
                    buttonLayout.setSchema(schema);
                    //取消按钮
                    bottomButtonList.add(BottomButtonDigiwinAthena.createNormalCancelButton(apiRequest.getLocale()));
                    //有编辑则有完成或者提交按钮
                    if (isEditable) {
                        BottomButtonDigiwinAthena submitButton = new BottomButtonDigiwinAthena();
                        //能批量提交则为提交按钮
                        if (uiBotAction.getSubmitType().getIsBatch()) {
                            submitButton.setName(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "提交"));
                            Action action = new Action();
                            Map<String, Object> actionRawData = new HashMap<>(2);
                            actionRawData.put("action", uiBotAction);
                            List<Map<String, Object>> tablePageDatas = (List<Map<String, Object>>) tablePageData.get(tableLayout.getSchema());
                            Boolean findPageData = false;
                            for (Map<String, Object> tableData : tablePageDatas) {
                                for (ParseFieldData fieldData : fieldDataList) {
                                    if (tableData.get(fieldData.getSchema()).equals(fieldData.getData())) {
                                        List<Map<String, Object>> data = new ArrayList<>(1);
                                        data.add(tableData);
                                        Map<String, Object> param = new HashMap<>(1);
                                        param.put(tableLayout.getSchema(), data);
                                        actionRawData.put("data", param);
                                        findPageData = true;
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                                if (findPageData) {
                                    break;
                                }
                            }
                            action.setRawData(actionRawData);
                            action.setType(ActionTypeEnum.CALL_API_NEXT.getValue());
                            submitButton.setAction(action);
                            submitButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                        } else {
                            submitButton.setName(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "完成"));
                            submitButton.setAction(new Action(apiRequest.getDataId(),
                                    PageSettingIdPresetEnum.MOBILE_ATHENA_ECN_PROJECT_ITEM_DETAIL.toString(),
                                    ActionTypeEnum.NEXT.getValue(), uiBotAction));
                            submitButton.setType(BottomButtonStyleEnum.STRESS.getValue());
                        }
                        bottomButtonList.add(submitButton);
                    }
                } else {
                    bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class
                    );
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        String nameKey = bottomButtonDigiwinAthena.getName();
                        bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                    });
                }
                newLayoutList.add(new UiBotLayout(layout.getSchema(), BottomButtonDigiwinAthena.COMPONENT_TYPE));
                pageSetting.getPageModel().getPageData().put(layout.getSchema(), bottomButtonList);
            }
        }
        pageSetting.getPageModel().setLayout(newLayoutList);
        pageSetting.getPageModel().setEditId(apiRequest.getEditId() == null ? "" : apiRequest.getEditId());
        return pageSetting.getPageModel();
    }

    private String buildEmptyText(Boolean isEdit) {
        if (isEdit != null && isEdit) {
            return "";
        } else {
            return "-";
        }
    }

    private Field convertTabItemCardContent(ParseFieldData fieldData) {
        if (fieldData == null || fieldData.getData() == null) {
            return null;
        }
        Field field = new Field();
        field.setLabel(fieldData.getLabel());
        field.setLabelStyleType(2);
        field.setValueStyleType(1);
        field.setSchema(fieldData.getSchema());
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
        AtomicReference<Object> value = new AtomicReference<>(fieldData.getData());
        if (fieldData.getOptions() != null) {
            fieldData.getOptions().forEach(uiBotTableColumnEditorOption -> {
                if (value.get().equals(uiBotTableColumnEditorOption.getValue())) {
                    value.set(uiBotTableColumnEditorOption.getTitle());
                }
            });
        }
        field.setValue(value.get().toString());
        return field;
    }

    /**
     * 转化签核类型数据
     *
     * @param fieldData
     * @param locale
     * @return
     */
    public Field approvalStateField(ParseFieldData fieldData, String locale, String dataId) {
        Field field = new Field();
        field.setLabel(fieldData.getLabel());
        field.setSchema(fieldData.getSchema());
        field.setLabelStyleType(2);
        field.setValueStyleType(1);
        Map valueMap = (Map) fieldData.getData();
        String approve = valueMap.get("approve").toString();
        switch (approve) {
            case "3":
                field.setValue(LocaleUtil.getMobileTextByKey(locale, "已签核"));
                break;
            default:
                field.setValue(LocaleUtil.getMobileTextByKey(locale, "签核中"));
                break;
        }
        Action action = new Action();
        action.setType(ActionTypeEnum.OPEN_NEW_PAGE_FROM_BOTTOM.getValue());
        action.setJumpPageTitle(fieldData.getLabel());
        action.setJumpPageId(PageSettingIdPresetEnum.MOBILE_APPROVAL_TASK_PROGRESS.toString());
        action.setRawData(valueMap);
        action.setDataId(dataId);
        field.setAction(action);
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
        return field;
    }

    /**
     * 处理任务进展状态、执行人
     *
     * @param fieldData
     * @return
     */
    public Field calculateTaskStatus(ParseFieldData fieldData, String locale) {
        Map<String, Object> dataMap = (Map<String, Object>) fieldData.getData();
        //计划完成时间
        String planEndTime = (String) dataMap.get("planEndTime");
        //是否关闭（完成）
        Boolean close = (Boolean) dataMap.get("closed");
        //实际完成日期
        String endTime = (String) dataMap.get("endTime");
        //执行人id
        String performerId = (String) dataMap.get("performerId");
        //执行人name
        String performerName = (String) dataMap.get("performerName");

        Field field = new Field();
        field.setSchema(fieldData.getSchema());
        field.setLabelStyleType(2);
        field.setAlignmentType(FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT.getValue());
        field.setLabel(fieldData.getLabel());
        if (close) {
            //已完成--正常完成、逾时完成
            if (DateTimeUtil.compareTime(endTime, planEndTime)) {
                //实际完成日期早于计划完成日期--正常完成
                field.setValue(LocaleUtil.getMobileTextByKey(locale, "已完成"));
                field.setType("DONE");
            } else {
                //实际完成日期晚于计划完成日期--逾时完成
                //逾期天数
                int days = DateTimeUtil.getDateTimePeriod(planEndTime, endTime);
                field.setValue(String.format(LocaleUtil.getMobileTextByKey(locale, "逾期后完成"), days));
                field.setType("OVERDUE_DONE");
            }
        } else {
            //未完成
            if (!DateTimeUtil.isBeforeNowDateTime(planEndTime)) {
                //未到计划完成日期--正在进行
                field.setValue(LocaleUtil.getMobileTextByKey(locale, "正在进行"));
                field.setType("LOADING");
            } else {
                //已到计划完成日期--逾时xx天
                int days = DateTimeUtil.getDateTimePeriod(planEndTime, DateTimeUtil.getTodayTimeUseDefaultPattern());
                field.setValue(String.format(LocaleUtil.getMobileTextByKey(locale, "逾期天数"), days));
                field.setType("OVERDUE");
            }
        }
        if (StringUtils.hasLength(performerName)) {
            BaseMobileComponentPerson person = new BaseMobileComponentPerson();
            person.setName(performerName);
            person.setUserId(performerId);
            field.setPerson(person);
        }
        return field;
    }

    private HorizontalProgressItem activity2ProgressItem(
            DigiwinAtmcActivity activity,
            String locale,
            boolean haveDefaultSelect,
            String projectId) {
        HorizontalProgressItem progressItem = new HorizontalProgressItem();
        progressItem.setId(activity.getId());
        progressItem.setName(activity.getName());

        //executeType为false时有<自动>标签
        Boolean executeType = activity.getExecuteType();
        if (executeType != null && !executeType) {
            progressItem.setLabel(new Label(LocaleUtil.getMobileTextByKey(locale, "自动"), LabelTypeEnum.NORMAL.getType()));
        }
        Integer state = activity.getState();
        switch (state) {
            case -9001:
                //未全部完成
                progressItem.setType(HorizontalProgressType.NOT_ALL_DONE.getValue());
                progressItem.setClickable(true);
                break;
            case 1:
                //正在进行中
                progressItem.setClickable(true);
                if (!haveDefaultSelect) {
                    //默认选中关卡逻辑，第一个状态为“正在进行中”的
                    progressItem.setDefaultSelected(true);
                }
                if ("SOLVE".equalsIgnoreCase(activity.getTmCategory())) {
                    progressItem.setType(HorizontalProgressType.EXCEPTION_EXCLUSION.getValue());
                    break;
                }
                Boolean exception = activity.getException();
                Boolean overdue = activity.getOverdue();
                if (exception != null && exception) {
                    progressItem.setType(HorizontalProgressType.EXCEPTION_OVERDUE.getValue());
                    break;
                }
                if (overdue != null && overdue) {
                    progressItem.setType(HorizontalProgressType.OVERDUE.getValue());
                    break;
                }
                progressItem.setType(HorizontalProgressType.DOING.getValue());
                break;
            case 3:
                //已完成
                progressItem.setType(HorizontalProgressType.DONE.getValue());
                progressItem.setClickable(true);
                break;
            default:
                progressItem.setType(HorizontalProgressType.NOT_START.getValue());
                progressItem.setClickable(false);
                break;
        }
        HorizontalProgressItem.HorizontalProgressItemDetail detail
                = new HorizontalProgressItem.HorizontalProgressItemDetail();
        detail.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/project/standard/progress/detail?tmTaskId=task_Process_ECN&projectId=" + projectId);
        progressItem.setDetail(detail);
        return progressItem;
    }
}
