package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.url.UrlUtil;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTag;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagDefinitionCodeEnum;
import com.digiwin.mobile.mobileuibot.core.columntag.ColumnTagService;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.*;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupStyleTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.picture.Picture;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberList;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategory;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategoryData;
import com.digiwin.mobile.mobileuibot.core.component.list.numberlist.NumberListCategoryDataField;
import com.digiwin.mobile.mobileuibot.core.component.search.*;
import com.digiwin.mobile.mobileuibot.core.component.table.Table;
import com.digiwin.mobile.mobileuibot.core.component.webview.Webview;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.cac.service.DigiwinCacProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinInventoryData;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinItemCategory;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.DigiwinOrderPriceData;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.model.KnowledgeMapsTbbReport;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mrs.model.Auxiliary;
import com.digiwin.mobile.mobileuibot.proxy.mrs.model.AuxiliaryInformationResponse;
import com.digiwin.mobile.mobileuibot.proxy.mrs.service.MrsService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.AttachmentViewTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.search.SearchController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.LocalDate;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>功能描述：UiBot数据模型构建策略接口--实现左滑推荐页面构建</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelLeftSlipStrategy
 * @Author: wuyang
 * @Date: 2022/4/18 11:13
 */
@Component("uiBotModelLeftSlipStrategy")
public class UiBotModelLeftSlipStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelLeftSlipStrategy.class);

    @Autowired
    private MrsService mrsService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;
    @Autowired
    private ColumnTagService columnTagService;
    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;
    @Autowired
    private DigiwinCacProxyService digiwinCacProxyService;
    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("BuildLeftSlip");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        ApiRawData apiRawData = apiRequest.getRawData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch, useMockData, modelTypeShow);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch, boolean useMockData, boolean modelTypeShow) {
        UiBotModel uiBotModel = new UiBotModel(pageSetting.getPageModel().getLayout());
        UiBotPageData uiBotPageData = pageSetting.getPageModel().getPageData();
        stopWatch.start("GetData From Athena API");
        /**
         * 查看分类
         */
        Map<String, Object> params = apiRequest.getRawData();
        String dataId = (String) params.get("dataId");

        String tenantId = (String) params.get("tenant_id");
        apiRequest.setTenantId(tenantId);
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        Map<String, Object> informationParams = new HashMap<>(6);
        informationParams.put("tenant_id", tenantId);
        informationParams.put("user_id", apiRequest.getUserId());
        informationParams.put("transaction_id", params.get("transaction_id"));
        informationParams.put("transaction_code", params.get("transaction_code"));
        if (params.get("item_type") != null && StringUtils.hasLength((String) params.get("item_type"))) {
            Map<String, String> taskCategory = new HashMap<>(1);
            taskCategory.put("task_category", (String) params.get("item_type"));
            informationParams.put("transaction_information", taskCategory);
        }
        informationParams.put("timestamp", System.currentTimeMillis());
        informationParams.put("userToken", userToken);
        informationParams.put("locale", locale);
        List<UiBotLayout> uiBotLayouts = new ArrayList<>();
        AuxiliaryInformationResponse auxiliaryInformationResponse = mrsService.recommendedAuxiliaryInformation(informationParams);
        if (auxiliaryInformationResponse != null && auxiliaryInformationResponse.getAuxiliaryList() != null
                && auxiliaryInformationResponse.getAuxiliaryList().size() > 0) {
            for (Auxiliary auxiliary : auxiliaryInformationResponse.getAuxiliaryList()) {
                for (UiBotLayout layout : pageSetting.getPageModel().getLayout()) {
                    if (auxiliary.getAuxiliaryCode().equals(layout.getSchema())) {
                        uiBotLayouts.add(layout);
                        break;
                    } else {
                        //这里需要加上个空域
                        if ("area".equals(layout.getSchema())) {
                            UiBotLayout areaLayout = new UiBotLayout("area", BlankArea.COMPONENT_TYPE);
                            uiBotLayouts.add(areaLayout);
                        }
                    }
                }

            }
        } else {
            //todo 暂时先放上，后续接入大AI，在去掉
            if ("PROJECT_LEFT_SLIP".equalsIgnoreCase(dataId)) {
                //项目详情左滑页面
                //空余产能
                UiBotLayout uiBotLayout = new UiBotLayout("pcc_itemAttribute_list", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(uiBotLayout);

                UiBotLayout areaLayout = new UiBotLayout("area", BlankArea.COMPONENT_TYPE);
                uiBotLayouts.add(areaLayout);

                //投入成本
                UiBotLayout boardLayout = new UiBotLayout("pcc_board_template", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(boardLayout);
            } else if ("INVENTORY_LEFT_SLIP".equalsIgnoreCase(dataId)) {
                //物料库存左滑页面
                //物料库存
                UiBotLayout boardLayout = new UiBotLayout("inventory_data", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(boardLayout);

                //异常回报记录
                UiBotLayout abnormalReviewLayout = new UiBotLayout("abnormal_review", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(abnormalReviewLayout);
            } else if ("PURCHASE_ORDER.I01".equalsIgnoreCase(dataId)) {
                //erp签核采购单
                //历史单价
                UiBotLayout historyPriceLayout = new UiBotLayout("erp_purchase_history_price", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(historyPriceLayout);
                UiBotLayout areaLayout = new UiBotLayout("area", BlankArea.COMPONENT_TYPE);
                uiBotLayouts.add(areaLayout);
                //附件
                UiBotLayout attachmentLayout = new UiBotLayout("erp_purchase_attachment", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(attachmentLayout);
            } else if ("uibotManualTask".equalsIgnoreCase(dataId)) {
                //客户基础资料
                UiBotLayout baseInformationLayout = new UiBotLayout("pom_basic_information", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(baseInformationLayout);

                UiBotLayout areaLayout = new UiBotLayout("area", BlankArea.COMPONENT_TYPE);
                uiBotLayouts.add(areaLayout);

                //订单状况
                UiBotLayout orderStatusLayout = new UiBotLayout("pom_order_status", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(orderStatusLayout);

                UiBotLayout areaLayout1 = new UiBotLayout("area", BlankArea.COMPONENT_TYPE);
                uiBotLayouts.add(areaLayout1);

                //应收账款
                UiBotLayout accountsReceivableLayout = new UiBotLayout("pom_accounts_receivable", CustomGroup.COMPONENT_TYPE);
                uiBotLayouts.add(accountsReceivableLayout);
            }
        }

        if (uiBotLayouts.size() == 0) {
            return emptyUibotModel(apiRequest.getLocale());
        }

        boolean isOfficialCustomer = false;
        List<UiBotLayout> removeUiBotLayouts = new ArrayList<>(2);
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                //如果是物料图档
                case SmartPreciseSearch.COMPONENT_TYPE:
                    List<Map<String, Object>> cardInfoRequests = (List<Map<String, Object>>) params.get("card_info");
                    if (cardInfoRequests == null || cardInfoRequests.size() == 0) {
                        return emptyUibotModel(apiRequest.getLocale());
                    } else {
                        for (Map<String, Object> param : cardInfoRequests) {
                            param.put("cad_type", "0");
                            param.put("is_select_all_version", true);
                        }
                    }
                    List<Map<String, Object>> cardInfoResponses = digiwinEspProxyService.getCardInfo(cardInfoRequests, apiRequest.getIamUserToken(), tenantId, apiRequest.getLocale());
                    if (cardInfoResponses == null || cardInfoResponses.size() == 0) {
                        return emptyUibotModel(apiRequest.getLocale());
                    }
                    UiBotPageData pageData = buildPageData(auxiliaryInformationResponse, uiBotLayout, cardInfoResponses, apiRequest);
                    if (pageData != null) {
                        uiBotModel.addPageData(uiBotLayout.getSchema(), pageData.get(uiBotLayout.getSchema()));
                    }
                    break;
                //空余产能、投入成本等
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup;
                    if ("pcc_itemAttribute_list".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        //空余产能
                        List<String> itemInfo = (List<String>) params.get("item_info");
                        if (itemInfo == null || itemInfo.size() < 1) {
                            customGroup = CustomGroup.create(
                                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "空余产能"),
                                    emptyUibotModel(apiRequest.getLocale()));
                        } else {
                            List<Map<String, Object>> humanResourceLoadList = digiwinEspProxyService
                                    .getHumanResourceLoadByDateId(itemInfo, "0", tenantId, locale, userToken);
                            if (humanResourceLoadList == null || humanResourceLoadList.size() < 1) {
                                customGroup = CustomGroup.create(
                                        LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "空余产能"),
                                        emptyUibotModel(apiRequest.getLocale()));
                            } else {
                                customGroup = buildCustomSlipModel(auxiliaryInformationResponse, uiBotLayout,
                                        uiBotPageData, apiRequest, humanResourceLoadList);
                            }
                        }
                    } else if ("pcc_board_template".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        //投入成本
                        String projectNo = (String) params.get("project_no");
                        String projectName = (String) params.get("project_name");
                        customGroup = buildBoardCustomGroup(uiBotLayout, uiBotPageData, projectNo, projectName,
                                userToken, apiRequest.getLocale());
                    } else if ("inventory_data".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        //物料库存
                        String purchaseNo = (String) params.get("purchase_no");
                        String itemNo = (String) params.get("item_no");
                        String itemName = (String) params.get("item_name_spec");
                        String eocCompanyId = (String) params.get("eoc_company_id");
                        if (StringUtils.hasLength(purchaseNo) && StringUtils.hasLength(itemNo)) {
                            customGroup = buildInventoryCustomGroup(uiBotLayout, uiBotPageData, purchaseNo, itemNo,
                                    itemName, userToken, tenantId, eocCompanyId, apiRequest.getLocale());
                        } else {
                            continue;
                        }

                    } else if ("abnormal_review".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        //异常回报
                        String taskNo = (String) params.get("task_no");
                        String projectNo = (String) params.get("project_no");
                        customGroup = buildAbnormalReviewCustomGroup(uiBotLayout, uiBotPageData, taskNo,
                                projectNo, apiRequest);
                    } else if ("erp_purchase_history_price".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        //erp签核采购单-历史单价
                        List<String> itemCodeList = (List<String>) params.get("item_code_list");
                        customGroup = buildHistoryPriceCustomGroup(itemCodeList, uiBotLayout, uiBotPageData, userToken, tenantId, apiRequest.getLocale());
                    } else if ("erp_purchase_attachment".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        //erp签核采购单-附件
                        List<Map<String, Object>> attachmentList = new ArrayList<>();
                        if (params.get("attachment") != null) {
                            attachmentList = (List<Map<String, Object>>) params.get("attachment");
                        }
                        Map<String, Object> attribute = Optional.ofNullable((Map<String, Object>) params.get("attribute")).orElse(new HashMap<>());
                        if (attachmentList == null || attachmentList.size() == 0) {
                            customGroup = CustomGroup.create(
                                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "附件"),
                                    emptyUibotModel(apiRequest.getLocale()));
                        } else {
                            customGroup = buildAttachmentCustomGroup(uiBotLayout, uiBotPageData, attachmentList, attribute, apiRequest.getLocale());
                        }
                    } else if ("pom_basic_information".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        //是否能够使用客户基础资料模组
                        Boolean moduleEnable = digiwinCacProxyService.useModuleByTenantIdAndUserId(tenantId, apiRequest.getUserId(),
                                "POM", "basicDataEntry", apiRequest.getIamUserToken());
                        if (moduleEnable) {
                            //行事历发起任务的基础客户资料
                            String customerNo = (String) params.get("customer_no");
                            if (!StringUtils.hasLength(customerNo)) {
                                customGroup = CustomGroup.create(
                                        LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "基础资料"),
                                        emptyUibotModel(apiRequest.getLocale()));
                            } else {
                                List<String> customerNos = new ArrayList<>(1);
                                customerNos.add(customerNo);
                                List<Map<String, Object>> digiwinCustomerInfos = digiwinEspProxyService.getCustomerInfoByNo(customerNos, apiRequest.getIamUserToken(),
                                        apiRequest.getTenantId(), apiRequest.getLocale());
                                if (digiwinCustomerInfos != null && digiwinCustomerInfos.size() > 0) {
                                    Map<String, Object> digiwinCustomerInfo = digiwinCustomerInfos.get(0);
                                    String customerProperty = (String) digiwinCustomerInfo.get("customer_property");
                                    //2为正式客户
                                    if ("2".equals(customerProperty)) {
                                        isOfficialCustomer = true;
                                    }
                                }
                                customGroup = buildBasicInformationCustomGroup(uiBotLayout, uiBotPageData, digiwinCustomerInfos, apiRequest, isOfficialCustomer);
                            }
                        } else {
                            isOfficialCustomer = false;
                            customGroup = CustomGroup.create(
                                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "基础资料"),
                                    noAccessUibotModel(apiRequest.getLocale()));
                        }

                    } else if ("pom_accounts_receivable".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        if (!isOfficialCustomer) {
                            removeUiBotLayouts.add(uiBotLayout);
                            continue;
                        }
                        //行事历发起任务的应收账款
                        String customerNo = (String) params.get("customer_no");
                        customGroup = buildAccountsReceivableCustomGroup(uiBotLayout, uiBotPageData, customerNo, apiRequest);
                    } else if ("pom_order_status".equalsIgnoreCase(uiBotLayout.getSchema())) {
                        if (!isOfficialCustomer) {
                            removeUiBotLayouts.add(uiBotLayout);
                            continue;
                        }
                        //行事历查看订单状况
                        String customerNo = (String) params.get("customer_no");
                        String customerName = ((ApiRawData) params).getString("customer_name");
                        customGroup = buildOrderStatusCustomGroup(uiBotLayout, uiBotPageData, customerName, apiRequest);
                    } else {
                        customGroup = CustomGroup.create(
                                LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "空余产能"),
                                emptyUibotModel(apiRequest.getLocale()));
                    }
                    uiBotModel.addPageData(uiBotLayout.getSchema(), customGroup);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    uiBotModel.addPageData(uiBotLayout.getSchema(), uiBotPageData.get(uiBotLayout.getSchema()));
                    break;
                default:
                    break;
            }
        }
        uiBotLayouts.removeAll(removeUiBotLayouts);
        stopWatch.stop();
        uiBotModel.setPageType(pageSetting.getPageModel().getPageType());
        uiBotModel.setLayout(uiBotLayouts);
        return uiBotModel;
    }

    private CustomGroup buildAbnormalReviewCustomGroup(UiBotLayout uiBotLayout, UiBotPageData uiBotPageData, String taskNo, String projectNo, ApiRequest apiRequest) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(uiBotPageData.get(uiBotLayout.getSchema())), UiBotModel.class);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroup customGroup = new CustomGroup();
        CustomGroupContent content = new CustomGroupContent();
        List<UiBotLayout> contentLayouts = new ArrayList<>();
        UiBotPageData pageData = uiBotModel.getPageData();

        List<Map<String, Object>> docInfos = new ArrayList<>(1);
        List<Map<String, Object>> projectInfos = new ArrayList<>(1);
        Map<String, Object> docInfo = new HashMap<>(2);
        docInfo.put("project_no", projectNo);
        Map<String, Object> projectInfo = new HashMap<>(2);
        projectInfo.put("project_no", projectNo);
        projectInfo.put("task_no", taskNo);
        projectInfos.add(projectInfo);
        docInfo.put("project_info", projectInfos);
        docInfos.add(docInfo);

        List<Map<String, Object>> abnormalReviewInfo = digiwinEspProxyService.getAbnormalReviewInfo(
                apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), docInfos);
        if (abnormalReviewInfo != null && abnormalReviewInfo.size() > 0) {
            List<ColumnTag> columnTagList = columnTagService.listColumnTagsByPathAndPageId(
                    uiBotLayout.getSchema(), apiRequest.getPageId());
            // 标题字段tag
            List<ColumnTag> titleTagList = columnTagList.stream()
                    .filter(tag -> tag.getPath().equalsIgnoreCase(uiBotLayout.getSchema()) && tag.getTagDefinition().getCode().equalsIgnoreCase(
                            ColumnTagDefinitionCodeEnum.DISPLAY_TITLE.getCode()))
                    .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                    .collect(Collectors.toList());
            // 重要字段
            List<ColumnTag> importantColumnTags = columnTagList.stream().filter(
                    ct -> ColumnTagDefinitionCodeEnum.DISPLAY_IMPORTANT.getCode()
                            .equalsIgnoreCase(ct.getTagDefinition().getCode()))
                    .sorted(Comparator.comparingInt(ColumnTag::getOrderNo)).collect(Collectors.toList());

            List<String> titleSchemas = new ArrayList<>(titleTagList.size());
            //重要字段只有一个，故取单个
            String importantSchema = importantColumnTags.get(0).getSchema();
            for (ColumnTag tag : titleTagList) {
                titleSchemas.add(tag.getSchema());
            }

            for (Map<String, Object> data : abnormalReviewInfo) {
                UiBotLayout contentLayout = new UiBotLayout();
                String schema = UUIDUtil.getUuid();
                contentLayout.setSchema(schema);
                contentLayout.setType(CustomGroup.COMPONENT_TYPE);

                List<UiBotLayout> mobileLayouts = new ArrayList<>(uiBotLayouts.size());
                CustomGroup customGroupItem = new CustomGroup();
                customGroupItem.setUseExpand(false);
                customGroupItem.setHiddenConfig(new HiddenConfig());
                customGroupItem.setHasDetail(false);
                customGroupItem.setName("");
                customGroupItem.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_BORDERED.getValue());
                CustomGroupContent contentItem = new CustomGroupContent();
                UiBotPageData pageDataItem = new UiBotPageData();
                String titleVale = "";
                String importValue = "";
                for (UiBotLayout layout : uiBotLayouts) {
                    UiBotLayout mobileLayout = new UiBotLayout();
                    switch (layout.getType()) {
                        case Field.COMPONENT_TYPE:
                            //标题
                            if (titleSchemas.contains(layout.getSchema())) {
                                titleVale = titleVale + dealEmptyString(data.get(layout.getSchema()));
                            } else if (importantSchema.equalsIgnoreCase(layout.getSchema())) {
                                //重要
                                importValue = dealEmptyString(data.get(importantSchema));
                                mobileLayout.setSchema(layout.getSchema());
                                mobileLayout.setType(layout.getType());
                            } else {
                                mobileLayout.setSchema(layout.getSchema());
                                mobileLayout.setType(layout.getType());
                                pageDataItem.put(layout.getSchema(), Field.create(
                                        layout.getmLabelText().get(apiRequest.getLocale()),
                                        dealEmptyString(data.get(layout.getSchema())),
                                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT, false));
                            }

                            break;
                        default:
                            break;
                    }
                    if (mobileLayout.getSchema() != null) {
                        mobileLayouts.add(mobileLayout);
                    }
                }
                pageDataItem.put(importantSchema, Field.create(titleVale, importValue, 1, FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_RIGHT_WITH_18PX, false));
                contentItem.setLayout(mobileLayouts);
                contentItem.setPageData(pageDataItem);
                customGroupItem.setContent(contentItem);
                contentLayouts.add(contentLayout);
                pageData.put(schema, customGroupItem);

            }
            content.setLayout(contentLayouts);
            content.setPageData(pageData);

        } else {
            UiBotModel emptyModel = emptyUibotModel(apiRequest.getLocale());
            content.setLayout(emptyModel.getLayout());
            content.setPageData(emptyModel.getPageData());
            return CustomGroup.create(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "异常回报"),
                    CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, content);
        }

        customGroup.setContent(content);
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED.getValue());
        customGroup.setHasDetail(false);
        customGroup.setName(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "异常回报"));
        customGroup.setUseExpand(true);
        HiddenConfig hiddenConfig = new HiddenConfig();
        hiddenConfig.setHiddenCount(3);
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "查看更多"));
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "收起"));
        hiddenConfig.setHiddenType(HiddenConfigTypeEnum.ENTRY.getValue());
        customGroup.setHiddenConfig(hiddenConfig);
        return customGroup;
    }

    /**
     * 行事历发起任务-订单状况
     *
     * @param uiBotLayout
     * @param uiBotPageData
     * @param customerName
     * @param apiRequest
     * @return
     */
    private CustomGroup buildOrderStatusCustomGroup(UiBotLayout uiBotLayout, UiBotPageData uiBotPageData, String customerName, ApiRequest apiRequest) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(uiBotPageData.get(uiBotLayout.getSchema())), UiBotModel.class);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData pageData = new UiBotPageData();
        List<KnowledgeMapsTbbReport> kgTbbReports = digiwinKnowledgeMapsProxyService.getTbbReports(apiRequest.getIamUserToken(), apiRequest.getLocale(), "POM");
        if (kgTbbReports == null || kgTbbReports.size() == 0) {
            UiBotModel emptyModel = emptyUibotModel(apiRequest.getLocale());
            customGroupContent.setLayout(emptyModel.getLayout());
            customGroupContent.setPageData(emptyModel.getPageData());
            return CustomGroup.create(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "订单状况"),
                    CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, customGroupContent);
        } else {
            for (UiBotLayout layout : uiBotLayouts) {
                switch (layout.getType()) {
                    case Webview.COMPONENT_TYPE:
                        Webview tbbWebview = new Webview();
                        try {
                            tbbWebview = KnowledgeMapsTbbReport.buildBoardWebview(kgTbbReports.get(0), apiRequest.getLocale(), apiRequest.getIamUserToken());
                        } catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        Webview webview = JSONObject.parseObject(
                                JSONObject.toJSONString(uiBotModel.getPageData().get(layout.getSchema()))
                                , Webview.class);
                        /**
                         * FIXME 目前筛选客户名称使用的是inputCost_projectId(TBB默认的第一个筛选框的key),后续建议从KM拿到筛选的key
                         * 在key塞入对应的值来筛选  add by wuyang on 20220907
                         * is_global_filter 代表是否隐藏
                         * 0：全部显示  不填时默认为0
                         * 1：全部隐藏
                         * 2：隐藏第一个选项
                         */
                        webview.setUrl(UrlUtil.urlEncodeChinese(tbbWebview.getUrl() + "&inputCost_projectId=" + customerName + "&is_global_filter=2"));
                        webview.getButtonList().add(webview.createLeftSlipOpenWindowButton());
                        pageData.put(layout.getSchema(), webview);
                        break;
                    default:
                        break;
                }
            }
            customGroupContent.setPageData(pageData);

            return CustomGroup.create(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "订单状况"),
                    CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, customGroupContent);
        }

    }

    /**
     * 行事历发起任务-应收账款
     *
     * @param layout
     * @param pageData
     * @param customerNo
     * @param apiRequest
     * @return
     */
    private CustomGroup buildAccountsReceivableCustomGroup(UiBotLayout layout, UiBotPageData pageData, String customerNo, ApiRequest apiRequest) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(pageData.get(layout.getSchema())), UiBotModel.class);
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "应收账款"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED.getValue());
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        List<String> customerNos = new ArrayList<>(1);
        customerNos.add(customerNo);
        List<Map<String, Object>> digiwinCustomerInfos = digiwinEspProxyService.getCustomerInfoByNo(customerNos, apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale());
        if (digiwinCustomerInfos == null || digiwinCustomerInfos.size() == 0) {
            UiBotModel emptyModel = emptyUibotModel(apiRequest.getLocale());
            customGroupContent.setLayout(emptyModel.getLayout());
            customGroupContent.setPageData(emptyModel.getPageData());
            customGroup.setContent(customGroupContent);
            customGroup.setUseExpand(false);
            customGroup.setHiddenConfig(new HiddenConfig());
            return customGroup;
        } else {
            Map<String, Object> digiwinCustomerInfo = digiwinCustomerInfos.get(0);
            List<Map<String, Object>> digiwinReceivables = digiwinEspProxyService.getReceivableByNo(
                    customerNos, apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), (String) digiwinCustomerInfo.get("eoc_company_id"));
            if (digiwinReceivables == null || digiwinReceivables.size() == 0) {
                UiBotModel emptyModel = emptyUibotModel(apiRequest.getLocale(), LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "应收账款"));
                customGroupContent.setLayout(emptyModel.getLayout());
                customGroupContent.setPageData(emptyModel.getPageData());
                customGroup.setContent(customGroupContent);
                customGroup.setHiddenConfig(new HiddenConfig());
                customGroup.setUseExpand(false);
                return customGroup;
            } else {
                UiBotLayout contentLayout = uiBotLayouts.get(0);
                UiBotPageData contentPageData = uiBotModel.getPageData();
                UiBotModel contentUiBotModel = JSONObject.parseObject(
                        JSONObject.toJSONString(contentPageData.get(contentLayout.getSchema())), UiBotModel.class);
                List<UiBotLayout> contentUiBotLayouts = contentUiBotModel.getLayout();
                List<String> months = new ArrayList<>();
                Map<String, Object> monthReceivable = new HashMap<>();

                digiwinReceivables.sort((d1, d2) -> {
                    String fieldUseToCompare = contentLayout.getSchema();
                    LocalDate d1Date = DateTimeUtil.parseLocalDateUseDefaultPattern(String.valueOf(d1.get(fieldUseToCompare)));
                    LocalDate d2Date = DateTimeUtil.parseLocalDateUseDefaultPattern(String.valueOf(d2.get(fieldUseToCompare)));
                    if (d1Date.isBefore(d2Date)) {
                        return 1;
                    } else if (d1Date.isEqual(d2Date)) {
                        return 0;
                    } else {
                        return -1;
                    }
                });

                for (Map<String, Object> digiwinReceivable : digiwinReceivables) {
                    String month = DateTimeUtil.getYearMonthOfTime((String) digiwinReceivable.get(contentLayout.getSchema()) + " 00:00:00");
                    if (!months.contains(month)) {
                        months.add(month);
                    }
                    if (monthReceivable.keySet().contains(month)) {
                        Map<String, Double> params = (Map<String, Double>) monthReceivable.get(month);
                        for (UiBotLayout uiBotLayout : contentUiBotLayouts) {
                            //取出当前
                            Double schema = (Double) digiwinReceivable.get(uiBotLayout.getSchema());
                            //累加金额
                            Double oldSchema = params.get(uiBotLayout.getSchema());
                            params.put(uiBotLayout.getSchema(), schema + oldSchema);
                        }
                        monthReceivable.put(month, params);
                    } else {
                        Map<String, Double> params = new HashMap<>(2);
                        for (UiBotLayout uiBotLayout : contentUiBotLayouts) {
                            params.put(uiBotLayout.getSchema(), (Double) digiwinReceivable.get(uiBotLayout.getSchema()));
                        }
                        monthReceivable.put(month, params);
                    }
                }
                List<UiBotLayout> middleLayouts = new ArrayList<>(months.size());
                UiBotLayout areaLayout = new UiBotLayout("area", BlankArea.COMPONENT_TYPE);
                //循环获取应收账款内容
                for (String month : months) {
                    UiBotLayout middleLayout = new UiBotLayout();
                    CustomGroup childCustomGroup = new CustomGroup();
                    childCustomGroup.setHiddenConfig(new HiddenConfig());
                    childCustomGroup.setName(month);
                    childCustomGroup.setUseExpand(false);
                    childCustomGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_INCLUDE_TITLE_BORDERED.getValue());
                    CustomGroupContent customGroupContent1 = new CustomGroupContent();
                    Map<String, Double> params = (Map<String, Double>) monthReceivable.get(month);
                    List<UiBotLayout> uiBotLayoutList = new ArrayList<>();
                    UiBotPageData pageData1 = new UiBotPageData();
                    for (UiBotLayout uiBotLayout : contentUiBotLayouts) {
                        String newSchema = uiBotLayout.getSchema() + UUIDUtil.getUuid();
                        switch (uiBotLayout.getType()) {
                            case Field.COMPONENT_TYPE:
                                pageData1.put(newSchema, Field.create(uiBotLayout.getmLabelText().get(apiRequest.getLocale()), String.valueOf(params.get(uiBotLayout.getSchema())), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, false));
                                break;
                            default:
                                break;
                        }
                        UiBotLayout newUibotLayOut = new UiBotLayout();
                        newUibotLayOut.setSchema(newSchema);
                        newUibotLayOut.setType(uiBotLayout.getType());
                        newUibotLayOut.setmLabelText(uiBotLayout.getmLabelText());
                        uiBotLayoutList.add(newUibotLayOut);
                    }
                    customGroupContent1.setLayout(uiBotLayoutList);
                    customGroupContent1.setPageData(pageData1);
                    childCustomGroup.setContent(customGroupContent1);
                    String middleSchema = UUIDUtil.getUuid();
                    middleLayout.setSchema(middleSchema);
                    middleLayout.setType(CustomGroup.COMPONENT_TYPE);
                    middleLayouts.add(middleLayout);
                    middleLayouts.add(areaLayout);
                    uiBotPageData.put(middleSchema, childCustomGroup);
                    uiBotPageData.put("area", contentPageData.get("area"));
                }
                customGroupContent.setLayout(middleLayouts);
            }
            customGroupContent.setPageData(uiBotPageData);
        }
        customGroup.setContent(customGroupContent);

        HiddenConfig hiddenConfig = new HiddenConfig();
        hiddenConfig.setHiddenCount(3);
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "查看更多"));
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "收起"));
        hiddenConfig.setHiddenType(HiddenConfigTypeEnum.ENTRY.getValue());
        customGroup.setHiddenConfig(hiddenConfig);
        customGroup.setUseExpand(true);
        hiddenConfig.setAction(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "应收账款"), ActionTypeEnum.OPEN_NEW_PAGE.getValue());
        return customGroup;
    }

    /**
     * 行事历发起任务--客户基础资料
     *
     * @param layout
     * @param pageData
     * @param digiwinCustomerInfos
     * @param request
     * @param isOfficialCustomer
     * @return
     */
    private CustomGroup buildBasicInformationCustomGroup(UiBotLayout layout, UiBotPageData pageData, List<Map<String, Object>> digiwinCustomerInfos, ApiRequest request, boolean isOfficialCustomer) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(pageData.get(layout.getSchema())), UiBotModel.class);
        CustomGroup customGroup = new CustomGroup();
        customGroup.setName(LocaleUtil.getMobileTextByKey(request.getLocale(), "基础资料"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_BORDERED.getValue());
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        if (digiwinCustomerInfos == null || digiwinCustomerInfos.size() == 0) {
            UiBotModel emptyModel = emptyUibotModel(request.getLocale(), LocaleUtil.getMobileTextByKey(request.getLocale(), "基础资料"));
            customGroupContent.setLayout(emptyModel.getLayout());
            customGroupContent.setPageData(emptyModel.getPageData());
            customGroup.setContent(customGroupContent);
            customGroup.setUseExpand(false);
            customGroup.setHiddenConfig(new HiddenConfig());
            return customGroup;
        } else {
            //只可能有一个，故直接取
            Map<String, Object> digiwinCustomerInfo = digiwinCustomerInfos.get(0);
            for (UiBotLayout uiBotLayout : uiBotLayouts) {
                switch (uiBotLayout.getType()) {
                    case Field.COMPONENT_TYPE:
                        if (uiBotLayout.getSchema().contains(".")) {
                            String[] schemas = uiBotLayout.getSchema().split("\\.");
                            Map<String, Object> params = new HashMap<>();
                            for (String schema : schemas) {
                                if (digiwinCustomerInfo.get(schema) instanceof Map) {
                                    params = (Map<String, Object>) digiwinCustomerInfo.get(schema);
                                } else if (digiwinCustomerInfo.get(schema) == null) {
                                    //塞入空数据
                                    uiBotPageData.put(uiBotLayout.getSchema(), Field.create(uiBotLayout.getmLabelText().get(request.getLocale()), "", FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, false));
                                    break;
                                } else {
                                    uiBotPageData.put(uiBotLayout.getSchema(), Field.create(uiBotLayout.getmLabelText().get(request.getLocale()), (String) params.get(schema), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, false));
                                    break;
                                }
                            }
                        } else {
                            //这里由于回传的是数字，被迫转换为对应含义
                            if ("customer_property".equals(uiBotLayout.getSchema())) {
                                if ("1".equals(digiwinCustomerInfo.get(uiBotLayout.getSchema()))) {
                                    uiBotPageData.put(uiBotLayout.getSchema(), Field.create(uiBotLayout.getmLabelText().get(request.getLocale()), LocaleUtil.getMobileTextByKey(request.getLocale(), "潜在"), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, false));
                                } else {
                                    uiBotPageData.put(uiBotLayout.getSchema(), Field.create(uiBotLayout.getmLabelText().get(request.getLocale()), LocaleUtil.getMobileTextByKey(request.getLocale(), "正式"), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, false));
                                }
                            } else {
                                uiBotPageData.put(uiBotLayout.getSchema(), Field.create(uiBotLayout.getmLabelText().get(request.getLocale()), (String) digiwinCustomerInfo.get(uiBotLayout.getSchema()), FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT_NEWLINE, false));
                            }
                        }
                        break;
                    case Picture.COMPONENT_TYPE:
                        uiBotPageData.put(uiBotLayout.getSchema(), Picture.createStaticPic(uiBotLayout.getSchema()));
                        break;
                    default:
                        break;
                }
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        customGroup.setContent(customGroupContent);
        //当前只有他自己的推荐信息时，就所有字段全部展示出来
        if (isOfficialCustomer) {
            customGroup.setUseExpand(true);
        } else {
            customGroup.setUseExpand(false);
        }

        HiddenConfig hiddenConfig = new HiddenConfig();
        hiddenConfig.setHiddenCount(6);
        hiddenConfig.setHiddenExpandContent(LocaleUtil.getMobileTextByKey(request.getLocale(), "查看更多"));
        hiddenConfig.setHiddenUnexpandContent(LocaleUtil.getMobileTextByKey(request.getLocale(), "收起"));
        hiddenConfig.setHiddenType(HiddenConfigTypeEnum.FIELD.getValue());
        hiddenConfig.setAction(LocaleUtil.getMobileTextByKey(request.getLocale(), "基础资料"), ActionTypeEnum.ACTION_CURRENT_PAGE.getValue());

        customGroup.setHiddenConfig(hiddenConfig);
        return customGroup;
    }

    /**
     * erp签核采购单-附件
     *
     * @param layout
     * @param pageData
     * @param attachmentList
     * @param attribute
     * @param locale
     * @return
     */
    private CustomGroup buildAttachmentCustomGroup(UiBotLayout layout, UiBotPageData pageData,
                                                   List<Map<String, Object>> attachmentList, Map<String, Object> attribute,
                                                   String locale) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(pageData.get(layout.getSchema())), UiBotModel.class);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case Attachment.COMPONENT_TYPE:
                    Attachment attachment = new Attachment();
                    attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());
                    List<AttachmentFile> fileList = new ArrayList<>();
                    attachment.setFileList(fileList);
                    for (Map<String, Object> attachmentMap : attachmentList) {
                        AttachmentFile file = new AttachmentFile();
                        file.setFileId((String) attachmentMap.get("id"));
                        file.setFileName((String) attachmentMap.get("name"));
                        if (attachmentMap.get("size") != null) {
                            file.setFileSize(Long.parseLong(attachmentMap.get("size").toString()));
                        }
                        file.setUploader((String) attachmentMap.get("upload_user_name"));
                        String createData = (String) attachmentMap.get("create_date");
                        if (StringUtils.hasLength(createData)) {
                            createData = createData.replaceAll("/", "-");
                        }
                        file.setUploadTime(createData);
                        file.setFileExtension(AttachmentUtil.getAttachmentFileSuffix((String) attachmentMap.get("name")));

                        file.setViewable(true);
                        String type = (String) attribute.get("type");
                        if (AttachmentViewTypeEnum.OUTER.name().equals(type)) {
                            file.setShareUrl((String) attachmentMap.get("url"));
                        } else if (AttachmentViewTypeEnum.ERP.name().equals(type)) {
                            file.setViewable(false);
                        }
                        fileList.add(file);
                    }
                    uiBotPageData.put(uiBotLayout.getSchema(), attachment);
                    break;
                default:
                    break;
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create(LocaleUtil.getMobileTextByKey(locale, "附件"),
                CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, customGroupContent);
    }

    /**
     * erp签核采购单-历史单价
     *
     * @param layout
     * @param pageData
     * @param userToken
     * @param tenantId
     * @param locale
     * @return
     */
    private CustomGroup buildHistoryPriceCustomGroup(List<String> itemCodeList, UiBotLayout layout, UiBotPageData pageData, String userToken, String tenantId, String locale) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(pageData.get(layout.getSchema())), UiBotModel.class);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case NumberList.COMPONENT_TYPE:
                    //todo 历史单价接口还没好，先用mock数据
                    List<DigiwinOrderPriceData> orderPriceDataList = new ArrayList<>();
                    if (!CollectionUtils.isEmpty(itemCodeList)) {
                        orderPriceDataList = digiwinEspProxyService.getLatelyPriceListByItemCode(itemCodeList, userToken, tenantId, locale);
                    }
                    NumberList numberList = new NumberList();
                    numberList.setTitle(String.format(LocaleUtil.getMobileTextByKey(locale, "本次采购存在单价异常物料共n项"), Optional.ofNullable(itemCodeList).map(List::size).orElse(0)));
                    numberList.setMorePageTitle(LocaleUtil.getMobileTextByKey(locale, "历史单价"));
                    numberList.setDisplayDataNum(3);
                    numberList.setShowCategoryTitle(false);
                    List<NumberListCategory> categoryList = new ArrayList<>();
                    numberList.setCategoryList(categoryList);
                    NumberListCategory category = new NumberListCategory();
                    categoryList.add(category);
                    category.setCategoryTitle("");
                    category.setCategoryName("");
                    category.setDefaultSelect(true);
                    category.setNumber(0.0);
                    category.setEmptyPromptText(LocaleUtil.getMobileTextByKey(locale, "暂无历史单价"));
                    List<NumberListCategoryData> dataList = new ArrayList<>();
                    category.setData(dataList);
                    if (!CollectionUtils.isEmpty(orderPriceDataList)) {
                        for (DigiwinOrderPriceData priceData : orderPriceDataList) {
                            NumberListCategoryData data = new NumberListCategoryData();
                            dataList.add(data);
                            data.setTitle(priceData.getItemName());
                            List<NumberListCategoryDataField> fields = new ArrayList<>();
                            data.setFields(fields);
                            if (StringUtils.hasLength(priceData.getItemSpec())) {
                                NumberListCategoryDataField field = new NumberListCategoryDataField();
                                field.setLabel(LocaleUtil.getMobileTextByKey(locale, "规格"));
                                field.setValue(priceData.getItemSpec());
                                fields.add(field);
                            }
                            if (priceData.getPurchasePrice() != null) {
                                NumberListCategoryDataField field = new NumberListCategoryDataField();
                                field.setLabel(LocaleUtil.getMobileTextByKey(locale, "最近采购单价"));
                                field.setValue(String.valueOf(priceData.getPurchasePrice()));
                                fields.add(field);
                            }
                            if (StringUtils.hasLength(priceData.getSupplierName())) {
                                NumberListCategoryDataField field = new NumberListCategoryDataField();
                                field.setLabel(LocaleUtil.getMobileTextByKey(locale, "供应商"));
                                field.setValue(priceData.getSupplierName());
                                fields.add(field);
                            }
                            if (StringUtils.hasLength(priceData.getPurchaseDate())) {
                                NumberListCategoryDataField field = new NumberListCategoryDataField();
                                field.setLabel(LocaleUtil.getMobileTextByKey(locale, "采买日期"));
                                field.setValue(priceData.getPurchaseDate());
                                fields.add(field);
                            }
                        }
                    }
                    uiBotPageData.put(uiBotLayout.getSchema(), numberList);
                    break;
                default:
                    break;
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        return CustomGroup.create(LocaleUtil.getMobileTextByKey(locale, "历史单价"),
                CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, customGroupContent);
    }

    /**
     * 物料库存CustomGroup生成
     *
     * @param layout
     * @param pageData
     * @param purchaseNo
     * @param itemNo
     * @param itemName
     * @param userToken
     * @param locale
     * @return
     */
    private CustomGroup buildInventoryCustomGroup(UiBotLayout layout, UiBotPageData pageData, String purchaseNo, String itemNo, String itemName, String userToken, String tenantId, String eocCompanyId, String locale) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(pageData.get(layout.getSchema())), UiBotModel.class);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case NumberList.COMPONENT_TYPE:
                    NumberList numberList = new NumberList();
                    numberList.setTitle(itemName);
                    numberList.setMorePageTitle(LocaleUtil.getMobileTextByKey(locale, "物料库存"));
                    numberList.setDisplayDataNum(3);
                    String eocSiteId = digiwinEspProxyService
                            .getEocSiteIdByPurchaseNo(purchaseNo, eocCompanyId, userToken, tenantId, locale);
                    List<DigiwinItemCategory> itemCategoryList =
                            digiwinEspProxyService.getCategoryByItemNo(itemNo, eocCompanyId, userToken, tenantId, locale);
                    List<DigiwinInventoryData> inventoryDataList = digiwinEspProxyService
                            .getInventoryByCategory(eocSiteId, itemCategoryList, eocCompanyId, userToken, tenantId, locale);

                    List<NumberListCategory> categoryList = itemCategoryList.stream().map(itemCategory -> {
                        NumberListCategory category = new NumberListCategory();
                        category.setCategoryName(itemCategory.getClassificationMethodName());
                        category.setCategoryTitle("“" + itemCategory.getCategoryName() + "”" + LocaleUtil.getMobileTextByKey(locale, "库存总数量") + ":");
                        category.setDefaultSelect(false);
                        category.setEmptyPromptText(LocaleUtil.getMobileTextByKey(locale, "暂无物料库存"));
                        String categoryNo = itemCategory.getCategoryNo();
                        //库存总数
                        AtomicReference<Double> number = new AtomicReference<>(0.0);
                        List<NumberListCategoryData> numberListCategoryDataList = inventoryDataList.stream()
                                .filter(inventoryData -> categoryNo.equalsIgnoreCase(inventoryData.getCategoryNo()))
                                .map(inventoryData -> {
                                    NumberListCategoryData categoryData = new NumberListCategoryData();
                                    categoryData.setTitle(inventoryData.getWarehouseName());
                                    NumberListCategoryDataField field = new NumberListCategoryDataField();
                                    field.setLabel(LocaleUtil.getMobileTextByKey(locale, "库存总数"));
                                    List<NumberListCategoryDataField> fields = new ArrayList<>();
                                    fields.add(field);
                                    categoryData.setFields(fields);
                                    field.setValue(inventoryData.getInventoryQty().toString());
                                    number.updateAndGet(v -> v + inventoryData.getInventoryQty());
                                    return categoryData;
                                })
                                .collect(Collectors.toList());
                        category.setData(numberListCategoryDataList);
                        category.setNumber(number.get());
                        return category;
                    }).collect(Collectors.toList());
                    if (categoryList != null && !categoryList.isEmpty()) {
                        categoryList.get(0).setDefaultSelect(true);
                    }
                    numberList.setCategoryList(categoryList);
                    uiBotPageData.put(uiBotLayout.getSchema(), numberList);
                    break;
                default:
                    break;
            }
        }
        customGroupContent.setPageData(uiBotPageData);

        return CustomGroup.create(LocaleUtil.getMobileTextByKey(locale, "物料库存"),
                CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, customGroupContent);
    }

    /**
     * 投入成本CustomGroup生成
     *
     * @param layout
     * @param projectNo
     * @param projectName
     * @param userToken
     * @return
     */
    private CustomGroup buildBoardCustomGroup(UiBotLayout layout, UiBotPageData pageData, String projectNo, String projectName, String userToken, String locale) {
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(pageData.get(layout.getSchema())), UiBotModel.class);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout : uiBotLayouts) {
            switch (uiBotLayout.getType()) {
                case Webview.COMPONENT_TYPE:
                    Webview webview = JSONObject.parseObject(
                            JSONObject.toJSONString(uiBotModel.getPageData().get(uiBotLayout.getSchema()))
                            , Webview.class);
                    String url = AppContext.getApiUrlSetting().getTbbWebUrl() + webview.getUrl().replace("${token}", userToken)
                            .replace("${project_no}", projectNo != null ? projectNo : "")
                            .replace("${project_name}", projectName != null ? projectName : "")
                            .replace("${locale}", locale);
                    webview.setUrl(UrlUtil.urlEncodeChinese(url + "&is_global_filter=1"));
                    webview.getButtonList().add(webview.createLeftSlipOpenWindowButton());
                    uiBotPageData.put(uiBotLayout.getSchema(), webview);
                    break;
                default:
                    break;
            }
        }
        customGroupContent.setPageData(uiBotPageData);

        return CustomGroup.create(LocaleUtil.getMobileTextByKey(locale, "投入成本"),
                CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED, customGroupContent);

    }

    private UiBotModel emptyUibotModel(String locale) {
        List<UiBotLayout> uiBotLayoutList = new ArrayList<>(1);
        UiBotLayout uiBotLayout1 = new UiBotLayout();
        uiBotLayout1.setSchema("emptyData");
        uiBotLayout1.setType(Empty.COMPONENT_TYPE);
        uiBotLayoutList.add(uiBotLayout1);
        UiBotModel uiBotModel1 = new UiBotModel(uiBotLayoutList);
        UiBotPageData pageData = uiBotModel1.getPageData();
        pageData.put("emptyData", Empty.create(LocaleUtil.getMobileTextByKey(locale, "暂无数据"), true));
        logger.error("未找到相关分类。。。");
        return uiBotModel1;
    }

    private UiBotModel emptyUibotModel(String locale, String categoryName) {
        List<UiBotLayout> uiBotLayoutList = new ArrayList<>(1);
        UiBotLayout uiBotLayout1 = new UiBotLayout();
        uiBotLayout1.setSchema("emptyData");
        uiBotLayout1.setType(Empty.COMPONENT_TYPE);
        uiBotLayoutList.add(uiBotLayout1);
        UiBotModel uiBotModel1 = new UiBotModel(uiBotLayoutList);
        UiBotPageData pageData = uiBotModel1.getPageData();
        pageData.put("emptyData", Empty.create(LocaleUtil.getMobileTextByKey(locale, "暂无数据") + categoryName, true));
        logger.error("未找到相关分类。。。");
        return uiBotModel1;
    }

    private UiBotModel noAccessUibotModel(String locale) {
        List<UiBotLayout> uiBotLayoutList = new ArrayList<>(1);
        UiBotLayout uiBotLayout1 = new UiBotLayout();
        uiBotLayout1.setSchema("emptyData");
        uiBotLayout1.setType(Empty.COMPONENT_TYPE);
        uiBotLayoutList.add(uiBotLayout1);
        UiBotModel uiBotModel1 = new UiBotModel(uiBotLayoutList);
        UiBotPageData pageData = uiBotModel1.getPageData();
        pageData.put("emptyData", Empty.create(LocaleUtil.getMobileTextByKey(locale, "未开启应用权限，请到鼎捷云开启"), true));
        logger.error("未开启应用权限，请到鼎捷云开启");
        return uiBotModel1;
    }


    /**
     * 空余产能CustomGroup构造
     *
     * @param auxiliaryInformationResponse
     * @param uiBotLayout
     * @param pageData
     * @param apiRequest
     * @param humanResourceLoadList
     * @return
     */
    private CustomGroup buildCustomSlipModel(AuxiliaryInformationResponse auxiliaryInformationResponse, UiBotLayout uiBotLayout, UiBotPageData pageData, ApiRequest apiRequest, List<Map<String, Object>> humanResourceLoadList) {
        CustomGroup customGroup = new CustomGroup();
        UiBotModel uiBotModel = JSONObject.parseObject(
                JSONObject.toJSONString(pageData.get(uiBotLayout.getSchema())), UiBotModel.class);
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();

//        for (Auxiliary auxiliary : auxiliaryInformationResponse.getAuxiliaryList()) {
//            if (auxiliary.getAuxiliaryCode().equals(uiBotLayout.getSchema())) {
//                customGroup.setName(auxiliary.getAuxiliaryName());
        customGroup.setName(LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "空余产能"));
        customGroup.setStyleType(CustomGroupStyleTypeEnum.STYLE_LEFT_SLIP_UNBORDERED.getValue());
        CustomGroupContent customGroupContent = new CustomGroupContent();
        customGroupContent.setLayout(uiBotLayouts);
        UiBotPageData uiBotPageData = new UiBotPageData();
        for (UiBotLayout uiBotLayout1 : uiBotLayouts) {
            switch (uiBotLayout1.getType()) {
                case Table.COMPONENT_TYPE:
                    Table classTable = Table.create(uiBotLayout1, uiBotModel.getPageData(), humanResourceLoadList, apiRequest.getLocale(), "0");
                    if (classTable.getRows() == null || classTable.getRows().size() < 1) {
                        UiBotModel emptyModel = emptyUibotModel(apiRequest.getLocale());
                        customGroupContent.setLayout(emptyModel.getLayout());
                        customGroupContent.setPageData(emptyModel.getPageData());
                        customGroup.setContent(customGroupContent);
                        return customGroup;
                    }
                    uiBotPageData.put(uiBotLayout1.getSchema(), classTable);
                    break;
                default:
                    break;
            }
        }
        customGroupContent.setPageData(uiBotPageData);
        customGroup.setContent(customGroupContent);
//                break;
//            }
//        }
        return customGroup;
    }


    private UiBotPageData buildPageData(AuxiliaryInformationResponse auxiliaryInformationResponse, UiBotLayout uiBotLayout, List<Map<String, Object>> cardInfoResponses, ApiRequest apiRequest) {
        if (cardInfoResponses == null || cardInfoResponses.size() < 1) {
            return null;
        }
        Map<String, Object> oldPageData = new HashMap<>();
        List<ColumnTag> columnTagList = columnTagService.listColumnTagsByPathAndPageId("cad_info", apiRequest.getPageId());
        // 次要字段tag
        List<ColumnTag> profileTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase("cad_info") && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_PROFILE.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());
        //图片字段tag
        List<ColumnTag> picTagList = columnTagList.stream()
                .filter(tag -> tag.getPath().equalsIgnoreCase("cad_info") && tag.getTagDefinition().getCode().equalsIgnoreCase(
                        ColumnTagDefinitionCodeEnum.DISPLAY_PIC.getCode()))
                .sorted(Comparator.comparingInt(ColumnTag::getOrderNo))
                .collect(Collectors.toList());
        List<SmartPreciseSearch> smartPreciseSearches = new ArrayList<>();
        for (Map<String, Object> cardInfoResponse : cardInfoResponses) {
            SmartPreciseSearch smartPreciseSearch = new SmartPreciseSearch();
            List<SmartPreciseSearchField> fields = new ArrayList<>();
            for (ColumnTag columnTag : profileTagList) {
                SmartPreciseSearchField searchField = new SmartPreciseSearchField();
                searchField.setFieldId(columnTag.getSchema());
                searchField.setFieldTitle(columnTag.getmLabelText().get(apiRequest.getLocale()));
                searchField.setFieldValue((String) cardInfoResponse.get(columnTag.getSchema()));
                searchField.setFieldLayoutType(columnTag.getParallel() ? 2 : 1);
                searchField.setSkip(columnTag.getSkip());
                searchField.setSkipConfig(new SkipConfig());
                fields.add(searchField);
            }
            smartPreciseSearch.setFields(fields);
            smartPreciseSearch.setStyleType(SmartPreciseSearchStyleTypeEnum.LEFT_IMAGE_RIGHT_TEXT.getValue());
            List<Pic> pics = new ArrayList<>(1);
            for (ColumnTag columnTag : picTagList) {
                Pic pic = new Pic();
                pic.setPicUrl((String) cardInfoResponse.get(columnTag.getSchema()));
                pics.add(pic);
            }
            smartPreciseSearch.setPics(pics);
            smartPreciseSearch.setDataKey((String) cardInfoResponse.get("graph_no"));
            smartPreciseSearches.add(smartPreciseSearch);
        }
        if (smartPreciseSearches.size() == 0) {
            return null;
        } else {
            SearchController searchController = new SearchController();
            oldPageData = searchController.buildModel(smartPreciseSearches, null,
                    "共${count}项", "${count}", true, "ddc_itemAttribute_list");
            List<Map<String, Object>> datas = (List<Map<String, Object>>) oldPageData.get("contentList");
            if (datas != null && datas.size() > 0) {
                for (Map<String, Object> data : datas) {
                    Map<String, Object> action = (Map<String, Object>) ((Map<String, Object>) data.get("data")).get("action");
                    action.put("type", ActionTypeEnum.OPEN_NEW_PAGE.getValue());
                    Map<String, Object> rawData = (Map<String, Object>) action.get("rawData");
                    if (rawData == null) {
                        rawData = new HashMap<>();
                    }
                    rawData.put("params", cardInfoResponses);
                    action.put("rawData", rawData);
                }
            }
        }
        UiBotPageData pageData = new UiBotPageData();
        Map<String, Object> params = new HashMap<>();
        for (Auxiliary auxiliary : auxiliaryInformationResponse.getAuxiliaryList()) {
            if (auxiliary.getAuxiliaryCode().equals(uiBotLayout.getSchema())) {
                params.put("title", auxiliary.getAuxiliaryName());
                params.putAll(oldPageData);
                break;
            }
        }
        pageData.put(uiBotLayout.getSchema(), params);
        return pageData;

    }

    @Autowired
    private HttpService httpService;

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        Map<String, Object> params = apiRequest.getRawData();
        String dataId = (String) params.get("dataId");
//        try {
//            Thread.sleep(100L);
//        } catch (InterruptedException e) {
//            e.printStackTrace();
//        }
        String data = "";
        UiBotModel uiBotModel = null;
        if ("PURCHASE_APPROVAL_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            data = FileUtil.readText("static/appstore-use/left-slip-purchaseapproval-show-437720680112192.json");
        } else if ("PROJECT_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            data = FileUtil.readText("static/appstore-use/left-slip-project-show-318819017437759.json");
//            ResponseEntity<UiBotModel> result = null;
//            result = httpService.doGet("http://180.167.0.43:18086/staticDemo/athena/left-slip-project-show-318819017437759.json", UiBotModel.class);
//            if (null != result && result.getStatusCode().is2xxSuccessful()) {
//                uiBotModel = result.getBody();
//                return uiBotModel;
//            }
        } else if ("INVENTORY_LEFT_SLIP".equalsIgnoreCase(dataId)) {
            String itemNameSpec = (String) params.get("item_name_spec");
            data = FileUtil.readText("static/appstore-use/left-slip-inventory-show-0218A-08-20220523.json");
            data = data.replaceAll("0218A-08", itemNameSpec);
        }
        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }

    private String dealEmptyString(Object data) {
        if (data == null) {
            return "-";
        } else {
            return StringUtils.hasLength(String.valueOf(data)) ? String.valueOf(data) : "-";
        }
    }

}

