package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgress;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgressItem;
import com.digiwin.mobile.mobileuibot.core.component.horizontalprogress.HorizontalProgressType;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.TitleContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

/**
 * 标准项目详情(以鼎华的应用需求为例进行开发)
 *
 * @author zhangjj
 * @date 2022/6/2 17:48
 */
@Component("uiBotModelStandardProjectDetailStrategy")
public class UiBotModelStandardProjectDetailStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private LocaleService localeService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        if (modelTypeShow) {
            return this.doShowData(apiRequest);
        }
        String locale = apiRequest.getLocale();
        Boolean isShare = false;
        if (apiRequest.getRawData() == null) {
            isShare = apiRequest.getRawData().get("isShare") == null ? false :
                    (Boolean) apiRequest.getRawData().get("isShare");
        }
        //调用已读接口
        this.digiwinAtmcProxyService.updateDigiwinAtmcTaskReadCount(
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        this.digiwinAtmcProxyService.updateDigiwinAtmcBacklogReadCount(
                apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId());
        List<DigiwinReassignReport> reassignReportList = this.digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(),
                apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
        DigiwinAtmcEnginePanelInfo enginePanelInfo = digiwinAtmcProxyService.getEnginePanelInfoByTaskId(
                apiRequest.getDataId(),
                apiRequest.getClientId(),
                apiRequest.getIamUserToken(),
                apiRequest.getTenantId(),
                apiRequest.getLocale());
        DigiwinAtmcPanelTask task = enginePanelInfo.getTask();
        //titleBody组件
        TitleBody titleBody = new TitleBody();
        String startTime = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getStartTime).orElse("");
        String endTime = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getEndTime).orElse("");
        String createTime = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getCreateTime).orElse("");
        String name = Optional.ofNullable(task).map(DigiwinAtmcPanelTask::getName).orElse("");
        if (StringUtils.hasLength(startTime)) {
            startTime = startTime.substring(5, 10).replace("-", ".");
        }
        if (StringUtils.hasLength(endTime)) {
            endTime = endTime.substring(5, 10).replace("-", ".");
        }
        if (StringUtils.hasLength(createTime)) {
            createTime = createTime.substring(0, 10).replace("-", ".");
        }
        TitleContent content = new TitleContent();
        content.setText(startTime + "-" + endTime + name);
        PageDesc pageDesc = new PageDesc(name);
        List<PageDesc.LabelValue> labelValueList = new ArrayList<>();
        labelValueList.add(
                new PageDesc.LabelValue(
                        LocaleUtil.getMobileTextByKey(locale, "时间"),
                        startTime + "-" + endTime));
        labelValueList.add(
                new PageDesc.LabelValue(
                        LocaleUtil.getMobileTextByKey(locale, "发起方"),
                        createTime + " " + LocaleUtil.getMobileTextByKey(locale, "由Athena发起当前项目")));
        String source;
        if (!Locale.US.toString().equals(locale)) {
            source = String.format(
                    LocaleUtil.getMobileTextByKey(locale, "标准项目来源"),
                    task.getSources().size(),
                    task.getSourceCount(),
                    task.getSourceName());
        } else {
            source = String.format(
                    LocaleUtil.getMobileTextByKey(locale, "标准项目来源"),
                    task.getSourceCount(),
                    task.getSourceName(),
                    task.getSources().size());
        }
        labelValueList.add(new PageDesc.LabelValue(LocaleUtil.getMobileTextByKey(locale, "来源"), LocaleUtil.getMobileTextByKey(locale, source)));
        pageDesc.setLabelValueList(labelValueList);
        content.setDesc(pageDesc);
        titleBody.setContent(content);
        //水平进度组件
        HorizontalProgress horizontalProgress = new HorizontalProgress();
        if (enginePanelInfo.getRoute() != null
                && enginePanelInfo.getRoute().getSelectRoute() != null
                && enginePanelInfo.getRoute().getSelectRoute().getActivities() != null) {
            List<HorizontalProgressItem> progressList = new ArrayList<>();
            List<DigiwinAtmcEngineActivity> activities = enginePanelInfo.getRoute().getSelectRoute().getActivities();
            boolean haveDefaultSelect = false;
            for (DigiwinAtmcEngineActivity activity : activities) {
                HorizontalProgressItem item = activity2ProgressItem(activity, locale, haveDefaultSelect, apiRequest.getDataId(), task.getTmTaskId());
                progressList.add(item);
                if (item.getDefaultSelected()) {
                    haveDefaultSelect = true;
                }
            }
            if (!haveDefaultSelect && !progressList.isEmpty()) {
                progressList.get(0).setDefaultSelected(true);
            }
            horizontalProgress.setProgressList(progressList);
        }

        List<UiBotLayout> layoutList = pageSetting.getPageModel().getLayout();
        if (layoutList != null) {
            for (UiBotLayout layout : layoutList) {
                if (HorizontalProgress.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                    pageSetting.getPageModel().getPageData().put(layout.getSchema(), horizontalProgress);
                    continue;
                }
                if (TitleBody.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                    pageSetting.getPageModel().getPageData().put(layout.getSchema(), titleBody);
                }
            }
        }
        UiBotModel uiBotModel = pageSetting.getPageModel();
        if (enginePanelInfo != null && enginePanelInfo.getReassign() != null && !isShare) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(enginePanelInfo.getReassign());
            buttonActionRawData.put("appCode", enginePanelInfo.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", enginePanelInfo.getTask());

            buttons.add(Button.createApprovalReassign(apiRequest.getDataId() + "",
                    buttonActionRawData,
                    apiRequest.getLocale(), "PROJECT", 58926));
            buttons.add(Button.createShareWithOthers(apiRequest.getDataId(),
                    JsonUtil.objectToJavaObject(enginePanelInfo.getReassign(), Map.class),
                    apiRequest.getLocale(), localeService));
        }
        if (reassignReportList != null && reassignReportList.size() > 0) {
            List<UiBotLayout> layouts = uiBotModel.getLayout();
            for (UiBotLayout layout : layouts) {
                if (TitleBody.COMPONENT_TYPE.equals(layout.getType())) {
                    TitleBody titleBody1 = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleBody.class);
                    List<Tag> tags = titleBody1.getTags();
                    if (tags == null) {
                        tags = new ArrayList<>();
                    } else {
                        for (Tag tag : tags) {
                            if (LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派").equals(tag.getText())) {
                                tags.remove(tag);
                                break;
                            }
                        }
                    }
                    Tag tag = Tag.createOnlyTextStateTag(String.format(
                                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "由转派"),
                                    reassignReportList.get(0).getOldPerformerName()),
                            Action.createReassignReportAction(apiRequest.getLocale(),
                                    reassignReportList));
                    tags.add(tag);
                    break;
                } else {
                    if (PageDesc.COMPONENT_TYPE.equals(layout.getType())) {
                        PageDesc pageDesc1 = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), PageDesc.class);
                        List<PageDescContent> pageDescContents = pageDesc1.getContent();
                        pageDescContents.add(PageDescContent.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                        uiBotModel.getPageData().put(layout.getSchema(), pageDesc1);
                    }
                    if (TitleDesc.COMPONENT_TYPE.equals(layout.getType())) {
                        TitleDesc titleDesc = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleDesc.class);
                        List<Label> labels = titleDesc.getLabelList();
                        labels.add(Label.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                        uiBotModel.getPageData().put(layout.getSchema(), titleDesc);
                    }
                }
            }
        }
        return pageSetting.getPageModel();
    }

    private UiBotModel doShowData(ApiRequest apiRequest) {
        String dataId = apiRequest.getDataId();
        String data = FileUtil.readText("static/appstore-use/project-standard-detail-show-" + dataId + ".json");
        return JsonUtil.jsonStringToObject(data, UiBotModel.class);
    }

    private HorizontalProgressItem activity2ProgressItem(DigiwinAtmcEngineActivity activity, String locale, boolean haveDefaultSelect, String projectId, String tmTaskId) {
        HorizontalProgressItem progressItem = new HorizontalProgressItem();
        progressItem.setName(activity.getName());

        //标准的项目只有一个taskCode
        if (activity.getTaskCodes() != null && !activity.getTaskCodes().isEmpty()) {
            DigiwinAtmcEngineTaskCode taskCode = activity.getTaskCodes().get(0);
            progressItem.setId(taskCode.getId());
            Integer state = taskCode.getState() != null ? taskCode.getState() : 0;
            switch (state) {
                case -9001:
                    //未全部完成
                    progressItem.setType(HorizontalProgressType.NOT_ALL_DONE.getValue());
                    progressItem.setClickable(true);
                    break;
                case 1:
                    //正在进行中
                    progressItem.setClickable(true);
                    if (!haveDefaultSelect) {
                        //默认选中关卡逻辑，第一个状态为“正在进行中”的
                        progressItem.setDefaultSelected(true);
                    }
                    Boolean overdue = taskCode.getOverdue();
                    Boolean exception = taskCode.getException();
                    if (exception != null && exception) {
                        progressItem.setType(HorizontalProgressType.EXCEPTION_OVERDUE.getValue());
                        break;
                    }
                    if (overdue != null && overdue) {
                        progressItem.setType(HorizontalProgressType.OVERDUE.getValue());
                        break;
                    }
                    progressItem.setType(HorizontalProgressType.DOING.getValue());
                    break;
                case 3:
                    //已完成
                    progressItem.setType(HorizontalProgressType.DONE.getValue());
                    progressItem.setClickable(true);
                    break;
                default:
                    progressItem.setType(HorizontalProgressType.NOT_START.getValue());
                    progressItem.setClickable(false);
                    break;
            }
            HorizontalProgressItem.HorizontalProgressItemDetail detail
                    = new HorizontalProgressItem.HorizontalProgressItemDetail();
            detail.setUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/project/standard/progress/detail?tmTaskId=" + tmTaskId + "&projectId=" + projectId);
            progressItem.setDetail(detail);
        }
        return progressItem;
    }
}
