package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeData;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 功能:报工在线人员清单渲染页
 *
 * @author: wuyangz
 * @date: 20230515
 */
@Component("uiBotModelBuildApcOnlineReportStrategy")
public class UiBotModelBuildApcOnlineReportStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        final String locale = apiRequest.getLocale();
        final UiBotModel uiBotModel = pageSetting.getPageModel();
        final List<UiBotLayout> layoutList = uiBotModel.getLayout();
        final UiBotPageData pageData = uiBotModel.getPageData();

        for (UiBotLayout uiBotLayout : layoutList) {
            final String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case EmployeeList.COMPONENT_TYPE:
                    pageData.put(schema, buildEmployeeData(apiRequest));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons =
                            ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                    }
                    pageData.put(schema, buttons);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private EmployeeList buildEmployeeData(ApiRequest apiRequest) {
        final String locale = apiRequest.getLocale();
        EmployeeList employeeList = new EmployeeList()
                .setTitle(localeService.getLanguageValue(locale, "报工在线人员清单")).setStyle(2);
        List<Map<String, Object>> onlineReporterData = digiwinEspProxyService.getWoOpOnlineReporterInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(),
                (List<Map<String, Object>>) apiRequest.getRawData().get("wo_op_report_data"));

        Boolean isShowOpName = apiRequest.getRawData().getBoolean("isShowOpName");
        if (CollectionUtils.isEmpty(onlineReporterData)) {
            return employeeList;
        }
        List<EmployeeData> employeeDatas = new ArrayList<>();
        for (int i = 0; i < onlineReporterData.size(); i++) {
            List<Map<String, Object>> onlineReporterDetail = (List<Map<String, Object>>) onlineReporterData.get(i).get("online_reporter_detail");
            if (CollectionUtils.isEmpty(onlineReporterData)) {
                return employeeList;
            }
            for (Map<String, Object> reporterDetail : onlineReporterDetail) {
                List<Map<String, Object>> opDetails = (List<Map<String, Object>>) reporterDetail.get("wo_sub_op_detail");
                if (CollectionUtils.isEmpty(opDetails)) {
                    return employeeList;
                }
                for (Map<String, Object> opDetail : opDetails) {
                    List<Map<String, Object>> reporterDetails = (List<Map<String, Object>>) opDetail.get("reporter_detail");
                    if (CollectionUtils.isEmpty(reporterDetails)) {
                        return employeeList;
                    }
                    for (Map<String, Object> detail : reporterDetails) {
                        EmployeeData data = new EmployeeData();
                        data.setEmployeeNo((String) detail.get("reporter_no"));
                        data.setEmployeeName((String) detail.get("reporter_name"));
                        data.setFields(buildEmployeFiled(locale, reporterDetail, isShowOpName));
                        employeeDatas.add(data);
                    }

                }
            }
        }
        return employeeList.setTotal(employeeDatas.size()).setEmployeeDatas(employeeDatas);
    }

    private List<Field> buildEmployeFiled(String locale, Map<String, Object> reporterDetail, Boolean isShowOpName) {
        List<Field> fields = new ArrayList<>(1);
        Field field = new Field();
        field.setLabel(localeService.getLanguageValue(locale, "班组"));
        field.setValue(ModuleUtils.emptyValueToHyphen(reporterDetail.get("team_name")));
        fields.add(field);

        if(BooleanUtils.isTrue(isShowOpName)){
            Field opNameField = new Field();
            opNameField.setLabel(localeService.getLanguageValue(locale, "子制程名称"));
            opNameField.setValue(ModuleUtils.emptyValueToHyphen(reporterDetail.get("op_name")));
            fields.add(opNameField);
        }
        return fields;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel(apiRequest.getLocale());
    }
}
