package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.MessageBar;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeData;
import com.digiwin.mobile.mobileuibot.core.component.list.employeelist.EmployeeList;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * 功能: 进度回报 提交提示页
 *
 * @author: wjw
 * @date: created at 2023/2/3
 */
@Component("uiBotModelBuildApcProjectScheduleReportSubmitStrategy")
public class UiBotModelBuildApcProjectScheduleReportSubmitStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        final String locale = apiRequest.getLocale();
        final UiBotModel uiBotModel = pageSetting.getPageModel();
        final List<UiBotLayout> layoutList = uiBotModel.getLayout();
        final UiBotPageData pageData = uiBotModel.getPageData();

        for (UiBotLayout uiBotLayout : layoutList) {
            final String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case MessageBar.COMPONENT_TYPE:
                    pageData.put(schema, MessageBar.create(
                            localeService.getLanguageValue(locale, "请以下人员于「工时回报」进行「人员下线」操作")));
                    break;
                case EmployeeList.COMPONENT_TYPE:
                    pageData.put(schema, this.buildEmployeeData(apiRequest));
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons =
                            ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(LocaleUtil.getMobileTextByDatabaseKey(locale, bottomButton.getName()));
                    }
                    pageData.put(schema, buttons);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private EmployeeList buildEmployeeData(ApiRequest apiRequest) {
        final String locale = apiRequest.getLocale();
        EmployeeList employeeList = new EmployeeList()
                .setTitle(localeService.getLanguageValue(locale, "报工在线人员清单"));
        JSONArray onlineReporterDetail = apiRequest.getRawData().getJSONArray("online_reporter_detail");
        if (null == onlineReporterDetail) {
            return employeeList;
        }
        List<EmployeeData> employeeDatas = new ArrayList<>();
        for (int i = 0; i < onlineReporterDetail.size(); i++) {
            JSONArray subOpDetail = onlineReporterDetail.getJSONObject(i).getJSONArray("wo_sub_op_detail");
            if (null == subOpDetail) {
                continue;
            }
            for (int j = 0; j < subOpDetail.size(); j++) {
                JSONArray reporterDetail = subOpDetail.getJSONObject(j).getJSONArray("reporter_detail");
                if (null == reporterDetail) {
                    continue;
                }
                for (int k = 0; k < reporterDetail.size(); k++) {
                    JSONObject object = reporterDetail.getJSONObject(k);
                    employeeDatas.add(new EmployeeData()
                            .setEmployeeNo(object.getString("reporter_no"))
                            .setEmployeeName(object.getString("reporter_name")));
                }
            }
        }
        return employeeList.setTotal(employeeDatas.size()).setEmployeeDatas(employeeDatas);
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel(apiRequest.getLocale());
    }
}
