package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 功能:制令上线场域工艺清单渲染页
 *
 * @author: wuyangz
 * @date: 20230607
 */
@Component("uiBotModelBuildApcWorkShopOnlineAreaDetailStrategy")
public class UiBotModelBuildApcWorkShopOnlineAreaDetailStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        final String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();

        Map<String, Object> rawData = apiRequest.getRawData();
        List<Map<String, Object>> datas = (List<Map<String, Object>>) rawData.get("wo_op_data");
        if (CollectionUtils.isEmpty(datas)) {
            return UiBotModel.emptyUibotModelWithCancelButton(locale);
        }

        for (UiBotLayout uiBotLayout : layoutList) {
            final String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    customGroup.setName(rawData.get(customGroup.getName()) + " " + localeService.getLanguageValue(locale, "区域派工资讯"));
                    CustomGroupContent content = customGroup.getContent();
                    List<UiBotLayout> customUiBotLayouts = new ArrayList<>(datas.size());
                    UiBotPageData customPageData = new UiBotPageData();
                    for (UiBotLayout layout : content.getLayout()) {
                        if (Card.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                            Card card = JsonUtil.objectToJavaObject(content.getPageData().get(layout.getSchema()), Card.class);
                            for (Map<String, Object> data : datas) {
                                String id = (String) data.get(card.getTitle());
                                UiBotLayout newLayout = new UiBotLayout(id, Card.COMPONENT_TYPE);
                                Card dataCard = new Card();
                                dataCard.setTitle(id);
                                List<CardContent> cardContents = card.getContent();
                                for (CardContent cardContent : cardContents) {
                                    CardContent newCardContent = new CardContent();
                                    newCardContent.setLabel(localeService.getLanguageValue(locale, cardContent.getLabel()));
                                    newCardContent.setValue((String) data.get(cardContent.getSchema()));
                                    newCardContent.setSchema(cardContent.getSchema());
                                    dataCard.getContent().add(newCardContent);
                                }
                                customPageData.put(id, dataCard);
                                customUiBotLayouts.add(newLayout);
                            }
                        }
                    }
                    content.setLayout(customUiBotLayouts);
                    content.setPageData(customPageData);
                    pageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons =
                            ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(localeService.getLanguageValue(locale, bottomButton.getName()));
                    }
                    pageData.put(schema, buttons);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel(apiRequest.getLocale());
    }
}
