package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.locale.service.impl.LocaleServiceImpl;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 功能:制令上线去处理->区域多选->详情页面（机制开启）
 *
 * @author: yanfeng
 * @date: 2023/06/30
 */
@Component("uiBotModelBuildApcWorkShopOnlineAreaTakeEffectDetailStrategy")
public class UiBotModelBuildApcWorkShopOnlineAreaTakeEffectDetailStrategy implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel;
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        final String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_WHITE.getValue());
        List<UiBotLayout> layoutList = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        Map<String, Object> rawData = apiRequest.getRawData();
        Map<String, Object> params = JsonUtil.objectToJavaObject(rawData.get("rawData"), new TypeReference<Map<String, Object>>() {
        });
        if (CollectionUtils.isEmpty(params)) {
            return UiBotModel.emptyUibotModelWithCancelButton(locale);
        }
        params.put("area_no", rawData.get("area_no"));
        Map<String, Object> returnMap = digiwinEspProxyService.getWoOpDispatchAreaSpaceDetailInfo(apiRequest.getIamUserToken(),
                apiRequest.getTenantId(), apiRequest.getLocale(), params);
        if (ObjectUtil.isEmpty(returnMap)) {
            return UiBotModel.emptyUibotModelWithCancelButton(locale);
        }
        //佔用比例
        String areaSpacePercentage;
        if (ObjectUtil.isNotEmpty(returnMap.get("area_space_percentage"))) {
            areaSpacePercentage = returnMap.get("area_space_percentage").toString();
        } else {
            areaSpacePercentage = "0";
        }
        //已生效数据集合
        List<Map<String, Object>> datas = (List<Map<String, Object>>) returnMap.get("eff_wo_op_data");
        if (CollUtil.isEmpty(datas)) {
            return uiBotModel;
        }
        for (UiBotLayout uiBotLayout : layoutList) {
            final String schema = uiBotLayout.getSchema();
            switch (uiBotLayout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(schema), CustomGroup.class);
                    customGroup.setName(rawData.get(customGroup.getName()) + " "
                            + localeService.getLanguageValue(locale, "区域占用比例") + ": " + Double.valueOf(areaSpacePercentage).intValue());
                    CustomGroupContent content = customGroup.getContent();
                    List<UiBotLayout> customUiBotLayouts = new ArrayList<>(datas.size());
                    UiBotPageData customPageData = new UiBotPageData();
                    for (UiBotLayout layout : content.getLayout()) {
                        if (Card.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                            Card card = JsonUtil.objectToJavaObject(content.getPageData().get(layout.getSchema()), Card.class);
                            for (Map<String, Object> data : datas) {
                                Retractable retractable = new Retractable();
                                List<BaseMobileComponentWrapper<BaseMobileComponent>> retractableContent = retractable.getContent();
                                String id = UUID.randomUUID().toString();
                                UiBotLayout newLayout = new UiBotLayout(id, Retractable.COMPONENT_TYPE);
                                List<Map<String, Object>> mapList = (List<Map<String, Object>>) data.get("eff_wo_op_detail");
                                if (CollUtil.isNotEmpty(mapList)) {
                                    for (Map<String, Object> map : mapList) {
                                        Card dataCard = new Card();
                                        dataCard.setTitle((String) map.get(card.getTitle()));
                                        dataCard.setBgColor("#f8f8fc");
                                        List<CardContent> cardContents = card.getContent();
                                        for (CardContent cardContent : cardContents) {
                                            CardContent newCardContent = new CardContent();
                                            newCardContent.setLabel(localeService.getLanguageValue(locale, cardContent.getLabel()));
                                            switch (cardContent.getSchema()) {
                                                case "occupy_space":
                                                    //区域占比
                                                    if (ObjectUtil.isNotEmpty(map.get(cardContent.getSchema()))) {
                                                        int i = (int) Double.parseDouble(map.get(cardContent.getSchema()).toString());
                                                        newCardContent.setValue(String.valueOf(i));
                                                    }
                                                    break;
                                                case "plan_complete_date":
                                                    //预计完工日
                                                    if (ObjectUtil.isNotEmpty(map.get(cardContent.getSchema()))) {
                                                        String date = map.get(cardContent.getSchema()).toString();
                                                        newCardContent.setValue(DateUtil.format(DateUtil.parse(date), "yyyy.MM.dd"));
                                                    }
                                                    break;
                                                default:
                                                    newCardContent.setValue((String) map.get(cardContent.getSchema()));
                                                    break;
                                            }
                                            newCardContent.setSchema(cardContent.getSchema());
                                            dataCard.getContent().add(newCardContent);
                                        }
                                        retractableContent.add(new BaseMobileComponentWrapper<>(dataCard, Card.COMPONENT_TYPE));
                                    }
                                }
                                retractable.setTitle(getStartDate(data, locale) + " " + "("
                                        + localeService.getLanguageValue(locale, "可用区域：")
                                        + Double.valueOf(String.valueOf(data.get("available_space"))).intValue() + ")");
                                retractable.setStyle(2);
                                retractable.setAlignmentType(1);
                                retractable.setContent(retractableContent);
                                //"area_show_color": "區域展現顏色":1-绿色2-蓝色3-橘色
                                retractable.setIconStatus(Integer.parseInt(String.valueOf(data.get("area_show_color"))));
                                customPageData.put(id, retractable);
                                customUiBotLayouts.add(newLayout);
                            }
                        }
                    }
                    content.setLayout(customUiBotLayouts);
                    content.setPageData(customPageData);
                    pageData.put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    List<BottomButtonDigiwinAthena> buttons =
                            ModuleUtils.listMapToListObject((List) pageData.get(schema), BottomButtonDigiwinAthena.class);
                    for (BottomButtonDigiwinAthena bottomButton : buttons) {
                        bottomButton.setName(localeService.getLanguageValue(locale, bottomButton.getName()));
                    }
                    pageData.put(schema, buttons);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private static String getStartDate(Map<String, Object> data, String local) {
        LocaleService localeService = SpringContextHolder.getBean(LocaleServiceImpl.class);
        if (ObjectUtils.isEmpty(data.get("start_date"))) {
            return "";
        } else {
            String date = String.valueOf(data.get("start_date"));
            LocalDate localDate = LocalDate.parse(LocalDate.now().getYear() + "/" + date, DateTimeFormatter.ofPattern("yyyy/MM/dd"));
            return String.format("%s%s", localDate.getMonthValue() + localeService.getLanguageValue(local, "月"), localDate.getDayOfMonth() + localeService.getLanguageValue(local, "日"));
        }
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return UiBotModel.emptyUibotModel(apiRequest.getLocale());
    }
}
