package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.AppBasePageNameEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

@Component
public class PersonnelOnlineManage {

    private static final Logger logger =
            LoggerFactory.getLogger(PersonnelOnlineManage.class);

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private LocaleService localeService;

    public List<WoOpReportInfo> woOpReportPersonnelGet(String iamUserToken, String tenantId, String locale,
                                                       String eocCompanyId, String eocSiteId) {
        List<WoOpReportInfo> allReportList = new ArrayList<>();

        // 使用Future方式执行多任务
        List<Future<?>> futureList = new ArrayList<>();
        Future<List<WoOpReportInfo>> online = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinEspProxyService.woOpReportPersonnelCheckedInInfoGet(
                        iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(online);

        Future<List<WoOpReportInfo>> offline = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinEspProxyService.woOpReportPersonnelNotCheckInInfoGet(
                        iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(offline);

        Future<List<WoOpReportInfo>> except = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinEspProxyService.woOpReportPersonnelExceptInfoGet(
                        iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(except);

        Future<List<WoOpReportInfo>> support = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinEspProxyService.requestSupportInfoGet(
                        iamUserToken, tenantId, locale, eocCompanyId, eocSiteId));
        futureList.add(support);

        //查询任务执行的结果
        try {
            PersonnelStateEnum[] keys =
                    {PersonnelStateEnum.ONLINE, PersonnelStateEnum.OFFLINE,
                            PersonnelStateEnum.EXCEPT, PersonnelStateEnum.SUPPORT};
            for (int i = 0; i < futureList.size(); i++) {
                Future<?> future = futureList.get(i);
                // CPU高速轮询：每个future都并发轮循，判断完成状态然后获取结果，
                // 这一行，是本实现方案的精髓所在。即有10个future在高速轮询，完成一个future的获取结果，就关闭一个轮询
                while (true) {
                    // 获取future成功完成状态，如果想要限制每个任务的超时时间，取消本行的状态判断+future.get(1000*1, TimeUnit.MILLISECONDS)+catch超时异常使用即可。
                    if (future.isDone() && !future.isCancelled()) {
                        //获取结果
                        List<WoOpReportInfo> result = (List<WoOpReportInfo>) future.get();
                        for (WoOpReportInfo reportInfo : result) {
                            reportInfo.setStateEnum(keys[i]);
                        }
                        allReportList.addAll(result);
                        break;//当前future获取结果完毕，跳出while
                    } else {
                        //每次轮询休息1毫秒（CPU纳秒级），避免CPU高速轮循耗空CPU---》新手别忘记这个
                        Thread.sleep(1);
                    }
                }
            }
        } catch (InterruptedException | ExecutionException e) {
            logger.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        }
        allReportList.forEach(e -> {
            e.setEocCompanyId(eocCompanyId);
            e.setEocSiteId(eocSiteId);
        });
        return allReportList;
    }

    public void buildRawData(InputCascade.DefaultSelect defaultSelect, Map<String, Object> rawData) {
        List<Map<String, Object>> list = this.defaultSelect2List(defaultSelect);
        if (!CollectionUtils.isEmpty(list)) {
            rawData.put("eoc_company_id", list);
        }
    }

    private List<Map<String, Object>> defaultSelect2List(InputCascade.DefaultSelect defaultSelect) {
        if (null == defaultSelect) {
            return new ArrayList<>();
        }
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> oneMap = JsonUtil.objectToJavaObject(defaultSelect, new TypeReference<Map<String, Object>>() {
        });
        oneMap.remove("child");
        list.add(oneMap);
        Map<String, Object> twoMap = JsonUtil.objectToJavaObject(defaultSelect.getChild(), new TypeReference<Map<String, Object>>() {
        });
        twoMap.remove("child");
        list.add(twoMap);
        return list;
    }

    public Button createSearchButton(String locale, InputCascade.DefaultSelect defaultSelect) {
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("searchCategoryId", "personnel_online_search");
        this.buildRawData(defaultSelect, rawData);

        Button button = new Button();
        button.setName(localeService.getLanguageValue(locale, "搜索"));
        button.setId(UUIDUtil.getUuid());
        button.setIconData(59124);
        button.setIconColor("0xFF333333");
        Action<Map<String, Object>> action = new Action<>();
        action.setType(ActionTypeEnum.OPEN_BASE_NEW_PAGE.getValue());
        action.setJumpPageId(AppBasePageNameEnum.APP_SEARCH.getValue());
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }

    public Button createViewModeButton(String locale, InputCascade.DefaultSelect defaultSelect) {
        Map<String, Object> rawData = new HashMap<>();
        this.buildRawData(defaultSelect, rawData);

        Button button = new Button();
        button.setName(localeService.getLanguageValue(locale, "选择查阅方式"));
        button.setId(UUIDUtil.getUuid());
        button.setIconData(58915);
        button.setIconColor("0xFF333333");
        Action<Map<String, Object>> action = new Action<>();
        action.setType(ActionTypeEnum.PERSONNEL_STATE_SWITCH_PAGE.getValue());
        action.setJumpPageId("");
        action.setRequestUrl(AppContext.getBaseUrl() + "/mobile/v1/proxy/choice/view/list");
        action.setJumpPageTitle(localeService.getLanguageValue(locale, "选择查阅方式"));
        action.setRawData(rawData);
        button.setAction(action);
        return button;
    }
}
