package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelState;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.componentsetting.ComponentSettingRequestIdEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.compdatabuild.UiBotCompDataBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>功能描述：APP工作台-主管查看在线人员状态-按状态展示中-刷新整个tab数据 tab组件构造策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotCompDataBuildPersonnelStateStrategy
 * @Author: Zaregoto
 * @Date: 2021/10/20 16:29
 */
@Component("uiBotCompDataBuildPersonnelStateStrategy")
public class UiBotCompDataBuildPersonnelStateStrategy
        implements UiBotCompDataBuildStrategy<CustomTab> {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotCompDataBuildPersonnelStateStrategy.class);

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;

    @Override
    public String getTypeByRequestId() {
        return ComponentSettingRequestIdEnum.DIRECTOR_CHECK_PERSONNEL_STATE.getReuqestId();
    }

    @Override
    public CustomTab buildComponentData(ApiRequest apiRequest) throws IOException {
        return null;
    }

    @Override
    public List<CustomTab> buildComponentDataList(ApiRequest apiRequest)
            throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        CustomTabs customTabs;
        if (!useMockData && !modelTypeShow) {
            customTabs = this.doActually(apiRequest);
        } else {
            customTabs = this.doMockData(apiRequest);
        }
        return customTabs;
    }

    private CustomTabs doActually(ApiRequest apiRequest) {
        PageSetting pageSetting = pageSettingService.findById(apiRequest.getPageId());
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();
        UiBotLayout layout = uiBotModel.getLayout().stream()
                .filter(o -> CustomTabs.COMPONENT_TYPE.equals(o.getType()))
                .collect(Collectors.toList()).get(0);
        CustomTabs customTabs =
                JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomTabs.class);

        InputCascade.DefaultSelect defaultSelect = null;
        // 判断rawData中是否存在数据
        if (null != apiRequest.getRawData() && null != apiRequest.getRawData().get("eoc_company_id")) {
            List<InputCascade.DefaultSelect> selectList = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("eoc_company_id"),
                    new TypeReference<List<InputCascade.DefaultSelect>>() {
                    });
            if (!CollectionUtils.isEmpty(selectList)){
                defaultSelect = selectList.get(0).setChild(selectList.get(1));
            }
        }
        this.buildCustomTabs(apiRequest, customTabs, defaultSelect);
        return customTabs;
    }

    private void buildCustomTabs(ApiRequest apiRequest, CustomTabs customTabs, InputCascade.DefaultSelect defaultSelect) {
        String eocCompanyId = "";
        String eocSiteId = "";
        if (null != defaultSelect && null != defaultSelect.getChild()) {
            eocCompanyId = Optional.ofNullable(defaultSelect.getId()).orElse("");
            eocSiteId = Optional.ofNullable(defaultSelect.getChild().getId()).orElse("");
        }
        // 获取主管下所有人员状况
        List<WoOpReportInfo> allReportList = personnelOnlineManage
                .woOpReportPersonnelGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                        eocCompanyId, eocSiteId);
        Map<PersonnelStateEnum, List<WoOpReportInfo>> reportMap = allReportList.stream()
                .collect(Collectors.groupingBy(WoOpReportInfo::getStateEnum));

        for (CustomTab customTab : customTabs) {
            customTab.updateRefreshConfigParam(apiRequest.getIamUserToken(),
                    apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId(), apiRequest.getPageId(), apiRequest.getRawData());
            PersonnelStateEnum stateEnum = PersonnelStateEnum.valueOf(customTab.getId());
            List<WoOpReportInfo> reportList = reportMap.computeIfAbsent(stateEnum, k -> new ArrayList<>());
            this.fillCustomTab(apiRequest, customTab, stateEnum, reportList);
        }
    }

    private void fillCustomTab(ApiRequest apiRequest, CustomTab customTab,
                               PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        CustomTabContentContainer<PersonnelState> content = new CustomTabContentContainer<>();
        content.setContentCmptType(PersonnelState.COMPONENT_TYPE);
        content.setData(this.createContent(apiRequest, stateEnum, reportList));
        customTab.setContent(Collections.singletonList(content));
        customTab.setName(localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName())
                + "(" + reportList.size() + ")");
    }

    private PersonnelState createContent(ApiRequest apiRequest, PersonnelStateEnum stateEnum,
                                         List<WoOpReportInfo> reportList) {
        return new PersonnelState().convert(apiRequest, localeService, stateEnum, reportList);
    }

    private CustomTabs doMockData(ApiRequest apiRequest) {
        return null;
    }
}
