package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Retractable;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelStateGroup;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTab;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabContentContainer;
import com.digiwin.mobile.mobileuibot.core.component.tab.customtab.CustomTabs;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 功能: 主管查看在线人员情况-依组别查阅-详情
 *
 * @author: wjw
 * @date: created at 2023/3/1
 */
@Component("uiBotModelBuildPersonnelOnlineGroupDetailStrategy")
public class UiBotModelBuildPersonnelOnlineGroupDetailStrategy
        implements UiBotModelBuildStrategy {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;

    @Autowired
    private UiBotModelBuildPersonnelOnlineGroupStrategy uiBotModelBuildPersonnelOnlineGroupStrategy;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    public UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();

        InputCascade.DefaultSelect defaultSelect = null;
        // 判断rawData中是否存在数据
        if (null != apiRequest.getRawData() && null != apiRequest.getRawData().get("eoc_company_id")) {
            List<InputCascade.DefaultSelect> selectList = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("eoc_company_id"),
                    new TypeReference<List<InputCascade.DefaultSelect>>() {
                    });
            if (!CollectionUtils.isEmpty(selectList)){
                defaultSelect = selectList.get(0).setChild(selectList.get(1));
            }
        }
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case CustomTabs.COMPONENT_TYPE:
                    CustomTabs customTabs =
                            JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomTabs.class);
                    this.buildCustomTabs(apiRequest, customTabs, defaultSelect);
                    pageData.put(layout.getSchema(), customTabs);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private void buildCustomTabs(ApiRequest apiRequest, CustomTabs customTabs, InputCascade.DefaultSelect defaultSelect) {
        String eocCompanyId = "";
        String eocSiteId = "";
        if (null != defaultSelect && null != defaultSelect.getChild()) {
            eocCompanyId = Optional.ofNullable(defaultSelect.getId()).orElse("");
            eocSiteId = Optional.ofNullable(defaultSelect.getChild().getId()).orElse("");
        }

        String teamNo = apiRequest.getRawData().getString("teamNo");

        List<WoOpReportInfo> allReportList = personnelOnlineManage
                .woOpReportPersonnelGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                        eocCompanyId, eocSiteId);

        // 处理支援的数据
        uiBotModelBuildPersonnelOnlineGroupStrategy.handleSupportWoOpReportInfo(allReportList);

        Map<PersonnelStateEnum, List<WoOpReportInfo>> reportMap =
                allReportList.stream()
                        .filter(woOpReportInfo -> woOpReportInfo.getTeamNo().equals(teamNo))
                        .collect(Collectors.groupingBy(WoOpReportInfo::getStateEnum));

        for (CustomTab customTab : customTabs) {
            customTab.updateRefreshConfigParam(apiRequest.getIamUserToken(),
                    apiRequest.getLocale(), apiRequest.getClientId(), apiRequest.getTenantId(),
                    apiRequest.getPageId(), apiRequest.getRawData());
            PersonnelStateEnum stateEnum = PersonnelStateEnum.valueOf(customTab.getId());
            List<WoOpReportInfo> reportList = reportMap.computeIfAbsent(stateEnum, k -> new ArrayList<>());

            if (CollectionUtils.isEmpty(reportList)) {
                buidlEmptyTab(apiRequest, customTab);
                continue;
            }
            if (PersonnelStateEnum.ONLINE.equals(stateEnum)) {
                this.fillOnlineTab(apiRequest, customTab, reportList);
            } else if (PersonnelStateEnum.SUPPORT.equals(stateEnum)) {
                CustomTab.fillSupportTab(apiRequest, customTab, reportList);
            } else {
                this.fillCustomTab(apiRequest, customTab, stateEnum, reportList);
            }
        }
    }

    private void fillCustomTab(ApiRequest apiRequest, CustomTab customTab,
                               PersonnelStateEnum stateEnum, List<WoOpReportInfo> reportList) {
        CustomTabContentContainer<PersonnelStateGroup> content = new CustomTabContentContainer<>();
        content.setContentCmptType(PersonnelStateGroup.COMPONENT_TYPE);
        content.setData(this.createContent(apiRequest, stateEnum, reportList));
        customTab.setContent(Collections.singletonList(content));
        customTab.setName(localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName())
                + "(" + reportList.size() + ")");
    }

    private void fillOnlineTab(ApiRequest apiRequest, CustomTab customTab, List<WoOpReportInfo> reportList) {
        CustomTabContentContainer content = new CustomTabContentContainer<>();
        content.setContentCmptType(ZtbViewList.COMPONENT_TYPE);
        content.setData(ZtbViewList.buildZtbViewList(apiRequest,  localeService,  reportList));
        customTab.setContent(Collections.singletonList(content));
        customTab.setName(localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName())
                + "(" + reportList.size() + ")");
    }

    private CustomTab buidlEmptyTab(ApiRequest apiRequest, CustomTab customTab) {
        customTab.setName((localeService.getLanguageValue(apiRequest.getLocale(), customTab.getName()) + "(0)"));
        customTab.setStyle(2);
        customTab.setAlignmentType(1);
        CustomTabContentContainer customTabContentContainer = new CustomTabContentContainer();
        customTabContentContainer.setData(Empty.create(localeService.getLanguageValue(apiRequest.getLocale(), "暂无数据")));
        customTabContentContainer.setContentCmptType(Empty.COMPONENT_TYPE);
        customTab.setContent(Collections.singletonList(customTabContentContainer));
        return customTab;
    }

    private PersonnelStateGroup createContent(ApiRequest apiRequest, PersonnelStateEnum stateEnum,
                                              List<WoOpReportInfo> teamList) {
        // 详情不用给title字段值，切记
        return new PersonnelStateGroup().convert(apiRequest, localeService, stateEnum, teamList)
                .setTitle("");
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}
