package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.basic.BlankArea;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascade;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeSelectStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.input.cascade.InputCascadeTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.personnel.PersonnelGroup;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.WoOpReportInfo;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 功能: 主管查看在线人员情况-依组别查阅
 *
 * @author: wjw
 * @date: created at 2023/3/1
 */
@Component("uiBotModelBuildPersonnelOnlineGroupStrategy")
public class UiBotModelBuildPersonnelOnlineGroupStrategy
        implements UiBotModelBuildStrategy {

    @Autowired
    private PersonnelOnlineManage personnelOnlineManage;

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        String locale = apiRequest.getLocale();
        UiBotModel uiBotModel = pageSetting.getPageModel();
        UiBotPageData pageData = uiBotModel.getPageData();

        InputCascade.DefaultSelect defaultSelect = null;
        for (UiBotLayout layout : uiBotModel.getLayout()) {
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), CustomGroup.class);
                    defaultSelect = this.buildCustomGroup(apiRequest, customGroup, defaultSelect);
                    pageData.put(layout.getSchema(), customGroup);
                    break;
                case BlankArea.COMPONENT_TYPE:
                    BlankArea blankArea = JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), BlankArea.class);
                    pageData.put(layout.getSchema(), blankArea);
                    break;
                case PersonnelGroup.COMPONENT_TYPE:
                    PersonnelGroup personnelGroup =
                            JsonUtil.objectToJavaObject(pageData.get(layout.getSchema()), PersonnelGroup.class);
                    this.createPersonnelGroup(apiRequest, personnelGroup, defaultSelect);
                    pageData.put(layout.getSchema(), personnelGroup);
                    break;
                default:
                    break;
            }
        }
        List<Button> appbarButtonList = uiBotModel.getAppbarButtonList();
        // 创建一个搜索按钮
        appbarButtonList.add(personnelOnlineManage.createSearchButton(locale, defaultSelect));
        // 创建一个切换查阅方式按钮
        appbarButtonList.add(personnelOnlineManage.createViewModeButton(locale, defaultSelect));

        return uiBotModel;
    }

    private InputCascade.DefaultSelect buildCustomGroup(ApiRequest apiRequest, CustomGroup customGroup, InputCascade.DefaultSelect defaultSelect) {
        String locale = apiRequest.getLocale();
        CustomGroupContent content = customGroup.getContent();
        for (UiBotLayout layout : content.getLayout()) {
            switch (layout.getType()) {
                case InputCascade.COMPONENT_TYPE:
                    //公司别
                    List<Map<String, Object>> companys = digiwinEocProxyService.getCompany(apiRequest.getIamUserToken());
                    //工厂别
                    List<Map<String, Object>> factorys = digiwinEocProxyService.getFactory(apiRequest.getIamUserToken());
                    InputCascade inputCascade = InputCascade.create(companys, factorys, layout.getSchema(), "eoc_site_id",
                            localeService.getLanguageValue(locale, "云端营运据点"), 2, InputCascadeTypeEnum.PARSE.getValue(),
                            InputCascadeSelectStyleEnum.BG_STYLE_WHITE.getValue(), locale);
                    // 判断rawData中是否存在数据
                    if (null != apiRequest.getRawData() && null != apiRequest.getRawData().get(layout.getSchema())) {
                        List<InputCascade.DefaultSelect> selectList = JsonUtil.objectToJavaObject(apiRequest.getRawData().get(layout.getSchema()),
                                new TypeReference<List<InputCascade.DefaultSelect>>() {
                                });
                        if (!CollectionUtils.isEmpty(selectList)){
                            inputCascade.setDefaultSelect(selectList.get(0).setChild(selectList.get(1)));
                        }
                    }
                    defaultSelect = inputCascade.getDefaultSelect();

                    // 改变据点 刷新页面
                    Action submitAction = new Action<>();
                    submitAction.setJumpPageId(apiRequest.getPageId());
                    submitAction.setJumpPageTitle("");
                    submitAction.setType(ActionTypeEnum.BACK_REFRESH.getValue());
                    inputCascade.setSubmitAction(submitAction);
                    inputCascade.setIsSubmit(true);
                    content.getPageData().put(layout.getSchema(), inputCascade);
                    break;
                default:
                    break;
            }
        }
        return defaultSelect;
    }

    private void initButton(String locale, List<BottomButtonDigiwinAthena> customButtonList) {
        if (!CollectionUtils.isEmpty(customButtonList)) {
            for (BottomButtonDigiwinAthena buttonDigiwinAthena : customButtonList) {
                if (StringUtils.hasLength(buttonDigiwinAthena.getName())) {
                    buttonDigiwinAthena.setName(
                            localeService.getLanguageValue(locale, buttonDigiwinAthena.getName()));
                }
                if (StringUtils.hasLength(buttonDigiwinAthena.getSubName())) {
                    buttonDigiwinAthena.setSubName(
                            localeService.getLanguageValue(locale, buttonDigiwinAthena.getSubName()));
                }
                this.setRequestUrl(buttonDigiwinAthena);
                List<BottomButtonDigiwinAthena> children = buttonDigiwinAthena.getChildren();
                if (!CollectionUtils.isEmpty(children)) {
                    for (BottomButtonDigiwinAthena button : children) {
                        if (StringUtils.hasLength(button.getName())) {
                            button.setName(localeService.getLanguageValue(locale, button.getName()));
                        }
                        if (StringUtils.hasLength(button.getSubName())) {
                            button.setSubName(localeService.getLanguageValue(locale, button.getSubName()));
                        }
                        Action action = button.getAction();
                        if (action != null) {
                            if (StringUtils.hasLength(action.getJumpPageTitle())) {
                                action.setJumpPageTitle(localeService.getLanguageValue(locale, action.getJumpPageTitle()));
                            }
                            if (StringUtils.hasLength(action.getToastMsg())) {
                                action.setToastMsg(localeService.getLanguageValue(locale, action.getToastMsg()));
                            }
                        }
                        this.setRequestUrl(button);
                    }
                }
            }
        }
    }

    private void setRequestUrl(BottomButtonDigiwinAthena button) {
        Action action = button.getAction();
        if (action == null || !StringUtils.hasLength(action.getRequestUrl())) {
            return;
        }
        action.setRequestUrl(AppContext.getBaseUrl() + action.getRequestUrl());
    }

    private void createPersonnelGroup(ApiRequest apiRequest, PersonnelGroup personnelGroup, InputCascade.DefaultSelect defaultSelect) {
        String eocCompanyId = "";
        String eocSiteId = "";
        if (null != defaultSelect && null != defaultSelect.getChild()) {
            eocCompanyId = Optional.ofNullable(defaultSelect.getId()).orElse("");
            eocSiteId = Optional.ofNullable(defaultSelect.getChild().getId()).orElse("");
        }
        // 获取主管下所有人员状况
        List<WoOpReportInfo> allReportList = personnelOnlineManage
                .woOpReportPersonnelGet(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                        eocCompanyId, eocSiteId);

        // 处理支援的数据
        handleSupportWoOpReportInfo(allReportList);

        Map<String, Object> rawData = new HashMap<>();
        personnelOnlineManage.buildRawData(defaultSelect, rawData);
        personnelGroup.convert(apiRequest, allReportList, rawData);
    }

    /**
     *  支援的teamNo和teamName是多个，逗号分隔，如果按照班组条件查询需要按班组拆分开
     *
     * */
    public void handleSupportWoOpReportInfo(List<WoOpReportInfo> allReportList) {
        List<WoOpReportInfo> supportReportList = allReportList.stream().filter(allReport -> PersonnelStateEnum.SUPPORT.equals(allReport.getStateEnum())).collect(Collectors.toList());
        allReportList.removeIf(allReport -> PersonnelStateEnum.SUPPORT.equals(allReport.getStateEnum()));

        supportReportList = supportReportList.stream().map(supportReport -> {
            if (CollectionUtils.isEmpty(supportReport.getTeamList()) || supportReport.getTeamList().size() == 1) {
                return Collections.singletonList(supportReport);
            }
            return supportReport.getTeamList().stream().map(teamNo -> {
                WoOpReportInfo supportWoOpReportInfoByTeamNo = new WoOpReportInfo();
                BeanUtils.copyProperties(supportReport, supportWoOpReportInfoByTeamNo);
                supportWoOpReportInfoByTeamNo.setTeamNo(teamNo.getTeamNo());
                supportWoOpReportInfoByTeamNo.setTeamName(teamNo.getTeamName());
                supportWoOpReportInfoByTeamNo.setTeamList(null);
                return supportWoOpReportInfoByTeamNo;
            }).collect(Collectors.toList());
        }).flatMap(List::stream).collect(Collectors.toList());
        allReportList.addAll(supportReportList);
    }

    private UiBotModel doMockData(ApiRequest apiRequest) {
        return null;
    }
}
