package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.basic.Empty;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroup;
import com.digiwin.mobile.mobileuibot.core.component.group.CustomGroupContent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.mdc.service.DigiwinMdcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：人员状况已上线详细信息页面生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UibotModelBuildPersonalOnlineDetailStrategy
 * @Author: xujinc
 * @Date: 2024年9月03日 11点55分
 */
@Component("uibotModelBuildPersonalStateOnlineDetailStrategy")
public class UibotModelBuildPersonalStateOnlineDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger =
            LoggerFactory.getLogger(UibotModelBuildPersonalStateOnlineDetailStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Autowired
    private DigiwinMdcProxyService digiwinMdcProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("Build APC Attachemnt Detail Page");
        UiBotModel uiBotModel = null;
        Boolean useMockData = AppContext.getUseMockData();
        if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        String locale = apiRequest.getLocale();
        Map<String, Object> rawData = apiRequest.getRawData().getInnerMap();
        Map<String, Object> woOpReportInfo = JsonUtil.objectToJavaObject(rawData.get("woOpReportInfo"), new TypeReference<Map<String, Object>>() {
        });

        Map<String, Object> queryConditionMap = new HashMap<>(2);
        Map<String, Object> woInfoMap = new HashMap<>(2);
        woInfoMap.put("wo_no", woOpReportInfo.get("wo_no"));
        woInfoMap.put("plot_no", woOpReportInfo.get("plot_no"));
        queryConditionMap.put("wo_no_list", Collections.singletonList(woInfoMap));

        Map<String, Object> opInfoMap = new HashMap<>(1);
        opInfoMap.put("op_no", woOpReportInfo.get("op_no"));
        queryConditionMap.put("op_no_list", Collections.singletonList(opInfoMap));
        queryConditionMap.put("progress_percentage_less_than", 100);
        queryConditionMap.put("progress_percentage_greater_than", 0);

        Map<String, Object> parameterMap = new HashMap<>(1);
        parameterMap.put("query_condition", Collections.singletonList(queryConditionMap));
        parameterMap.put("enterprise_no", woOpReportInfo.get("eoc_company_id"));
        parameterMap.put("site_no", woOpReportInfo.get("eoc_site_id"));

        Map<String, Object> requestParamMap = new HashMap<>(2);
        requestParamMap.put("parameter", parameterMap);
        requestParamMap.put("actionId", "dispatch.report.info.get");

        List<Map<String, Object>> queryDataList = digiwinEspProxyService.getDispatchReportInfo(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(),
                MapUtils.getString(woOpReportInfo, "eoc_company_id"), Collections.singletonList(queryConditionMap));

        // 拼成最终数据
        stopWatch.start("Build APC Attachemnt Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case CustomGroup.COMPONENT_TYPE:
                    if (CollectionUtils.isEmpty(queryDataList)) {
                        layout.setType(Empty.COMPONENT_TYPE);
                        uiBotModel.getPageData().put(schema, Empty.create(localeService.getLanguageValue(locale, "暂无数据"), true));
                        break;
                    }
                    boolean isProductGatewayE10orT100 = digiwinMdcProxyService.isProductGatewayE10orT100(apiRequest.getIamUserToken(), apiRequest.getTenantId());
                    Map<String, Object> queryData = queryDataList.get(0);
                    CustomGroup customGroup = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(schema), CustomGroup.class);
                    CustomGroupContent customGroupContent = customGroup.getContent();
                    List<UiBotLayout> customGroupUiBotLayouts = customGroupContent.getLayout();
                    Iterator<UiBotLayout> customGroupUiBotLayoutIterator = customGroupUiBotLayouts.iterator();
                    while (customGroupUiBotLayoutIterator.hasNext()) {
                        UiBotLayout customGroupUiBotLayout = customGroupUiBotLayoutIterator.next();
                        String customGroupSchema = customGroupUiBotLayout.getSchema();
                        switch (customGroupUiBotLayout.getType()) {
                            case Field.COMPONENT_TYPE:
                                // 产品线为E10或T100才展示特征码
                                if ("item_feature_no".equalsIgnoreCase(customGroupSchema) || "item_feature_spec".equalsIgnoreCase(customGroupSchema)) {
                                    if (!isProductGatewayE10orT100) {
                                        customGroupUiBotLayoutIterator.remove();
                                        continue;
                                    }
                                }

                                String label = localeService.getLanguageValue(locale, customGroupUiBotLayout.getLabel());
                                if ("zh_TW".equalsIgnoreCase(locale)) {
                                    // 工艺单号
                                    if ("wo_no".equals(customGroupSchema)) {
                                        label = "製令單號";
                                    }
                                    // 在制数量
                                    if ("remaining_qty".equals(customGroupSchema)) {
                                        label = "預計產量";
                                    }
                                }

                                Field field = Field.createLabelLeftValueRightField(label, MapUtils.getString(queryData, customGroupSchema));
                                customGroupContent.getPageData().put(customGroupSchema, field);
                                break;
                        }
                    }
                    uiBotModel.getPageData().put(schema, customGroup);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonDigiwinAthena submitButton = BottomButtonDigiwinAthena.createNormalCancelButton(locale, "关闭");
                    uiBotModel.getPageData().put(schema, Collections.singletonList(submitButton));
                    break;
                default:
                    break;
            }
        }

        stopWatch.stop();
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
