package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonStyleEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.card.card.Card;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardContent;
import com.digiwin.mobile.mobileuibot.core.component.card.card.CardOpenDetailTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.list.ztbviewlist.ZtbViewList;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabItemCardDetailPage;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotPageData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author xujinc
 * @desc 人员状况合并工单详情页
 */
@Component("uibotModelBuildPersonelStateMergeDetailStrategy")
public class UibotModelBuildPersonelStateMergeDetailStrategy implements UiBotModelBuildStrategy {
    private static final Logger logger = LoggerFactory.getLogger(UibotModelBuildPersonelStateMergeDetailStrategy.class);

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        StopWatch stopWatch = new StopWatch("Build Personel State Merge Detail Page");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        UiBotPageData pageData = uiBotModel.getPageData();
        String locale = apiRequest.getLocale();

        ApiRawData apiRawData = apiRequest.getRawData();

        for (UiBotLayout layout : uiBotLayouts) {
            String schema = layout.getSchema();
            switch (layout.getType()) {
                case ZtbViewList.COMPONENT_TYPE:
                    ZtbViewList ztbViewList = JsonUtil.objectToJavaObject(pageData.get(schema), ZtbViewList.class);
                    List<CardContent> cardContentList = ztbViewList.getData().get(0).getContent();
                    List<Map<String, Object>> mergeWoOpReportInfoList = JsonUtil.objectToJavaObject(apiRawData.get("mergeWoOpReportInfoList"), new TypeReference<List<Map<String, Object>>>() {
                    });

                    List<Card> cardList = new ArrayList<>();

                    for (Map<String, Object> mergeWoOpReportInfo : mergeWoOpReportInfoList) {
                        Map<String, Object> cardContentMap = new LinkedHashMap<>();
                        cardContentList.forEach(e -> {
                            String label;
                            if ("project_no".equalsIgnoreCase(e.getSchema())) {
                                label = "zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "專案代號" : "项目代号";
                            } else if ("project_name".equalsIgnoreCase(e.getSchema())) {
                                label = "zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "專案名稱" : "项目名称";
                            } else if ("wo_no".equalsIgnoreCase(e.getSchema())) {
                                label = "zh_TW".equalsIgnoreCase(apiRequest.getLocale()) ? "製令單號" : "工单单号";
                            } else {
                                label = localeService.getLanguageValue(locale, e.getLabel());
                            }
                            cardContentMap.put(label, mergeWoOpReportInfo.get(e.getSchema()));
                        });

                        String dataId = UUIDUtil.getUuid();

                        Map<String, Object> rawData = new HashMap<>();
                        rawData.put("woOpReportInfo", mergeWoOpReportInfo);
                        List<Button> buttonList = new ArrayList<>(1);
                        buttonList.add(Button.createButton(localeService.getLanguageValue(locale,
                                "详细信息"), dataId, BottomButtonStyleEnum.NORMAL.getValue(), null));

                        TabItemCardDetailPage tabItemCardDetailPage = new TabItemCardDetailPage();
                        tabItemCardDetailPage.setDataId(dataId);
                        tabItemCardDetailPage.setPageId(PageSettingIdPresetEnum.MOBILE_ATHENA_APC_PERSONEL_STATE_ONLINE_DETAIL.toString());
                        tabItemCardDetailPage.setRawData(rawData);

                        Card card = Card.create(StringUtils.EMPTY, cardContentMap, buttonList, false);
                        card.setDataId(dataId);
                        card.setDetailPage(tabItemCardDetailPage);
                        card.setOpenDetailType(CardOpenDetailTypeEnum.BY_BUTTON.getValue());
                        cardList.add(card);
                    }
                    ztbViewList.setData(cardList);
                    ztbViewList.setDetailPageSwiper(true);
                    pageData.put(schema, ztbViewList);
                    break;
                case BottomButtonDigiwinAthena.COMPONENT_TYPE:
                    BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                            pageSetting.getPageModel().getPageData().get(layout.getSchema()),
                            BottomButtonList.class);
                    bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                        bottomButtonDigiwinAthena.setName(localeService.getLanguageValue(locale, bottomButtonDigiwinAthena.getName()));
                    });
                    pageData.put(schema, bottomButtonList);
                    break;
                default:
                    break;
            }
        }
        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
