package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.SourceCategoryEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.model.db1.UserCardListFilter;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfig;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.MobileDesignerConfigRepository;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.mysql.model.UserCardListFilterQueryDTO;
import com.digiwin.mobile.mobileuibot.mysql.service.UserCardListFilterService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.DigiwinAtdmRequest;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.knowledgemaps.service.DigiwinKnowledgeMapsProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.button.UiBotQueryButton;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.template.BusinessProcessPerformerImpl;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：APC-机位生产进度页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildApcStandProductionProgressPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/8/12 17:02
 */
@Component
public class UiBotModelBuildApcStandProductionProgressPageStrategy implements UiBotModelBuildStrategy {

    private static final String TMACTIVITYID = "DataEntry_getlist__apc_stand_production_progress";

    @Autowired
    private MobileDesignerConfigRepository mobileDesignerConfigRepository;

    @Autowired
    private BusinessProcessPerformerImpl businessProcessPerformerImpl;

    @Autowired
    private PcRuleService pcRuleService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private UserCardListFilterService userCardListFilterService;

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    @Autowired
    private DigiwinKnowledgeMapsProxyService digiwinKnowledgeMapsProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setPageBackgroudColor(BackgroundColorEnum.APP_MAIN_GREY.getValue());
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        handleUiBotModel(apiRequest, uiBotModel);
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        return uiBotModel;
    }

    private void handleUiBotModel(ApiRequest apiRequest, UiBotModel uiBotModel) {
        uiBotModel.setPageData(this.buildPageData(apiRequest));
        // 构建页面配置
        UiBotQueryButton queryButton = this.buildQueryButton();
        // 构建上下文
        PcUiBotExecuteContext executeContext = this.buildPcUiBotExecuteContext(apiRequest);
        // 构建渲染数据
        this.bulidRanderData(apiRequest, executeContext, uiBotModel, queryButton);
        // 构建规则
        this.buildRule(executeContext, uiBotModel);
        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(uiBotModel.getPageData(), UiBotPageData.class));
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
    }

    private UiBotPageData buildPageData(ApiRequest apiRequest) {
        // 查询条件
        Map<String, Object> queryCondition = new HashMap<>();
        queryCondition.put("task_display_field", this.buildTaskDisplayField(apiRequest));
        UserCardListFilter userCardListFilter = userCardListFilterService.getUserCardListFilterByTmActivityIdAndUserId(
                new UserCardListFilterQueryDTO()
                        .setTenantId(apiRequest.getTenantId())
                        .setUserId(apiRequest.getUserId())
                        .setTmActivityId(TMACTIVITYID));
        Optional.ofNullable(userCardListFilter)
                .map(UserCardListFilter::getData)
                .filter(StringUtils::hasLength)
                .map(data -> JsonUtil.jsonStringToObject(data, new TypeReference<Map<String, Object>>() {
                }))
                .ifPresent(queryCondition::putAll);

        Map<String, Object> parameter = new HashMap<>(1);
        parameter.put("query_condition", Lists.newArrayList(queryCondition));
        DigiwinAtdmRequest request = DigiwinAtdmRequest.create("layout.report.statistics.area.info.get", parameter, null, null);
        try {
            DigiwinAthenaApiResponse<Map<String, Object>> athenaApiResponse = digiwinAtdmProxyService.dataQueryByActionId(
                    apiRequest.getLocale(),
                    apiRequest.getIamUserToken(),
                    JsonUtil.javaObjectToJsonString(request),
                    apiRequest.getTenantId()
            );
            return Optional.ofNullable(athenaApiResponse)
                    .map(DigiwinAthenaApiResponse::getResponse)
                    .map(UiBotPageData::new)
                    .orElseGet(UiBotPageData::new);
        } catch (Exception e) {
            return new UiBotPageData();
        }
    }

    private String buildTaskDisplayField(ApiRequest apiRequest) {
        // task_display_field：设计器-任务卡显示标 （1-工单单号；2-项目号；3-计划批号）
        String taskDisplayField = "1";
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("variableId", "taskNameField");
        jsonArray.add(jsonObject);
        List<Map<String, Object>> mechanismVariableList = digiwinKnowledgeMapsProxyService.getMechanismVariableList(apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getLocale(), jsonArray);
        if (!CollectionUtils.isEmpty(mechanismVariableList)) {
            for (Map<String, Object> mechanismVariable : mechanismVariableList) {
                if ("taskNameField".equals(mechanismVariable.get("variableId"))) {
                    taskDisplayField = StringUtil.valueOf(mechanismVariable.get("result"));
                    break;
                }
            }
        }
        return taskDisplayField;
    }

    public UiBotQueryButton buildQueryButton() {
        MobileDesignerConfig config = mobileDesignerConfigRepository.selectOneDsl(TMACTIVITYID, MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        List<UiBotPageLayout> uiBotPageLayoutList = Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> {
                    MobileRenderDataUtil.multilingualProcessing(r, AppRequestContext.getContextEntity().getLocale());
                    return r;
                })
                .map(r -> r.getJSONObject("pageDslMobile"))
                .map(r -> r.getJSONArray("layout").getJSONObject(0))
                .map(r -> r.getJSONObject("data"))
                .map(r -> r.get("data"))
                .map(r -> JsonUtil.objectToJavaObject(r, new TypeReference<List<UiBotPageLayout>>() {
                }))
                .orElseGet(ArrayList::new);
        uiBotPageLayoutList.forEach(uiBotPageLayout -> uiBotPageLayout.convert(uiBotPageLayout.getComponentType()));

        UiBotQueryButton queryButton = new UiBotQueryButton();
        queryButton.setPageLayout(uiBotPageLayoutList);

        List<Map<String, Object>> hooks = Optional.ofNullable(config)
                .map(MobileDesignerConfig::getData)
                .map(r -> r.getJSONObject("pageDslMobile"))
                .map(r -> JsonUtil.objectToJavaObject(r.get("hooks"), new TypeReference<List<Map<String, Object>>>() {
                })).orElseGet(ArrayList::new);
        queryButton.setHooks(hooks);

        Map<String, Object> dataSourceSet = new HashMap<>();
        dataSourceSet.put("mainDatasource", "layout_data");
        queryButton.setDataSourceSet(dataSourceSet);

        return queryButton;
    }

    private PcUiBotExecuteContext buildPcUiBotExecuteContext(ApiRequest apiRequest) {
        PcUiBotExecuteContext executeContext = PcUiBotExecuteContext.create(apiRequest.getLocale(), apiRequest.getTenantId(), TMACTIVITYID);
        executeContext.appendPageInfo(UiBotDesignerService.PAGECODE_TASK_DETAIL, null, TMACTIVITYID, PcUiBotActivityConstants.PERFORMER, Boolean.FALSE);
        executeContext.setAuthoredUser(new PcUiBotAuthoredUser()
                .setUserId(apiRequest.getUserId()).setTenantId(apiRequest.getTenantId())
                .setToken(apiRequest.getIamUserToken()));
        return executeContext;
    }

    private void bulidRanderData(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, UiBotModel uiBotModel, UiBotQueryButton queryButton) {
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        MobilePageRawData mobilePageRawData = new MobilePageRawData();
        mobilePageRawData.setSourceCategory(SourceCategoryEnum.APC_STAND_PRODUCTION_PROGRESS.name());

        // 高级属性--构建主页面hooks与上下文中组件级hooks
        uiBotDesignerRenderService.buildMainPageHooksByQueryButton(queryButton, cmptContext, uiBotModel, null);

        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                businessProcessPerformerImpl.buildBodyCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            // 添加空组件
            uiBotModel.getRenderData().addEmptyComponentToBody();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(
                        new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }

            // 构建bottom
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                    businessProcessPerformerImpl.buildBottomCmpt(executeContext, uiBotModel, cmptContext, queryButton, mobilePageRawData, null);
            if (!CollectionUtils.isEmpty(bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
    }

    private void buildRule(PcUiBotExecuteContext executeContext, UiBotModel uiBotModel) {
        List<UiBotRule> rules = pcRuleService.buildRuleOfLocal(executeContext.getTmActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        if (!CollectionUtils.isEmpty(rules)) {
            uiBotModel.setRules(rules);
        }
    }

    public static String getTmActivityId() {
        return TMACTIVITYID;
    }


    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}