package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.ksc;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.appec.SlipConfigLeft;
import com.digiwin.mobile.mobileuibot.core.appec.SlipTitle;
import com.digiwin.mobile.mobileuibot.core.component.action.Action;
import com.digiwin.mobile.mobileuibot.core.component.basic.Label;
import com.digiwin.mobile.mobileuibot.core.component.basic.Tag;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.TaskCrumbs;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.button.BottomButtonList;
import com.digiwin.mobile.mobileuibot.core.component.button.Button;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDesc;
import com.digiwin.mobile.mobileuibot.core.component.navbar.pagedesc.PageDescContent;
import com.digiwin.mobile.mobileuibot.core.component.title.titlebody.TitleBody;
import com.digiwin.mobile.mobileuibot.core.component.title.titledesc.TitleDesc;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingIdPresetEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSettingService;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.project.common.ProjectStringUtil;
import com.digiwin.mobile.mobileuibot.project.common.ProjectTypeUtil;
import com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem;
import com.digiwin.mobile.mobileuibot.project.strategy.ProjectDetailBuildStrategyFactory;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPersonResponse;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * <p>功能描述：鼎捷雅典娜应用体系云管家（KSC）的项目详情画面生成策略类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildKscProjectDetailStrategy
 * @Author: Zaregoto
 * @Date: 2023/6/9
 */
@Slf4j
@Component("uiBotModelBuildKscProjectDetailStrategy")
public class UiBotModelBuildKscProjectDetailStrategy implements UiBotModelBuildStrategy {
    //未开始
    private static final String TASK_STATUS_NOT_STARTED = "10";

    @Resource(name = "defaultThreadPool")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private DigiwinPcUiBotProxyService digiwinPcUiBotProxyService;

    @Autowired
    private ProjectDetailBuildStrategyFactory projectDetailBuildStrategyFactory;

    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private PageSettingService pageSettingService;

    @Autowired
    private DigiwinEocProxyService digiwinEocProxyService;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private LocaleService localeService;


    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildKscDetail");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (modelTypeShow) {
            uiBotModel = this.doShowData(pageSetting, apiRequest, stopWatch);
        } else if (!useMockData) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        log.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    @Autowired
    private HttpService httpService;

    private UiBotModel doShowData(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        return null;
    }

    @SneakyThrows
    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest, StopWatch stopWatch) {
        if (pageSetting.getPageId().equalsIgnoreCase(
                PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_NEXT_LEVEL_TASK_LIST.toString())) {
            return this.buildKscProjectNextLevelTaskList(pageSetting, apiRequest);
        }

        ApiRawData rawData = apiRequest.getRawData();
        boolean isShare = rawData.get("isShare") == null ? false : (Boolean) rawData.get("isShare");

        /**
         * 1. 获取项目详情阅读次数
         *   GET调用https://atmc-test.apps.digiwincloud.com.cn/api/atmc/v1/task/readCount/${projectId}接口
         * 1. 获取任务详情阅次数
         *   GET调用https://atmc-test.apps.digiwincloud.com.cn/api/atmc/v1/backlog/readCount/${projectId}接口
         * 1. 查询数字化看板数据
         *   GET调用https://atmc-test.apps.digiwincloud.com.cn/api/atmc/v1/task/panel/${projectId}
         * 2. 获取项目详情数据源
         *   GET调用https://uibot-test.apps.digiwincloud.com.cn/api/ai/v1/bot/project/detail/${tmTaskId}/${tmActivityId}/${projectId}接口
         * 3. UIBot展示项目数据
         *   POST调用https://uibot-test.apps.digiwincloud.com.cn/api/ai/v1/bot/action/show接口
         * 4. 调用ProjectDetailBuildStrategyFactory策略工厂类找到策略后进行build界面
         * 5. 调用UiBotModelBuildService进行最后的Model的build
         */
        stopWatch.start("GetData From Athena API");
        //使用Future方式执行多任务
        List<Future<?>> futureList = new ArrayList<>();
        Future<DigiwinAtmcTaskReadCount> futureTaskReadCount = this.threadPoolTaskExecutor.submit(() ->
                this.digiwinAtmcProxyService.updateDigiwinAtmcTaskReadCount(
                        apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), apiRequest.getDataId()));
        futureList.add(futureTaskReadCount);

        Future<List> futureReassignReport = this.threadPoolTaskExecutor.submit(
                () -> this.digiwinAtmcProxyService.getProjectReassignReport(apiRequest.getDataId(),
                        apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId()));
        futureList.add(futureReassignReport);

        Future<DigiwinAtmcEnginePanelInfo> futureAtmcEnginePanelInfo = this.threadPoolTaskExecutor.submit(() ->
                this.digiwinAtmcProxyService.getEnginePanelInfoByTaskId(
                        apiRequest.getDataId() + "",
                        apiRequest.getClientId(),
                        apiRequest.getIamUserToken(),
                        apiRequest.getTenantId(),
                        apiRequest.getLocale()));
        futureList.add(futureAtmcEnginePanelInfo);

        DigiwinAtmcTaskReadCount atmcTaskReadCount = null;
        DigiwinAtmcBacklogReadCount atmcBacklogReadCount = null;
        List<DigiwinReassignReport> reassignReportList = null;
        //旧项目中控台项目详情的可视化看板数据（基于流程引擎）
        DigiwinAtmcPanel atmcPanel = null;
        //新项目中控台项目详情的可视化看板数据（基于任务引擎）
        DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo = null;
        //查询任务执行的结果
        try {
            for (Future<?> future : futureList) {
                // CPU高速轮询：每个future都并发轮循，判断完成状态然后获取结果，
                // 这一行，是本实现方案的精髓所在。即有10个future在高速轮询，完成一个future的获取结果，就关闭一个轮询
                while (true) {
                    // 获取future成功完成状态，如果想要限制每个任务的超时时间，取消本行的状态判断+future.get(1000*1, TimeUnit.MILLISECONDS)+catch超时异常使用即可。
                    if (future.isDone() && !future.isCancelled()) {
                        //获取结果
                        Object obj = future.get();
                        if (obj instanceof DigiwinAtmcTaskReadCount) {
                            atmcTaskReadCount = (DigiwinAtmcTaskReadCount) obj;
                        }
                        if (obj instanceof DigiwinAtmcPanel) {
                            atmcPanel = (DigiwinAtmcPanel) obj;
                        }
                        if (obj instanceof DigiwinAtmcEnginePanelInfo) {
                            atmcEnginePanelInfo = (DigiwinAtmcEnginePanelInfo) obj;
                        }
                        if (obj instanceof List) {
                            reassignReportList = (List<DigiwinReassignReport>) obj;
                        }
                        break;//当前future获取结果完毕，跳出while
                    } else {
                        //每次轮询休息1毫秒（CPU纳秒级），避免CPU高速轮循耗空CPU---》新手别忘记这个
                        Thread.sleep(1);
                    }
                }
            }
        } catch (InterruptedException | ExecutionException e) {
            log.error(e.getLocalizedMessage());
            e.printStackTrace();
            String message = e.getMessage();
            if (null != e.getCause()) {
                message = e.getCause().getMessage();
            }
            throw new ServiceException(message);
        } finally {

        }
        stopWatch.stop();

        String tmTaskId;
        String tmActivityId;

        Assert.notNull(atmcEnginePanelInfo, "atmcEnginePanelInfo must not null!");
        Assert.notNull(atmcEnginePanelInfo.getRoute(), "atmcEnginePanelInfo.route must not null!");
        Assert.notNull(atmcEnginePanelInfo.getTask(), "atmcEnginePanelInfo.task must not null!");

        tmTaskId = atmcEnginePanelInfo.getTask().getTmTaskId();
        List<DigiwinAtmcEngineActivity> activityList = atmcEnginePanelInfo.getRoute().getSelectRoute().getActivities();
        List<DigiwinAtmcEngineTaskCode> taskCodes = new ArrayList<>();
        for (DigiwinAtmcEngineActivity activity : activityList) {
            if (activity != null && activity.getTaskCodes() != null) {
                taskCodes.addAll(activity.getTaskCodes());
            }
        }

        Map<String, Object> projectInfoDetail = getProjectInfo(apiRequest, atmcEnginePanelInfo);
        String projectStatus = MapUtils.getString(projectInfoDetail, "project_status");
        Optional<DigiwinAtmcEngineTaskCode> taskCodeOptional = taskCodes.stream().filter(taskCode -> {
                    // 未启动项目走项目编辑页，其他走不可编辑页
                    if (Objects.equals(projectStatus, TASK_STATUS_NOT_STARTED)) {
                        return ProjectStringUtil.KSC_PROJECT_TYPE_PROGRESS_MAINTENANC_ACTIVITY.equalsIgnoreCase(taskCode.getId());
                    }
                    return ProjectStringUtil.KSC_PROJECT_TYPE_PROGRESS_TRACK_ACTIVITY.equalsIgnoreCase(taskCode.getId());
                }
        ).findFirst();
        if (!taskCodeOptional.isPresent()) {
            return UiBotModel.emptyUibotModel(apiRequest.getLocale());
        }
        tmActivityId = taskCodeOptional.get().getId();
        atmcPanel = new DigiwinAtmcPanel();
        atmcPanel.setTask(atmcEnginePanelInfo.getTask());

        List<Map<String, Object>> projectDetailDataStateList = this.digiwinPcUiBotProxyService
                .getProjectDetailByProjectId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(),
                        apiRequest.getDataId(), tmTaskId, tmActivityId);

        // FIXME 这里数据源有多个，先以项目中控台的需求取第一个，后面做到其他项目详情时需要再改
        if (projectDetailDataStateList == null || projectDetailDataStateList.isEmpty()) {
            return UiBotModel.emptyUibotModel(apiRequest.getLocale());
        }
        Map<String, Object> projectDetailDataState = projectDetailDataStateList.get(0);

        UiBotModel pcUiBotModel = this.digiwinPcUiBotProxyService.actionShow(
                apiRequest.getLocale(), apiRequest.getIamUserToken(),
                JsonUtil.javaObjectToJsonString(projectDetailDataState)
        );

        // 针对API返回的PC端UiBotModel进行解析，并转换为移动端所需接口格式
        Assert.notNull(pcUiBotModel, "project detail must have uibotmodel data!");

        stopWatch.start("Build Project-Detail Page Data");

        if (ProjectTypeUtil.KSC_PROJECT_EDIT_PLAN_TYPE.equals(ProjectStringUtil.getProjectBuildTypeByDetailPatternCategory(tmTaskId, tmActivityId))
                && Objects.equals(projectStatus, TASK_STATUS_NOT_STARTED)) {
            pageSetting = pageSettingService.findById(PageSettingIdPresetEnum.MOBILE_ATHENA_SYSTEM_CLOUD_HOUSE_KEEPER_PROJECT_EDIT_PLAN_DETAIL.name());
            //存放流程变量信息
            apiRequest.getRawData().put("projectDetailDataState", projectDetailDataState);
        }

        Map<String, Object> projectDetail;
        // 根据pcUiBotModel的内容，组出projectDetail内的组件信息
        projectDetail = this.projectDetailBuildStrategyFactory
                .get(ProjectStringUtil.getProjectBuildTypeByDetailPatternCategory(tmTaskId, tmActivityId))
                .build(apiRequest, apiRequest.getIamUserToken(), pageSetting, pcUiBotModel, atmcPanel);
        stopWatch.stop();

        PccProjectInfo projectInfo = (PccProjectInfo) projectDetail.get("project_info");
        projectDetail.remove("project_info");

        stopWatch.start("Build Common Page Model");
        UiBotModel uiBotModel = this.uiBotModelBuildService.buildModel(pageSetting, projectDetail, true);
        stopWatch.stop();

        // 左右滑页面的标题处理
        String athenaProjectName = Optional.ofNullable(atmcPanel).map(DigiwinAtmcPanel::getTask)
                .map(DigiwinAtmcPanelTask::getName).orElse("");
        // 右滑摇人标题
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getLeft() != null) {
            SlipTitle slipTitle = uiBotModel.getSlip().getSlipConfig().getLeft().getSubTitle();
            slipTitle.setContent(athenaProjectName + " " + LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "当前沟通"));
            SlipConfigLeft left = uiBotModel.getSlip().getSlipConfig().getLeft();

            //先查EOC、IAM等账号信息（不包含邮箱、手机号等）
            List<DigiwinAtmcBacklogPerformer> backlogPerformers = digiwinAtmcProxyService.getPerformerListByProjectId(apiRequest.getDataId(),
                    apiRequest.getIamUserToken(), apiRequest.getLocale(), apiRequest.getTenantId());
            //在查邮箱、手机号等信息
            EocPersonResponse eocPersonResponse = digiwinEocProxyService.getSimplePersonList(
                    apiRequest.getIamUserToken(), 9999, 1, "");
            SlipConfigLeft.setPersonListByBacklog(left, backlogPerformers, eocPersonResponse);
        }


        // 支持转派功能，只有非分享的项目中控台的项目卡才支持转派
        if (atmcEnginePanelInfo != null && atmcEnginePanelInfo.getReassign() != null && !isShare) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            Map<String, Object> buttonActionRawData = new HashMap<>(atmcEnginePanelInfo.getReassign());
            buttonActionRawData.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", atmcEnginePanelInfo.getTask());
            buttonActionRawData.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());

            buttons.add(Button.createApprovalReassign(apiRequest.getDataId() + "",
                    buttonActionRawData,
                    apiRequest.getLocale(), "PROJECT", 58926));

            Map<String, Object> rawDataInAppbarButton = new HashMap<>(atmcEnginePanelInfo.getReassign());
            rawDataInAppbarButton.put("appCode", atmcEnginePanelInfo.getTask().getAppCode());
            rawDataInAppbarButton.put("project_type", atmcEnginePanelInfo.getTask().getTmTaskId());
            buttons.add(Button.createShareWithOthers(apiRequest.getDataId(),
                    JsonUtil.objectToJavaObject(rawDataInAppbarButton, Map.class),
                    apiRequest.getLocale(), localeService));
        }
        if (atmcPanel != null && atmcPanel.getReassign() != null && !isShare) {
            List<Button> buttons = uiBotModel.getAppbarButtonList();
            // TODO 未来项目详情加载性能优化点：需要将该数据放在转派开窗时加载
            // 如果项目详情中找不到可转派的用户清单，再单独调用平台新接口获取
            if (null == atmcPanel.getReassign().getReassignUsers()) {
                List<DigiwinAtmcReassignUser> batchReassignUsers = this.digiwinAtmcProxyService
                        .batchGetProjectReassignUsers(atmcPanel.getTask(), apiRequest.getIamUserToken(),
                                apiRequest.getLocale(), apiRequest.getTenantId());
                atmcPanel.getReassign().setReassignUsers(batchReassignUsers);
            }
            Map<String, Object> buttonActionRawData = new HashMap<>(JsonUtil.objectToJavaObject(atmcPanel.getReassign(), Map.class));
            buttonActionRawData.put("appCode", atmcPanel.getTask().getAppCode());
            buttonActionRawData.put("projectDetail", atmcPanel.getTask());
            buttonActionRawData.put("project_type", atmcPanel.getTask().getTmTaskId());

            buttons.add(Button.createApprovalReassign(apiRequest.getDataId() + "",
                    JsonUtil.objectToJavaObject(buttonActionRawData, Map.class),
                    apiRequest.getLocale(), "PROJECT", 58926));

            Map<String, Object> rawDataInAppbarButton = JsonUtil.objectToJavaObject(atmcPanel.getReassign(), Map.class);
            rawDataInAppbarButton.put("appCode", atmcPanel.getTask().getAppCode());
            rawDataInAppbarButton.put("project_type", atmcPanel.getTask().getTmTaskId());
            buttons.add(Button.createShareWithOthers(apiRequest.getDataId(),
                    JsonUtil.objectToJavaObject(rawDataInAppbarButton, Map.class),
                    apiRequest.getLocale(), localeService));
        }
        if (!CollectionUtils.isEmpty(reassignReportList)) {
            List<UiBotLayout> layouts = uiBotModel.getLayout();
            for (UiBotLayout layout : layouts) {
                if (TitleBody.COMPONENT_TYPE.equals(layout.getType())) {
                    TitleBody titleBody = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleBody.class);
                    List<Tag> tags = titleBody.getTags();
                    if (tags == null) {
                        tags = new ArrayList<>();
                    } else {
                        for (Tag tag : tags) {
                            if (LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "转派").equals(tag.getText())) {
                                tags.remove(tag);
                                break;
                            }
                        }
                    }
                    Tag tag = Tag.createOnlyTextStateTag(String.format(
                                    LocaleUtil.getMobileTextByKey(apiRequest.getLocale(), "由转派"),
                                    reassignReportList.get(0).getOldPerformerName()),
                            Action.createReassignReportAction(apiRequest.getLocale(),
                                    reassignReportList));
                    tags.add(tag);
                    uiBotModel.getPageData().put(layout.getSchema(), titleBody);
                    break;
                } else {
                    if (PageDesc.COMPONENT_TYPE.equals(layout.getType())) {
                        PageDesc pageDesc = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), PageDesc.class);
                        List<PageDescContent> pageDescContents = pageDesc.getContent();
                        pageDescContents.add(PageDescContent.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                        uiBotModel.getPageData().put(layout.getSchema(), pageDesc);
                    }
                    if (TitleDesc.COMPONENT_TYPE.equals(layout.getType())) {
                        TitleDesc titleDesc = JsonUtil.objectToJavaObject(uiBotModel.getPageData().get(layout.getSchema()), TitleDesc.class);
                        List<Label> labels = titleDesc.getLabelList();
                        labels.add(Label.buildReassignReport(apiRequest.getLocale(), reassignReportList));
                        uiBotModel.getPageData().put(layout.getSchema(), titleDesc);
                    }
                }
            }
        }

        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }

    /**
     * 详情二级页面
     *
     * @param pageSetting
     * @param apiRequest
     * @return
     */
    private UiBotModel buildKscProjectNextLevelTaskList(PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel pageModel = pageSetting.getPageModel();
        String taskNo = apiRequest.getDataId();
        String projectNo = (String) apiRequest.getRawData().get("projectNo");
        // 参考：com.digiwin.mobile.mobileuibot.project.model.projectcc.ProjectCCTaskItem#create()方法设置ApiRawData的做法，这边做解析
        List<PccProjectTaskInfo> allProjectTaskInfoList =
                apiRequest.getRawData().getJSONArray("data").toJavaList(PccProjectTaskInfo.class);
        for (UiBotLayout layout : pageModel.getLayout()) {
            // FIXME 后面要改成组件生成策略工厂来做，且目前使用字面量为写死的逻辑
            if (TaskCrumbs.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                // 筛选出taskNo的下级任务
                List<PccProjectTaskInfo> processedTaskList = allProjectTaskInfoList
                        .stream()
                        // 排除自己
                        .filter(projectTaskInfo ->
                                !projectTaskInfo.getTaskNo().equalsIgnoreCase(taskNo))
                        // 获取下级任务
                        .filter(projectTaskInfo -> projectTaskInfo.getUpperLevelTaskNo().equalsIgnoreCase(taskNo))
                        // 筛选出第一级的任务，并按业务逻辑(sequence)正序排序
                        .sorted(Comparator.comparingInt(PccProjectTaskInfo::getSequence))
                        .collect(Collectors.toList());
                // 转换为taskItem后，返回给前端
                List<ProjectCCTaskItem> taskItemList = processedTaskList
                        .stream()
                        .map(projectTaskInfo ->
                                ProjectCCTaskItem.createKsc(apiRequest.getLocale(), projectTaskInfo, allProjectTaskInfoList, true, apiRequest.getIamUserToken(), projectNo))
                        .collect(Collectors.toList());

                Map<String, Object> crumbsMap = new HashMap<>();
                crumbsMap.put("data", taskItemList);
                Optional<PccProjectTaskInfo> pccProjectTaskInfoOptional = allProjectTaskInfoList.stream()
                        .filter(projectTaskInfo -> projectTaskInfo.getTaskNo().equalsIgnoreCase(taskNo))
                        .findFirst();
                String taskName = "";
                if (pccProjectTaskInfoOptional.isPresent()) {
                    taskName = pccProjectTaskInfoOptional.get().getTaskName();
                }

                crumbsMap.put("crumbsRoot", taskName);

                pageModel.getPageData().put(layout.getSchema(), crumbsMap);
            }
            if (BottomButtonDigiwinAthena.COMPONENT_TYPE.equals(layout.getType())) {
                BottomButtonList bottomButtonList = JsonUtil.objectToJavaObject(
                        pageModel.getPageData().get(layout.getSchema()),
                        BottomButtonList.class
                );
                bottomButtonList.forEach(bottomButtonDigiwinAthena -> {
                    String nameKey = bottomButtonDigiwinAthena.getName();
                    bottomButtonDigiwinAthena.setName(LocaleUtil.getMobileTextByDatabaseKey(apiRequest.getLocale(), nameKey));
                });
                pageModel.getPageData().put(layout.getSchema(), bottomButtonList);
            }
        }

        return this.uiBotModelBuildService.buildModel(pageSetting, pageModel.getPageData());
    }

    /**
     * 返回项目信息
     *
     * @param apiRequest
     * @param apiRequest
     * @return
     */
    private Map<String, Object> getProjectInfo(ApiRequest apiRequest, DigiwinAtmcEnginePanelInfo atmcEnginePanelInfo) {
        String projectNo = Optional.ofNullable(atmcEnginePanelInfo.getTask())
                .map(DigiwinAtmcPanelTask::getSourceIds).orElse("");

        if (StringUtils.isEmpty(projectNo)) {
            throw new ServiceException("projectNo is empty!");
        }

        Map<String, Object> bodyPayloadMap = new HashMap<>(4);
        bodyPayloadMap.put("actionId", "bm.pisc.project.get");

        Map<String, Object> projectInfoMap = new HashMap<>(1);
        projectInfoMap.put("project_no", projectNo);

        Map<String, Object> parameter = new HashMap<>(1);
        parameter.put("project_info", Collections.singletonList(projectInfoMap));
        bodyPayloadMap.put("parameter", parameter);

        DigiwinAthenaApiResponse<JSONObject> resp = digiwinAtdmProxyService
                .handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId(), "", bodyPayloadMap);
        if (resp.getStatus() == 200 && StringUtils.isEmpty(resp.getErrorMessage())) {
            return Optional.ofNullable(resp.getResponse())
                    .map(e -> (List<Map<String, Object>>) e.get("project_info"))
                    .map(e -> e.get(0))
                    .orElse(Collections.emptyMap());
        }
        return Collections.emptyMap();
    }
}
