package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.ksc;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccTailTaskProductItemTab;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccTailTaskProductItemTabList;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccTaskDetailSummary;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.ProcessStatusEnum;
import com.digiwin.mobile.mobileuibot.core.component.tab.tabs.TabsComponent;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：体系云管家（KSC）项目详情中的任务详情页面的生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildKscTailTaskStrategy
 * @Author: Zaregoto
 * @Date: 2022/5/16 14:57
 */
@Component("uiBotModelBuildKscTailTaskStrategy")
public class UiBotModelBuildKscTailTaskStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildKscTailTaskStrategy.class);

    @Autowired
    private DigiwinEspProxyService digiwinEspProxyService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("KSC Detail Task");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        PccProjectTaskInfo taskInfo = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("taskInfo"), PccProjectTaskInfo.class);
        //项目名称
        String projectNo = taskInfo.getProjectNo();
        //任务名称
        String taskNo = taskInfo.getTaskNo();
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();

        // 拼成最终数据
        stopWatch.start("Build KscTailTask Detail Page Model...");
        List<UiBotLayout> uiBotLayouts = uiBotModel.getLayout();
        for (UiBotLayout layout : uiBotLayouts) {
            //获取头部组件信息
            if (PccTaskDetailSummary.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                PccTaskDetailSummary projectCCTaskItem = PccTaskDetailSummary.createKsc(locale, taskInfo, true, userToken, projectNo);
                uiBotModel.getPageData().put(layout.getSchema(), projectCCTaskItem);
            }

            if (TabsComponent.COMPONENT_TYPE.equalsIgnoreCase(layout.getType())) {
                PccTailTaskProductItemTabList pccTailTaskProductItemTabList = this.getOrdTaskCategoryDetailData(apiRequest, taskInfo);
//                switch (taskCategory.toUpperCase()) {
//                    case "ORD":
//                    case "1": //试验北斗-产品设计和开发
//                    case "2": //试验北斗-过程设计和开发
//                    case "3": //试验北斗-产品与过程确认
//                    case "4": //试验优测-试验检测
//                        pccTailTaskProductItemTabList = this.getOrdTaskCategoryDetailData(apiRequest, taskInfo);
//                        break;
//                    case "PLM":
//                        // TODO 待后台有数据后，需验证
//                        pccTailTaskProductItemTabList = this.getPlmTaskCategoryDetailData(apiRequest, taskInfo);
//                        break;
//                    case "PLM_PROJECT":
//                        // TODO 待后台有数据后，需验证
//                        pccTailTaskProductItemTabList = this.getPlmProjectTaskCategoryDetailData(apiRequest, taskInfo);
//                        break;
//                    case "MES":
//                        // TODO 待后台有数据后，需验证
//                        pccTailTaskProductItemTabList = this.getMesTaskCategoryDetailData(apiRequest, taskInfo);
//                        break;
//                    case "REVIEW":
//                        pccTailTaskProductItemTabList = this.getReviewTaskCategoryDetailData(apiRequest, taskInfo);
//                        break;
//                    default:
//                        pccTailTaskProductItemTabList = this.getOtherTaskCategoryDetailData(apiRequest, taskInfo);
//                        break;
//                }
                uiBotModel.getPageData().put(layout.getSchema(), pccTailTaskProductItemTabList);
            }
        }
        stopWatch.stop();
        return uiBotModel;
    }

    //若api获取不到数据就造假数据测试下。
    public List<Map<String, Object>> getDocInfoResponses(List<Map<String, Object>> docInfoResponses) {
        if (docInfoResponses.size() == 0) {
            Map<String, Object> docInfoMap = new HashMap<>();
            docInfoMap.put("accepted_return_qty", 0);
            docInfoMap.put("actual_finish_date", "");
            docInfoMap.put("actual_start_date", "");
            docInfoMap.put("close_status", "N");
            docInfoMap.put("complete_qty", 0);
            docInfoMap.put("complete_rate", 0);
            docInfoMap.put("contract_date", "");
            docInfoMap.put("contract_name", "");
            docInfoMap.put("contract_no", "");
            docInfoMap.put("customer_name", "");
            docInfoMap.put("delivery_qty", 0);
            docInfoMap.put("demand_date", "");
            docInfoMap.put("feed_qty", 0);
            docInfoMap.put("instalment_trans_curr_amount", 0);
            docInfoMap.put("issue_set_qty", 0);
            docInfoMap.put("item_name_spec", "變壓器");
            docInfoMap.put("item_no", "2-2-31-0000210");
            docInfoMap.put("op_name", "");
            docInfoMap.put("op_type", "");
            docInfoMap.put("out_plan_time", "Y");
            docInfoMap.put("payment_method", "");
            docInfoMap.put("plan_date_e", "");
            docInfoMap.put("plan_delivery_date", "2022-04-28");
            docInfoMap.put("plan_start_date", "");
            docInfoMap.put("process_no", "");
            docInfoMap.put("process_seq", "");
            docInfoMap.put("production_qty", 0);
            docInfoMap.put("project_leader_code", "igp-13");
            docInfoMap.put("project_leader_name", "ERP專案經理");
            docInfoMap.put("project_name", "TY-001");
            docInfoMap.put("project_no", "TY-001");
            docInfoMap.put("purchase_no", "331-110426001");
            docInfoMap.put("purchase_qty", 1);
            docInfoMap.put("purchase_seq", "0001");
            docInfoMap.put("purchase_sub_seq", "");
            docInfoMap.put("purchaser_name", "");
            docInfoMap.put("reference_doc_no", "");
            docInfoMap.put("reference_type_no", "");
            docInfoMap.put("requisitions_no", "");
            docInfoMap.put("requisitions_qty", 0);
            docInfoMap.put("shipping_date", "");
            docInfoMap.put("shipping_qty", 0);
            docInfoMap.put("so_no", "");
            docInfoMap.put("so_qty", 0);
            docInfoMap.put("status", "N");
            docInfoMap.put("stock_in_qty", 0);
            docInfoMap.put("supplier_name", "");
            docInfoMap.put("task_no", "51");
            docInfoMap.put("trans_curr_ar_amount", 0);
            docInfoMap.put("trans_curr_received_amount", 0);
            docInfoMap.put("trans_currency", "");
            docInfoMap.put("trans_currency_name", "");
            docInfoMap.put("wo_no", "331-110426001");
            docInfoResponses.add(docInfoMap);

            Map<String, Object> docInfoMap1 = new HashMap<>();
            docInfoMap1.put("accepted_return_qty", 0);
            docInfoMap1.put("actual_finish_date", "");
            docInfoMap1.put("actual_start_date", "");
            docInfoMap1.put("close_status", "N");
            docInfoMap1.put("complete_qty", 0);
            docInfoMap1.put("complete_rate", 0);
            docInfoMap1.put("contract_date", "");
            docInfoMap1.put("contract_name", "");
            docInfoMap1.put("contract_no", "");
            docInfoMap1.put("customer_name", "");
            docInfoMap1.put("delivery_qty", 0);
            docInfoMap1.put("demand_date", "");
            docInfoMap1.put("feed_qty", 0);
            docInfoMap1.put("instalment_trans_curr_amount", 0);
            docInfoMap1.put("issue_set_qty", 0);
            docInfoMap1.put("item_name_spec", "高壓電容(85度C)100uf/400V22*30");
            docInfoMap1.put("item_no", "3-1-04-39A3-100");
            docInfoMap1.put("op_name", "");
            docInfoMap1.put("op_type", "");
            docInfoMap1.put("out_plan_time", "Y");
            docInfoMap1.put("payment_method", "");
            docInfoMap1.put("plan_date_e", "");
            docInfoMap1.put("plan_delivery_date", "2022-04-28");
            docInfoMap1.put("plan_start_date", "");
            docInfoMap1.put("process_no", "");
            docInfoMap1.put("process_seq", "");
            docInfoMap1.put("production_qty", 0);
            docInfoMap1.put("project_leader_code", "igp-13");
            docInfoMap1.put("project_leader_name", "ERP專案經理");
            docInfoMap1.put("project_name", "TY-001");
            docInfoMap1.put("project_no", "TY-001");
            docInfoMap1.put("purchase_no", "331-110426002");
            docInfoMap1.put("purchase_qty", 2);
            docInfoMap1.put("purchase_seq", "0002");
            docInfoMap1.put("purchase_sub_seq", "");
            docInfoMap1.put("purchaser_name", "");
            docInfoMap1.put("reference_doc_no", "");
            docInfoMap1.put("reference_type_no", "");
            docInfoMap1.put("requisitions_no", "");
            docInfoMap1.put("requisitions_qty", 0);
            docInfoMap1.put("shipping_date", "");
            docInfoMap1.put("shipping_qty", 0);
            docInfoMap1.put("so_no", "");
            docInfoMap1.put("so_qty", 0);
            docInfoMap1.put("status", "N");
            docInfoMap1.put("stock_in_qty", 0);
            docInfoMap1.put("supplier_name", "");
            docInfoMap1.put("task_no", "51");
            docInfoMap1.put("trans_curr_ar_amount", 0);
            docInfoMap1.put("trans_curr_received_amount", 0);
            docInfoMap1.put("trans_currency", "");
            docInfoMap1.put("trans_currency_name", "");
            docInfoMap1.put("wo_no", "331-110426002");
            docInfoResponses.add(docInfoMap1);
        }
        return docInfoResponses;

    }


    /**
     * 一般任务类型，获取明细数据，并生成组件
     *
     * @param apiRequest
     * @param taskInfo
     * @return
     */
    private PccTailTaskProductItemTabList getOrdTaskCategoryDetailData(ApiRequest apiRequest,
                                                                       PccProjectTaskInfo taskInfo) {
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();

        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        //将我需要的请求参数封装起来
        List<PccProjectTaskInfo> projectProjectInfoRequestList = new ArrayList<>();
        projectProjectInfoRequestList.add(taskInfo);
        //api获取待处理数据
        List<Map<String, Object>> pendingResponses = digiwinEspProxyService.getBmPiscAttachmentJoinRelation(eocSiteId, eocCompanyId,
                userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus(),
                taskInfo.getProjectNo(), taskInfo.getTaskNo());
        String pendingTabName = "待处理";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.createKsc(pendingTabName, pendingResponses, taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(pendingTab);

        //api获取已完成数据
        List<Map<String, Object>> completedResponses = digiwinEspProxyService.getBmPiscAttachmentJoinRelation(eocSiteId, eocCompanyId,
                userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus(),
                taskInfo.getProjectNo(), taskInfo.getTaskNo());
        String completedTabName = "已完成";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.createKsc(completedTabName, completedResponses, taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(completedTab);

        return pccTailTaskProductItemTabList;
    }

    /**
     * PLM任务类型，获取明细数据，并生成组件
     *
     * @param apiRequest
     * @param taskInfo
     * @return
     */
    private PccTailTaskProductItemTabList getPlmTaskCategoryDetailData(ApiRequest apiRequest,
                                                                       PccProjectTaskInfo taskInfo) {
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();

        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        // TODO 待与后台有数据后api验证
        List<PccProjectTaskInfo> taskInfoList = new ArrayList<>();
        taskInfoList.add(taskInfo);
        List<Map<String, Object>> todoWorkItemDataList = this.digiwinEspProxyService.getWorkItemData(eocSiteId, eocCompanyId,
                taskInfoList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());
        List<Map<String, Object>> doneWorkItemDataList = this.digiwinEspProxyService.getWorkItemData(eocSiteId, eocCompanyId,
                taskInfoList, userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());

        String pendingTabName = "待处理";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.createKsc(pendingTabName, todoWorkItemDataList,
                taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(pendingTab);

        String completedTabName = "已完成";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.createKsc(completedTabName, doneWorkItemDataList,
                taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(completedTab);


        return pccTailTaskProductItemTabList;
    }

    /**
     * PLM项目任务类型，获取明细数据，并生成组件
     *
     * @param apiRequest
     * @param taskInfo
     * @return
     */
    private PccTailTaskProductItemTabList getPlmProjectTaskCategoryDetailData(ApiRequest apiRequest,
                                                                              PccProjectTaskInfo taskInfo) {
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();

        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        // 任务状态：30.进行中;40.已结案;50.暂停;60.指定结案
        final String TASK_STATUS_DOING = "30";
        final String TASK_STATUS_COMPLETED = "40";
        final String TASK_STATUS_PAUSED = "50";
        final String TASK_STATUS_ASSIGNED_COMPLETED = "60";

        // TODO 待与后台有数据后api验证
        List<PccProjectTaskInfo> taskInfoList = new ArrayList<>();
        taskInfoList.add(taskInfo);
        List<Map<String, Object>> itemDataList = this.digiwinEspProxyService
                .getProjectTaskCompleteRateData(eocSiteId, eocCompanyId, taskInfoList, userToken, tenantId, locale);

        // 区分出待处理、已完成的任务
        List<Map<String, Object>> todoTaskList = new ArrayList<>();
        List<Map<String, Object>> doneTaskList = new ArrayList<>();
        itemDataList.forEach(map -> {
            String taskStatus = (String) map.getOrDefault("task_status", "");
            if (taskStatus.equals(TASK_STATUS_DOING) || taskStatus.equals(TASK_STATUS_PAUSED)) {
                todoTaskList.add(map);
            } else if (taskStatus.equals(TASK_STATUS_COMPLETED) || taskStatus.equals(TASK_STATUS_ASSIGNED_COMPLETED)) {
                doneTaskList.add(map);
            } else {

            }
        });

        String pendingTabName = "待处理";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.createKsc(pendingTabName, todoTaskList,
                taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(pendingTab);

        String completedTabName = "已完成";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.createKsc(completedTabName, doneTaskList,
                taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(completedTab);


        return pccTailTaskProductItemTabList;
    }

    /**
     * MES任务类型，获取明细数据，并生成组件
     *
     * @param apiRequest
     * @param taskInfo
     * @return
     */
    private PccTailTaskProductItemTabList getMesTaskCategoryDetailData(ApiRequest apiRequest,
                                                                       PccProjectTaskInfo taskInfo) {
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();

        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();

        //将我需要的请求参数封装起来
        // TODO 待与后台有数据后api验证
        List<PccProjectTaskInfo> projectWoProductionInfoRequestList = new ArrayList<>();
        projectWoProductionInfoRequestList.add(taskInfo);
        List<Map<String, Object>> todoItemDataList = digiwinEspProxyService.getProjectWoProductionInfoProcess(
                eocSiteId, eocCompanyId, projectWoProductionInfoRequestList, userToken, tenantId, locale,
                ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());
        List<Map<String, Object>> doneItemDataList = digiwinEspProxyService.getProjectWoProductionInfoProcess(
                eocSiteId, eocCompanyId, projectWoProductionInfoRequestList, userToken, tenantId, locale,
                ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());


        //生成待处理tab逻辑
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.createKsc("待处理", todoItemDataList,
                taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(pendingTab);

        //Fixme 生成已完成tab逻辑
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.createKsc("已完成", doneItemDataList,
                taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(completedTab);

        return pccTailTaskProductItemTabList;
    }

    /**
     * 项目检讨任务类型，获取明细数据，并生成组件
     *
     * @param apiRequest
     * @param taskInfo
     * @return
     */
    private PccTailTaskProductItemTabList getReviewTaskCategoryDetailData(ApiRequest apiRequest,
                                                                          PccProjectTaskInfo taskInfo) {
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();

        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        // TODO 目前review任务类型走的和ord类型一个api，review目前PC端没有数据，故沿用ord类型的显示字段
        //将我需要的请求参数封装起来
        List<PccProjectTaskInfo> projectProjectInfoRequestList = new ArrayList<>();
        projectProjectInfoRequestList.add(taskInfo);
        //api获取待处理数据
        List<Map<String, Object>> pendingResponses = digiwinEspProxyService.getBmPiscAttachmentJoinRelation(eocSiteId, eocCompanyId,
                userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus(),
                taskInfo.getProjectNo(), taskInfo.getTaskNo());
        String pendingTabName = "待处理";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.createKsc(pendingTabName, pendingResponses, taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(pendingTab);

        //api获取已完成数据
        List<Map<String, Object>> completedResponses = digiwinEspProxyService.getBmPiscAttachmentJoinRelation(eocSiteId, eocCompanyId,
                userToken, tenantId, locale, ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus(),
                taskInfo.getProjectNo(), taskInfo.getTaskNo());
        String completedTabName = "已完成";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.createKsc(completedTabName, completedResponses, taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(completedTab);

        return pccTailTaskProductItemTabList;
    }

    /**
     * 其他任务类型，获取明细数据，并生成组件
     * 其他任务类型：MO.生产、PO.采购、OD.订单、MOOP.工单制程、EXPORT.出货通知单、SHIPMENT.出货单、PR.请购、PRSUM.请购(汇总)、POSUM.采购(汇总)、POPUR.采购进货明细
     *
     * @param apiRequest
     * @param taskInfo
     * @return
     */
    private PccTailTaskProductItemTabList getOtherTaskCategoryDetailData(ApiRequest apiRequest,
                                                                         PccProjectTaskInfo taskInfo) {
        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();
        String eocCompanyId = taskInfo.getEocCompanyId();
        String eocSiteId = taskInfo.getEocSiteId();
        String tenantId = apiRequest.getTenantId();

        PccTailTaskProductItemTabList pccTailTaskProductItemTabList = new PccTailTaskProductItemTabList();
        //将我需要的请求参数封装起来
        List<PccProjectTaskInfo> projectDocInfoRequestList = new ArrayList<>();
        projectDocInfoRequestList.add(taskInfo);

        // 此处不能通过查出所有数据后，自行过滤。因为api的响应参数中，结案状态(close_status)可能是空，无法判断
        //api获取待处理数据
        List<Map<String, Object>> todoItemList = digiwinEspProxyService.getProjectDocInfoProcess(
                eocSiteId, eocCompanyId, projectDocInfoRequestList, userToken, tenantId, locale,
                ProcessStatusEnum.PROCESS_STATUS_PENDING.getProcessStatus());

        //api获取已完工数据
        List<Map<String, Object>> doneItemList = digiwinEspProxyService.getProjectDocInfoProcess(
                eocSiteId, eocCompanyId, projectDocInfoRequestList, userToken, tenantId, locale,
                ProcessStatusEnum.PROCESS_STATUS_COMPLETED.getProcessStatus());

        //待处理数据
        String pendingTabName = "待处理";
        PccTailTaskProductItemTab pendingTab = PccTailTaskProductItemTab.createKsc(pendingTabName, todoItemList, taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(pendingTab);

        //已完成数据
        String completedTabName = "已完成";
        PccTailTaskProductItemTab completedTab = PccTailTaskProductItemTab.createKsc(completedTabName, doneItemList, taskCategory, apiRequest, taskInfo);
        pccTailTaskProductItemTabList.add(completedTab);

        return pccTailTaskProductItemTabList;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        PccProjectTaskInfo taskInfo = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("taskInfo"), PccProjectTaskInfo.class);
        //任务类型
        String taskCategory = taskInfo.getTaskCategory();
        if ("PO".equalsIgnoreCase(taskCategory)) {
            data = FileUtil.readText("static/tail_task_detail_with_material.json");
        } else {
            data = FileUtil.readText("static/tail_task_detail_without_material.json");
        }

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
