package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.pcc;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.file.FileUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.localization.LocaleUtil;
import com.digiwin.mobile.mobileuibot.core.UiBotModelBuildService;
import com.digiwin.mobile.mobileuibot.core.appec.LeftHeader;
import com.digiwin.mobile.mobileuibot.core.component.MobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.basic.FieldAlignmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.business.pcc.PccStringUtil;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentFile;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentRawDataDigiwinAthena;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.AttachmentTypeEnum;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.aam.model.AttachmentDetail;
import com.digiwin.mobile.mobileuibot.proxy.aam.service.DigiwinAamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.dmc.config.DigiwinDmcConfig;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.attachment.UiBotAttachmentData;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.table.UiBotTableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>功能描述：项目中控台（PCC）任务详情中料件详情页面的生成策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBuildPccMaterialStrategy
 * @Author: Liux
 * @Date: 2022/5/16 14:57
 */
@Component("uiBotModelBuildPccMaterialStrategy")
public class UiBotModelBuildPccMaterialStrategy implements UiBotModelBuildStrategy {

    private static final Logger logger =
            LoggerFactory.getLogger(UiBotModelBuildPccMaterialStrategy.class);

    private static String[] taskCategoryArray = new String[]{"ORD", "PLM", "PLM_PROJECT", "MES,REVIEW", "POSUM", "1", "2", "3", "4"};


    @Autowired
    private UiBotModelBuildService uiBotModelBuildService;

    @Autowired
    private DigiwinAamProxyService digiwinAamProxyService;

    @Autowired
    private LocaleService localeService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest)
            throws IOException {
        StopWatch stopWatch = new StopWatch("BuildDashboard");
        Boolean useMockData = AppContext.getUseMockData();
        Boolean modelTypeShow =
                AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(pageSetting, apiRequest, stopWatch);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        logger.debug(stopWatch.prettyPrint());

        return uiBotModel;
    }

    private UiBotModel doActually(PageSetting pageSetting, ApiRequest apiRequest,
                                  StopWatch stopWatch) {
        UiBotModel uiBotModel = pageSetting.getPageModel();
        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();

        // 待处理组件和数据绑定的逻辑
        String userToken = apiRequest.getIamUserToken();
        String locale = apiRequest.getLocale();

        JSONObject productItem = apiRequest.getRawData().getJSONObject("productItem");
        JSONObject taskInfo = apiRequest.getRawData().getJSONObject("taskInfo");

        String purchaseNo = productItem.getString("purchase_no");
        String projectNo = productItem.getString("project_no");
        String taskNo = productItem.getString("task_no");
        String itemNo = productItem.getString("item_no");
        String itemNameSpec = productItem.getString("item_name_spec");
        String eocCompanyId = taskInfo.getString("eoc_company_id");
        String taskCategory = taskInfo.getString("task_category");

        boolean isNotOtherCategory = Arrays.stream(taskCategoryArray).anyMatch(e -> e.equalsIgnoreCase(taskCategory));

        String[] fieldArray = PccStringUtil.getFieldsByTaskCategory(taskCategory, false);
        for (String field : fieldArray) {
            if (!productItem.containsKey(field)) {
                continue;
            }
            MobileComponent itemContentComponent = null;
            if ("attachment".equals(field)) {
                // PCC定制页面，没有元数据，无法知晓栏位信息，故手工硬编码实现
                JSONObject rawAttachmentData = productItem.getJSONObject(field);
                if (CollectionUtils.isEmpty(rawAttachmentData.getJSONArray("data"))) {
                    continue;
                }
                UiBotTableColumn manualCreatedColumn = new UiBotTableColumn();
                manualCreatedColumn.setSchema(field);
                manualCreatedColumn.setHeaderName(LocaleUtil.getMobileTextByKey(locale, field));
                manualCreatedColumn.doSetCanNotEdit();
                itemContentComponent = Attachment.create(Attachment.class, locale, manualCreatedColumn, productItem);
            } else {
                String label = LocaleUtil.getMobileTextByKey(locale, field);
                String valueStr = productItem.getString(field);
                valueStr = PccStringUtil.getValueShowText(locale, taskCategory, field, valueStr);
                // 品名规格，使用item_name_spec_02 ，包含了品名和规格，中间web端用</br>来换行将规格展示在品名下面，移动需要替换为\n
                if ("item_name_spec_02".equals(field) && !isNotOtherCategory){
                    valueStr = valueStr.replace("</br>", "\n");
                    label = LocaleUtil.getMobileTextByKey(locale, "item_name_spec");
                }
                if (valueStr.trim().isEmpty()) {
                    // 只读的话，空值，移动不显示

                    // taskCategory 为other 同时只是项目中控台的 才在值为空的时候显示横杠
                    if (!isNotOtherCategory) {
                        valueStr = "-";
                    } else {
                        continue;
                    }
                }
                itemContentComponent = Field.create(
                        label,
                        valueStr,
                        FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT, false);

                UiBotLayout fieldLayout = new UiBotLayout();
                fieldLayout.setType(Field.COMPONENT_TYPE);
                fieldLayout.setSchema(field);
                uiBotModel.addLayout(fieldLayout);
            }

            uiBotModel.getPageData().put(field, itemContentComponent);
        }

        //交付物，附件展示
        List<String> attachmentFields = Arrays.asList("manualAssignmentDelivery", "manualAssignmentAttachment");

        //调用接口获取文件
        String rowDataKey = projectNo + ";" + taskNo + ";";
        List<AttachmentDetail> attachmentMessageList = digiwinAamProxyService.attachment(attachmentFields, Collections.singletonList(rowDataKey), "",
                apiRequest.getTenantId(), userToken);

        Map<String, List<AttachmentDetail>> attachmentMessageMapByCategory = Collections.emptyMap();
        if (!CollectionUtils.isEmpty(attachmentMessageList)) {
            attachmentMessageMapByCategory = attachmentMessageList.stream().collect(Collectors.groupingBy(AttachmentDetail::getCategory));
        }

        for (String attachmentField : attachmentFields) {
            String label = localeService.getLanguageValue(locale,
                    Objects.equals(attachmentField, "manualAssignmentDelivery") ? "交付物" : "附件");

            List<AttachmentDetail> attachmentMessageListByCategory = attachmentMessageMapByCategory.get(attachmentField);

            //交付物，附件没值展示横杠
            if (CollectionUtils.isEmpty(attachmentMessageListByCategory)) {
                UiBotLayout fieldLayout = new UiBotLayout();
                fieldLayout.setType(Field.COMPONENT_TYPE);
                fieldLayout.setSchema(attachmentField);
                uiBotModel.addLayout(fieldLayout);

                Field field = Field.create(label, "-", FieldAlignmentTypeEnum.LABEL_LEFT_VALUE_LEFT, false);
                uiBotModel.getPageData().put(attachmentField, field);
                continue;
            }

            Attachment attachment = new Attachment();
            attachment.setType(AttachmentTypeEnum.READ_ONLY.getValue());

            List<UiBotAttachmentData> uiBotAttachmentDataList = attachmentMessageListByCategory.stream().map(item -> {
                UiBotAttachmentData uiBotAttachmentData = new UiBotAttachmentData(item.getId(), item.getName(),
                        Double.valueOf(Objects.nonNull(item.getSize()) ? item.getSize() : 0),
                        item.getUploadUserName(), item.getCreateDate());
                return uiBotAttachmentData;
            }).collect(Collectors.toList());

            for (UiBotAttachmentData uibotAttachData : uiBotAttachmentDataList) {
                AttachmentFile attachmentFile = AttachmentFile.create(locale, uibotAttachData);
                attachment.getFileList().add(attachmentFile);
            }

            attachment.setTitle(label);
            AttachmentRawDataDigiwinAthena rawDataDigiwinAthena = new AttachmentRawDataDigiwinAthena();
            rawDataDigiwinAthena.setBuckets(DigiwinDmcConfig.ATHENA_BUCKET);
            rawDataDigiwinAthena.setDisableAam(true);
            attachment.setRawData(rawDataDigiwinAthena);

            UiBotLayout fieldLayout = new UiBotLayout();
            fieldLayout.setType(Attachment.COMPONENT_TYPE);
            fieldLayout.setSchema(attachmentField);
            uiBotModel.addLayout(fieldLayout);

            uiBotModel.getPageData().put(attachmentField, attachment);
        }

        // 没有料号的任务类型，去除左滑辅助资讯页面
//        if ("ORD".equals(taskCategory) || "PLM".equals(taskCategory) || "PLM_PROJECT".equals(taskCategory) || "ODAR".equals(taskCategory)) {
//            uiBotModel.getSlip().setSlipType(SlipTypeEnum.NO_SLIP.getValue());
//        } else {
        //传参数给左滑推荐资讯
        if (uiBotModel.getSlip().getSlipConfig() != null && uiBotModel.getSlip().getSlipConfig().getRight() != null) {
            LeftHeader header = uiBotModel.getSlip().getSlipConfig().getRight().getHeader();
            header.getSubTitle().setContent(taskInfo.getString("task_name"));
            if (uiBotModel.getSlip().getSlipConfig().getRight().getBody() != null) {
                Map<String, Object> params = uiBotModel.getSlip().getSlipConfig().getRight().getBody().getJumpConfig().getParams();
                params.put("purchase_no", purchaseNo);
                params.put("item_no", itemNo);
                params.put("item_name_spec", itemNameSpec);
                params.put("eoc_company_id", eocCompanyId);
                params.put("item_type", taskCategory);
                params.put("project_no", projectNo);
                params.put("task_no", taskNo);
            }
        }
//        }

        return uiBotModel;
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        try {
            Thread.sleep(100L);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        String data;
        UiBotModel uiBotModel = null;

        JSONObject taskInfo = apiRequest.getRawData().getJSONObject("taskInfo");
        //任务类型
        String taskCategory = taskInfo.getString("task_category");
        if ("PO".equalsIgnoreCase(taskCategory)) {
            data = FileUtil.readText("static/with_material_detail_.json");
        } else {
            data = FileUtil.readText("static/without_material_detail.json");
        }

        if (null != data && !data.isEmpty()) {
            uiBotModel = JsonUtil.jsonStringToObject(data, UiBotModel.class);
        }

        return uiBotModel;
    }
}
