package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRawData;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.common.BackgroundColorEnum;
import com.digiwin.mobile.mobileuibot.core.component.*;
import com.digiwin.mobile.mobileuibot.core.component.layout.singlelistcontainer.SingleListContainer;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzerFactory;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.UiBotModelBuildStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotMultipleDataSourceService;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.service.PcRuleService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：Athena V2版--条目详情页面通用解析页面--抽象类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: AbstractUniversalParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/10/20 11:34
 */
@Slf4j
@Component
public abstract class AbstractUniversalParsingPageStrategy<T extends AbstractEntity> implements UiBotModelBuildStrategy {

    @Autowired
    protected PcRuleService pcRuleService;

    @Autowired
    protected UiBotDesignerRenderService uiBotDesignerRenderService;

    @Autowired
    protected ComponentParamAnalyzerFactory componentParamAnalyzerFactory;

    @Autowired
    private UiBotMultipleDataSourceService uiBotMultipleDataSourceService;

    protected UiBotModel buildModel(T absEntity, PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        Boolean useMockData = AppContext.getUseMockData();
        boolean modelTypeShow = AppRequestContext.requestNeedShowMockData();
        UiBotModel uiBotModel;
        if (!useMockData && !modelTypeShow) {
            uiBotModel = this.doActually(absEntity, pageSetting, apiRequest);
        } else {
            uiBotModel = this.doMockData(pageSetting, apiRequest);
        }
        return uiBotModel;
    }

    public UiBotModel doActually(T absEntity, PageSetting pageSetting, ApiRequest apiRequest) {
        UiBotModel uiBotModel = UiBotModel.emptyUiBotModel();
        uiBotModel.setRenderVersion(MobileRenderMetaData.RENDER_VERSION_2);
        if (ObjectUtils.isEmpty(uiBotModel.getRenderData())) {
            uiBotModel.setRenderData(UiBotRenderData.createEmptyRenderData());
        }
        PcUiBotExecuteContext executeContext = JsonUtil.objectToJavaObject(apiRequest.getRawData().get("executeContext"), PcUiBotExecuteContext.class);

        // 存储公共的上下文属性
        absEntity.setApiRequest(apiRequest).setExecuteContext(executeContext).setUiBotModel(uiBotModel);

        // 原始RawData数据处理与任务DSL配置获取
        this.handleRawDataData(absEntity);

        // 构建设计态页面DSL
        UiBotPageLayout pageLayout = this.bulidPageLayout(absEntity);
        if (pageLayout == null) {
            // 添加空组件 --- 弹窗页如果显示空组件，则需要重置底部按钮，只增加取消按钮
            uiBotModel.getRenderData().addEmptyComponentToBody();
            uiBotModel.getRenderData().resetCancelComponentToBottom();
            return uiBotModel;
        }

        // 组件上下文
        ComponentContext cmptContext = JsonUtil.objectToJavaObject(apiRequest, ComponentContext.class);
        cmptContext.setExecuteContext(executeContext);
        cmptContext.setPageLayoutInfo(this.handlePageLayoutData(absEntity));
        cmptContext.setPageDefine(getPageDefine(absEntity));

        // 处理多数据源配置
        this.resetPageMultipleDataSourceData(cmptContext, executeContext, pageLayout, apiRequest);

        // 获取rawdata中数据
        ApiRawData rawData = apiRequest.getRawData();
        Object data = rawData.get("data");
        MobilePageRawData mobilePageRawData = new MobilePageRawData()
                .setRawMap((Map<String, Object>) rawData.get("rawMap"))
                .setDataId(apiRequest.getDataId())
                .setRawDataType(rawData.getString("rawDataType"))
                .setExtendedFields((Map<String, Object>) rawData.get("baseEntryExtendedFields"))
                .setSourceCategory(rawData.getString("sourceCategory"))
                .setDataKeys((List<String>) rawData.get("dataKeys"))
                .setComponentId(rawData.getString("componentId"));

        // 构建渲染数据
        this.bulidRanderData(absEntity, pageLayout, data, mobilePageRawData, cmptContext);

        // 构建规则
        this.buildRule(absEntity);
        // 移除特定逻辑下的可编辑规则
        this.removeEditRulesIfNecessary(absEntity);

        // 原始数据
        uiBotModel.setRawUiBotPageData(JsonUtil.objectToJavaObject(CollectionUtils.isEmpty(mobilePageRawData.getRawMap()) ? data : mobilePageRawData.getRawMap(), UiBotPageData.class));

        // 构建机制参数和交付设计器参数
        uiBotDesignerRenderService.buildVariablesAndDelivery(apiRequest, uiBotModel, executeContext);

        uiBotModel.getLayout().clear();
        uiBotModel.getPageData().clear();
        uiBotModel.getActions().clear();
        uiBotModel.setPageDataIndex(null);
        uiBotModel.setPageDataKeys(null);
        uiBotModel.initMobileLayoutType();
        uiBotModel.setExecuteContext(JsonUtil.objectToJavaObject(executeContext, UiBotExecuteContext.class));
        uiBotModel.setPageBackgroudColor(StringUtils.hasLength(uiBotModel.getPageBackgroudColor())
                ?
                uiBotModel.getPageBackgroudColor()
                :
                BackgroundColorEnum.APP_MAIN_GREY.getValue());
        return uiBotModel;
    }

    protected abstract void handleRawDataData(T absEntity);

    protected abstract UiBotPageLayout bulidPageLayout(T absEntity);

    protected abstract Map<String, Map<String, Object>> handlePageLayoutData(T absEntity);

    private void resetPageMultipleDataSourceData(ComponentContext cmptContext, PcUiBotExecuteContext executeContext, UiBotPageLayout pageLayout, ApiRequest apiRequest) {
        Map<String, Object> rawParam = new HashMap<>();
        Object data = apiRequest.getRawData().get("data");
        if (data != null) {
            if (data instanceof Map) {
                rawParam.putAll((Map<String, Object>) data);
            } else if (data instanceof List) {
                if (!CollectionUtils.isEmpty((List<?>) data)) {
                    List<?> listData = (List<?>) data;
                    if (listData.get(0) instanceof Map<?, ?>) {
                        rawParam.putAll((Map<String, Object>) listData.get(0));
                    }
                }
            }
        }
        // 处理多数据源配置
        Map<String, Object> multipleDataSourceData = uiBotMultipleDataSourceService.buildPageMultipleDataSourceData(cmptContext, executeContext, pageLayout, rawParam);
        if (multipleDataSourceData != null) {
            // 存在多数据源配置，替换原数据
            apiRequest.getRawData().put("data", multipleDataSourceData);
        }
    }

    protected abstract void buildRule(T absEntity);

    protected void removeEditRulesIfNecessary(T absEntity) {
    }

    protected abstract Map<String, Object> buildHooks(T absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext);

    protected abstract PcUiBotPageDefine getPageDefine(T absEntity);

    protected void bulidRanderData(T absEntity, UiBotPageLayout pageLayout, Object dataResult, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        UiBotModel uiBotModel = absEntity.getUiBotModel();

        // 高级属性
        uiBotModel.setHooks(buildHooks(absEntity, pageLayout, cmptContext));

        List<BaseMobileComponentWrapper<BaseMobileComponent>> bodyCmptList =
                this.buildBodyCmpt(absEntity, pageLayout, dataResult, mobilePageRawData, cmptContext);
        if (CollectionUtils.isEmpty(bodyCmptList)) {
            // 添加空组件 --- 弹窗页如果显示空组件，则需要重置底部按钮，只增加取消按钮
            uiBotModel.getRenderData().addEmptyComponentToBody();
            uiBotModel.getRenderData().resetCancelComponentToBottom();
        } else {
            int bodyContainerType = UiBotDesignerRenderService.getBodyContainerType(bodyCmptList);
            if (bodyContainerType == 1) {
                SingleListContainer<BaseMobileComponent> singleListContainer = new SingleListContainer<>();
                singleListContainer.addAll(bodyCmptList);
                uiBotModel.getRenderData().addWrapperedComponentToBody(
                        new BaseMobileComponentWrapper<>(singleListContainer, "DW_" + singleListContainer.returnComponentType()));
            } else {
                uiBotModel.getRenderData().addWrapperedComponentListToBody(bodyCmptList);
            }

            // 构建bottom
            List<BaseMobileComponentWrapper<BaseMobileComponent>> bottomCmptList =
                    this.buildBottomCmpt(absEntity, pageLayout, dataResult, mobilePageRawData, cmptContext);
            if (!CollectionUtils.isEmpty(bottomCmptList)) {
                uiBotModel.getRenderData().addWrapperedComponentListToBottom(bottomCmptList);
            }
        }
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBodyCmpt(T absEntity, UiBotPageLayout mainPageLayout, Object dataResult, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        UiBotModel uiBotModel = absEntity.getUiBotModel();

        uiBotModel.setTitleVisible(mainPageLayout.getTitleVisible());
        // 设计器配置标题隐藏时，设置title为空字符串，flutter端根据标题为空默认隐藏
        uiBotModel.setPageTitle(BooleanUtils.isTrue(mainPageLayout.getTitleVisible()) ? mainPageLayout.getTitle() : "");
        uiBotModel.setShowMore(mainPageLayout.getShowMore());
        uiBotModel.setPageBackgroudColor(mainPageLayout.getPageBackgroudColor());

        if (dataResult == null) {
            // 无数据
            return null;
        } else if (dataResult instanceof List) {
            // 不会走到此逻辑，留空，易读
            return null;
        } else if (dataResult instanceof Map) {
            // 是对象，表示表单
            Map<String, Object> map = (Map<String, Object>) dataResult;
            List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                    uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBody(), map, mobilePageRawData);
            if (CollectionUtils.isEmpty(cmptList)) {
                return null;
            } else {
                return cmptList;
            }
        } else {
            // 不会走到此逻辑，留空，易读
            return null;
        }
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottomCmpt(T absEntity, UiBotPageLayout mainPageLayout, Object dataResult, MobilePageRawData mobilePageRawData, ComponentContext cmptContext) {
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        if (dataResult == null) {
            return null;
        }
        if (dataResult instanceof List) {
            // 不会走到此逻辑，留空，易读
            return null;
        } else if (dataResult instanceof Map) {
            Map<String, Object> map = (Map<String, Object>) dataResult;
            cmptContext.setCanBottomButton(true);
            List<BaseMobileComponentWrapper<BaseMobileComponent>> cmptList =
                    uiBotDesignerRenderService.buildCmptDsl(cmptContext, executeContext, mainPageLayout.getBottom(), map, mobilePageRawData);
            if (CollectionUtils.isEmpty(cmptList)) {
                return null;
            } else {
                return cmptList;
            }
        } else {
            // 不会走到此逻辑，留空，易读
            return null;
        }
    }

    private UiBotModel doMockData(PageSetting pageSetting, ApiRequest apiRequest) {
        return null;
    }
}
