package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.report.UiBotModelBuildApcStandProductionProgressPageStrategy;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.mongodb.designerconfig.common.MobileDesignerConfigTypeEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：APC-机位生产进度页面--条目详情页面通用解析页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelApcStandProductionProgressUniversalParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/8/13 13:12
 */
@Component
public class UiBotModelApcStandProductionProgressUniversalParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelApcStandProductionProgressUniversalParsingPageStrategy.ApcStandProductionProgressEntity> {

    @Autowired
    private UiBotDesignerRenderService uiBotDesignerRenderService;

    @Autowired
    private UiBotModelBuildApcStandProductionProgressPageStrategy apcStandProductionProgressPageStrategy;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new ApcStandProductionProgressEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(ApcStandProductionProgressEntity absEntity) {
        absEntity.setPageDefine(JsonUtil.objectToJavaObject(apcStandProductionProgressPageStrategy.buildQueryButton(), PcUiBotPageDefine.class));
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(ApcStandProductionProgressEntity absEntity) {
        // pageId是随机字符串
        String pageId = absEntity.getApiRequest().getPageId();

        // 根据pageId获取设计态页面DSL
        return Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayout)
                .orElse(new ArrayList<>())
                .stream()
                .filter(pageLayout -> pageId.equals(pageLayout.getPageId()))
                .findFirst()
                .orElse(null);
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(ApcStandProductionProgressEntity absEntity) {
        return new HashMap<>();
    }

    @Override
    protected void buildRule(ApcStandProductionProgressEntity absEntity) {
        // 走本地配置
        List<UiBotRule> rules = pcRuleService.buildRuleOfLocal(absEntity.getExecuteContext().getTmActivityId(), MobileDesignerConfigTypeEnum.DATA_ENTRY.getValue());
        if (!CollectionUtils.isEmpty(rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }


    @Data
    protected static
    class ApcStandProductionProgressEntity extends AbstractEntity {
        private PcUiBotPageDefine pageDefine;
    }

    @Override
    protected Map<String, Object> buildHooks(ApcStandProductionProgressEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        List<Map<String, Object>> hooks = Optional.ofNullable(absEntity).map(ApcStandProductionProgressEntity::getPageDefine)
                .map(PcUiBotPageDefine::getHooks).orElseGet(ArrayList::new);
        return uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(ApcStandProductionProgressEntity absEntity) {
        return absEntity.getPageDefine();
    }
}
