package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.impl.DataViewRawDslRenderService;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：Athena V2版--数据录入--模型驱动--浏览页面--视图驱动DSL--条目详情页面通用解析页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBasicDataBrowseDetailViewDrivenParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/1/2 10:45
 */
@Slf4j
@Component("uiBotModelBasicDataBrowseDetailViewDrivenParsingPageStrategy")
public class UiBotModelBasicDataBrowseDetailViewDrivenParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelBasicDataBrowseDetailViewDrivenParsingPageStrategy.BasicDataBrowseDetailViewDrivenEntity> {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private DataViewRawDslRenderService dataViewRawDslRenderService;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new BasicDataBrowseDetailViewDrivenEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(BasicDataBrowseDetailViewDrivenEntity absEntity) {
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(BasicDataBrowseDetailViewDrivenEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        Map<String, Object> rawDataRawData = (Map<String, Object>) apiRequest.getRawData().get("rawData");
        PcUiBotTmViewShowFieldsMobile parentField = JsonUtil
                .objectToJavaObject(Optional.ofNullable(rawDataRawData)
                                .map(r -> r.get("parentField"))
                                .orElse(null),
                        PcUiBotTmViewShowFieldsMobile.class);
        if (parentField == null) {
            return null;
        }
        List<PcUiBotTmViewShowFieldsMobile> subFields = parentField.getField();
        if (CollectionUtils.isEmpty(subFields)) {
            return null;
        }
        UiBotPageLayout uiBotPageLayout = new UiBotPageLayout();
        uiBotPageLayout.setPageBackgroudColor(null);
        uiBotPageLayout.setShowMore(false);
        uiBotPageLayout.setTitle(localeService.getLanguageValue(executeContext.getLocale(), "视图驱动"));
        uiBotPageLayout.setTitleVisible(false);
        uiBotPageLayout.setPageId(apiRequest.getPageId());
        uiBotPageLayout.setSchema("a1h8t2ko0a");
        uiBotPageLayout.setComponentType("set-up-drawer");
        uiBotPageLayout.setHeader(new ArrayList<>());
        uiBotPageLayout.setBody(this.buildBody(executeContext, parentField));
        uiBotPageLayout.setBottom(this.buildBottom(executeContext));
        return uiBotPageLayout;
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(BasicDataBrowseDetailViewDrivenEntity absEntity) {
        return new HashMap<>();
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBody(PcUiBotExecuteContext executeContext, PcUiBotTmViewShowFieldsMobile parentField) {
        parentField.setIsArray(false);
        return dataViewRawDslRenderService.buildBody(executeContext, parentField);
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(PcUiBotExecuteContext executeContext) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(executeContext));
        return Lists.newArrayList(new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE));
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(PcUiBotExecuteContext executeContext) {
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        // 构建取消按钮
        BaseMobileComponentWrapper<BottomButtonDigiwinAthena> cancelButton = this.buildCancelButton(executeContext);
        contentGroup.add(cancelButton);
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildCancelButton(PcUiBotExecuteContext executeContext) {
        String locale = executeContext.getLocale();
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        UiBotAction uiBotAction = new UiBotAction();
        button.setSubmitAction(uiBotAction);

        uiBotAction.setBtnId(UUIDUtil.getUuid());
        uiBotAction.setTitle(localeService.getLanguageValue(locale, "取消"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setType(ActionTypeEnum.BACK.getValue());
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setIsCheckButton(false);

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    @Override
    protected void buildRule(BasicDataBrowseDetailViewDrivenEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        String tmActivityId = absEntity.getExecuteContext().getTmActivityId();
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(tmActivityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }

    @Data
    protected static
    class BasicDataBrowseDetailViewDrivenEntity extends AbstractEntity {

    }

    @Override
    protected Map<String, Object> buildHooks(BasicDataBrowseDetailViewDrivenEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        return null;
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(BasicDataBrowseDetailViewDrivenEntity absEntity) {
        return null;
    }
}
