package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.DWCallWorkEnum;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotDoubleDocumentPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.BaseDataDoubleDocumentPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.BaseDataDesignerDocumentPageBuilder;
import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：Athena V2版--数据录入--默认解析--条目详情页面通用解析页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBasicDataUniversalParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/12/7 14:07
 */
@Component("uiBotModelBasicDataUniversalParsingPageStrategy")
public class UiBotModelBasicDataUniversalParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelBasicDataUniversalParsingPageStrategy.BasicDataEntity> {

    @Autowired
    private BaseDataDoubleDocumentPageDefineAnalyzer baseDataDoubleDocumentPageDefineAnalyzer;

    @Autowired
    private BaseDataDesignerDocumentPageBuilder baseDataDesignerDocumentPageBuilder;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new BasicDataEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(BasicDataEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        // wjw TODO: 2023/12/19 数据录入--如果场景要操作 apiRequest中的submitParam、submitParams、currentSubmitParam，
        //  可能需要根据 业务类型 为 'local-delete'   |   'local-add'  |  'local-save' ，本地保存时，才可使用，其它先置空
        if (!Lists.newArrayList(BusinessTypeEnum.LOCAL_ADD.getValue(),
                        BusinessTypeEnum.LOCAL_SAVE.getValue(),
                        BusinessTypeEnum.LOCAL_DELETE.getValue())
                .contains(apiRequest.getRawData().getBusinessType())) {
            // 置空，因数据录入--通用解析页使用不到此数据
            apiRequest.setSubmitParam(null);
            apiRequest.setSubmitParams(null);
            apiRequest.setCurrentSubmitParam(null);
        }

        if (DWCallWorkEnum.ADD.getValue().equals(apiRequest.getRawData().getDesignParameter().getDWCallWork())) {
            // 区分新增还是保存操作，隐藏相应按钮(现组合按钮中、本地操作按钮使用)
            absEntity.getExecuteContext().setEditType("add");
            if (apiRequest.getRawData().containsKey("data")) {
                // 数据录入新增下重置data数据
                apiRequest.getRawData().put("data", new HashMap<>());
            }
        }

        // 填充submitActions属性值
        this.buildUniversalParsingSubmitActions(absEntity);
    }

    /**
     * 填充submitActions属性值
     */
    private void buildUniversalParsingSubmitActions(BasicDataEntity absEntity) {
        // 构建 submitActions
        List<PcUiBotDoubleDocumentPageDefine> pageDefines = baseDataDoubleDocumentPageDefineAnalyzer.analysis(absEntity.getExecuteContext());
        // 填充submitActions属性值
        baseDataDesignerDocumentPageBuilder.BuildActions(pageDefines.get(0), null);

        absEntity.setPageDefine(pageDefines.get(0));
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(BasicDataEntity absEntity) {
        // pageId是随机字符串
        String pageId = absEntity.getApiRequest().getPageId();

        // 根据pageId获取设计态页面DSL
        return Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayout)
                .orElse(new ArrayList<>())
                .stream()
                .filter(pageLayout -> pageId.equals(pageLayout.getPageId()))
                .findFirst()
                .orElse(null);
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(BasicDataEntity absEntity) {
        return Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayoutInfo)
                .orElse(new HashMap<>());
    }

    @Override
    protected void buildRule(BasicDataEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        String tmActivityId = absEntity.getExecuteContext().getTmActivityId();
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(tmActivityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }

    @Data
    protected static
    class BasicDataEntity extends AbstractEntity {
        private PcUiBotDoubleDocumentPageDefine pageDefine;
    }

    @Override
    protected Map<String, Object> buildHooks(BasicDataEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        List<Map<String, Object>> hooks = Optional.ofNullable(absEntity).map(BasicDataEntity::getPageDefine)
                .map(PcUiBotDoubleDocumentPageDefine::getHooks).orElse(Collections.emptyList());
        return uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(BasicDataEntity absEntity) {
        return absEntity.getPageDefine();
    }
}
