package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import cn.hutool.core.map.MapUtil;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.DWCallWorkEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.BaseDataDoubleDocumentPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.BaseDataDesignerDocumentPageBuilder;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.DesignerBusinessDataEntryDrivenTaskBuilder;
import com.google.common.collect.Lists;
import lombok.Data;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：Athena V2版--任务卡--数据录入--模型驱动--流程设计--生成的任务卡--条目详情页面通用解析页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelBizDataEntryDrivenItemParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/1/16 9:59
 */
@Component("uiBotModelBizDataEntryDrivenItemParsingPageStrategy")
public class UiBotModelBizDataEntryDrivenItemParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelBizDataEntryDrivenItemParsingPageStrategy.BizDataEntryDrivenItemEntity> {

    @Autowired
    private DesignerBusinessDataEntryDrivenTaskBuilder designerBusinessDataEntryDrivenTaskBuilder;

    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;

    @Autowired
    private BaseDataDoubleDocumentPageDefineAnalyzer baseDataDoubleDocumentPageDefineAnalyzer;

    @Autowired
    private BaseDataDesignerDocumentPageBuilder baseDataDesignerDocumentPageBuilder;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new BizDataEntryDrivenItemEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(BizDataEntryDrivenItemEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        // wjw TODO: 2023/12/19 数据录入--如果场景要操作 apiRequest中的submitParam、submitParams、currentSubmitParam，
        //  可能需要根据 业务类型 为 'local-delete'   |   'local-add'  |  'local-save' ，本地保存时，才可使用，其它先置空
        if (!Lists.newArrayList(BusinessTypeEnum.LOCAL_ADD.getValue(),
                        BusinessTypeEnum.LOCAL_SAVE.getValue(),
                        BusinessTypeEnum.LOCAL_DELETE.getValue())
                .contains(apiRequest.getRawData().getBusinessType())) {
            // 置空，因数据录入--通用解析页使用不到此数据
            apiRequest.setSubmitParam(null);
            apiRequest.setSubmitParams(null);
            apiRequest.setCurrentSubmitParam(null);
        }

        if (DWCallWorkEnum.ADD.getValue().equals(apiRequest.getRawData().getDesignParameter().getDWCallWork())) {
            // 区分新增还是保存操作，隐藏相应按钮(现组合按钮中、本地操作按钮使用)
            absEntity.getExecuteContext().setEditType("add");
            if (apiRequest.getRawData().containsKey("data")) {
                // 数据录入新增下重置data数据
                apiRequest.getRawData().put("data", new HashMap<>());
            }
        }

        // 填充submitActions属性值
        this.buildUniversalParsingSubmitActions(absEntity);
    }

    private void buildUniversalParsingSubmitActions(BizDataEntryDrivenItemEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        UiBotModel uiBotModel = absEntity.getUiBotModel();
        // 获取任务定义
        List<PcUiBotTaskPageDefine> pageDefineList = taskPageDefineAnalyzer.analysis(null, executeContext, null);
        if (CollectionUtils.isEmpty(pageDefineList)) {
            return;
        }
        PcUiBotTaskPageDefine pageDefine = pageDefineList.get(0);

        // 设置任务卡是否结束
        uiBotModel.setFinished(pageDefine.getFinished());
        uiBotModel.setFinishedTitle(pageDefine.getFinishedTitle());

        absEntity.setFinished(pageDefine.getFinished());
        absEntity.setModelFieldMap(pageDefine.getModelFieldMap());

        PcUiBotTmFormInfo bindForm = pageDefine.getBindForm();
        if (bindForm == null) {
            return;
        }
        String formCode = bindForm.getFormCode();
        if (StringUtils.isEmpty(formCode)) {
            return;
        }
        absEntity.setFormCode(formCode);

        // 获取基础资料编辑页的DSL
        PcUiBotExecuteContext newExecuteContext = JsonUtil.objectToJavaObject(executeContext, PcUiBotExecuteContext.class);
        newExecuteContext.setPageCode(UiBotDesignerService.PAGECODE_EDIT_PAGE);
        newExecuteContext.setTmActivityId(formCode);
        this.buildSubmitActions(absEntity, newExecuteContext);
    }

    private void buildSubmitActions(BizDataEntryDrivenItemEntity absEntity, PcUiBotExecuteContext newExecuteContext) {
        // 构建 submitActions
        List<PcUiBotDoubleDocumentPageDefine> pageDefines = baseDataDoubleDocumentPageDefineAnalyzer.analysis(newExecuteContext);
        // 填充submitActions属性值
        baseDataDesignerDocumentPageBuilder.BuildActions(pageDefines.get(0), null);
        absEntity.setPageDefine(pageDefines.get(0));
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(BizDataEntryDrivenItemEntity absEntity) {
        // pageId是随机字符串
        String pageId = absEntity.getApiRequest().getPageId();

        // 根据pageId获取设计态页面DSL
        UiBotPageLayout uiBotPageLayout = Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayout)
                .orElse(new ArrayList<>())
                .stream()
                .filter(pageLayout -> pageId.equals(pageLayout.getPageId()))
                .findFirst()
                .orElse(null);
        if (uiBotPageLayout == null) {
            return uiBotPageLayout;
        }

        // 字段权限
        Map<String, PcUiBotModelField> modelFieldMap = absEntity.getModelFieldMap();
        if (MapUtil.isNotEmpty(modelFieldMap)) {
            // 任务是否已结束
            boolean finished = BooleanUtils.isTrue(absEntity.getFinished());
            // 设置栏位显隐
            designerBusinessDataEntryDrivenTaskBuilder.setFieldVisible(uiBotPageLayout.getBody(), modelFieldMap, finished);
        }
        return uiBotPageLayout;
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(BizDataEntryDrivenItemEntity absEntity) {
        return Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayoutInfo)
                .orElse(new HashMap<>());
    }

    @Override
    protected void buildRule(BizDataEntryDrivenItemEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        UiBotModel uiBotModel = absEntity.getUiBotModel();
        String tmActivityId = absEntity.getExecuteContext().getTmActivityId();
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(tmActivityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            uiBotModel.setRules(rules);
        }
        if (BooleanUtils.isTrue(absEntity.getFinished())) {
            // 任务已结束移除编辑的规则
            uiBotModel.getRules().removeIf(ruleMap -> StringUtils.equals("EDIT", String.valueOf(ruleMap.getScope())));
        }
    }

    @Data
    protected static
    class BizDataEntryDrivenItemEntity extends AbstractEntity {
        private Boolean finished;
        private Map<String, PcUiBotModelField> modelFieldMap;
        // 任务卡绑定基础资料编辑页面code
        private String formCode;
        private PcUiBotDoubleDocumentPageDefine pageDefine;

    }

    @Override
    protected Map<String, Object> buildHooks(BizDataEntryDrivenItemEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        List<Map<String, Object>> hooks = Optional.ofNullable(absEntity).map(BizDataEntryDrivenItemEntity::getPageDefine)
                .map(PcUiBotDoubleDocumentPageDefine::getHooks).orElse(Collections.emptyList());
        return uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(BizDataEntryDrivenItemEntity absEntity) {
        return absEntity.getPageDefine();
    }
}
