package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponent;
import com.digiwin.mobile.mobileuibot.core.component.BaseMobileComponentWrapper;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionSubmitParam;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionTypeEnum;
import com.digiwin.mobile.mobileuibot.core.component.action.ConfirmPop;
import com.digiwin.mobile.mobileuibot.core.component.basic.Field;
import com.digiwin.mobile.mobileuibot.core.component.button.*;
import com.digiwin.mobile.mobileuibot.core.component.input.attachment.Attachment;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTime;
import com.digiwin.mobile.mobileuibot.core.component.input.datetimepicker.InputDateTimePicker;
import com.digiwin.mobile.mobileuibot.core.component.input.switchcomponent.InputSwitch;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.compsubmithandle.ComponentParamAnalyzer;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.AssistanPatternTaskBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：Athena V2版--任务卡--数据驱动DSL--从bpmdata中获取字段属性--条目详情页面通用解析页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelDataDrivenDslUniversalParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/10/19 14:34
 */
@Slf4j
@Component("uiBotModelDataDrivenDslUniversalParsingPageStrategy")
public class UiBotModelDataDrivenDslUniversalParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelDataDrivenDslUniversalParsingPageStrategy.DataDrivenDslEntity> {

    @Autowired
    private LocaleService localeService;

    @Autowired
    private AssistanPatternTaskBuilder assistanPatternTaskBuilder;

    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new DataDrivenDslEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(DataDrivenDslEntity absEntity) {
        // 通过前端传递的提交参数，处理原始rawdata数据
        this.handleRawDataDataOfSubmitParam(absEntity.getApiRequest());
        // 处理rawMap数据，构建提交按钮rawdata时，data传入所有数据
        this.handleRawDataRawMapAndPageDefines(absEntity);
    }

    /**
     * 通过前端传递的提交参数，处理原始rawdata数据
     */
    private void handleRawDataDataOfSubmitParam(ApiRequest apiRequest) {
        if (CollectionUtils.isEmpty(apiRequest.getSubmitParam())) {
            return;
        }
        // 原始数据
        Map<String, Object> data = (Map<String, Object>) apiRequest.getRawData().get("data");
        for (ActionSubmitParam submitParam : apiRequest.getSubmitParam()) {
            String type = submitParam.getType();
            // 跳过不处理
            if (Field.COMPONENT_TYPE.equalsIgnoreCase(type)) {
                continue;
            }
            String schema = submitParam.getSchema();
            Object paramObj = submitParam.getParams();
            switch (type) {
                case Attachment.COMPONENT_TYPE:
                    break;
                case InputDateTimePicker.COMPONENT_TYPE:
                    InputDateTimePicker picker = (InputDateTimePicker) paramObj;
                    if (picker.getDatetimeValue() != null) {
                        data.put(schema, InputDateTime.getDateTypeDateStringByType(picker.getDatetimeValue(), picker.getType()));
                    }
                    break;
                case InputSwitch.COMPONENT_TYPE:
                    InputSwitch inputSwitch = (InputSwitch) paramObj;
                    data.put(schema, Optional.ofNullable(inputSwitch.getSwitchState()).orElse(0) == 1);
                    break;
                default:
                    ComponentParamAnalyzer componentParamAnalyzer = this.componentParamAnalyzerFactory.get(type);
                    if (null == componentParamAnalyzer) {
                        log.error("当前提交参数没有对应参数解析器，请注意是否会有后续参数异常！当前schema是：{}，参数是：{}",
                                schema, JsonUtil.javaObjectToJsonString(paramObj));
                        continue;
                    }
                    Object analyzedParam = componentParamAnalyzer.analyzeSubmitParam(paramObj);
                    if (analyzedParam instanceof Map) {
                        data.putAll((Map<? extends String, ?>) analyzedParam);
                    } else {
                        // 提交内容暂存下来
                        data.put(schema, analyzedParam);
                    }
                    break;
            }
        }
    }

    private void handleRawDataRawMapAndPageDefines(DataDrivenDslEntity absEntity) {
        // 构建 submitActions
        List<PcUiBotTaskPageDefine> pageDefines = taskPageDefineAnalyzer.analysis(null, absEntity.getExecuteContext(), null);

        this.handleRawDataRawMap(absEntity.getApiRequest());

        absEntity.setPageDefines(pageDefines);
    }

    private void handleRawDataRawMap(ApiRequest apiRequest) {
        // wjw FIXME: 2023/12/13 直接从数据源获取全量数据替换存在bug，因构建的mobile_card_dataId_key 不存在无法更新数据
        /*if (CollectionUtils.isEmpty(pageDefines)) {
            return;
        }
        QueryResultSet queryResultSet = generalPageTemplate.BuildDataSource(executeContext, pageDefines.get(0), uiBotModel);
        if (queryResultSet == null) {
            return;
        }
        Map<String, Object> rawMap = queryResultSet.getPageData();
        // 重置rawMap为全量数据，因为提交按钮提到了第二个页面中
        apiRequest.getRawData().put("rawMap", rawMap);*/

        Map<String, Object> allRawMap = (Map<String, Object>) apiRequest.getRawData().get("allRawMap");
        if (CollectionUtils.isEmpty(allRawMap)) {
            return;
        }
        // 重置rawMap为全量数据，因为提交按钮提到了第二个页面中
        apiRequest.getRawData().put("rawMap", allRawMap);
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(DataDrivenDslEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        Map<String, Object> rawDataRawData = (Map<String, Object>) apiRequest.getRawData().get("rawData");
        boolean existSubmitButton = Optional.ofNullable(rawDataRawData)
                .map(r -> (Boolean) r.get("existSubmitButton"))
                .orElse(false);
        PcUiBotMetadataField parentField = JsonUtil.objectToJavaObject(Optional.ofNullable(rawDataRawData)
                        .map(r -> r.get("parentField"))
                        .orElse(null),
                PcUiBotMetadataField.class);
        String sourceType = Optional.ofNullable(rawDataRawData)
                .map(r -> (String) r.get("sourceType"))
                .orElse(null);
        String nanaMessageId = Optional.ofNullable(rawDataRawData)
                .map(r -> (String) r.get("nanaMessageId"))
                .orElse(null);
        if (parentField == null) {
            return null;
        }
        List<PcUiBotMetadataField> subFields = parentField.getSubFields();
        if (CollectionUtils.isEmpty(subFields)) {
            return null;
        }
        UiBotPageLayout uiBotPageLayout = new UiBotPageLayout();
        uiBotPageLayout.setPageBackgroudColor(null);
        uiBotPageLayout.setShowMore(false);
        uiBotPageLayout.setTitle(localeService.getLanguageValue(executeContext.getLocale(), "数据驱动"));
        uiBotPageLayout.setTitleVisible(false);
        uiBotPageLayout.setPageId(apiRequest.getPageId());
        uiBotPageLayout.setSchema("a1h8t2ko0a");
        uiBotPageLayout.setComponentType("set-up-drawer");
        uiBotPageLayout.setHeader(new ArrayList<>());
        uiBotPageLayout.setBody(this.buildBody(executeContext, parentField, existSubmitButton, sourceType, nanaMessageId));
        uiBotPageLayout.setBottom(this.buildBottom(executeContext, parentField, existSubmitButton, absEntity.getPageDefines(), sourceType, nanaMessageId));
        return uiBotPageLayout;
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(DataDrivenDslEntity absEntity) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        return Optional.ofNullable(absEntity.getPageDefines())
                .orElse(Collections.emptyList())
                .stream()
                .filter(pageDefine -> StringUtils.hasLength(dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode()))
                .findFirst()
                .map(PcUiBotPageDefine::getPageLayoutInfo)
                .orElse(new HashMap<String, Map<String, Object>>());
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBody(PcUiBotExecuteContext executeContext, PcUiBotMetadataField showField, boolean existSubmitButton, String sourceType, String nanaMessageId) {
        PcUiBotShowMetadata showMetadata = new PcUiBotShowMetadata();
        showField.setArray(false);
        showMetadata.setShowFields(Lists.newArrayList(showField));
        return assistanPatternTaskBuilder.buildBody(executeContext, showMetadata, existSubmitButton, false, sourceType, nanaMessageId, true);
    }

    private List<BaseMobileComponentWrapper<BaseMobileComponent>> buildBottom(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, List<PcUiBotTaskPageDefine> pageDefines, String sourceType, String nanaMessageId) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.setContentGroup(this.buildButtonGroupContentGroup(executeContext, parentField, existSubmitButton, pageDefines, sourceType, nanaMessageId));
        return Lists.newArrayList(new BaseMobileComponentWrapper<>(buttonGroup, "DW_" + ButtonGroup.COMPONENT_TYPE));
    }

    private List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> buildButtonGroupContentGroup(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, List<PcUiBotTaskPageDefine> pageDefines, String sourceType, String nanaMessageId) {
        List<BaseMobileComponentWrapper<BottomButtonDigiwinAthena>> contentGroup = new ArrayList<>();
        // 构建取消按钮
        BaseMobileComponentWrapper<BottomButtonDigiwinAthena> cancelButton = this.buildCancelButton(executeContext);
        contentGroup.add(cancelButton);

        String dataStateCode = executeContext.getDataStateCode();
        Optional<PcUiBotTaskPageDefine> currentPageDefine = Optional.ofNullable(pageDefines).orElse(new ArrayList<>()).stream()
                // 获取对应数据状态下的定义
                .filter(pageDefine -> StringUtils.hasLength(dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode()))
                .findFirst();
        if (!currentPageDefine.isPresent()) {
            // 无对应数据状态的定义，直接返回
            return contentGroup;
        }
        PcUiBotTaskPageDefine pageDefine = currentPageDefine.get();
        // 合并任务，详情页面构建提交按钮
        if (BooleanUtils.isTrue(pageDefine.getMerge())) {
            // 构建提交按钮
            BaseMobileComponentWrapper<BottomButtonDigiwinAthena> submitButton = this.buildMergeSubmitButton(executeContext, parentField, existSubmitButton, pageDefine, sourceType, nanaMessageId);
            if (submitButton != null) {
                contentGroup.add(submitButton);
            }
        } else {
            // 构建暂存按钮
            BaseMobileComponentWrapper<BottomButtonDigiwinAthena> saveButton = this.buildSaveButton(executeContext, parentField, existSubmitButton);
            if (saveButton != null) {
                contentGroup.add(saveButton);
            }
            // 构建保存并提交按钮
            BaseMobileComponentWrapper<BottomButtonDigiwinAthena> submitButton = this.buildSubmitButton(executeContext, parentField, existSubmitButton, pageDefine, sourceType, nanaMessageId);
            if (submitButton != null) {
                contentGroup.add(submitButton);
            }
        }
        return contentGroup;
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildMergeSubmitButton(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, PcUiBotTaskPageDefine pageDefine, String sourceType, String nanaMessageId) {
        if (BooleanUtils.isTrue(pageDefine.getFinished())) {
            // 已完成任务，不展示提交按钮
            return null;
        }
        List<PcUiBotSubmitAction> submitActions = pageDefine.getSubmitActions();
        if (CollectionUtils.isEmpty(submitActions)) {
            return null;
        }
        // 只展示提交按钮
        Optional<PcUiBotSubmitAction> uiBotActionOptional = submitActions.stream().filter(r -> "TaskEngine".equals(r.getType()) && "submit-data".equals(r.getActionId())).findFirst();
        if (!uiBotActionOptional.isPresent()) {
            return null;
        }
        // 封装提交action
        PcUiBotSubmitAction submitAction = uiBotActionOptional.get();

        String uuid = UUIDUtil.getUuid();
        submitAction.setUuid(uuid);
        submitAction.setBtnId(uuid);
        submitAction.setTitle(localeService.getLanguageValue(executeContext.getLocale(), "提交"));
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        // 直接刷新主页面，因为是分批提交
        uiBotJumpAction.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
        uiBotJumpAction.setJumpPageId("page1");
        uiBotJumpAction.setNanaMessageId(nanaMessageId);
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setConfirmPop(ConfirmPop
                .create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "是否确定")
                                + submitAction.getTitle()
                                + "？",
                        true));

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, new TypeReference<UiBotAction>() {
        }));

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE, uuid);
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildCancelButton(PcUiBotExecuteContext executeContext) {
        String locale = executeContext.getLocale();
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        UiBotAction uiBotAction = new UiBotAction();
        button.setSubmitAction(uiBotAction);

        uiBotAction.setBtnId(UUIDUtil.getUuid());
        uiBotAction.setTitle(localeService.getLanguageValue(locale, "取消"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);

        uiBotJumpAction.setType(ActionTypeEnum.BACK.getValue());
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.NORMAL.getValue());
        uiBotJumpAction.setIsCheckButton(false);

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);
    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildSaveButton(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton) {
        boolean isEditable = Optional
                .ofNullable(parentField.getSubFields())
                .orElse(new ArrayList<>())
                .stream()
                .anyMatch(PcUiBotMetadataField::isCanEdit);
        // wjw TODO: 2023/10/20 因条目详情页可能没有录入字段使保存按钮不显示，导致如果没有保存按钮，
        // 则主页面的批量提交校验一直会有条数据是待处理状态，故先注释掉此块逻辑
//        if (!isEditable) {
//            // 无编辑字段，则无完成或者提交按钮
//            return null;
//        }
        if (!existSubmitButton) {
            return null;
        }

        String locale = executeContext.getLocale();
        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        UiBotAction uiBotAction = new UiBotAction();
        button.setSubmitAction(uiBotAction);

        uiBotAction.setBtnId(UUIDUtil.getUuid());
        uiBotAction.setTitle(localeService.getLanguageValue(locale, "暂存"));
        uiBotAction.setBtnType(ButtonTypeEnum.JUMP.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        uiBotAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setType(ActionTypeEnum.JUMP_NEXT_AND_TRANSFER_DATA_TO_PREFIX.getValue());
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setSaveType("save");

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE);

    }

    private BaseMobileComponentWrapper<BottomButtonDigiwinAthena> buildSubmitButton(PcUiBotExecuteContext executeContext, PcUiBotMetadataField parentField, boolean existSubmitButton, PcUiBotTaskPageDefine pageDefine, String sourceType, String nanaMessageId) {
        boolean isEditable = Optional
                .ofNullable(parentField.getSubFields())
                .orElse(new ArrayList<>())
                .stream()
                .anyMatch(PcUiBotMetadataField::isCanEdit);
        // wjw TODO: 2023/10/20 因条目详情页可能没有录入字段使保存按钮不显示，导致如果没有保存按钮，
        // 则主页面的批量提交校验一直会有条数据是待处理状态，故先注释掉此块逻辑
//        if (!isEditable) {
//            // 无编辑字段，则无完成或者提交按钮
//            return null;
//        }
        if (!existSubmitButton) {
            return null;
        }
        if (BooleanUtils.isTrue(pageDefine.getFinished())) {
            // 已完成任务，不展示提交按钮
            return null;
        }
        List<PcUiBotSubmitAction> submitActions = pageDefine.getSubmitActions();
        if (CollectionUtils.isEmpty(submitActions)) {
            return null;
        }
        // 只展示提交按钮
        Optional<PcUiBotSubmitAction> uiBotActionOptional = submitActions.stream().filter(r -> "TaskEngine".equals(r.getType()) && "submit-data".equals(r.getActionId())).findFirst();
        if (!uiBotActionOptional.isPresent()) {
            return null;
        }
        // 封装提交action
        PcUiBotSubmitAction submitAction = uiBotActionOptional.get();

        String uuid = UUIDUtil.getUuid();
        submitAction.setUuid(uuid);
        submitAction.setBtnId(uuid);
        submitAction.setTitle(localeService.getLanguageValue(executeContext.getLocale(), "保存并提交"));
        submitAction.setBtnType(ButtonTypeEnum.SUBMIT.getValue());
        UiBotJumpAction uiBotJumpAction = new UiBotJumpAction();
        submitAction.setJumpAction(uiBotJumpAction);
        uiBotJumpAction.setBtnStyleType(BottomButtonStyleEnum.STRESS.getValue());
        if ("nana".equals(sourceType) || StringUtils.hasLength(sourceType)) {
            // nana 来源，直接刷新主页面，因为无法处理跳转第三方
            uiBotJumpAction.setType(ActionTypeEnum.BACK_ONE_WITH_REFRESH.getValue());
            uiBotJumpAction.setJumpPageId("page1");
        } else {
            // 其它，返回上二页并刷新
            uiBotJumpAction.setType(ActionTypeEnum.BACK_TWO_WITH_REFRESH.getValue());
        }
        uiBotJumpAction.setNanaMessageId(nanaMessageId);
        uiBotJumpAction.setIsCheckButton(true);
        uiBotJumpAction.setConfirmPop(ConfirmPop
                .create(localeService.getLanguageValue(AppRequestContext.getContextEntity().getLocale(), "是否确定")
                                + submitAction.getTitle()
                                + "？",
                        true));
        uiBotJumpAction.setSaveType("submit");
        Map<String, Object> rawData = new HashMap<>();
        rawData.put("saveType", "submit");
        uiBotJumpAction.setRawData(rawData);

        BottomButtonDigiwinAthena button = new BottomButtonDigiwinAthena();
        button.setSubmitAction(JsonUtil.objectToJavaObject(submitAction, new TypeReference<UiBotAction>() {
        }));

        return new BaseMobileComponentWrapper<>(button, "DW_" + Button.COMPONENT_TYPE, uuid);
    }

    @Override
    protected void buildRule(DataDrivenDslEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        String tmActivityId = absEntity.getExecuteContext().getTmActivityId();
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(tmActivityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }

    @Data
    protected static
    class DataDrivenDslEntity extends AbstractEntity {
        private List<PcUiBotTaskPageDefine> pageDefines;
    }

    @Override
    protected Map<String, Object> buildHooks(DataDrivenDslEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        List<Map<String, Object>> hooks = Optional.ofNullable(absEntity.getPageDefines()).orElse(new ArrayList<>())
                .stream()
                // 获取对应数据状态下的定义
                .filter(pageDefine -> StringUtils.hasLength(dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode()))
                .findFirst()
                .map(PcUiBotTaskPageDefine::getHooks)
                .orElse(Collections.emptyList());
        return uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(DataDrivenDslEntity absEntity) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        return Optional.ofNullable(absEntity.getPageDefines()).orElse(new ArrayList<>())
                .stream()
                // 获取对应数据状态下的定义
                .filter(pageDefine -> StringUtils.hasLength(dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode()))
                .findFirst().orElse(null);
    }
}
