package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.action.ActionServiceImpl;
import com.digiwin.mobile.mobileuibot.core.component.action.DigiwinActionSubmitParas;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.multipledatasource.UiBotModelDesignerMultipleDataSources;
import com.digiwin.mobile.mobileuibot.designer.uibot.enums.BusinessTypeEnum;
import com.digiwin.mobile.mobileuibot.designer.uibot.service.UiBotDesignerRenderService;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.model.DigiwinAtmcActivityData;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.*;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.TaskPageDefineAnalyzer;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.IOException;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * <p>功能描述：Athena V2版--任务卡--默认解析--条目详情页面通用解析页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelDesignerUniversalParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2023/8/18 10:06
 */
@Slf4j
@Component("uiBotModelDesignerUniversalParsingPageStrategy")
public class UiBotModelDesignerUniversalParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelDesignerUniversalParsingPageStrategy.DesignerEntity> {

    @Autowired
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;

    @Autowired
    private DigiwinAtdmProxyService digiwinAtdmProxyService;

    @Autowired
    private DigiwinAtmcProxyService digiwinAtmcProxyService;

    @Autowired
    private ActionServiceImpl actionServiceImpl;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new DesignerEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(DesignerEntity absEntity) {
        // 处理单身新增功能
        this.handleLocalOperationOfPageData(absEntity.getApiRequest());
        // 通过前端传递的提交参数，处理原始rawdata数据
        this.handleRawDataDataOfSubmitParam(absEntity.getApiRequest());
        // 填充submitActions属性值
        this.buildUniversalParsingSubmitActions(absEntity);
//        // 处理当前数据状态code
//        this.handleDataStateCode(absEntity);
        // 试验优测定制
        this.customUtInspectionResultsRegistration(absEntity);
    }

    /**
     * 处理单身新增功能--ZtbViewList卡片列表组件与表单组件
     */
    public void handleLocalOperationOfPageData(ApiRequest apiRequest) {
        if (!Lists.newArrayList(BusinessTypeEnum.LOCAL_ADD.getValue(),
                        BusinessTypeEnum.LOCAL_SAVE.getValue(),
                        BusinessTypeEnum.LOCAL_DELETE.getValue())
                .contains(apiRequest.getRawData().getBusinessType())) {
            // 非本地操作时，返回
            return;
        }
        // 当前 表单组件
        UiBotDesignerRenderService.handleAddSimpleDataOfPageData(apiRequest, apiRequest.getRawData().get("data"));
        // 当前 ZtbViewList卡片列表组件
        UiBotDesignerRenderService.handleAddCardListDataOfPageData(apiRequest, (Map<String, Object>) apiRequest.getRawData().get("data"));
        // clear 防止对后续逻辑有影响，如：通过前端传递的提交参数，处理原始rawdata数据
        apiRequest.setSubmitParam(null);
        apiRequest.setSubmitParams(null);
        apiRequest.setCurrentSubmitParam(null);
    }

    /**
     * 通过前端传递的提交参数，处理原始rawdata数据
     */
    public void handleRawDataDataOfSubmitParam(ApiRequest apiRequest) {
        if (CollectionUtils.isEmpty(apiRequest.getSubmitParam())) {
            return;
        }
        // 原始数据
        Map<String, Object> data = (Map<String, Object>) apiRequest.getRawData().get("data");

        List<DigiwinActionSubmitParas> digiwinActionSubmitParasList = new ArrayList<>(
                actionServiceImpl.buildSubmitParasMap(apiRequest.getSubmitParam())
                        .stream()
                        .filter(distinctByKey(obj -> obj.getOriginalSchema() + "-" + obj.getMobilePath())).collect(Collectors.toList()));
        digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_SUBMIT_CARD_DATA_KEY.equals(r.getOriginalSchema()));
        digiwinActionSubmitParasList.removeIf(r -> PcUiBotConstants.MOBILE_LOCAL_ADD_CARD_DATA_KEY.equals(r.getOriginalSchema()));

        // 处理简单组件提交的数据
        actionServiceImpl.handleSubmitOfSimple("", digiwinActionSubmitParasList, data);
    }

    /**
     * 填充submitActions属性值
     */
    private void buildUniversalParsingSubmitActions(DesignerEntity absEntity) {
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        DigiwinAtmcActivityData activityData = null;
        if ("UT_InspectionResultsRegistration".equalsIgnoreCase(executeContext.getTmActivityId())) {
            activityData = digiwinAtmcProxyService.getTaskData(executeContext.getMobileDataId(), executeContext);
            executeContext.appendTaskData(activityData);
        }
        // 构建 submitActions
        List<PcUiBotTaskPageDefine> pageDefines = taskPageDefineAnalyzer.analysis(null, executeContext, activityData);
        //多数据源查询元数据，替换RawData里的key：data数据
        UiBotModelDesignerMultipleDataSources.queryMetadataMultipleSources(absEntity, pageDefines);
        // 填充submitActions属性值
        pageDefines.forEach(uiBotDesignerRenderService::buildCmptSubmitAction);

        absEntity.setPageDefines(pageDefines);
    }

//    private void handleDataStateCode(DesignerEntity absEntity) {
//        List<PcUiBotTaskPageDefine> pageDefines = absEntity.getPageDefines();
//        if (CollectionUtils.isEmpty(pageDefines)) {
//            return;
//        }
//        // pageId是随机字符串
//        String pageId = absEntity.getApiRequest().getPageId();
//
//        // 获取数据状态code
//        pageDefines.stream()
//                .filter(pageDefine ->
//                        pageDefine.getPageLayout()
//                                .stream()
//                                .anyMatch(pageLayout -> pageId.equals(pageLayout.getPageId())))
//                .findFirst()
//                .ifPresent(pageDefine -> absEntity.setDataStateCode(pageDefine.getDataStateCode()));
//    }

    private void customUtInspectionResultsRegistration(DesignerEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        Object data = apiRequest.getRawData().get("data");
        if (!PcUiBotActivityConstant.TASK_DATA_STATE_CODE_COMPLETED.equals(executeContext.getDataStateCode()) &&
                "UT_InspectionResultsRegistration".equalsIgnoreCase(executeContext.getTmActivityId())) {
            // FIXME 试验优测定制 - 已完成页签详情页数据不查接口
            // 试验优测定制 - 待检测条目详情页数据重新查询接口
            // 替换rawdata中从前一个页面传递过来的数据，注意：因子条目详情页不走此策略类，故处理方式只针对于条目详情页定制处理
            JSONObject jsonObject = this.utInspectionResultsRegistrationHandle(apiRequest, executeContext, data);
            if (!CollectionUtils.isEmpty(jsonObject)) {
                // 提交入参需要activity__backlog__data 和activity__data__status参数，只能从data中获取到
                Map<String, Object> dataMap = (Map<String, Object>) data;
                dataMap.putAll(jsonObject);
                apiRequest.getRawData().put("data", dataMap);
                // rawMap 暂不处理，只考虑条目详情页
//                apiRequest.getRawData().put("rawMap", );
            }
            UiBotDesignerRenderService.handleAddSimpleDataOfPageData(apiRequest, apiRequest.getRawData().get("data"));
        }
    }

    /**
     * 获取最新taskInfo，因为上一页面点击进来的数据还是老数据
     */
    public JSONObject utInspectionResultsRegistrationHandle(ApiRequest apiRequest, PcUiBotExecuteContext executeContext, Object data) {
        if (data == null) {
            return null;
        }
        Map<String, Object> oldData = (Map<String, Object>) data;
        Map<String, Object> params = new HashMap<>();
        params.put("actionId", "bm.qmsc.quality.inspection.application.item.get");
        params.put("businessUnit", executeContext.getBusinessUnit());
        params.put("executeContext", executeContext);
        Map<String, Object> taskInfoMap = new HashMap<>();
        Map<String, Object> taskInfo = new HashMap<>();
        taskInfo.put("inspection_no", oldData.get("inspection_no"));
        taskInfo.put("item_status", oldData.get("item_status"));
        taskInfo.put("quality_inspection_no", oldData.get("quality_inspection_no"));
        taskInfoMap.put("task_info", Lists.newArrayList(taskInfo));
        params.put("parameter", taskInfoMap);
        DigiwinAthenaApiResponse<JSONObject> result =
                digiwinAtdmProxyService
                        .handleByActionId(apiRequest.getLocale(), apiRequest.getIamUserToken(),
                                apiRequest.getTenantId(), "", params);
        if (result.getStatus() != 200) {
            return null;
        }
        JSONObject response = result.getResponse();
        if (response == null) {
            return null;
        }
        JSONArray jsonArray = response.getJSONArray("task_info");
        if (CollectionUtils.isEmpty(jsonArray)) {
            return null;
        }
        return jsonArray.getJSONObject(0);
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(DesignerEntity absEntity) {
        List<PcUiBotTaskPageDefine> pageDefines = absEntity.getPageDefines();
        if (CollectionUtils.isEmpty(pageDefines)) {
            return null;
        }
        // pageId是随机字符串
        String pageId = absEntity.getApiRequest().getPageId();

        // 根据pageId获取设计态页面DSL
        return pageDefines
                .stream()
                .map(PcUiBotPageDefine::getPageLayout)
                .flatMap(Collection::stream)
                .filter(pageLayout -> pageId.equals(pageLayout.getPageId()))
                .findFirst()
                .orElse(null);
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(DesignerEntity absEntity) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        return Optional.ofNullable(absEntity.getPageDefines())
                .orElse(Collections.emptyList())
                .stream()
                .filter(pageDefine -> StringUtils.hasLength(dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode()))
                .findFirst()
                .map(PcUiBotPageDefine::getPageLayoutInfo)
                .orElse(new HashMap<String, Map<String, Object>>());
    }

    @Override
    protected void buildRule(DesignerEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        String tmActivityId = absEntity.getExecuteContext().getTmActivityId();
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(tmActivityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }

    @Override
    protected void removeEditRulesIfNecessary(DesignerEntity absEntity) {
        PcUiBotExecuteContext executeContext = absEntity.getExecuteContext();
        UiBotModel uiBotModel = absEntity.getUiBotModel();
        List<UiBotRule> rules = uiBotModel.getRules();
        if (CollectionUtils.isEmpty(rules) || executeContext == null) {
            return;
        }
        // 非performer 或者 是被分享的
        if (/*(!"performer".equals(executeContext.getIdentity())) || executeContext.isShared()
                ||*/"completed".equals(executeContext.getDataStateCode())
                || BooleanUtils.isTrue(uiBotModel.getFinished())) {
            // 去掉只有在可编辑时才起作用的规则
            // 非编辑类：!x.containsKey("scope") || !Objects.equals("EDIT", x.get("scope")
            // 编辑类：x.containsKey("scope") && Objects.equals("EDIT", x.get("scope")
            rules.removeIf(rule -> Objects.equals("EDIT", rule.getScope()));
        }
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap<Object, Boolean> map = new ConcurrentHashMap<>();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Data
    protected static
    class DesignerEntity extends AbstractEntity {
        private List<PcUiBotTaskPageDefine> pageDefines;
    }

    @Override
    protected Map<String, Object> buildHooks(DesignerEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        List<Map<String, Object>> hooks = Optional.ofNullable(absEntity.getPageDefines()).orElse(new ArrayList<>())
                .stream()
                // 获取对应数据状态下的定义
                .filter(pageDefine -> StringUtils.hasLength(dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode()))
                .findFirst()
                .map(PcUiBotTaskPageDefine::getHooks)
                .orElse(Collections.emptyList());
        return uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(DesignerEntity absEntity) {
        String dataStateCode = absEntity.getExecuteContext().getDataStateCode();
        return Optional.ofNullable(absEntity.getPageDefines()).orElse(new ArrayList<>())
                .stream()
                // 获取对应数据状态下的定义
                .filter(pageDefine -> StringUtils.hasLength(dataStateCode) && dataStateCode.equals(pageDefine.getDataStateCode()))
                .findFirst().orElse(null);
    }
}
