package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.component.MobilePageRawData;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotTaskPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.ProjectPageDefineAnalyzer;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：Athena 项目卡--里程碑下--项目详情页通用解析策略</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelProjectMilestoneUniversalParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/12/4 20:03
 */
@Slf4j
@Component("uiBotModelProjectMilestoneUniversalParsingPageStrategy")
public class UiBotModelProjectMilestoneUniversalParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelProjectMilestoneUniversalParsingPageStrategy.ProjectMilestoneEntity> {

    @Autowired
    private ProjectPageDefineAnalyzer projectPageDefineAnalyzer;

    @Autowired
    private UiBotModelDesignerUniversalParsingPageStrategy uiBotModelDesignerUniversalParsingPageStrategy;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new ProjectMilestoneEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(ProjectMilestoneEntity absEntity) {
        // 处理单身新增功能
        uiBotModelDesignerUniversalParsingPageStrategy.handleLocalOperationOfPageData(absEntity.getApiRequest());
        // 通过前端传递的提交参数，处理原始rawdata数据
        uiBotModelDesignerUniversalParsingPageStrategy.handleRawDataDataOfSubmitParam(absEntity.getApiRequest());
        // 填充submitActions属性值
        this.buildUniversalParsingSubmitActions(absEntity);
    }

    /**
     * 填充submitActions属性值
     */
    private void buildUniversalParsingSubmitActions(ProjectMilestoneEntity absEntity) {
        // 构建 submitActions
        List<PcUiBotTaskPageDefine> pageDefines = projectPageDefineAnalyzer.analysis(absEntity.getExecuteContext(), absEntity.getExecuteContext().getMobileDataId(), absEntity.getApiRequest());
        // 填充submitActions属性值
        pageDefines.forEach(uiBotDesignerRenderService::buildCmptSubmitAction);

        absEntity.setPageDefines(pageDefines);
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(ProjectMilestoneEntity absEntity) {
        return uiBotModelDesignerUniversalParsingPageStrategy.bulidPageLayout(absEntity);
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(ProjectMilestoneEntity absEntity) {
        return uiBotModelDesignerUniversalParsingPageStrategy.handlePageLayoutData(absEntity);
    }


    @Override
    protected void buildRule(ProjectMilestoneEntity absEntity) {
        uiBotModelDesignerUniversalParsingPageStrategy.buildRule(absEntity);
    }

    @Override
    protected void removeEditRulesIfNecessary(ProjectMilestoneEntity absEntity) {
        uiBotModelDesignerUniversalParsingPageStrategy.removeEditRulesIfNecessary(absEntity);
    }

    @Data
    protected static
    class ProjectMilestoneEntity extends UiBotModelDesignerUniversalParsingPageStrategy.DesignerEntity {
    }

    @Override
    protected Map<String, Object> buildHooks(ProjectMilestoneEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        return uiBotModelDesignerUniversalParsingPageStrategy.buildHooks(absEntity, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(ProjectMilestoneEntity absEntity) {
        return uiBotModelDesignerUniversalParsingPageStrategy.getPageDefine(absEntity);
    }
}
