package com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer;

import com.digiwin.mobile.mobileuibot.api.ApiRequest;
import com.digiwin.mobile.mobileuibot.core.component.ComponentContext;
import com.digiwin.mobile.mobileuibot.core.pagesetting.PageSetting;
import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.designer.entity.AbstractEntity;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.PcUiBotPageDefine;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.UiBotModel;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.layout.UiBotPageLayout;
import com.digiwin.mobile.mobileuibot.proxy.uibot.model.rule.UiBotRule;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.activity.analyzer.WorkbenchPageDefineAnalyzer;
import com.digiwin.mobile.mobileuibot.proxy.uibot.pcservice.builder.WorkbenchPageBuilder;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;

/**
 * <p>功能描述：Athena V2版--工作台--默认解析--条目详情页面通用解析页面</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: UiBotModelWorkbenchUniversalParsingPageStrategy.java
 * @Author: wangjwc
 * @Date: created at 2024/8/27 15:19
 */
@Component
public class UiBotModelWorkbenchUniversalParsingPageStrategy extends AbstractUniversalParsingPageStrategy<UiBotModelWorkbenchUniversalParsingPageStrategy.WorkbenchEntity> {

    @Autowired
    private UiBotModelDesignerUniversalParsingPageStrategy uiBotModelDesignerUniversalParsingPageStrategy;

    @Autowired
    private WorkbenchPageBuilder workbenchPageBuilder;

    @Autowired
    private WorkbenchPageDefineAnalyzer workbenchPageDefineAnalyzer;

    @Override
    public UiBotModel buildModel(PageSetting pageSetting, ApiRequest apiRequest) throws IOException {
        return super.buildModel(new WorkbenchEntity(), pageSetting, apiRequest);
    }

    @Override
    protected void handleRawDataData(WorkbenchEntity absEntity) {
        // 处理单身新增功能
        uiBotModelDesignerUniversalParsingPageStrategy.handleLocalOperationOfPageData(absEntity.getApiRequest());
        // 通过前端传递的提交参数，处理原始rawdata数据
        uiBotModelDesignerUniversalParsingPageStrategy.handleRawDataDataOfSubmitParam(absEntity.getApiRequest());
        // 填充submitActions属性值
        this.buildUniversalParsingSubmitActions(absEntity);
    }

    /**
     * 填充submitActions属性值
     */
    private void buildUniversalParsingSubmitActions(WorkbenchEntity absEntity) {
        // 构建 submitActions
        List<PcUiBotPageDefine> pageDefines = workbenchPageDefineAnalyzer.analysis(absEntity.getExecuteContext());
        // 填充submitActions属性值
        workbenchPageBuilder.BuildActions(pageDefines.get(0), null);

        absEntity.setPageDefine(pageDefines.get(0));
    }

    @Override
    protected UiBotPageLayout bulidPageLayout(WorkbenchEntity absEntity) {
        // pageId是随机字符串
        String pageId = absEntity.getApiRequest().getPageId();

        // 根据pageId获取设计态页面DSL
        return Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayout)
                .orElse(new ArrayList<>())
                .stream()
                .filter(pageLayout -> pageId.equals(pageLayout.getPageId()))
                .findFirst()
                .orElse(null);
    }

    @Override
    protected Map<String, Map<String, Object>> handlePageLayoutData(WorkbenchEntity absEntity) {
        return Optional.ofNullable(absEntity.getPageDefine())
                .map(PcUiBotPageDefine::getPageLayoutInfo)
                .orElse(new HashMap<>());
    }

    @Override
    protected void buildRule(WorkbenchEntity absEntity) {
        ApiRequest apiRequest = absEntity.getApiRequest();
        String tmActivityId = absEntity.getExecuteContext().getTmActivityId();
        List<UiBotRule> rules = pcRuleService.buildRuleOfKm(tmActivityId, apiRequest.getLocale(), apiRequest.getIamUserToken(), apiRequest.getTenantId());
        if (!CollectionUtils.isEmpty(rules)) {
            absEntity.getUiBotModel().setRules(rules);
        }
    }

    @Data
    protected static
    class WorkbenchEntity extends AbstractEntity {
        private PcUiBotPageDefine pageDefine;
    }

    @Override
    protected Map<String, Object> buildHooks(WorkbenchEntity absEntity, UiBotPageLayout pageLayout, ComponentContext cmptContext) {
        List<Map<String, Object>> hooks = Optional.ofNullable(absEntity).map(WorkbenchEntity::getPageDefine)
                .map(PcUiBotPageDefine::getHooks).orElse(Collections.emptyList());
        return uiBotDesignerRenderService.buildHooks(hooks, pageLayout, cmptContext);
    }

    @Override
    protected PcUiBotPageDefine getPageDefine(WorkbenchEntity absEntity) {
        return absEntity.getPageDefine();
    }
}
